/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.KeyIdentifier;
import iaik.cms.RecipientInfo;
import iaik.cms.SecurityProvider;
import iaik.cms.SubjectKeyID;
import iaik.cms.z;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;

public class KeyTransRecipientInfo
extends RecipientInfo {
    private KeyIdentifier uO;
    private PublicKey uP;
    private byte[] rE;

    public KeyTransRecipientInfo() {
        this.version_ = 0;
    }

    public KeyTransRecipientInfo(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public KeyTransRecipientInfo(CertificateIdentifier certificateIdentifier, AlgorithmID algorithmID, PublicKey publicKey) {
        this();
        this.uO = certificateIdentifier;
        int n2 = certificateIdentifier.getKeyIdType();
        if (n2 == 1) {
            this.version_ = 2;
        } else if (n2 != 0) {
            throw new IllegalArgumentException("Invalid recipientIdentifier! Expected SubjectKeyIdentifier or IssuerAndSerialNumber!");
        }
        this.keyEncryptionAlgorithm_ = algorithmID;
        this.uP = publicKey;
    }

    public KeyTransRecipientInfo(CertificateIdentifier certificateIdentifier, AlgorithmID algorithmID, byte[] byArray) {
        this();
        this.uO = certificateIdentifier;
        if (certificateIdentifier.getKeyIdType() == 1) {
            this.version_ = 2;
        }
        this.keyEncryptionAlgorithm_ = algorithmID;
        this.rE = byArray;
    }

    public KeyTransRecipientInfo(X509Certificate x509Certificate, int n2, AlgorithmID algorithmID) {
        this.a(x509Certificate, n2, algorithmID);
    }

    public KeyTransRecipientInfo(X509Certificate x509Certificate, AlgorithmID algorithmID) {
        this();
        try {
            this.a(x509Certificate, 0, algorithmID);
        }
        catch (X509ExtensionException x509ExtensionException) {}
    }

    public void decode(ASN1Object aSN1Object) {
        this.version_ = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
        this.uO = new z(aSN1Object.getComponentAt(1)).getCertificateIdentifier();
        this.keyEncryptionAlgorithm_ = new AlgorithmID(aSN1Object.getComponentAt(2));
        this.rE = (byte[])aSN1Object.getComponentAt(3).getValue();
    }

    public SecretKey decryptKey(Key key, KeyIdentifier keyIdentifier, String string) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        if (keyIdentifier != null && !this.isRecipientInfoFor(keyIdentifier)) {
            throw new CMSException("KeyTransRecipientInfo does not belong to given recipient.");
        }
        if (key != null && !(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Need a private key for decrypting the content encryption key!");
        }
        try {
            return securityProvider.decryptKey(this.rE, this.keyEncryptionAlgorithm_, (PrivateKey)key, string);
        }
        catch (Exception exception) {
            throw new CMSException("Unable to decrypt encrypted content-encryption key: " + exception.getMessage());
        }
    }

    public void encryptKey(SecretKey secretKey) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        if (this.keyEncryptionAlgorithm_ == null) {
            throw new NullPointerException("Unable to encrypt symmetric key. Key-encryption algorithm not set!");
        }
        if (this.uP == null) {
            throw new NullPointerException("Unable to encrypt symmetric key. Public key of the recipient not set!");
        }
        if (secretKey == null) {
            throw new NullPointerException("Cannot encrypt a null key!");
        }
        try {
            this.rE = securityProvider.encryptKey(secretKey, this.keyEncryptionAlgorithm_, this.uP);
        }
        catch (Exception exception) {
            throw new CMSException("Unable to encrypt the symmetric key: " + exception.getMessage());
        }
    }

    public byte[] getEncryptedKey() {
        return this.rE;
    }

    public byte[] getEncryptedKey(KeyIdentifier keyIdentifier) {
        if (keyIdentifier != null && !this.isRecipientInfoFor(keyIdentifier)) {
            throw new CMSException("KeyTransRecipientInfo does not belong to given recipient.");
        }
        return this.rE;
    }

    private static CertificateIdentifier a(X509Certificate x509Certificate, int n2) {
        if (n2 == 0) {
            return new IssuerAndSerialNumber(x509Certificate);
        }
        if (n2 == 1) {
            return new SubjectKeyID(x509Certificate);
        }
        throw new IllegalArgumentException("Cannot create KeyTransRecipientInfo: illegal recipient identifier type: " + n2);
    }

    public KeyIdentifier[] getRecipientIdentifiers() {
        return new KeyIdentifier[]{this.uO};
    }

    private void a(X509Certificate x509Certificate, int n2, AlgorithmID algorithmID) {
        this.uP = x509Certificate.getPublicKey();
        this.uO = KeyTransRecipientInfo.a(x509Certificate, n2);
        this.keyEncryptionAlgorithm_ = algorithmID;
    }

    public boolean isRecipientInfoFor(KeyIdentifier keyIdentifier) {
        return this.uO.equals(keyIdentifier);
    }

    public CertificateIdentifier isRecipientInfoFor(X509Certificate x509Certificate) {
        try {
            CertificateIdentifier certificateIdentifier = KeyTransRecipientInfo.a(x509Certificate, this.uO.getKeyIdType());
            if (this.isRecipientInfoFor(certificateIdentifier)) {
                return certificateIdentifier;
            }
        }
        catch (X509ExtensionException x509ExtensionException) {}
        return null;
    }

    public ASN1Object toASN1Object() {
        if (this.uO == null) {
            throw new NullPointerException("recipientIdentifier field of this KeyTransRecipientInfo not set!");
        }
        if (this.keyEncryptionAlgorithm_ == null) {
            throw new NullPointerException("keyEncryptionAlgorithm field of this KeyTransRecipientInfo not set!");
        }
        if (this.rE == null) {
            throw new NullPointerException("encryptedKey field of this KeyTransRecipientInfo not set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
        sEQUENCE.addComponent(new z((CertificateIdentifier)this.uO).toASN1Object());
        sEQUENCE.addComponent(this.keyEncryptionAlgorithm_.toASN1Object());
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.rE));
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("version: " + this.version_ + "\n");
        stringBuffer.append("recipientIdentifier: " + this.uO + "\n");
        stringBuffer.append("keyEncryptionAlgorithm: " + this.keyEncryptionAlgorithm_ + "\n");
        stringBuffer.append("encryptedKey: " + (this.rE == null ? "not set" : Util.toString((byte[])this.rE, (int)0, (int)5)) + "...");
        return stringBuffer.toString();
    }
}

