/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.KeyIdentifier;
import iaik.cms.OriginatorPublicKey;
import iaik.cms.RecipientInfo;
import iaik.cms.RecipientKeyIdentifier;
import iaik.cms.SecurityProvider;
import iaik.cms.SubjectKeyID;
import iaik.cms.x;
import iaik.cms.y;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.SecretKey;

public class KeyAgreeRecipientInfo
extends RecipientInfo {
    private static boolean a = false;
    private KeyIdentifier uK;
    private byte[] rE;
    private Vector tA;
    private PrivateKey uL;
    private PublicKey uM;
    private AlgorithmID uN;
    private int h;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    public KeyAgreeRecipientInfo() {
        this.version_ = 3;
        this.tA = new Vector();
        this.h = -1;
    }

    public KeyAgreeRecipientInfo(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public KeyAgreeRecipientInfo(ASN1Object aSN1Object, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(aSN1Object);
    }

    public KeyAgreeRecipientInfo(AlgorithmID algorithmID, AlgorithmID algorithmID2, int n2) {
        this();
        this.keyEncryptionAlgorithm_ = (AlgorithmID)algorithmID.clone();
        this.uN = (AlgorithmID)algorithmID2.clone();
        this.h = n2;
    }

    public KeyAgreeRecipientInfo(KeyIdentifier keyIdentifier, AlgorithmID algorithmID, byte[] byArray) {
        this();
        if (keyIdentifier.getKeyIdType() != 0 && keyIdentifier.getKeyIdType() != 1 && keyIdentifier.getKeyIdType() != 4) {
            throw new IllegalArgumentException("Invalid originator identifier. Expected IssuerAndSerialNumber, SubjectKeyID or OriginatorPublicKey!");
        }
        this.uK = keyIdentifier;
        this.keyEncryptionAlgorithm_ = (AlgorithmID)algorithmID.clone();
        this.rE = byArray;
    }

    public KeyAgreeRecipientInfo(X509Certificate x509Certificate, PrivateKey privateKey, int n2, AlgorithmID algorithmID, AlgorithmID algorithmID2, int n3, byte[] byArray) {
        this();
        this.a(x509Certificate, privateKey, n2, algorithmID, algorithmID2, n3, byArray);
    }

    public KeyPair addRecipient(CertificateIdentifier certificateIdentifier, PublicKey publicKey) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        if (certificateIdentifier.getKeyIdType() != 0 && certificateIdentifier.getKeyIdType() != 2) {
            throw new IllegalArgumentException("Invalid recipient identifier. Expected IssuerAndSerialNumber or RecipientKeyIdentifier!");
        }
        KeyPair keyPair = null;
        if (this.uL == null) {
            try {
                keyPair = securityProvider.generateKeyAgreementKeyPair(this.keyEncryptionAlgorithm_, publicKey);
                this.uL = keyPair.getPrivate();
                this.uM = keyPair.getPublic();
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Cannot create ephemeral originator key: " + exception.getMessage());
            }
            this.uK = new OriginatorPublicKey(keyPair.getPublic());
        } else {
            try {
                if (this.uL == null) {
                    throw new NullPointerException("Cannot add recipient; originator private key not set.");
                }
                securityProvider.checkDomainParameters(this.uL, publicKey);
                keyPair = new KeyPair(this.uM, this.uL);
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Cannot add recipient key: " + exception.getMessage());
            }
        }
        this.tA.addElement(new y(certificateIdentifier, publicKey));
        return keyPair;
    }

    public void addRecipient(CertificateIdentifier certificateIdentifier, byte[] byArray) {
        if (certificateIdentifier.getKeyIdType() != 0 && certificateIdentifier.getKeyIdType() != 2) {
            throw new IllegalArgumentException("Invalid recipient identifier. Expected IssuerAndSerialNumber or RecipientKeyIdentifier!");
        }
        if (this.uK == null) {
            throw new CMSException("Cannot add already encrypted key; the originator field of this KeyAgreeRecipientInfo is not set!");
        }
        this.tA.addElement(new y(certificateIdentifier, byArray));
    }

    public KeyPair addRecipient(X509Certificate x509Certificate, int n2) {
        CertificateIdentifier certificateIdentifier = KeyAgreeRecipientInfo.a(x509Certificate, n2);
        return this.addRecipient(certificateIdentifier, x509Certificate.getPublicKey());
    }

    public int countRecipientEncryptedKeys() {
        return this.tA.size();
    }

    public void decode(ASN1Object aSN1Object) {
        ASN1Object aSN1Object2;
        int n2;
        block5: {
            this.version_ = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
            this.uK = new x((ASN1Object)aSN1Object.getComponentAt(1).getValue(), this.securityProvider_).a();
            n2 = 2;
            if (aSN1Object.getComponentAt(n2).isA(ASN.CON_SPEC)) {
                this.rE = (byte[])((ASN1Object)aSN1Object.getComponentAt(n2++).getValue()).getValue();
            }
            this.keyEncryptionAlgorithm_ = new AlgorithmID(aSN1Object.getComponentAt(n2++));
            try {
                aSN1Object2 = this.keyEncryptionAlgorithm_.getParameter();
                if (aSN1Object2 != null) {
                    this.uN = new AlgorithmID(aSN1Object2);
                }
            }
            catch (Exception exception) {
                if (!a) break block5;
                System.out.println("Missing key wrap algorithm id parameter in key agree algorithm id!");
            }
        }
        aSN1Object2 = aSN1Object.getComponentAt(n2);
        int n3 = 0;
        while (n3 < aSN1Object2.countComponents()) {
            this.tA.addElement(new y(aSN1Object2.getComponentAt(n3)));
            ++n3;
        }
    }

    public SecretKey decryptKey(Key key) {
        return this.decryptKey(key, null, "RAW");
    }

    public SecretKey decryptKey(Key key, KeyIdentifier keyIdentifier, String string) {
        if (key != null && !(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Need a private key for decrypting the content encryption key!");
        }
        SecretKey secretKey = null;
        if (this.uM != null) {
            secretKey = this.decryptKey((PrivateKey)key, keyIdentifier, this.uM, string);
        } else {
            if (this.uK.getKeyIdType() != 4) {
                throw new CMSException("Cannot decrypt content encryption key. Need originator public key!");
            }
            secretKey = this.decryptKey((PrivateKey)key, keyIdentifier, ((OriginatorPublicKey)this.uK).getPublicKey(), string);
        }
        return secretKey;
    }

    /*
     * Unable to fully structure code
     */
    public SecretKey decryptKey(PrivateKey var1_1, KeyIdentifier var2_2, PublicKey var3_3, String var4_4) {
        if (this.tA.isEmpty()) {
            throw new CMSException("No encrypted key included in this KeyAgreeRecipientInfo!");
        }
        if (var3_3 == null) {
            throw new CMSException("Cannot decrypt content encryption key. Need originator public key!");
        }
        var5_5 = this.tA.elements();
        if (var2_2 == null) ** GOTO lbl18
        while (var5_5.hasMoreElements()) {
            var6_6 = (y)var5_5.nextElement();
            if (!var6_6.a((CertificateIdentifier)var2_2)) continue;
            return var6_6.a(this.keyEncryptionAlgorithm_, this.uN, var1_1, var3_3, this.rE, var4_4, this.securityProvider_);
        }
        throw new CMSException("No encrypted key found for this recipientIdentifier");
lbl-1000:
        // 1 sources

        {
            try {
                return ((y)var5_5.nextElement()).a(this.keyEncryptionAlgorithm_, this.uN, var1_1, var3_3, this.rE, var4_4, this.securityProvider_);
            }
            catch (Exception var6_7) {
                if (!KeyAgreeRecipientInfo.a) continue;
                System.out.println("Error decrypting key: " + var6_7.getMessage());
                System.out.println("Try the next recipient encrypted key...");
            }
lbl18:
            // 3 sources

            ** while (var5_5.hasMoreElements())
        }
lbl19:
        // 1 sources

        throw new InvalidKeyException("Cannot decrypt any of the encrypted content encryption keys of this KeyAgreeRecipientInfo with the given private key!");
    }

    public SecretKey decryptKey(PrivateKey privateKey, X509Certificate x509Certificate, String string) {
        SecretKey secretKey = null;
        if (this.uM != null) {
            secretKey = this.decryptKey(privateKey, x509Certificate, this.uM, string);
        } else {
            if (this.uK.getKeyIdType() != 4) {
                throw new CMSException("Cannot decrypt content encryption key. Need originator public key!");
            }
            secretKey = this.decryptKey(privateKey, x509Certificate, ((OriginatorPublicKey)this.uK).getPublicKey(), string);
        }
        return secretKey;
    }

    public SecretKey decryptKey(PrivateKey privateKey, X509Certificate x509Certificate, PublicKey publicKey, String string) {
        Enumeration enumeration = this.tA.elements();
        KeyIdentifier keyIdentifier = null;
        while (enumeration.hasMoreElements()) {
            try {
                y y2 = (y)enumeration.nextElement();
                CertificateIdentifier certificateIdentifier = y2.b();
                if (keyIdentifier == null || keyIdentifier.getKeyIdType() != certificateIdentifier.getKeyIdType()) {
                    keyIdentifier = KeyAgreeRecipientInfo.a(x509Certificate, certificateIdentifier.getKeyIdType());
                }
                if (!keyIdentifier.equals(certificateIdentifier)) continue;
                return y2.a(this.keyEncryptionAlgorithm_, this.uN, privateKey, publicKey, this.rE, string, this.securityProvider_);
            }
            catch (X509ExtensionException x509ExtensionException) {}
        }
        throw new CMSException("No recipient encrypted key included for this recipient!");
    }

    public void encryptKey(SecretKey secretKey) {
        if (this.keyEncryptionAlgorithm_ == null) {
            throw new NullPointerException("Unable to encrypt symmetric key. Key-encryption algorithm is not set!");
        }
        if (this.uK == null) {
            throw new NullPointerException("Unable to encrypt symmetric key. Originator not set!");
        }
        if (this.tA.isEmpty()) {
            throw new NullPointerException("Unable to encrypt symmetric key. No recipient information added!");
        }
        if (secretKey == null) {
            throw new NullPointerException("Cannot encrypt a null key!");
        }
        Enumeration enumeration = this.tA.elements();
        while (enumeration.hasMoreElements()) {
            ((y)enumeration.nextElement()).a(secretKey, this.keyEncryptionAlgorithm_, this.uL, this.uN, this.h, this.rE, this.securityProvider_);
        }
    }

    public byte[] getEncryptedKey(KeyIdentifier keyIdentifier) {
        byte[] byArray = null;
        if (this.tA.size() > 0) {
            if (keyIdentifier != null) {
                Enumeration enumeration = this.tA.elements();
                while (enumeration.hasMoreElements()) {
                    y y2 = (y)enumeration.nextElement();
                    if (!keyIdentifier.equals(y2.b())) continue;
                    byArray = y2.a();
                    break;
                }
            } else {
                y y3 = (y)this.tA.firstElement();
                byArray = y3.a();
            }
        }
        return byArray;
    }

    public AlgorithmID getKeyWrapAlgorithm() {
        return this.uN;
    }

    public KeyIdentifier getOriginator() {
        return this.uK;
    }

    private static CertificateIdentifier a(X509Certificate x509Certificate, int n2) {
        if (n2 == 0) {
            return new IssuerAndSerialNumber(x509Certificate);
        }
        if (n2 == 2) {
            return new RecipientKeyIdentifier(new SubjectKeyID(x509Certificate));
        }
        throw new IllegalArgumentException("Invalid recipient identifier. Expected IssuerAndSerialNumber or RecipientKeyIdentifier!");
    }

    public KeyIdentifier[] getRecipientIdentifiers() {
        int n2 = this.countRecipientEncryptedKeys();
        KeyIdentifier[] keyIdentifierArray = new CertificateIdentifier[n2];
        int n3 = 0;
        while (n3 < n2) {
            keyIdentifierArray[n3] = ((y)this.tA.elementAt(n3)).b();
            ++n3;
        }
        return keyIdentifierArray;
    }

    public byte[] getUKM() {
        return this.rE;
    }

    private void a(X509Certificate x509Certificate, PrivateKey privateKey, int n2, AlgorithmID algorithmID, AlgorithmID algorithmID2, int n3, byte[] byArray) {
        this.uL = privateKey;
        this.uM = x509Certificate.getPublicKey();
        if (n2 == 0) {
            this.uK = new IssuerAndSerialNumber(x509Certificate);
        } else if (n2 == 1) {
            this.uK = new SubjectKeyID(x509Certificate);
        } else {
            throw new IllegalArgumentException("Cannot create KeyAgreeRecipientInfo: illegal originator identifier type: " + n2);
        }
        this.keyEncryptionAlgorithm_ = (AlgorithmID)algorithmID.clone();
        this.uN = (AlgorithmID)algorithmID2.clone();
        this.h = n3;
        this.rE = byArray;
    }

    public boolean isRecipientInfoFor(KeyIdentifier keyIdentifier) {
        Enumeration enumeration = this.tA.elements();
        while (enumeration.hasMoreElements()) {
            if (!keyIdentifier.equals(((y)enumeration.nextElement()).b())) continue;
            return true;
        }
        return false;
    }

    public CertificateIdentifier isRecipientInfoFor(X509Certificate x509Certificate) {
        Enumeration enumeration = this.tA.elements();
        KeyIdentifier keyIdentifier = null;
        while (enumeration.hasMoreElements()) {
            try {
                CertificateIdentifier certificateIdentifier = ((y)enumeration.nextElement()).b();
                if (keyIdentifier == null || keyIdentifier.getKeyIdType() != certificateIdentifier.getKeyIdType()) {
                    keyIdentifier = KeyAgreeRecipientInfo.a(x509Certificate, certificateIdentifier.getKeyIdType());
                }
                if (!keyIdentifier.equals(certificateIdentifier)) continue;
                return (CertificateIdentifier)keyIdentifier;
            }
            catch (X509ExtensionException x509ExtensionException) {}
        }
        return null;
    }

    void a(PublicKey publicKey, PrivateKey privateKey) {
        this.uM = publicKey;
        this.uL = privateKey;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider_ = securityProvider;
    }

    public void setUKM(byte[] byArray) {
        this.rE = byArray;
    }

    public ASN1Object toASN1Object() {
        if (this.uK == null) {
            throw new NullPointerException("originator field of this KeyAgreeRecipientInfo not set!");
        }
        if (this.keyEncryptionAlgorithm_ == null) {
            throw new NullPointerException("keyEncryptionAlgorithm field of this KeyAgreeRecipientInfo not set!");
        }
        if (this.tA.isEmpty()) {
            throw new NullPointerException("No recipientEncryptedKey included!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, new x(this.uK).toASN1Object()));
        if (this.rE != null && this.rE.length > 0) {
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(1, (ASN1Object)new OCTET_STRING(this.rE)));
        }
        sEQUENCE.addComponent(this.keyEncryptionAlgorithm_.toASN1Object());
        sEQUENCE.addComponent(ASN.createSequenceOf((Vector)this.tA));
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("version: " + this.version_ + "\n");
        stringBuffer.append("originator: " + this.uK + "\n");
        if (this.rE != null) {
            stringBuffer.append("ukm: " + Util.toString((byte[])this.rE, (int)0, (int)5) + "...\n");
        }
        stringBuffer.append("keyEncryptionAlgorithm: " + this.keyEncryptionAlgorithm_ + "\n");
        stringBuffer.append("recipientEncryptedKeys: {\n");
        Enumeration enumeration = this.tA.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(String.valueOf(String.valueOf(enumeration.nextElement())) + "\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

