/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.cms.KEKIdentifier;
import iaik.cms.KeyIdentifier;
import iaik.cms.RecipientInfo;
import iaik.cms.SecurityProvider;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.SecretKey;

public class KEKRecipientInfo
extends RecipientInfo {
    private static boolean rM = false;
    KEKIdentifier uH;
    SecretKey uI;
    byte[] rE;
    AlgorithmParameters uJ;

    static {
        rM = DebugCMS.getDebugMode() && rM;
    }

    public KEKRecipientInfo() {
        this.version_ = 4;
    }

    public KEKRecipientInfo(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public KEKRecipientInfo(ASN1Object aSN1Object, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(aSN1Object);
    }

    public KEKRecipientInfo(KEKIdentifier kEKIdentifier, AlgorithmID algorithmID, SecretKey secretKey) {
        this(kEKIdentifier, algorithmID, secretKey, null);
    }

    public KEKRecipientInfo(KEKIdentifier kEKIdentifier, AlgorithmID algorithmID, SecretKey secretKey, AlgorithmParameters algorithmParameters) {
        this();
        this.uH = kEKIdentifier;
        this.keyEncryptionAlgorithm_ = (AlgorithmID)algorithmID.clone();
        this.uI = secretKey;
        this.uJ = algorithmParameters;
    }

    public KEKRecipientInfo(KEKIdentifier kEKIdentifier, AlgorithmID algorithmID, byte[] byArray) {
        this();
        this.uH = kEKIdentifier;
        this.keyEncryptionAlgorithm_ = (AlgorithmID)algorithmID.clone();
        this.rE = byArray;
    }

    public void decode(ASN1Object aSN1Object) {
        block3: {
            SecurityProvider securityProvider = this.securityProvider_;
            if (securityProvider == null) {
                securityProvider = SecurityProvider.getSecurityProvider();
            }
            this.version_ = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
            this.uH = new KEKIdentifier(aSN1Object.getComponentAt(1));
            this.keyEncryptionAlgorithm_ = new AlgorithmID(aSN1Object.getComponentAt(2));
            this.rE = (byte[])aSN1Object.getComponentAt(3).getValue();
            try {
                this.uJ = securityProvider.getAlgorithmParameters(this.keyEncryptionAlgorithm_);
            }
            catch (Exception exception) {
                if (!rM) break block3;
                System.out.println("Cannot create AlgorithmParameters for " + this.keyEncryptionAlgorithm_.getAlgorithm().getName());
            }
        }
    }

    public SecretKey decryptKey(Key key, KeyIdentifier keyIdentifier, String string) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        if (keyIdentifier != null && !this.isRecipientInfoFor(keyIdentifier)) {
            throw new CMSException("KEKRecipientInfo does not belong to given recipient.");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Need a secret key for decrypting the content encryption key!");
        }
        try {
            int n2;
            String string2 = string;
            if ((string2 == null || string2.equalsIgnoreCase("RAW")) && (n2 = (string2 = this.keyEncryptionAlgorithm_.getRawImplementationName()).indexOf("Wrap") + 4) != 3 && n2 < string2.length()) {
                string2 = string2.substring(n2);
            }
            return securityProvider.unwrapKey(this.rE, this.keyEncryptionAlgorithm_, (SecretKey)key, this.uJ, string2);
        }
        catch (Exception exception) {
            throw new CMSException("Unable to decrypt encrypted content-encryption key: " + exception.getMessage());
        }
    }

    public void encryptKey(SecretKey secretKey) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        if (this.keyEncryptionAlgorithm_ == null) {
            throw new NullPointerException("Unable to encrypt symmetric key. Content-encryption algorithm is not set!");
        }
        if (this.uI == null) {
            throw new NullPointerException("Unable to encrypt symmetric key. Key encryption key is not set!");
        }
        if (secretKey == null) {
            throw new NullPointerException("Cannot encrypt a null key!");
        }
        try {
            this.rE = securityProvider.wrapKey(secretKey, this.keyEncryptionAlgorithm_, this.uI, this.uJ);
        }
        catch (Exception exception) {
            throw new CMSException("Unable to encrypt the symmetric key: " + exception.getMessage());
        }
    }

    public byte[] getEncryptedKey() {
        return this.rE;
    }

    public byte[] getEncryptedKey(KeyIdentifier keyIdentifier) {
        if (keyIdentifier != null && !this.isRecipientInfoFor(keyIdentifier)) {
            throw new CMSException("KEKRecipientInfo does not belong to given recipient.");
        }
        return this.rE;
    }

    public KeyIdentifier getRecipientIdentifier() {
        return this.uH;
    }

    public KeyIdentifier[] getRecipientIdentifiers() {
        return new KeyIdentifier[]{this.uH};
    }

    public boolean isRecipientInfoFor(KeyIdentifier keyIdentifier) {
        return this.uH.equals(keyIdentifier);
    }

    public CertificateIdentifier isRecipientInfoFor(X509Certificate x509Certificate) {
        return null;
    }

    public ASN1Object toASN1Object() {
        if (this.uH == null) {
            throw new NullPointerException("kekid field of this KEKRecipientInfo not set!");
        }
        if (this.keyEncryptionAlgorithm_ == null) {
            throw new NullPointerException("keyEncryptionAlgorithm field of this KEKRecipientInfo not set!");
        }
        if (this.rE == null) {
            throw new NullPointerException("encryptedKey field of this KEKRecipientInfo not set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
        sEQUENCE.addComponent(this.uH.toASN1Object());
        sEQUENCE.addComponent(this.keyEncryptionAlgorithm_.toASN1Object());
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.rE));
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("version: " + this.version_ + "\n");
        stringBuffer.append("kekid: " + this.uH + "\n");
        stringBuffer.append("keyEncryptionAlgorithm: " + this.keyEncryptionAlgorithm_ + "\n");
        stringBuffer.append("encryptedKey: " + (this.rE == null ? "not set" : Util.toString((byte[])this.rE, (int)0, (int)5)) + "...");
        return stringBuffer.toString();
    }
}

