/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.cms.KeyIdentifier;
import iaik.cms.OtherKeyAttribute;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.util.Date;

public class KEKIdentifier
implements KeyIdentifier {
    private byte[] a;
    private Date b;
    private OtherKeyAttribute uG;

    public KEKIdentifier() {
    }

    public KEKIdentifier(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public KEKIdentifier(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Cannot create a KEKIdentifier with no key identifier");
        }
        this.a = byArray;
    }

    public void decode(ASN1Object aSN1Object) {
        int n2 = aSN1Object.countComponents();
        this.a = (byte[])aSN1Object.getComponentAt(0).getValue();
        if (this.a == null) {
            throw new CodingException("Invalid KEKIdentifier. Missing key identifier!");
        }
        if (n2 > 3) {
            throw new CodingException("Cannot create KEKIdentifier. Invalid number of components: " + n2);
        }
        int n3 = 1;
        while (n3 < n2) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(n3);
            if (aSN1Object2.isA(ASN.GeneralizedTime)) {
                if (n3 != 1) {
                    throw new CodingException("Invalid KEKIdentifier. Date is not second component!");
                }
                ChoiceOfTime choiceOfTime = new ChoiceOfTime(aSN1Object.getComponentAt(n3));
                this.b = choiceOfTime.getDate();
            } else {
                this.uG = new OtherKeyAttribute(aSN1Object.getComponentAt(n3));
            }
            ++n3;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof KEKIdentifier) {
            KEKIdentifier kEKIdentifier = (KEKIdentifier)object;
            if (!this.hasKeyIdentifier(kEKIdentifier.getKeyIdentifier())) {
                return false;
            }
            if (!this.hasDate(kEKIdentifier.getDate())) {
                return false;
            }
            return this.hasOtherKeyAttribute(kEKIdentifier.getOtherKeyAttribute());
        }
        return false;
    }

    public Date getDate() {
        return this.b;
    }

    public int getKeyIdType() {
        return 3;
    }

    public String getKeyIdTypeName() {
        return "KEKIdentifier";
    }

    public byte[] getKeyIdentifier() {
        return this.a;
    }

    public OtherKeyAttribute getOtherKeyAttribute() {
        return this.uG;
    }

    public boolean hasDate(Date date) {
        if (this.b != null && date != null) {
            return this.b.equals(date);
        }
        return this.b == null && date == null;
    }

    public boolean hasKeyIdentifier(byte[] byArray) {
        return CryptoUtils.equalsBlock((byte[])this.a, (byte[])byArray);
    }

    public boolean hasOtherKeyAttribute(OtherKeyAttribute otherKeyAttribute) {
        if (this.uG != null && otherKeyAttribute != null) {
            return this.uG.equals(otherKeyAttribute);
        }
        return this.uG == null && otherKeyAttribute == null;
    }

    public int hashCode() {
        return Util.calculateHashCode((byte[])this.a);
    }

    public void setDate(Date date) {
        this.b = date;
    }

    public void setOtherKeyAttribute(OtherKeyAttribute otherKeyAttribute) {
        this.uG = otherKeyAttribute;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.a));
        if (this.b != null) {
            ChoiceOfTime choiceOfTime = new ChoiceOfTime(this.b);
            choiceOfTime.setEncodingType(ASN.GeneralizedTime);
            sEQUENCE.addComponent(choiceOfTime.toASN1Object());
        }
        if (this.uG != null) {
            sEQUENCE.addComponent(this.uG.toASN1Object());
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("keyIdentifier: " + Util.toString((byte[])this.a));
        if (this.b != null) {
            stringBuffer.append("\ndate: " + this.b.toString());
        }
        if (this.uG != null) {
            stringBuffer.append("\nother: " + this.uG.toString());
        }
        return stringBuffer.toString();
    }
}

