/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Name;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.x509.X509Certificate;
import java.math.BigInteger;

public class IssuerAndSerialNumber
implements CertificateIdentifier {
    private static boolean a = false;
    private Name uF;
    private BigInteger rS;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    public IssuerAndSerialNumber() {
    }

    public IssuerAndSerialNumber(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public IssuerAndSerialNumber(Name name, BigInteger bigInteger) {
        this.uF = name;
        this.rS = bigInteger;
    }

    public IssuerAndSerialNumber(X509Certificate x509Certificate) {
        this.a(x509Certificate);
    }

    public void decode(ASN1Object aSN1Object) {
        this.uF = new Name(aSN1Object.getComponentAt(0));
        this.rS = (BigInteger)aSN1Object.getComponentAt(1).getValue();
    }

    public boolean equals(Object object) {
        if (object instanceof IssuerAndSerialNumber) {
            IssuerAndSerialNumber issuerAndSerialNumber = (IssuerAndSerialNumber)object;
            if (this.uF.equals((Object)issuerAndSerialNumber.uF) && this.rS.compareTo(issuerAndSerialNumber.rS) == 0) {
                return true;
            }
        }
        return false;
    }

    public Name getIssuer() {
        return this.uF;
    }

    public int getKeyIdType() {
        return 0;
    }

    public String getKeyIdTypeName() {
        return "IssuerAndSerialNumber";
    }

    public BigInteger getSerialNumber() {
        return this.rS;
    }

    public int hashCode() {
        return this.uF.hashCode() + this.rS.hashCode();
    }

    public boolean identifiesCert(X509Certificate x509Certificate) {
        return this.uF.equals((Object)x509Certificate.getIssuerDN()) && this.rS.compareTo(x509Certificate.getSerialNumber()) == 0;
    }

    private void a(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new NullPointerException("cert must not be null!");
        }
        this.uF = (Name)x509Certificate.getIssuerDN();
        this.rS = x509Certificate.getSerialNumber();
    }

    public boolean isIssuerOf(X509Certificate x509Certificate) {
        return this.identifiesCert(x509Certificate);
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.uF.toASN1Object());
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.rS));
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SerialNumber: " + this.rS + "\n");
        stringBuffer.append("Issuer: " + this.uF);
        return stringBuffer.toString();
    }
}

