/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.DigestInfo;
import iaik.cms.IaikProvider;
import iaik.cms.SecurityProvider;
import iaik.utils.CryptoUtils;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;

public class IaikCCProvider
extends IaikProvider {
    public byte[] calculateSignatureFromHash(AlgorithmID algorithmID, AlgorithmID algorithmID2, PrivateKey privateKey, byte[] byArray) {
        byte[] byArray2 = null;
        String string = algorithmID.getImplementationName();
        if (SecurityProvider.c(string, true)) {
            DigestInfo digestInfo = new DigestInfo(algorithmID2, byArray);
            byte[] byArray3 = digestInfo.toByteArray();
            try {
                Cipher cipher = this.getCipher("RSA/ECB/PKCS1Padding/Sign", 1, (Key)privateKey, (AlgorithmParameters)null);
                byArray2 = cipher.doFinal(byArray3);
            }
            catch (Exception exception) {
                throw new SignatureException("Cannot calculate RSA siganture: " + exception.toString());
            }
        } else {
            byArray2 = super.calculateSignatureFromHash(algorithmID, algorithmID2, privateKey, byArray);
        }
        return byArray2;
    }

    public boolean verifySignatureFromHash(AlgorithmID algorithmID, AlgorithmID algorithmID2, PublicKey publicKey, byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        String string = algorithmID.getImplementationName();
        if (SecurityProvider.c(string, true)) {
            byte[] byArray3;
            Object object;
            try {
                object = this.getCipher("RSA/ECB/PKCS1Padding/Verify", 2, (Key)publicKey, (AlgorithmParameters)null);
                byArray3 = ((Cipher)object).doFinal(byArray2);
            }
            catch (Exception exception) {
                throw new SignatureException("Cannot verify RSA signature: " + exception.toString());
            }
            object = null;
            try {
                object = new DigestInfo(byArray3);
            }
            catch (CodingException codingException) {
                throw new SignatureException("Error decoding DigestInfo: " + codingException.toString());
            }
            if (!((DigestInfo)object).checkDigestAlgorithm(algorithmID2)) {
                throw new SignatureException("Digest algorithm mismatch!");
            }
            bl = CryptoUtils.equalsBlock((byte[])byArray, (byte[])((DigestInfo)object).getDigest());
        } else if (string.equals("RSASSA-PSS")) {
            Signature signature = this.getSignature("RawRSASSA-PSS", 2, (Key)publicKey);
            AlgorithmParameterSpec algorithmParameterSpec = null;
            try {
                algorithmParameterSpec = this.getAlgorithmParameterSpec(algorithmID);
                if (algorithmParameterSpec != null) {
                    SecurityProvider.setSignatureParameters(signature, algorithmParameterSpec);
                }
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new NoSuchAlgorithmException("Error getting PSS parameters from algorithm ID: " + invalidParameterSpecException.toString());
            }
            signature.update(byArray);
            bl = signature.verify(byArray2);
        } else if (string.equals("SHA-1/DSA") || string.equals("SHA/DSA") || string.equals("DSA")) {
            Signature signature = this.getSignature("RawDSA", 2, (Key)publicKey);
            signature.update(byArray);
            bl = signature.verify(byArray2);
        } else if (string.equals("ECDSA")) {
            Signature signature = this.getSignature("RawECDSA", 2, (Key)publicKey);
            signature.update(byArray);
            bl = signature.verify(byArray2);
        } else {
            throw new NoSuchAlgorithmException("Algorithm " + algorithmID.getAlgorithm().getName() + " not supported!");
        }
        return bl;
    }
}

