/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.CertificateSet;
import iaik.cms.ContentStream;
import iaik.cms.DebugCMS;
import iaik.cms.EncryptedContentInfoStream;
import iaik.cms.KeyAgreeRecipientInfo;
import iaik.cms.KeyIdentifier;
import iaik.cms.OriginatorInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.RevocationInfoChoices;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import iaik.cms.b;
import iaik.utils.EOFListener;
import iaik.utils.NotifyEOFInputStream;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.SecretKey;

public class EnvelopedDataStream
implements ContentStream,
EOFListener {
    private static boolean rH = false;
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    protected int version_ = 0;
    protected OriginatorInfo originatorInfo_;
    protected Vector recipientInfos_ = new Vector();
    protected EncryptedContentInfoStream encryptedContentInfo_;
    protected SecretKey symmetricKey_;
    protected int blockSize_ = 2048;
    protected Attribute[] unprotectedAttrs_;
    protected SecurityProvider securityProvider_;
    private DerInputStream uy;
    protected boolean keyChanged_;
    static Class a;

    static {
        rH = DebugCMS.getDebugMode() && rH;
    }

    protected EnvelopedDataStream() {
    }

    public EnvelopedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID) {
        this(objectID, inputStream, algorithmID, -1, null);
    }

    public EnvelopedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID, int n2) {
        this(objectID, inputStream, algorithmID, n2, null);
    }

    public EnvelopedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID, int n2, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.encryptedContentInfo_ = new EncryptedContentInfoStream(objectID, inputStream);
        this.encryptedContentInfo_.setSecurityProvider(this.securityProvider_);
        this.symmetricKey_ = this.encryptedContentInfo_.setupCipher(algorithmID, n2);
        this.keyChanged_ = true;
    }

    public EnvelopedDataStream(InputStream inputStream) {
        this(inputStream, (SecurityProvider)null);
    }

    public EnvelopedDataStream(InputStream inputStream, AlgorithmID algorithmID) {
        this(ObjectID.cms_data, inputStream, algorithmID, -1, null);
    }

    public EnvelopedDataStream(InputStream inputStream, AlgorithmID algorithmID, int n2) {
        this(ObjectID.cms_data, inputStream, algorithmID, n2, null);
    }

    public EnvelopedDataStream(InputStream inputStream, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(inputStream);
    }

    public EnvelopedDataStream(RecipientInfo[] recipientInfoArray, EncryptedContentInfoStream encryptedContentInfoStream) {
        this();
        this.setRecipientInfos(recipientInfoArray);
        this.encryptedContentInfo_ = encryptedContentInfoStream;
    }

    public void addRecipientInfo(RecipientInfo recipientInfo) {
        if (recipientInfo.getSecurityProvider() == null) {
            recipientInfo.setSecurityProvider(this.securityProvider_);
        }
        this.recipientInfos_.addElement(recipientInfo);
        this.a();
    }

    private void a() {
        Object object;
        this.version_ = 0;
        if (this.originatorInfo_ != null) {
            this.version_ = 2;
            object = this.originatorInfo_.getRevocationInfoChoices();
            if (((RevocationInfoChoices)object).containsOtherRevocationInfos()) {
                this.version_ = 4;
            } else {
                CertificateSet certificateSet = this.originatorInfo_.getCertificateSet();
                if (certificateSet.containsOtherCertificates()) {
                    this.version_ = 4;
                } else if (certificateSet.getAttributeCertificateType() == 2) {
                    this.version_ = 3;
                }
            }
        }
        if (this.version_ < 3) {
            object = this.recipientInfos_.elements();
            while (object.hasMoreElements()) {
                int n2 = ((RecipientInfo)object.nextElement()).getRecipientInfoType();
                if (n2 > 2) {
                    this.version_ = 3;
                    break;
                }
                if (n2 <= 0) continue;
                this.version_ = 2;
            }
            if (this.version_ < 2 && this.unprotectedAttrs_ != null && this.unprotectedAttrs_.length > 0) {
                this.version_ = 2;
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void decode(InputStream inputStream) {
        Object[] objectArray;
        DerInputStream derInputStream;
        int n2;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        if ((n2 = (derInputStream = ((DerInputStream)inputStream).readSequence()).nextTag()) == 6) {
            objectArray = derInputStream.readObjectID();
            if (!objectArray.equals((Object)ObjectID.cms_envelopedData)) {
                throw new CMSParsingException("Content type not EnvelopedData!");
            }
            this.uy = derInputStream.readContextSpecific().readSequence();
        } else {
            this.uy = derInputStream;
        }
        this.version_ = this.uy.readInteger().intValue();
        if (this.uy.nextIsContextSpecific()) {
            int n3 = this.uy.readContextSpecific(16);
            if (n3 != 0) {
                throw new CMSParsingException("Invalid OriginatorInfo tag: " + n3);
            }
            this.originatorInfo_ = new OriginatorInfo((InputStream)this.uy);
        }
        objectArray = RecipientInfo.parseRecipientInfos((InputStream)this.uy, this.securityProvider_);
        this.recipientInfos_ = Util.getVector((Object[])objectArray);
        if (this.originatorInfo_ != null && !this.originatorInfo_.isEmpty()) {
            int n4 = 0;
            while (n4 < objectArray.length) {
                KeyAgreeRecipientInfo keyAgreeRecipientInfo;
                KeyIdentifier keyIdentifier;
                if (((RecipientInfo)objectArray[n4]).getRecipientInfoType() == 1 && (keyIdentifier = (keyAgreeRecipientInfo = (KeyAgreeRecipientInfo)objectArray[n4]).getOriginator()) != null && keyIdentifier.getKeyIdType() != 4) {
                    try {
                        X509Certificate x509Certificate = this.originatorInfo_.getCertificate((CertificateIdentifier)keyIdentifier);
                        if (x509Certificate != null) {
                            keyAgreeRecipientInfo.a(x509Certificate.getPublicKey(), null);
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n4;
            }
        }
        this.encryptedContentInfo_ = new EncryptedContentInfoStream((InputStream)this.uy);
        this.encryptedContentInfo_.setSecurityProvider(this.securityProvider_);
        if (this.encryptedContentInfo_.a != null) {
            this.encryptedContentInfo_.a = new NotifyEOFInputStream(this.encryptedContentInfo_.a);
            ((NotifyEOFInputStream)this.encryptedContentInfo_.a).addEOFListener((EOFListener)this);
        }
    }

    public int getBlockSize() {
        return this.blockSize_;
    }

    public ObjectID getContentType() {
        return ObjectID.cms_envelopedData;
    }

    public EncryptedContentInfoStream getEncryptedContentInfo() {
        return this.encryptedContentInfo_;
    }

    public InputStream getInputStream() {
        return this.encryptedContentInfo_.getInputStream();
    }

    public int getMode() {
        return this.encryptedContentInfo_.getMode();
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo_;
    }

    public RecipientInfo getRecipientInfo(KeyIdentifier keyIdentifier) {
        Enumeration enumeration = this.recipientInfos_.elements();
        while (enumeration.hasMoreElements()) {
            RecipientInfo recipientInfo = (RecipientInfo)enumeration.nextElement();
            if (!recipientInfo.isRecipientInfoFor(keyIdentifier)) continue;
            return recipientInfo;
        }
        return null;
    }

    public RecipientInfo getRecipientInfo(X509Certificate x509Certificate) {
        Enumeration enumeration = this.recipientInfos_.elements();
        while (enumeration.hasMoreElements()) {
            RecipientInfo recipientInfo = (RecipientInfo)enumeration.nextElement();
            if (recipientInfo.isRecipientInfoFor(x509Certificate) == null) continue;
            return recipientInfo;
        }
        return null;
    }

    public RecipientInfo[] getRecipientInfos() {
        return (RecipientInfo[])Util.toArray((Vector)this.recipientInfos_, (Class)(a != null ? a : (a = EnvelopedDataStream.class$("iaik.cms.RecipientInfo"))));
    }

    public RecipientInfo[] getRecipientInfos(int n2) {
        Enumeration enumeration = this.recipientInfos_.elements();
        Vector<RecipientInfo> vector = new Vector<RecipientInfo>();
        while (enumeration.hasMoreElements()) {
            RecipientInfo recipientInfo = (RecipientInfo)enumeration.nextElement();
            if (recipientInfo.getRecipientInfoType() != n2) continue;
            vector.addElement(recipientInfo);
        }
        Object[] objectArray = new RecipientInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider_;
    }

    public Attribute getUnprotectedAttribute(ObjectID objectID) {
        Attribute attribute = null;
        if (this.unprotectedAttrs_ != null) {
            int n2 = 0;
            while (n2 < this.unprotectedAttrs_.length) {
                if (this.unprotectedAttrs_[n2].getType().equals((Object)objectID)) {
                    attribute = this.unprotectedAttrs_[n2];
                    break;
                }
                ++n2;
            }
        }
        return attribute;
    }

    public Attribute[] getUnprotectedAttributes() {
        if (this.unprotectedAttrs_ == null) {
            this.unprotectedAttrs_ = new Attribute[0];
        }
        return this.unprotectedAttrs_;
    }

    public int getVersion() {
        return this.version_;
    }

    public void notifyEOF() {
        if (this.uy.nextIsContextSpecific()) {
            try {
                int n2 = this.uy.readContextSpecific(17);
                if (n2 != 1) {
                    throw new IOException("Error parsing unprotected attributes. Invalid tag: " + n2);
                }
                this.unprotectedAttrs_ = b.c(DerCoder.decode((InputStream)this.uy));
            }
            catch (CodingException codingException) {
                throw new IOException("Error parsing unprotected attributes: " + codingException.getMessage());
            }
        }
        if (Utils.getIaikProviderVersion() >= 3.16) {
            this.uy.readEOC();
        }
    }

    public void setBlockSize(int n2) {
        this.blockSize_ = n2;
    }

    public void setInputStream(InputStream inputStream) {
        if (this.encryptedContentInfo_ == null) {
            throw new NullPointerException("Cannot set content input stream. Internal EncryptedContentInfo not initialized!");
        }
        this.encryptedContentInfo_.setInputStream(inputStream);
    }

    public void setMode(int n2) {
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.encryptedContentInfo_.setMode(n2);
    }

    public void setOriginatorInfo(OriginatorInfo originatorInfo) {
        this.originatorInfo_ = originatorInfo;
        this.a();
    }

    public void setRecipientInfos(RecipientInfo[] recipientInfoArray) {
        this.recipientInfos_.removeAllElements();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            this.addRecipientInfo(recipientInfoArray[n2]);
            ++n2;
        }
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider_ = securityProvider;
        if (this.recipientInfos_ != null) {
            Object[] objectArray = Util.toArray((Vector)this.recipientInfos_);
            int n2 = 0;
            while (n2 < objectArray.length) {
                RecipientInfo recipientInfo = (RecipientInfo)objectArray[n2];
                if (recipientInfo.getSecurityProvider() == null) {
                    recipientInfo.setSecurityProvider(this.securityProvider_);
                }
                ++n2;
            }
        }
        if (this.encryptedContentInfo_ != null && this.encryptedContentInfo_.getSecurityProvider() == null) {
            this.encryptedContentInfo_.setSecurityProvider(securityProvider);
        }
    }

    public void setUnprotectedAttributes(Attribute[] attributeArray) {
        this.unprotectedAttrs_ = attributeArray;
        this.a();
    }

    public void setupCipher(Key key) {
        this.encryptedContentInfo_.setupCipher(key);
    }

    public SecretKey setupCipher(Key key, int n2) {
        if (n2 < 0 || n2 > this.recipientInfos_.size()) {
            throw new ArrayIndexOutOfBoundsException("RecipientInfo index out of bounds!");
        }
        RecipientInfo recipientInfo = (RecipientInfo)this.recipientInfos_.elementAt(n2);
        SecretKey secretKey = recipientInfo.decryptKey(key, null, this.encryptedContentInfo_.getContentEncryptionAlgorithm().getRawImplementationName());
        this.setupCipher(secretKey);
        return secretKey;
    }

    public SecretKey setupCipher(Key key, KeyIdentifier keyIdentifier) {
        RecipientInfo recipientInfo = this.getRecipientInfo(keyIdentifier);
        if (recipientInfo == null) {
            throw new CMSException("No recipient for the given recipient identifier included!");
        }
        SecretKey secretKey = recipientInfo.decryptKey(key, keyIdentifier, this.encryptedContentInfo_.getContentEncryptionAlgorithm().getRawImplementationName());
        this.setupCipher(secretKey);
        return secretKey;
    }

    public SecretKey setupCipher(Key key, X509Certificate x509Certificate) {
        RecipientInfo recipientInfo = null;
        CertificateIdentifier certificateIdentifier = null;
        Enumeration enumeration = this.recipientInfos_.elements();
        while (enumeration.hasMoreElements()) {
            recipientInfo = (RecipientInfo)enumeration.nextElement();
            certificateIdentifier = recipientInfo.isRecipientInfoFor(x509Certificate);
            if (certificateIdentifier != null) break;
        }
        if (certificateIdentifier == null) {
            throw new CMSException("No recipient for the given recipient identifier included!");
        }
        SecretKey secretKey = recipientInfo.decryptKey(key, certificateIdentifier, this.encryptedContentInfo_.getContentEncryptionAlgorithm().getRawImplementationName());
        this.setupCipher(secretKey);
        return secretKey;
    }

    public ASN1Object toASN1Object() {
        return this.toASN1Object(this.blockSize_);
    }

    protected ASN1Object toASN1Object(int n2) {
        SEQUENCE sEQUENCE;
        if (n2 <= 0) {
            n2 = this.blockSize_;
        }
        if (this.recipientInfos_ == null || this.recipientInfos_.size() == 0) {
            throw new CMSException("No recipients specified.");
        }
        if (this.symmetricKey_ != null && this.keyChanged_) {
            sEQUENCE = this.recipientInfos_.elements();
            while (sEQUENCE.hasMoreElements()) {
                ((RecipientInfo)sEQUENCE.nextElement()).encryptKey(this.symmetricKey_);
            }
            this.keyChanged_ = false;
        }
        this.encryptedContentInfo_.setBlockSize(n2);
        sEQUENCE = new SEQUENCE(n2 > 0);
        try {
            sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
            if (this.originatorInfo_ != null && !this.originatorInfo_.isEmpty()) {
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, this.originatorInfo_.toASN1Object(), true));
            }
            sEQUENCE.addComponent((ASN1Object)RecipientInfo.createRecipientInfos(this.recipientInfos_));
            sEQUENCE.addComponent(this.encryptedContentInfo_.toASN1Object());
            if (this.unprotectedAttrs_ != null && this.unprotectedAttrs_.length > 0) {
                ASN1Object aSN1Object = ASN.createSetOf((ASN1Type[])this.unprotectedAttrs_);
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(1, aSN1Object, true));
            }
        }
        catch (CodingException codingException) {
            throw new CMSException(codingException.toString());
        }
        return sEQUENCE;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version_ + "\n");
        if (this.originatorInfo_ != null && !this.originatorInfo_.isEmpty()) {
            stringBuffer.append("originatorInfo: " + this.originatorInfo_ + "\n");
        }
        if (bl) {
            n2 = 0;
            while (n2 < this.recipientInfos_.size()) {
                stringBuffer.append("RecipientInfo " + (n2 + 1) + ": {\n");
                Utils.printIndented(((RecipientInfo)this.recipientInfos_.elementAt(n2)).toString(), true, stringBuffer);
                stringBuffer.append("\n}\n");
                ++n2;
            }
        } else {
            stringBuffer.append("RecipientInfos: " + this.recipientInfos_.size() + "\n");
        }
        stringBuffer.append("EncryptedContentInfo: {\n");
        Utils.printIndented(this.encryptedContentInfo_.toString(), true, stringBuffer);
        stringBuffer.append("\n}");
        if (this.unprotectedAttrs_ != null && this.unprotectedAttrs_.length > 0) {
            stringBuffer.append("\nUnprotected attributes: {\n");
            n2 = 0;
            while (n2 < this.unprotectedAttrs_.length) {
                Utils.printIndented(this.unprotectedAttrs_[n2].toString(), false, stringBuffer);
                ++n2;
            }
            stringBuffer.append("\n}");
        }
        return stringBuffer.toString();
    }

    public void writeTo(OutputStream outputStream) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    public void writeTo(OutputStream outputStream, int n2) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(n2), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }
}

