/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.cms.CMSException;
import iaik.cms.CertificateSet;
import iaik.cms.DebugCMS;
import iaik.cms.OriginatorInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.RevocationInfoChoices;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import iaik.cms.t;
import iaik.utils.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.SecretKey;

public class EnvelopedDataOutputStream
extends OutputStream {
    private static boolean a = false;
    private int b = 0;
    private OriginatorInfo tz;
    private Vector tA = new Vector();
    private t uz;
    private SecretKey uA;
    private Attribute[] uB;
    private SecurityProvider tY;
    private OutputStream uC;
    private boolean j;
    private boolean k = true;
    private boolean up;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    private EnvelopedDataOutputStream() {
    }

    public EnvelopedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID) {
        this(objectID, outputStream, algorithmID, -1, null);
    }

    public EnvelopedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID, int n2) {
        this(objectID, outputStream, algorithmID, n2, null);
    }

    public EnvelopedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID, int n2, SecurityProvider securityProvider) {
        this();
        this.uC = outputStream;
        this.tY = securityProvider;
        this.uz = new t(objectID, outputStream);
        this.uz.b(false);
        this.uz.a(securityProvider);
        this.uA = this.uz.a(algorithmID, n2);
    }

    public EnvelopedDataOutputStream(OutputStream outputStream, AlgorithmID algorithmID) {
        this(ObjectID.cms_data, outputStream, algorithmID, -1, null);
    }

    public EnvelopedDataOutputStream(OutputStream outputStream, AlgorithmID algorithmID, int n2) {
        this(ObjectID.cms_data, outputStream, algorithmID, n2, null);
    }

    public void addRecipientInfo(RecipientInfo recipientInfo) {
        if (recipientInfo.getSecurityProvider() == null) {
            recipientInfo.setSecurityProvider(this.tY);
        }
        this.tA.addElement(recipientInfo);
        this.a();
    }

    private void a() {
        Object object;
        this.b = 0;
        if (this.tz != null) {
            this.b = 2;
            object = this.tz.getRevocationInfoChoices();
            if (((RevocationInfoChoices)object).containsOtherRevocationInfos()) {
                this.b = 4;
            } else {
                CertificateSet certificateSet = this.tz.getCertificateSet();
                if (certificateSet.containsOtherCertificates()) {
                    this.b = 4;
                } else if (certificateSet.getAttributeCertificateType() == 2) {
                    this.b = 3;
                }
            }
        }
        if (this.b < 3) {
            object = this.tA.elements();
            while (object.hasMoreElements()) {
                int n2 = ((RecipientInfo)object.nextElement()).getRecipientInfoType();
                if (n2 > 2) {
                    this.b = 3;
                    break;
                }
                if (n2 <= 0) continue;
                this.b = 2;
            }
            if (this.b < 2 && this.uB != null && this.uB.length > 0) {
                this.b = 2;
            }
        }
    }

    private void b() {
        if (this.up) {
            throw new IOException("Stream already closed!");
        }
    }

    public void close() {
        this.b();
        this.up = true;
        this.c();
        this.uz.close();
        if (this.uB != null && this.uB.length > 0) {
            try {
                ASN1Object aSN1Object = ASN.createSetOf((ASN1Type[])this.uB);
                this.uC.write(DerCoder.encode((ASN1Object)new CON_SPEC(1, aSN1Object, true)));
            }
            catch (CodingException codingException) {
                throw new IOException(codingException.toString());
            }
        }
        this.uC.write(new byte[2]);
        if (this.k) {
            this.uC.close();
        }
    }

    private void c() {
        if (!this.j) {
            try {
                this.uC.write(new byte[]{48, -128});
                this.uC.write(DerCoder.encode((ASN1Object)new INTEGER(this.b)));
                if (this.tz != null && !this.tz.isEmpty()) {
                    this.uC.write(DerCoder.encode((ASN1Object)new CON_SPEC(0, this.tz.toASN1Object(), true)));
                }
                if (this.uA != null) {
                    Enumeration enumeration = this.tA.elements();
                    while (enumeration.hasMoreElements()) {
                        ((RecipientInfo)enumeration.nextElement()).encryptKey(this.uA);
                    }
                }
                this.uC.write(DerCoder.encode((ASN1Object)RecipientInfo.createRecipientInfos(this.tA)));
                this.j = true;
            }
            catch (CMSException cMSException) {
                throw new IOException(cMSException.toString());
            }
        }
    }

    public void flush() {
        this.b();
        this.c();
        this.uz.flush();
    }

    public SecurityProvider getSecurityProvider() {
        return this.tY;
    }

    public int getVersion() {
        return this.b;
    }

    public boolean isPassThroughClose() {
        return this.k;
    }

    public void setOriginatorInfo(OriginatorInfo originatorInfo) {
        this.tz = originatorInfo;
        this.a();
    }

    public void setPassThroughClose(boolean bl) {
        this.k = bl;
    }

    public void setRecipientInfos(RecipientInfo[] recipientInfoArray) {
        this.tA.removeAllElements();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            this.addRecipientInfo(recipientInfoArray[n2]);
            ++n2;
        }
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.tY = securityProvider;
        if (this.tA != null) {
            Object[] objectArray = Util.toArray((Vector)this.tA);
            int n2 = 0;
            while (n2 < objectArray.length) {
                RecipientInfo recipientInfo = (RecipientInfo)objectArray[n2];
                if (recipientInfo.getSecurityProvider() == null) {
                    recipientInfo.setSecurityProvider(this.tY);
                }
                ++n2;
            }
        }
        if (this.uz != null && this.uz.b() == null) {
            this.uz.a(securityProvider);
        }
    }

    public void setUnprotectedAttributes(Attribute[] attributeArray) {
        this.uB = attributeArray;
        this.a();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.b + "\n");
        if (this.tz != null && !this.tz.isEmpty()) {
            stringBuffer.append("originatorInfo: " + this.tz + "\n");
        }
        if (bl) {
            n2 = 0;
            while (n2 < this.tA.size()) {
                stringBuffer.append("RecipientInfo " + (n2 + 1) + ": {\n");
                Utils.printIndented(((RecipientInfo)this.tA.elementAt(n2)).toString(), true, stringBuffer);
                stringBuffer.append("\n}\n");
                ++n2;
            }
        } else {
            stringBuffer.append("RecipientInfos: " + this.tA.size() + "\n");
        }
        stringBuffer.append("EncryptedContentInfo: {\n");
        Utils.printIndented(this.uz.toString(), true, stringBuffer);
        stringBuffer.append("\n}");
        if (this.uB != null && this.uB.length > 0) {
            stringBuffer.append("\nUnprotected attributes: {\n");
            n2 = 0;
            while (n2 < this.uB.length) {
                Utils.printIndented(this.uB[n2].toString(), false, stringBuffer);
                ++n2;
            }
            stringBuffer.append("\n}");
        }
        return stringBuffer.toString();
    }

    public void write(int n2) {
        this.b();
        this.write(new byte[]{(byte)(n2 & 0xFF)}, 0, 1);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.b();
        this.c();
        this.uz.write(byArray, n2, n3);
    }
}

