/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.Content;
import iaik.cms.EncryptedContentInfo;
import iaik.cms.EnvelopedDataStream;
import iaik.cms.KeyAgreeRecipientInfo;
import iaik.cms.KeyIdentifier;
import iaik.cms.OriginatorInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import iaik.cms.b;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EnvelopedData
extends EnvelopedDataStream
implements Content {
    protected EnvelopedData() {
        this.blockSize_ = -1;
    }

    public EnvelopedData(ASN1Object aSN1Object) {
        this(aSN1Object, null);
    }

    public EnvelopedData(ASN1Object aSN1Object, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(aSN1Object);
    }

    public EnvelopedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID) {
        this(objectID, byArray, algorithmID, -1);
    }

    public EnvelopedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID, int n2) {
        this(objectID, byArray, algorithmID, n2, null);
    }

    public EnvelopedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID, int n2, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.encryptedContentInfo_ = new EncryptedContentInfo(objectID, byArray);
        this.encryptedContentInfo_.setSecurityProvider(this.securityProvider_);
        this.symmetricKey_ = this.encryptedContentInfo_.setupCipher(algorithmID, n2);
        this.keyChanged_ = true;
    }

    public EnvelopedData(InputStream inputStream) {
        this(inputStream, (SecurityProvider)null);
    }

    public EnvelopedData(InputStream inputStream, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(inputStream);
    }

    public EnvelopedData(byte[] byArray, AlgorithmID algorithmID) {
        this(ObjectID.cms_data, byArray, algorithmID, -1);
    }

    public EnvelopedData(byte[] byArray, AlgorithmID algorithmID, int n2) {
        this(ObjectID.cms_data, byArray, algorithmID, n2);
    }

    public EnvelopedData(RecipientInfo[] recipientInfoArray, EncryptedContentInfo encryptedContentInfo) {
        this();
        this.setRecipientInfos(recipientInfoArray);
        this.encryptedContentInfo_ = encryptedContentInfo;
    }

    public void decode(ASN1Object aSN1Object) {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode((ASN1Object)aSN1Object)));
        }
        catch (IOException iOException) {
            throw new CMSParsingException(iOException.getMessage());
        }
    }

    public void decode(InputStream inputStream) {
        int n2;
        Object[] objectArray;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = null;
        DerInputStream derInputStream2 = ((DerInputStream)inputStream).readSequence();
        int n3 = derInputStream2.nextTag();
        if (n3 == 6) {
            objectArray = derInputStream2.readObjectID();
            if (!objectArray.equals((Object)ObjectID.cms_envelopedData)) {
                throw new CMSParsingException("Content type not EnvelopedData!");
            }
            derInputStream = derInputStream2.readContextSpecific().readSequence();
        } else {
            derInputStream = derInputStream2;
        }
        this.version_ = derInputStream.readInteger().intValue();
        if (derInputStream.nextIsContextSpecific()) {
            int n4 = derInputStream.readContextSpecific(16);
            if (n4 != 0) {
                throw new CMSParsingException("Invalid OriginatorInfo tag: " + n4);
            }
            this.originatorInfo_ = new OriginatorInfo((InputStream)derInputStream);
        }
        objectArray = RecipientInfo.parseRecipientInfos((InputStream)derInputStream, this.securityProvider_);
        this.recipientInfos_ = Util.getVector((Object[])objectArray);
        if (this.originatorInfo_ != null && !this.originatorInfo_.isEmpty()) {
            n2 = 0;
            while (n2 < objectArray.length) {
                KeyAgreeRecipientInfo keyAgreeRecipientInfo;
                KeyIdentifier keyIdentifier;
                if (((RecipientInfo)objectArray[n2]).getRecipientInfoType() == 1 && (keyIdentifier = (keyAgreeRecipientInfo = (KeyAgreeRecipientInfo)objectArray[n2]).getOriginator()) != null && keyIdentifier.getKeyIdType() != 4) {
                    try {
                        X509Certificate x509Certificate = this.originatorInfo_.getCertificate((CertificateIdentifier)keyIdentifier);
                        if (x509Certificate != null) {
                            keyAgreeRecipientInfo.a(x509Certificate.getPublicKey(), null);
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        this.encryptedContentInfo_ = new EncryptedContentInfo();
        this.encryptedContentInfo_.setSecurityProvider(this.securityProvider_);
        this.encryptedContentInfo_.decode((InputStream)derInputStream);
        if (derInputStream.nextIsContextSpecific()) {
            try {
                n2 = derInputStream.readContextSpecific(17);
                if (n2 != 1) {
                    throw new CMSParsingException("Invalid tag for unprotected attributes: " + n2);
                }
                this.unprotectedAttrs_ = b.c(DerCoder.decode((InputStream)derInputStream));
            }
            catch (CodingException codingException) {
                throw new CMSParsingException("Error parsing unprotected attributes: " + codingException.getMessage());
            }
        }
        if (Utils.getIaikProviderVersion() >= 3.16) {
            derInputStream.readEOC();
        }
    }

    public byte[] getContent() {
        return ((EncryptedContentInfo)this.encryptedContentInfo_).getContent();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    public void setContent(byte[] byArray) {
        if (this.encryptedContentInfo_ == null) {
            throw new NullPointerException("Cannot set content. Internal EncryptedContentInfo not initialized!");
        }
        ((EncryptedContentInfo)this.encryptedContentInfo_).setContent(byArray);
    }

    public void setInputStream(InputStream inputStream) {
        if (this.encryptedContentInfo_ == null) {
            throw new NullPointerException("Cannot set content input stream. Internal EncryptedContentInfo not initialized!");
        }
        this.encryptedContentInfo_.setInputStream(inputStream);
    }

    protected ASN1Object toASN1Object(int n2) {
        SEQUENCE sEQUENCE;
        if (n2 <= 0) {
            n2 = this.blockSize_;
        }
        if (this.recipientInfos_ == null) {
            throw new CMSException("No recipients specified.");
        }
        if (this.symmetricKey_ != null && this.keyChanged_) {
            sEQUENCE = this.recipientInfos_.elements();
            while (sEQUENCE.hasMoreElements()) {
                ((RecipientInfo)sEQUENCE.nextElement()).encryptKey(this.symmetricKey_);
            }
            this.keyChanged_ = false;
        }
        this.encryptedContentInfo_.setBlockSize(n2);
        sEQUENCE = new SEQUENCE(n2 > 0);
        try {
            sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
            if (this.originatorInfo_ != null && !this.originatorInfo_.isEmpty()) {
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, this.originatorInfo_.toASN1Object(), true));
            }
            sEQUENCE.addComponent((ASN1Object)RecipientInfo.createRecipientInfos(this.recipientInfos_));
            sEQUENCE.addComponent(this.encryptedContentInfo_.toASN1Object());
            if (this.unprotectedAttrs_ != null && this.unprotectedAttrs_.length > 0) {
                ASN1Object aSN1Object = ASN.createSetOf((ASN1Type[])this.unprotectedAttrs_);
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(1, aSN1Object, true));
            }
        }
        catch (CodingException codingException) {
            throw new CMSException(codingException.toString());
        }
        return sEQUENCE;
    }
}

