/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.ContentStream;
import iaik.cms.DebugCMS;
import iaik.cms.EncryptedContentInfoStream;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import iaik.cms.b;
import iaik.utils.EOFListener;
import iaik.utils.NotifyEOFInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class EncryptedDataStream
implements ContentStream,
EOFListener {
    private static boolean rH = false;
    protected int version_ = 0;
    protected int blockSize_ = 2048;
    protected EncryptedContentInfoStream encryptedContentInfo_;
    protected Attribute[] unprotectedAttrs_;
    protected SecurityProvider securityProvider_;
    private DerInputStream uy;
    static Class a;

    static {
        rH = DebugCMS.getDebugMode() && rH;
    }

    protected EncryptedDataStream() {
    }

    public EncryptedDataStream(ObjectID objectID, InputStream inputStream, int n2) {
        this();
        this.encryptedContentInfo_ = new EncryptedContentInfoStream(objectID, inputStream);
        this.encryptedContentInfo_.setBlockSize(n2);
        this.blockSize_ = n2;
    }

    public EncryptedDataStream(EncryptedContentInfoStream encryptedContentInfoStream) {
        this();
        this.encryptedContentInfo_ = encryptedContentInfoStream;
    }

    public EncryptedDataStream(InputStream inputStream) {
        this();
        this.decode(inputStream);
    }

    public EncryptedDataStream(InputStream inputStream, int n2) {
        this(ObjectID.cms_data, inputStream, n2);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void decode(InputStream inputStream) {
        DerInputStream derInputStream;
        int n2;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        if ((n2 = (derInputStream = ((DerInputStream)inputStream).readSequence()).nextTag()) == 6) {
            ObjectID objectID = derInputStream.readObjectID();
            if (!objectID.equals((Object)ObjectID.cms_encryptedData)) {
                throw new CMSParsingException("Content type not EncryptedData!");
            }
            this.uy = derInputStream.readContextSpecific().readSequence();
        } else {
            this.uy = derInputStream;
        }
        this.version_ = this.uy.readInteger().intValue();
        this.encryptedContentInfo_ = new EncryptedContentInfoStream((InputStream)this.uy);
        this.encryptedContentInfo_.a = new NotifyEOFInputStream(this.encryptedContentInfo_.a);
        ((NotifyEOFInputStream)this.encryptedContentInfo_.a).addEOFListener((EOFListener)this);
    }

    public int getBlockSize() {
        return this.blockSize_;
    }

    public ObjectID getContentType() {
        return ObjectID.cms_encryptedData;
    }

    public EncryptedContentInfoStream getEncryptedContentInfo() {
        return this.encryptedContentInfo_;
    }

    public InputStream getInputStream() {
        return this.encryptedContentInfo_.getInputStream();
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider_;
    }

    public Attribute getUnprotectedAttribute(ObjectID objectID) {
        Attribute attribute = null;
        if (this.unprotectedAttrs_ != null) {
            int n2 = 0;
            while (n2 < this.unprotectedAttrs_.length) {
                if (this.unprotectedAttrs_[n2].getType().equals((Object)objectID)) {
                    attribute = this.unprotectedAttrs_[n2];
                    break;
                }
                ++n2;
            }
        }
        return attribute;
    }

    public Attribute[] getUnprotectedAttributes() {
        if (this.unprotectedAttrs_ == null) {
            this.unprotectedAttrs_ = new Attribute[0];
        }
        return this.unprotectedAttrs_;
    }

    public int getVersion() {
        return this.version_;
    }

    public void notifyEOF() {
        if (this.uy.nextIsContextSpecific()) {
            try {
                int n2 = this.uy.readContextSpecific(17);
                if (n2 != 1) {
                    throw new IOException("Error parsing unprotected attributes. Invalid tag: " + n2);
                }
                this.unprotectedAttrs_ = b.c(DerCoder.decode((InputStream)this.uy));
            }
            catch (CodingException codingException) {
                throw new IOException("Error parsing unprotected attributes: " + codingException.getMessage());
            }
        }
        if (Utils.getIaikProviderVersion() >= 3.16) {
            this.uy.readEOC();
        }
    }

    public void setBlockSize(int n2) {
        this.blockSize_ = n2;
    }

    public void setInputStream(InputStream inputStream) {
        if (this.encryptedContentInfo_ == null) {
            throw new NullPointerException("Cannot set content input stream. Internal EncryptedContentInfo not initialized!");
        }
        this.encryptedContentInfo_.setInputStream(inputStream);
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider_ = securityProvider;
        if (this.encryptedContentInfo_ != null && this.encryptedContentInfo_.getSecurityProvider() == null) {
            this.encryptedContentInfo_.setSecurityProvider(securityProvider);
        }
    }

    public void setUnprotectedAttributes(Attribute[] attributeArray) {
        this.unprotectedAttrs_ = attributeArray;
        this.version_ = this.unprotectedAttrs_ != null ? 2 : 0;
    }

    AlgorithmParameterSpec b(AlgorithmID algorithmID, int n2) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        SecureRandom secureRandom = securityProvider.getSecureRandom();
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n2);
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(byArray));
        sEQUENCE.addComponent((ASN1Object)new INTEGER(BigInteger.valueOf(n2)));
        algorithmID.setParameter((ASN1Object)sEQUENCE);
        return pBEParameterSpec;
    }

    public void setupCipher(AlgorithmID algorithmID, Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            this.encryptedContentInfo_.setupCipher(algorithmID, key, algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.toString());
        }
    }

    public void setupCipher(AlgorithmID algorithmID, char[] cArray) {
        this.setupCipher(algorithmID, cArray, 2000);
    }

    public void setupCipher(AlgorithmID algorithmID, char[] cArray, int n2) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        try {
            AlgorithmParameterSpec algorithmParameterSpec = this.b(algorithmID, n2);
            Key key = securityProvider.getPBEKey(cArray, algorithmID);
            this.encryptedContentInfo_.setupCipher(algorithmID, key, algorithmParameterSpec);
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Error creating PBE key: " + exception.getMessage());
        }
    }

    public void setupCipher(Key key) {
        try {
            this.encryptedContentInfo_.setupCipher(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (CMSException cMSException) {
            throw new InvalidKeyException(cMSException.toString());
        }
    }

    public void setupCipher(char[] cArray) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        AlgorithmID algorithmID = this.encryptedContentInfo_.getContentEncryptionAlgorithm();
        AlgorithmParameters algorithmParameters = securityProvider.getAlgorithmParameters(algorithmID, "PBE");
        Object t2 = algorithmParameters.getParameterSpec(a != null ? a : (a = EncryptedDataStream.class$("javax.crypto.spec.PBEParameterSpec")));
        try {
            Key key = securityProvider.getPBEKey(cArray, algorithmID);
            this.encryptedContentInfo_.setupCipher(key, (AlgorithmParameterSpec)t2);
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Error creating PBE key: " + exception.getMessage());
        }
    }

    public ASN1Object toASN1Object() {
        return this.toASN1Object(-1);
    }

    protected ASN1Object toASN1Object(int n2) {
        if (n2 <= 0) {
            n2 = this.blockSize_;
        }
        this.encryptedContentInfo_.setBlockSize(n2);
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
        sEQUENCE.addComponent(this.encryptedContentInfo_.toASN1Object());
        try {
            if (this.unprotectedAttrs_ != null && this.unprotectedAttrs_.length > 0) {
                ASN1Object aSN1Object = ASN.createSetOf((ASN1Type[])this.unprotectedAttrs_);
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(1, aSN1Object, true));
            }
        }
        catch (CodingException codingException) {
            throw new CMSException("Error encoding unprotetced attributes: " + codingException.getMessage());
        }
        return sEQUENCE;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version_ + "\n");
        stringBuffer.append("EncryptedContentInfo: {\n");
        if (this.encryptedContentInfo_ != null) {
            Utils.printIndented(this.encryptedContentInfo_.toString(), true, stringBuffer);
        }
        stringBuffer.append("\n}\n");
        if (this.unprotectedAttrs_ != null && this.unprotectedAttrs_.length > 0) {
            stringBuffer.append("Unprotected Attributes: {\n");
            int n2 = 0;
            while (n2 < this.unprotectedAttrs_.length) {
                Utils.printIndented(this.unprotectedAttrs_[n2].toString(), false, stringBuffer);
                ++n2;
            }
        }
        stringBuffer.append("\n}\n");
        return stringBuffer.toString();
    }

    public void writeTo(OutputStream outputStream) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    public void writeTo(OutputStream outputStream, int n2) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(n2), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }
}

