/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.cms.DebugCMS;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import iaik.cms.t;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class EncryptedDataOutputStream
extends OutputStream {
    private static boolean a = false;
    private int b = 0;
    private t uv;
    private Attribute[] uw;
    private SecurityProvider ux;
    private OutputStream tW;
    private boolean g;
    private boolean sx = true;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    private EncryptedDataOutputStream() {
    }

    public EncryptedDataOutputStream(ObjectID objectID, OutputStream outputStream) {
        this(objectID, outputStream, null);
    }

    public EncryptedDataOutputStream(ObjectID objectID, OutputStream outputStream, SecurityProvider securityProvider) {
        this();
        this.tW = outputStream;
        this.ux = securityProvider;
        this.uv = new t(objectID, outputStream);
        this.uv.b(false);
        this.uv.a(securityProvider);
    }

    public EncryptedDataOutputStream(OutputStream outputStream) {
        this(ObjectID.cms_data, outputStream);
    }

    public void close() {
        this.a();
        this.uv.close();
        if (this.uw != null && this.uw.length > 0) {
            try {
                ASN1Object aSN1Object = ASN.createSetOf((ASN1Type[])this.uw);
                this.tW.write(DerCoder.encode((ASN1Object)new CON_SPEC(1, aSN1Object, true)));
            }
            catch (CodingException codingException) {
                throw new IOException(codingException.toString());
            }
        }
        this.tW.write(new byte[2]);
        if (this.sx) {
            this.tW.close();
        }
    }

    private void a() {
        if (!this.g) {
            this.tW.write(new byte[]{48, -128});
            this.tW.write(DerCoder.encode((ASN1Object)new INTEGER(this.b)));
            this.g = true;
        }
    }

    public void flush() {
        this.a();
        this.uv.flush();
    }

    public SecurityProvider getSecurityProvider() {
        return this.ux;
    }

    public int getVersion() {
        return this.b;
    }

    public boolean isPassThroughClose() {
        return this.sx;
    }

    public void setPassThroughClose(boolean bl) {
        this.sx = bl;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.ux = securityProvider;
        if (this.uv != null && this.uv.b() == null) {
            this.uv.a(securityProvider);
        }
    }

    public void setUnprotectedAttributes(Attribute[] attributeArray) {
        this.uw = attributeArray;
        this.b = this.uw != null ? 2 : 0;
    }

    private AlgorithmParameterSpec b(AlgorithmID algorithmID, int n2) {
        SecurityProvider securityProvider = this.ux;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        SecureRandom secureRandom = securityProvider.getSecureRandom();
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n2);
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(byArray));
        sEQUENCE.addComponent((ASN1Object)new INTEGER(BigInteger.valueOf(n2)));
        algorithmID.setParameter((ASN1Object)sEQUENCE);
        return pBEParameterSpec;
    }

    public void setupCipher(AlgorithmID algorithmID, Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            this.uv.a(algorithmID, key, algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.toString());
        }
    }

    public void setupCipher(AlgorithmID algorithmID, char[] cArray) {
        this.setupCipher(algorithmID, cArray, 2000);
    }

    public void setupCipher(AlgorithmID algorithmID, char[] cArray, int n2) {
        SecurityProvider securityProvider = this.ux;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        try {
            AlgorithmParameterSpec algorithmParameterSpec = this.b(algorithmID, n2);
            Key key = securityProvider.getPBEKey(cArray, algorithmID);
            this.uv.a(algorithmID, key, algorithmParameterSpec);
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Error creating PBE key: " + exception.getMessage());
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.b + "\n");
        stringBuffer.append("EncryptedContentInfo: {\n");
        Utils.printIndented(this.uv.toString(), true, stringBuffer);
        stringBuffer.append("\n}");
        if (this.uw != null && this.uw.length > 0) {
            stringBuffer.append("\nUnprotected attributes: {\n");
            int n2 = 0;
            while (n2 < this.uw.length) {
                Utils.printIndented(this.uw[n2].toString(), false, stringBuffer);
                ++n2;
            }
            stringBuffer.append("\n}");
        }
        return stringBuffer.toString();
    }

    public void write(int n2) {
        this.write(new byte[]{(byte)(n2 & 0xFF)}, 0, 1);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.a();
        this.uv.write(byArray, n2, n3);
    }
}

