/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.Content;
import iaik.cms.EncryptedContentInfo;
import iaik.cms.EncryptedDataStream;
import iaik.cms.Utils;
import iaik.cms.b;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EncryptedData
extends EncryptedDataStream
implements Content {
    protected EncryptedData() {
        this.blockSize_ = -1;
    }

    public EncryptedData(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public EncryptedData(ObjectID objectID, byte[] byArray) {
        this();
        this.encryptedContentInfo_ = new EncryptedContentInfo(objectID, byArray);
    }

    public EncryptedData(EncryptedContentInfo encryptedContentInfo) {
        this();
        this.encryptedContentInfo_ = encryptedContentInfo;
    }

    public EncryptedData(InputStream inputStream) {
        this();
        this.decode(inputStream);
    }

    public EncryptedData(byte[] byArray) {
        this(ObjectID.cms_data, byArray);
    }

    public void decode(ASN1Object aSN1Object) {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode((ASN1Object)aSN1Object)));
        }
        catch (Exception exception) {
            throw new CMSParsingException(exception.getMessage());
        }
    }

    public void decode(InputStream inputStream) {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = null;
        DerInputStream derInputStream2 = ((DerInputStream)inputStream).readSequence();
        int n2 = derInputStream2.nextTag();
        if (n2 == 6) {
            ObjectID objectID = derInputStream2.readObjectID();
            if (!objectID.equals((Object)ObjectID.cms_encryptedData)) {
                throw new CMSParsingException("Content type not EncryptedData!");
            }
            derInputStream = derInputStream2.readContextSpecific().readSequence();
        } else {
            derInputStream = derInputStream2;
        }
        this.version_ = derInputStream.readInteger().intValue();
        this.encryptedContentInfo_ = new EncryptedContentInfo();
        this.encryptedContentInfo_.decode((InputStream)derInputStream);
        if (derInputStream.nextIsContextSpecific()) {
            try {
                int n3 = derInputStream.readContextSpecific(17);
                if (n3 != 1) {
                    throw new CMSParsingException("Invalid tag for unprotected attributes: " + n3);
                }
                this.unprotectedAttrs_ = b.c(DerCoder.decode((InputStream)derInputStream));
            }
            catch (CodingException codingException) {
                throw new CMSParsingException("Error parsing unprotected attributes: " + codingException.getMessage());
            }
        }
        if (Utils.getIaikProviderVersion() >= 3.16) {
            derInputStream.readEOC();
        }
    }

    public byte[] getContent() {
        return ((EncryptedContentInfo)this.encryptedContentInfo_).getContent();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    public void setInputStream(InputStream inputStream) {
        throw new RuntimeException("Method not supported!");
    }

    protected ASN1Object toASN1Object(int n2) {
        if (n2 <= 0) {
            n2 = this.blockSize_;
        }
        this.encryptedContentInfo_.setBlockSize(n2);
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
        sEQUENCE.addComponent(this.encryptedContentInfo_.toASN1Object());
        try {
            if (this.unprotectedAttrs_ != null && this.unprotectedAttrs_.length > 0) {
                ASN1Object aSN1Object = ASN.createSetOf((ASN1Type[])this.unprotectedAttrs_);
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(1, aSN1Object, true));
            }
        }
        catch (Exception exception) {
            throw new CMSException("Error encoding unprotected attributes: " + exception.getMessage());
        }
        return sEQUENCE;
    }
}

