/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CMSRuntimeException;
import iaik.cms.CipherEngine;
import iaik.cms.DebugCMS;
import iaik.cms.EncryptedContentInfo;
import iaik.cms.IaikProvider;
import iaik.cms.InputStreamCipherEngine;
import iaik.cms.MacAADEngine;
import iaik.cms.MacEngine;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public class EncryptedContentInfoStream {
    private static boolean d = false;
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    protected ObjectID contentType_;
    protected AlgorithmID contentEncryptionAlgorithm_;
    InputStream a;
    protected CipherEngine cipher_;
    protected int blockSize_ = 2048;
    protected SecurityProvider securityProvider_;
    boolean rH = false;
    private byte[] uu;
    int c = 0;

    static {
        d = DebugCMS.getDebugMode() && d;
    }

    protected EncryptedContentInfoStream() {
    }

    public EncryptedContentInfoStream(ObjectID objectID, AlgorithmID algorithmID) {
        this();
        this.contentType_ = objectID;
        this.contentEncryptionAlgorithm_ = algorithmID;
    }

    public EncryptedContentInfoStream(ObjectID objectID, InputStream inputStream) {
        this();
        this.a = inputStream;
        this.contentType_ = objectID;
    }

    public EncryptedContentInfoStream(InputStream inputStream) {
        this();
        this.decode(inputStream);
    }

    protected void decode(InputStream inputStream) {
        DerInputStream derInputStream = inputStream instanceof DerInputStream ? ((DerInputStream)inputStream).readSequence() : new DerInputStream(inputStream).readSequence();
        this.contentType_ = derInputStream.readObjectID();
        this.contentEncryptionAlgorithm_ = new AlgorithmID(derInputStream);
        this.a(derInputStream);
    }

    void a(DerInputStream derInputStream) {
        if (derInputStream.nextTag() != -1) {
            if (derInputStream.readContextSpecific(4) != 0) {
                throw new IOException("Error parsing encrypted content!");
            }
            this.a = Utils.c(derInputStream);
            this.c = 1;
        } else {
            this.c = 2;
        }
    }

    public int getBlockSize() {
        return this.blockSize_;
    }

    public AlgorithmID getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm_;
    }

    public ObjectID getContentType() {
        return this.contentType_;
    }

    public InputStream getInputStream() {
        if (this.a == null) {
            return null;
        }
        if (this.cipher_ == null) {
            throw new CMSRuntimeException("Cipher yet not initialized!");
        }
        return ((InputStreamCipherEngine)this.cipher_).cipher(this.a, -1);
    }

    byte[] a() {
        byte[] byArray;
        block2: {
            byArray = null;
            if (this.cipher_ == null || !(this.cipher_ instanceof MacEngine)) break block2;
            try {
                byArray = ((MacEngine)((Object)this.cipher_)).getMac();
            }
            catch (Exception exception) {
                if (!d) break block2;
                exception.printStackTrace();
            }
        }
        return byArray;
    }

    public int getMode() {
        return this.c == 0 ? 1 : this.c;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider_;
    }

    public boolean hasContent() {
        return this.a != null;
    }

    void a(byte[] byArray) {
        this.uu = byArray;
        if (this.cipher_ != null && byArray != null && this.cipher_ instanceof MacAADEngine) {
            ((MacAADEngine)((Object)this.cipher_)).setAdditionalAuthData(byArray);
        }
    }

    void a(boolean bl) {
        this.rH = bl;
    }

    public void setBlockSize(int n2) {
        this.blockSize_ = n2;
    }

    public void setInputStream(InputStream inputStream) {
        this.a = inputStream;
    }

    public void setMode(int n2) {
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        if (this.c != 0) {
            throw new IllegalArgumentException("Mode already set!");
        }
        this.c = n2;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider_ = securityProvider;
    }

    public SecretKey setupCipher(AlgorithmID algorithmID) {
        return this.setupCipher(algorithmID, -1);
    }

    public SecretKey setupCipher(AlgorithmID algorithmID, int n2) {
        return this.setupCipher(algorithmID, n2, (AlgorithmParameterSpec)null);
    }

    public SecretKey setupCipher(AlgorithmID algorithmID, int n2, AlgorithmParameters algorithmParameters) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        SecretKey secretKey = securityProvider.generateKey(algorithmID, n2);
        try {
            this.setupCipher(algorithmID, (Key)secretKey, algorithmParameters);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new NoSuchAlgorithmException("Cannot init cipher with generated cek: " + invalidKeyException.toString());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new NoSuchAlgorithmException("Cannot init cipher with no parameters: " + invalidAlgorithmParameterException.toString());
        }
        return secretKey;
    }

    public SecretKey setupCipher(AlgorithmID algorithmID, int n2, AlgorithmParameterSpec algorithmParameterSpec) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        SecretKey secretKey = securityProvider.generateKey(algorithmID, n2);
        try {
            this.setupCipher(algorithmID, (Key)secretKey, algorithmParameterSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new NoSuchAlgorithmException("Cannot init cipher with generated cek: " + invalidKeyException.toString());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new NoSuchAlgorithmException("Cannot init cipher with no parameters: " + invalidAlgorithmParameterException.toString());
        }
        return secretKey;
    }

    public void setupCipher(AlgorithmID algorithmID, Key key, AlgorithmParameters algorithmParameters) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        this.contentEncryptionAlgorithm_ = (AlgorithmID)algorithmID.clone();
        this.cipher_ = this instanceof EncryptedContentInfo ? (this.rH ? securityProvider.getByteArrayAuthCipherEngine(this.contentEncryptionAlgorithm_, 1, key, algorithmParameters, this.uu) : securityProvider.getByteArrayCipherEngine(this.contentEncryptionAlgorithm_, 1, key, algorithmParameters)) : (this.rH ? securityProvider.getInputStreamAuthCipherEngine(this.contentEncryptionAlgorithm_, 1, key, algorithmParameters, this.uu) : securityProvider.getInputStreamCipherEngine(this.contentEncryptionAlgorithm_, 1, key, algorithmParameters));
    }

    public void setupCipher(AlgorithmID algorithmID, Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        this.contentEncryptionAlgorithm_ = (AlgorithmID)algorithmID.clone();
        this.cipher_ = this instanceof EncryptedContentInfo ? (this.rH ? securityProvider.getByteArrayAuthCipherEngine(this.contentEncryptionAlgorithm_, 1, key, algorithmParameterSpec, this.uu) : securityProvider.getByteArrayCipherEngine(this.contentEncryptionAlgorithm_, 1, key, algorithmParameterSpec)) : (this.rH ? securityProvider.getInputStreamAuthCipherEngine(this.contentEncryptionAlgorithm_, 1, key, algorithmParameterSpec, this.uu) : securityProvider.getInputStreamCipherEngine(this.contentEncryptionAlgorithm_, 1, key, algorithmParameterSpec));
    }

    public void setupCipher(Key key) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = securityProvider.getAlgorithmParameters(this.contentEncryptionAlgorithm_);
        }
        catch (Exception exception) {}
        try {
            this.setupCipher(key, algorithmParameters);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            String string = invalidAlgorithmParameterException.getMessage();
            throw new CMSException("Wrong algorithm parameters! " + (string != null ? string : ""));
        }
    }

    public void setupCipher(Key key, AlgorithmParameters algorithmParameters) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        if (key != null) {
            IaikProvider.a(key, this.contentEncryptionAlgorithm_);
        }
        this.cipher_ = this instanceof EncryptedContentInfo ? securityProvider.getByteArrayCipherEngine(this.contentEncryptionAlgorithm_, 2, key, algorithmParameters) : securityProvider.getInputStreamCipherEngine(this.contentEncryptionAlgorithm_, 2, key, algorithmParameters);
    }

    public void setupCipher(Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        this.cipher_ = this instanceof EncryptedContentInfo ? (this.rH ? securityProvider.getByteArrayAuthCipherEngine(this.contentEncryptionAlgorithm_, 2, key, algorithmParameterSpec, this.uu) : securityProvider.getByteArrayCipherEngine(this.contentEncryptionAlgorithm_, 2, key, algorithmParameterSpec)) : (this.rH ? securityProvider.getInputStreamAuthCipherEngine(this.contentEncryptionAlgorithm_, 2, key, algorithmParameterSpec, this.uu) : securityProvider.getInputStreamCipherEngine(this.contentEncryptionAlgorithm_, 2, key, algorithmParameterSpec));
    }

    public ASN1Object toASN1Object() {
        if (this.contentType_ == null) {
            throw new CMSException("contentType field not set!");
        }
        if (this.contentEncryptionAlgorithm_ == null) {
            throw new CMSException("contentEncryptionAlgorithm field not set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE(this.blockSize_ > 0);
        sEQUENCE.addComponent((ASN1Object)this.contentType_);
        sEQUENCE.addComponent(this.contentEncryptionAlgorithm_.toASN1Object());
        if (this.c != 2) {
            try {
                if (this.a != null) {
                    OCTET_STRING oCTET_STRING = null;
                    if (this.cipher_ == null) {
                        throw new CMSException("Cipher not initialized!");
                    }
                    this.a = ((InputStreamCipherEngine)this.cipher_).cipher(this.a, this.blockSize_);
                    oCTET_STRING = new OCTET_STRING(this.a, this.blockSize_);
                    CON_SPEC cON_SPEC = new CON_SPEC(0, (ASN1Object)oCTET_STRING, true);
                    sEQUENCE.addComponent((ASN1Object)cON_SPEC);
                }
            }
            catch (Exception exception) {
                throw new CMSException(exception.getMessage());
            }
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContentType: " + this.contentType_.getName() + "\n");
        stringBuffer.append("ContentEncryptionAlgorithm: " + this.contentEncryptionAlgorithm_ + "\n");
        stringBuffer.append("Content: ");
        if (this.a != null) {
            stringBuffer.append("supplied from an inputstream");
        }
        return stringBuffer.toString();
    }

    public void writeTo(OutputStream outputStream) {
        DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
    }
}

