/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.ByteArrayCipherEngine;
import iaik.cms.CMSCryptoException;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.CMSRuntimeException;
import iaik.cms.EncryptedContentInfoStream;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;

public class EncryptedContentInfo
extends EncryptedContentInfoStream {
    private byte[] d;

    protected EncryptedContentInfo() {
        this.blockSize_ = -1;
    }

    public EncryptedContentInfo(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public EncryptedContentInfo(ObjectID objectID, AlgorithmID algorithmID) {
        this();
        this.contentType_ = objectID;
        this.contentEncryptionAlgorithm_ = algorithmID;
    }

    public EncryptedContentInfo(ObjectID objectID, byte[] byArray) {
        this();
        if (byArray != null) {
            this.d = (byte[])byArray.clone();
        }
        this.contentType_ = objectID;
    }

    public EncryptedContentInfo(InputStream inputStream) {
        this();
        this.decode(inputStream);
    }

    public void decode(ASN1Object aSN1Object) {
        if (aSN1Object == null) {
            throw new CMSParsingException("Cannot decode a null object!");
        }
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CMSParsingException("Error parsing EncrypedContentInfo: Invalid ASN.1 type " + aSN1Object.getAsnType() + ". Expected SEQUENCE!");
        }
        try {
            int n2 = aSN1Object.countComponents();
            if (n2 < 2 || n2 > 3) {
                throw new CMSParsingException("Error parsing EncrypedContentInfo: Invalid number of components (" + n2 + ")");
            }
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
            if (!aSN1Object2.isA(ASN.ObjectID)) {
                throw new CMSParsingException("Error parsing EncrypedContentInfo: Invalid contentType component " + aSN1Object2.getAsnType() + ". Expected ObjectID!");
            }
            this.contentType_ = (ObjectID)aSN1Object2;
            aSN1Object2 = aSN1Object.getComponentAt(1);
            if (!aSN1Object2.isA(ASN.SEQUENCE)) {
                throw new CMSParsingException("Error parsing EncrypedContentInfo: Invalid contentEncryptionAlgorithm component " + aSN1Object2.getAsnType() + ". Expected ObjectID!");
            }
            this.contentEncryptionAlgorithm_ = new AlgorithmID(aSN1Object2);
            if (n2 == 3) {
                aSN1Object2 = aSN1Object.getComponentAt(2);
                if (!aSN1Object2.isA(ASN.CON_SPEC)) {
                    throw new CMSParsingException("Error parsing EncrypedContentInfo: Invalid encryptedContent component " + aSN1Object2.getAsnType() + ". Expected ConSpec!");
                }
                ((CON_SPEC)aSN1Object2).forceImplicitlyTagged(ASN.OCTET_STRING);
                OCTET_STRING oCTET_STRING = (OCTET_STRING)aSN1Object2.getValue();
                this.d = oCTET_STRING.getWholeValue();
                this.c = 1;
            } else {
                this.c = 2;
            }
        }
        catch (CodingException codingException) {
            throw new CMSParsingException("Error parsing EncrypedContentInfo: " + codingException.toString());
        }
        catch (IOException iOException) {
            throw new CMSParsingException("Error parsing encrypted content: " + iOException.toString());
        }
    }

    void a(DerInputStream derInputStream) {
        if (derInputStream.nextTag() != -1) {
            if (derInputStream.readContextSpecific(4) != 0) {
                throw new IOException("Error parsing encrypted content!");
            }
            try {
                OCTET_STRING oCTET_STRING = (OCTET_STRING)DerCoder.decode((InputStream)derInputStream);
                this.d = oCTET_STRING.getWholeValue();
            }
            catch (CodingException codingException) {
                throw new CMSParsingException("Error parsing content: " + codingException.toString());
            }
            this.c = 1;
        } else {
            this.c = 2;
        }
    }

    public byte[] getContent() {
        return this.d;
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    public InputStream getInputStream() {
        byte[] byArray = this.getContent();
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public boolean hasContent() {
        return this.d != null;
    }

    public void setContent(byte[] byArray) {
        this.d = (byte[])(byArray == null ? null : (byte[])byArray.clone());
    }

    public void setInputStream(InputStream inputStream) {
        try {
            int n2 = inputStream.available();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2 > 0 ? n2 : 2048);
            Util.copyStream((InputStream)inputStream, (OutputStream)byteArrayOutputStream, null);
            this.d = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new CMSRuntimeException("Error reading data: " + exception.toString());
        }
    }

    public void setupCipher(AlgorithmID algorithmID, Key key, AlgorithmParameters algorithmParameters) {
        super.setupCipher(algorithmID, key, algorithmParameters);
        if (this.cipher_ != null && this.d != null) {
            try {
                this.d = ((ByteArrayCipherEngine)this.cipher_).cipher(this.d);
            }
            catch (CMSCryptoException cMSCryptoException) {
                throw new InvalidAlgorithmParameterException(cMSCryptoException.getMessage());
            }
        }
    }

    public void setupCipher(AlgorithmID algorithmID, Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        super.setupCipher(algorithmID, key, algorithmParameterSpec);
        if (this.cipher_ != null && this.d != null) {
            try {
                this.d = ((ByteArrayCipherEngine)this.cipher_).cipher(this.d);
            }
            catch (CMSCryptoException cMSCryptoException) {
                throw new InvalidAlgorithmParameterException(cMSCryptoException.getMessage());
            }
        }
    }

    public void setupCipher(Key key, AlgorithmParameters algorithmParameters) {
        super.setupCipher(key, algorithmParameters);
        if (this.d != null) {
            try {
                this.d = ((ByteArrayCipherEngine)this.cipher_).cipher(this.d);
            }
            catch (CMSCryptoException cMSCryptoException) {
                throw new InvalidAlgorithmParameterException(cMSCryptoException.getMessage());
            }
        }
    }

    public void setupCipher(Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        super.setupCipher(key, algorithmParameterSpec);
        if (this.c != 2 && this.d != null) {
            try {
                this.d = ((ByteArrayCipherEngine)this.cipher_).cipher(this.d);
            }
            catch (CMSCryptoException cMSCryptoException) {
                throw new InvalidAlgorithmParameterException(cMSCryptoException.getMessage());
            }
        }
    }

    public ASN1Object toASN1Object() {
        if (this.contentEncryptionAlgorithm_ == null) {
            throw new CMSException("contentEncryptionAlgorithm field not set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE(this.blockSize_ > 0);
        sEQUENCE.addComponent((ASN1Object)this.contentType_);
        sEQUENCE.addComponent(this.contentEncryptionAlgorithm_.toASN1Object());
        if (this.c != 2 && this.d != null && this.d.length > 0) {
            OCTET_STRING oCTET_STRING = null;
            oCTET_STRING = this.blockSize_ > 0 ? new OCTET_STRING((InputStream)new ByteArrayInputStream(this.d), this.blockSize_) : new OCTET_STRING(this.d);
            CON_SPEC cON_SPEC = new CON_SPEC(0, (ASN1Object)oCTET_STRING, true);
            cON_SPEC.setIndefiniteLength(sEQUENCE.indefiniteLength());
            sEQUENCE.addComponent((ASN1Object)cON_SPEC);
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContentType: " + this.contentType_.getName() + "\n");
        stringBuffer.append("ContentEncryptionAlgorithm: " + this.contentEncryptionAlgorithm_ + "\n");
        stringBuffer.append("Content: ");
        if (this.d != null) {
            stringBuffer.append(String.valueOf(this.d.length) + " bytes");
        }
        return stringBuffer.toString();
    }
}

