/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.cms.CMSException;
import iaik.cms.CMSObjectID;
import iaik.cms.CMSParsingException;
import iaik.cms.Utils;
import iaik.cms.aa;
import java.io.InputStream;
import java.io.OutputStream;

public class EncapsulatedContentInfoStream {
    protected ObjectID contentType_;
    protected InputStream contentData_;
    protected int blockSize_ = 2048;

    protected EncapsulatedContentInfoStream() {
    }

    public EncapsulatedContentInfoStream(ObjectID objectID) {
        this();
        this.contentType_ = objectID;
        this.contentData_ = null;
    }

    public EncapsulatedContentInfoStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public EncapsulatedContentInfoStream(InputStream inputStream, ObjectID objectID) {
        this();
        this.contentType_ = objectID;
        this.contentData_ = inputStream;
    }

    EncapsulatedContentInfoStream(InputStream inputStream, boolean bl) {
        this();
        DerInputStream derInputStream = inputStream instanceof DerInputStream ? (DerInputStream)inputStream : new DerInputStream(inputStream);
        this.a(derInputStream, bl);
    }

    protected void decode(DerInputStream derInputStream) {
        this.a(derInputStream, false);
    }

    private void a(DerInputStream derInputStream, boolean bl) {
        aa aa2;
        DerInputStream derInputStream2 = derInputStream.readSequence();
        if (bl) {
            aa2 = new aa((InputStream)derInputStream2, 20);
            DerInputStream derInputStream3 = new DerInputStream((InputStream)aa2);
            ObjectID objectID = derInputStream3.readObjectID();
            this.contentType_ = new CMSObjectID(objectID, aa2.b());
        } else {
            this.contentType_ = derInputStream2.readObjectID();
        }
        if (derInputStream2.nextTag() == -1) {
            this.contentData_ = null;
            return;
        }
        aa2 = derInputStream2.readContextSpecific();
        if (aa2.nextTag() != 4) {
            throw new CMSParsingException("Next tag no OCTET STRING!");
        }
        this.contentData_ = Utils.c((DerInputStream)aa2);
    }

    public InputStream getContentInputStream() {
        return this.contentData_;
    }

    public ObjectID getContentType() {
        return this.contentType_;
    }

    public boolean hasContent() {
        return this.contentData_ != null;
    }

    public void setBlockSize(int n2) {
        this.blockSize_ = n2;
    }

    public ASN1Object toASN1Object() {
        if (this.contentType_ == null) {
            throw new CMSException("Cannot create ASN.1 object of CMS EncapsulatedContentInfo. At least the content type must be set!");
        }
        boolean bl = this.blockSize_ > 0;
        SEQUENCE sEQUENCE = new SEQUENCE(bl);
        sEQUENCE.addComponent((ASN1Object)this.contentType_);
        if (this.contentData_ != null) {
            OCTET_STRING oCTET_STRING = this.blockSize_ > 0 ? new OCTET_STRING(this.contentData_, this.blockSize_) : new OCTET_STRING(this.contentData_);
            CON_SPEC cON_SPEC = new CON_SPEC(0, (ASN1Object)oCTET_STRING);
            cON_SPEC.setIndefiniteLength(bl);
            sEQUENCE.addComponent((ASN1Object)cON_SPEC);
        }
        return sEQUENCE;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContentType: " + this.contentType_.getName() + " \n");
        if (this.contentData_ != null) {
            stringBuffer.append("Content data supplied from input stream.");
        } else {
            stringBuffer.append("no content!");
        }
        return stringBuffer.toString();
    }

    public void writeTo(OutputStream outputStream) {
        DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
    }
}

