/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.EncapsulatedContentInfoStream;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EncapsulatedContentInfo
extends EncapsulatedContentInfoStream {
    private byte[] a;

    protected EncapsulatedContentInfo() {
        this.blockSize_ = -1;
    }

    public EncapsulatedContentInfo(ASN1Object aSN1Object) {
        this();
        if (aSN1Object == null) {
            throw new CMSParsingException("Cannot parse a null object!");
        }
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CMSParsingException("EncapsulatedContentInfo must be a SEQUENCE!");
        }
        try {
            int n2 = aSN1Object.countComponents();
            if (n2 == 0) {
                throw new CMSParsingException("Missing content type in EncapsulatedContentInfo!");
            }
            if (n2 > 2) {
                throw new CMSParsingException("EncapsulatedContentInfo must not contain more than two components!");
            }
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
            if (!aSN1Object2.isA(ASN.ObjectID)) {
                throw new CMSParsingException("First component of EncapsulatedContentInfo must be content type!");
            }
            this.contentType_ = (ObjectID)aSN1Object2;
            if (n2 == 2) {
                ASN1Object aSN1Object3 = aSN1Object.getComponentAt(1);
                if (!aSN1Object3.isA(ASN.CON_SPEC)) {
                    throw new CMSParsingException("Second EncapsulatedContentInfo component must be context specfic");
                }
                this.a((ASN1Object)aSN1Object3.getValue());
            }
        }
        catch (CodingException codingException) {
            throw new CMSParsingException("Error parsing EncapsulatedContentInfo: " + codingException.toString());
        }
    }

    public EncapsulatedContentInfo(ObjectID objectID) {
        this();
        this.contentType_ = objectID;
        this.a = null;
    }

    public EncapsulatedContentInfo(InputStream inputStream) {
        this();
        if (inputStream instanceof DerInputStream) {
            this.decode((DerInputStream)inputStream);
        } else {
            this.decode(new DerInputStream(inputStream));
        }
    }

    public EncapsulatedContentInfo(byte[] byArray, ObjectID objectID) {
        this();
        this.a = byArray;
        this.contentType_ = objectID;
    }

    protected void decode(DerInputStream derInputStream) {
        DerInputStream derInputStream2 = derInputStream.readSequence();
        this.contentType_ = derInputStream2.readObjectID();
        if (derInputStream2.nextTag() == -1) {
            this.contentData_ = null;
        } else {
            DerInputStream derInputStream3 = derInputStream2.readContextSpecific();
            if (derInputStream3.nextTag() == 4) {
                try {
                    this.a(DerCoder.decode((InputStream)derInputStream3));
                    derInputStream3.readEOC();
                }
                catch (CodingException codingException) {
                    throw new CMSParsingException("Content parsing error: " + codingException.toString());
                }
            } else {
                throw new CMSParsingException("Next tag no OCTET STRING!");
            }
        }
    }

    private void a(ASN1Object aSN1Object) {
        if (aSN1Object == null) {
            throw new CMSParsingException("Cannot decode a null object!");
        }
        if (!aSN1Object.isA(ASN.OCTET_STRING)) {
            throw new CMSParsingException("Encapsulated content must be an OCTET STRING!");
        }
        try {
            this.a = ((OCTET_STRING)aSN1Object).getWholeValue();
        }
        catch (Exception exception) {
            throw new CMSParsingException("Error decoding octet string: " + exception.toString());
        }
    }

    public byte[] getContent() {
        return this.a;
    }

    public InputStream getContentInputStream() {
        return this.a == null ? null : new ByteArrayInputStream(this.a);
    }

    public ObjectID getContentType() {
        return this.contentType_;
    }

    public boolean hasContent() {
        return this.a != null;
    }

    void a(byte[] byArray) {
        this.a = byArray;
    }

    public ASN1Object toASN1Object() {
        if (this.contentType_ == null) {
            throw new CMSException("Cannot create ASN.1 object of CMS EncapsulatedContentInfo. At least the content type must be set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE(this.blockSize_ > 0);
        sEQUENCE.addComponent((ASN1Object)this.contentType_);
        if (this.a != null) {
            OCTET_STRING oCTET_STRING = this.blockSize_ > 0 ? new OCTET_STRING(this.a, this.blockSize_) : new OCTET_STRING(this.a);
            CON_SPEC cON_SPEC = new CON_SPEC(0, (ASN1Object)oCTET_STRING);
            cON_SPEC.setIndefiniteLength(this.blockSize_ > 0);
            sEQUENCE.addComponent((ASN1Object)cON_SPEC);
        }
        return sEQUENCE;
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContentType: " + this.contentType_.getName() + " \n");
        if (this.a != null) {
            stringBuffer.append(String.valueOf(this.a.length) + " bytes");
            if (bl) {
                stringBuffer.append(": " + Util.toString((byte[])this.a, (int)0, (int)15));
                if (this.a.length > 15) {
                    stringBuffer.append("...");
                }
            }
        } else {
            stringBuffer.append("No content!");
        }
        return stringBuffer.toString();
    }

    public void writeTo(OutputStream outputStream) {
        DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
    }
}

