/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.EncodeListener;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.ContentStream;
import iaik.cms.DebugCMS;
import iaik.cms.EncapsulatedContentInfoStream;
import iaik.cms.InputStreamHashEngine;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import iaik.utils.CryptoUtils;
import iaik.utils.EOFListener;
import iaik.utils.NotifyEOFInputStream;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;

public class DigestedDataStream
implements EncodeListener,
ContentStream,
EOFListener {
    private static boolean c = false;
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    protected int version_ = 0;
    protected AlgorithmID digestAlgorithm_;
    private InputStreamHashEngine ur;
    protected ObjectID contentType_;
    private DerInputStream rK;
    protected int blockSize_ = 2048;
    protected EncapsulatedContentInfoStream encapContentInfo_;
    byte[] a;
    byte[] b;
    protected InputStream inputStream_;
    protected int mode_ = 1;
    protected SecurityProvider securityProvider_;

    static {
        c = DebugCMS.getDebugMode() && c;
    }

    protected DigestedDataStream() {
    }

    public DigestedDataStream(ObjectID objectID, AlgorithmID algorithmID, byte[] byArray) {
        this();
        this.mode_ = 2;
        this.contentType_ = objectID;
        this.encapContentInfo_ = new EncapsulatedContentInfoStream(objectID);
        this.digestAlgorithm_ = algorithmID;
        this.a = byArray;
        if (!this.contentType_.equals((Object)ObjectID.cms_data)) {
            this.version_ = 2;
        }
    }

    public DigestedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID, int n2) {
        this(objectID, inputStream, algorithmID, n2, null);
    }

    public DigestedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID, int n2, SecurityProvider securityProvider) {
        this();
        if (algorithmID == null) {
            throw new NullPointerException("No digestAlgorithm specified!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        if (inputStream == null) {
            throw new NullPointerException("No data input stream specified!");
        }
        this.securityProvider_ = securityProvider;
        this.contentType_ = objectID;
        this.mode_ = n2;
        this.inputStream_ = inputStream;
        this.digestAlgorithm_ = (AlgorithmID)algorithmID.clone();
        if (!this.contentType_.equals((Object)ObjectID.cms_data)) {
            this.version_ = 2;
        }
        try {
            this.a(this.digestAlgorithm_);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.getMessage());
        }
    }

    public DigestedDataStream(InputStream inputStream) {
        this(inputStream, (SecurityProvider)null);
    }

    public DigestedDataStream(InputStream inputStream, AlgorithmID algorithmID) {
        this(inputStream, algorithmID, null);
    }

    public DigestedDataStream(InputStream inputStream, AlgorithmID algorithmID, int n2) {
        this(ObjectID.cms_data, inputStream, algorithmID, n2);
    }

    public DigestedDataStream(InputStream inputStream, AlgorithmID algorithmID, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        if (algorithmID == null) {
            throw new IOException("No digestAlgorithm specified!");
        }
        if (inputStream == null) {
            throw new IOException("No input stream supplied!");
        }
        this.inputStream_ = inputStream;
        this.mode_ = 2;
        this.digestAlgorithm_ = algorithmID;
        try {
            this.a(this.digestAlgorithm_);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException.getMessage());
        }
    }

    public DigestedDataStream(InputStream inputStream, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(inputStream);
    }

    public void decode(InputStream inputStream) {
        DerInputStream derInputStream;
        int n2;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        if ((n2 = (derInputStream = ((DerInputStream)inputStream).readSequence()).nextTag()) == 6) {
            ObjectID objectID = derInputStream.readObjectID();
            if (!objectID.equals((Object)ObjectID.cms_digestedData)) {
                throw new CMSParsingException("Content type not DigestedData!");
            }
            this.rK = derInputStream.readContextSpecific().readSequence();
        } else {
            this.rK = derInputStream;
        }
        this.version_ = this.rK.readInteger().intValue();
        this.digestAlgorithm_ = new AlgorithmID(this.rK);
        this.encapContentInfo_ = new EncapsulatedContentInfoStream((InputStream)this.rK);
        this.contentType_ = this.encapContentInfo_.getContentType();
        if (!this.encapContentInfo_.hasContent()) {
            this.mode_ = 2;
            this.notifyEOF();
            return;
        }
        this.inputStream_ = this.encapContentInfo_.getContentInputStream();
        try {
            this.a(this.digestAlgorithm_);
            this.inputStream_ = new NotifyEOFInputStream(this.inputStream_);
            ((NotifyEOFInputStream)this.inputStream_).addEOFListener((EOFListener)this);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("No implementation for hash algorithm: " + noSuchAlgorithmException.getMessage());
        }
    }

    public void encodeCalled(ASN1Object aSN1Object, int n2) {
        try {
            if (this.a != null) {
                aSN1Object.setValue((Object)this.a);
            } else {
                if (this.ur == null) {
                    throw new CodingException("Message Digest not initialized!");
                }
                this.a = this.ur.getHash();
                aSN1Object.setValue((Object)this.a);
            }
        }
        catch (Exception exception) {
            throw new CodingException("Unable to calculate digest: " + exception.getMessage());
        }
    }

    public int getBlockSize() {
        return this.blockSize_;
    }

    public ObjectID getContentType() {
        return ObjectID.cms_digestedData;
    }

    public byte[] getDigest() {
        return this.a;
    }

    public AlgorithmID getDigestAlgorithm() {
        return this.digestAlgorithm_;
    }

    public ObjectID getEncapsulatedContentType() {
        return this.contentType_;
    }

    public InputStream getInputStream() {
        return this.inputStream_;
    }

    public int getMode() {
        return this.mode_;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider_;
    }

    public int getVersion() {
        return this.version_;
    }

    public void notifyEOF() {
        this.a = this.rK.readOctetStringByteArray();
        if (Utils.getIaikProviderVersion() >= 3.16) {
            this.rK.readEOC();
        }
    }

    public void setBlockSize(int n2) {
        this.blockSize_ = n2;
    }

    public void setDigest(byte[] byArray) {
        this.a = byArray;
    }

    public void setInputStream(InputStream inputStream) {
        if (inputStream != null) {
            this.inputStream_ = inputStream;
            try {
                this.a(this.digestAlgorithm_);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CMSException(noSuchAlgorithmException.toString());
            }
        }
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider_ = securityProvider;
    }

    void a(AlgorithmID algorithmID) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        this.ur = securityProvider.getInputStreamHashEngine(algorithmID, this.inputStream_);
        this.inputStream_ = this.ur.getInputStream();
    }

    public ASN1Object toASN1Object() {
        return this.toASN1Object(-1);
    }

    protected ASN1Object toASN1Object(int n2) {
        if (n2 <= 0) {
            n2 = this.blockSize_;
        }
        if (this.digestAlgorithm_ == null) {
            throw new CMSException("digestAlgorithm not set!");
        }
        if (this.mode_ == 1) {
            if (this.ur == null) {
                throw new CMSException("Message Digest not initialized for digest computation!");
            }
            if (this.inputStream_ == null) {
                throw new CMSException("InputStream not set!");
            }
            this.encapContentInfo_ = new EncapsulatedContentInfoStream(this.inputStream_, this.contentType_);
            this.encapContentInfo_.setBlockSize(n2);
        } else if (this.encapContentInfo_ == null) {
            this.encapContentInfo_ = new EncapsulatedContentInfoStream(this.contentType_);
        }
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
        sEQUENCE.addComponent(this.digestAlgorithm_.toASN1Object());
        sEQUENCE.addComponent(this.encapContentInfo_.toASN1Object());
        if (this.a != null) {
            sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.a));
        } else {
            OCTET_STRING oCTET_STRING = new OCTET_STRING();
            oCTET_STRING.addEncodeListener((EncodeListener)this, 1);
            sEQUENCE.addComponent((ASN1Object)oCTET_STRING);
        }
        return sEQUENCE;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version_ + "\n");
        stringBuffer.append("DigestAlgorithm: ");
        if (this.digestAlgorithm_ != null) {
            stringBuffer.append(this.digestAlgorithm_.getName());
        }
        stringBuffer.append("\n");
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        if (this.encapContentInfo_ != null) {
            Utils.printIndented(this.encapContentInfo_.toString(bl), true, stringBuffer);
        }
        stringBuffer.append("\n}\n");
        stringBuffer.append("Digest: ");
        if (this.a != null) {
            stringBuffer.append(Util.toString((byte[])this.a));
        }
        return stringBuffer.toString();
    }

    public boolean verify() {
        if (this.a == null) {
            throw new CMSException("digest value not parsed from encoding!");
        }
        if (this.b != null) {
            return CryptoUtils.equalsBlock((byte[])this.b, (byte[])this.a);
        }
        if (this.ur == null) {
            throw new CMSException("MessageDigest not initialized for digest computation!");
        }
        this.b = this.ur.getHash();
        return CryptoUtils.equalsBlock((byte[])this.b, (byte[])this.a);
    }

    public void writeTo(OutputStream outputStream) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    public void writeTo(OutputStream outputStream, int n2) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(n2), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }
}

