/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.DataOutputStream;
import iaik.cms.DebugCMS;
import iaik.cms.OutputStreamHashEngine;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import iaik.cms.w;
import iaik.utils.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;

public class DigestedDataOutputStream
extends OutputStream {
    private static boolean a = false;
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    private int b = 0;
    private AlgorithmID tT;
    private ObjectID rZ;
    private OutputStreamHashEngine um;
    private OutputStream tW;
    private OutputStream tX;
    private byte[] un;
    private int i = 1;
    private SecurityProvider uo;
    private boolean k;
    private boolean up = true;
    private boolean uq;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    private DigestedDataOutputStream() {
    }

    public DigestedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID, int n2) {
        this(objectID, outputStream, algorithmID, n2, null);
    }

    public DigestedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID, int n2, SecurityProvider securityProvider) {
        this();
        if (algorithmID == null) {
            throw new NullPointerException("No digestAlgorithm specified!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        if (outputStream == null) {
            throw new NullPointerException("Output stream must not be null!");
        }
        this.uo = securityProvider;
        this.rZ = objectID;
        this.tX = n2 == 1 ? new DataOutputStream(outputStream, false) : new w();
        this.i = n2;
        this.tW = outputStream;
        this.tT = (AlgorithmID)algorithmID.clone();
        if (!this.rZ.equals((Object)ObjectID.cms_data)) {
            this.b = 2;
        }
        try {
            this.a(this.tT);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.toString());
        }
    }

    public DigestedDataOutputStream(OutputStream outputStream, AlgorithmID algorithmID, int n2) {
        this(ObjectID.cms_data, outputStream, algorithmID, n2, null);
    }

    private void a() {
        if (this.uq) {
            throw new IOException("Stream already closed!");
        }
    }

    public void close() {
        this.a();
        this.uq = true;
        this.b();
        this.tX.close();
        if (this.i == 1) {
            this.tW.write(new byte[2]);
        }
        this.tW.write(new byte[2]);
        if (this.un == null) {
            if (this.um == null) {
                throw new IOException("Message Digest not initialized!");
            }
            this.un = this.um.getHash();
        }
        this.tW.write(DerCoder.encode((ASN1Object)new OCTET_STRING(this.un)));
        this.tW.write(new byte[2]);
        if (this.up) {
            this.tW.close();
        }
    }

    private void b() {
        if (!this.k) {
            this.tW.write(new byte[]{48, -128});
            this.tW.write(DerCoder.encode((ASN1Object)new INTEGER(this.b)));
            this.tW.write(DerCoder.encode((ASN1Object)this.tT.toASN1Object()));
            this.tW.write(new byte[]{48, -128});
            this.tW.write(DerCoder.encode((ASN1Object)this.rZ));
            if (this.i == 1) {
                this.tW.write(new byte[]{-96, -128});
            }
            this.k = true;
        }
    }

    public void flush() {
        this.a();
        this.b();
        this.tX.flush();
    }

    public byte[] getDigest() {
        return this.un;
    }

    public SecurityProvider getSecurityProvider() {
        return this.uo;
    }

    public int getVersion() {
        return this.b;
    }

    public boolean isPassThroughClose() {
        return this.up;
    }

    public void setDigest(byte[] byArray) {
        this.un = byArray;
    }

    public void setPassThroughClose(boolean bl) {
        this.up = bl;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.uo = securityProvider;
    }

    private void a(AlgorithmID algorithmID) {
        SecurityProvider securityProvider = this.uo;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        this.um = securityProvider.getOutputStreamHashEngine(algorithmID, this.tX);
        this.tX = this.um.getOutputStream();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.b + "\n");
        stringBuffer.append("DigestAlgorithm: ");
        if (this.tT != null) {
            stringBuffer.append(this.tT.getName());
        }
        stringBuffer.append("\n");
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        Utils.printIndented("ContentType: " + this.rZ.getName() + (this.i == 1 ? ", content included\n" : ", no content\n"), true, stringBuffer);
        stringBuffer.append("Digest: ");
        if (this.un != null) {
            stringBuffer.append(Util.toString((byte[])this.un));
        }
        return stringBuffer.toString();
    }

    public void write(int n2) {
        this.a();
        this.write(new byte[]{(byte)(n2 & 0xFF)}, 0, 1);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.a();
        this.b();
        this.tX.write(byArray, n2, n3);
    }
}

