/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.Content;
import iaik.cms.DigestedDataStream;
import iaik.cms.EncapsulatedContentInfo;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;

public class DigestedData
extends DigestedDataStream
implements Content {
    private byte[] rE;

    protected DigestedData() {
        this.blockSize_ = -1;
    }

    public DigestedData(ASN1Object aSN1Object) {
        this(aSN1Object, null);
    }

    public DigestedData(ASN1Object aSN1Object, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(aSN1Object);
    }

    public DigestedData(ObjectID objectID, AlgorithmID algorithmID, byte[] byArray) {
        this();
        this.mode_ = 2;
        this.contentType_ = objectID;
        this.encapContentInfo_ = new EncapsulatedContentInfo(objectID);
        this.digestAlgorithm_ = algorithmID;
        this.a = byArray;
        if (!this.contentType_.equals((Object)ObjectID.cms_data)) {
            this.version_ = 2;
        }
    }

    public DigestedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID, int n2) {
        this(objectID, byArray, algorithmID, n2, null);
    }

    public DigestedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID, int n2, SecurityProvider securityProvider) {
        this();
        if (algorithmID == null) {
            throw new NullPointerException("No digestAlgorithm specified!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.securityProvider_ = securityProvider;
        this.contentType_ = objectID;
        this.mode_ = n2;
        this.rE = byArray;
        if (!this.contentType_.equals((Object)ObjectID.cms_data)) {
            this.version_ = 2;
        }
        this.encapContentInfo_ = n2 == 1 ? new EncapsulatedContentInfo(byArray, this.contentType_) : new EncapsulatedContentInfo(this.contentType_);
        this.digestAlgorithm_ = (AlgorithmID)algorithmID.clone();
        try {
            this.setupMessageDigest(this.digestAlgorithm_, false);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.getMessage());
        }
    }

    public DigestedData(InputStream inputStream) {
        this(inputStream, (SecurityProvider)null);
    }

    public DigestedData(InputStream inputStream, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(inputStream);
    }

    public DigestedData(byte[] byArray, AlgorithmID algorithmID) {
        this(byArray, algorithmID, null);
    }

    public DigestedData(byte[] byArray, AlgorithmID algorithmID, int n2) {
        this(ObjectID.cms_data, byArray, algorithmID, n2);
    }

    public DigestedData(byte[] byArray, AlgorithmID algorithmID, SecurityProvider securityProvider) {
        this();
        this.securityProvider_ = securityProvider;
        this.rE = byArray;
        this.mode_ = 2;
        this.digestAlgorithm_ = algorithmID;
        this.setupMessageDigest(algorithmID, true);
    }

    public void decode(ASN1Object aSN1Object) {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode((ASN1Object)aSN1Object)));
        }
        catch (IOException iOException) {
            throw new CMSParsingException(iOException.getMessage());
        }
    }

    public void decode(InputStream inputStream) {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = null;
        DerInputStream derInputStream2 = ((DerInputStream)inputStream).readSequence();
        int n2 = derInputStream2.nextTag();
        if (n2 == 6) {
            ObjectID objectID = derInputStream2.readObjectID();
            if (!objectID.equals((Object)ObjectID.cms_digestedData)) {
                throw new CMSParsingException("Content type not DigestedData!");
            }
            derInputStream = derInputStream2.readContextSpecific().readSequence();
        } else {
            derInputStream = derInputStream2;
        }
        this.version_ = derInputStream.readInteger().intValue();
        this.digestAlgorithm_ = new AlgorithmID(derInputStream);
        this.encapContentInfo_ = new EncapsulatedContentInfo((InputStream)derInputStream);
        this.contentType_ = this.encapContentInfo_.getContentType();
        if (!this.encapContentInfo_.hasContent()) {
            this.mode_ = 2;
        } else {
            this.rE = ((EncapsulatedContentInfo)this.encapContentInfo_).getContent();
            try {
                this.setupMessageDigest(this.digestAlgorithm_, true);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CMSParsingException(noSuchAlgorithmException.getMessage());
            }
        }
        this.a = derInputStream.readOctetStringByteArray();
        if (Utils.getIaikProviderVersion() >= 3.16) {
            derInputStream.readEOC();
        }
    }

    public byte[] getContent() {
        return this.rE;
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    public InputStream getInputStream() {
        if (this.rE == null) {
            return null;
        }
        return new ByteArrayInputStream(this.rE);
    }

    public void setContent(byte[] byArray) {
        this.rE = byArray;
        if (byArray != null) {
            try {
                boolean bl = this.a != null;
                this.setupMessageDigest(this.digestAlgorithm_, bl);
                if (!bl && this.mode_ == 1) {
                    if (this.encapContentInfo_ == null) {
                        this.encapContentInfo_ = new EncapsulatedContentInfo(this.contentType_);
                    }
                    ((EncapsulatedContentInfo)this.encapContentInfo_).a(byArray);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CMSException(noSuchAlgorithmException.toString());
            }
        }
    }

    protected void setupMessageDigest(AlgorithmID algorithmID, boolean bl) {
        SecurityProvider securityProvider = this.securityProvider_;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        if (this.rE == null) {
            throw new NoSuchAlgorithmException("No content to digest!");
        }
        if (bl) {
            this.b = securityProvider.getHash(algorithmID, this.rE);
        } else {
            this.a = securityProvider.getHash(algorithmID, this.rE);
        }
    }

    protected ASN1Object toASN1Object(int n2) {
        if (this.digestAlgorithm_ == null) {
            throw new CMSException("No digest algorithm set!");
        }
        if (this.encapContentInfo_ == null) {
            throw new CMSException("No content info set!");
        }
        if (n2 <= 0) {
            n2 = this.blockSize_;
        }
        this.encapContentInfo_.setBlockSize(n2);
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
        sEQUENCE.addComponent(this.digestAlgorithm_.toASN1Object());
        sEQUENCE.addComponent(this.encapContentInfo_.toASN1Object());
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.a));
        return sEQUENCE;
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version_ + "\n");
        stringBuffer.append("DigestAlgorithm: ");
        if (this.digestAlgorithm_ != null) {
            stringBuffer.append(this.digestAlgorithm_.getName());
        }
        stringBuffer.append("\n");
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        if (this.encapContentInfo_ != null) {
            Utils.printIndented(this.encapContentInfo_.toString(bl), true, stringBuffer);
        }
        stringBuffer.append("\n}\n");
        stringBuffer.append("Digest: ");
        if (this.a != null) {
            stringBuffer.append(Util.toString((byte[])this.a));
        }
        return stringBuffer.toString();
    }
}

