/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DigestInfo
implements ASN1Type {
    private AlgorithmID sM;
    private byte[] b;

    public DigestInfo(ASN1Object aSN1Object) {
        this.decode(aSN1Object);
    }

    public DigestInfo(AlgorithmID algorithmID, byte[] byArray) {
        this.sM = algorithmID;
        this.b = byArray;
    }

    public DigestInfo(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DerInputStream derInputStream = new DerInputStream((InputStream)byteArrayInputStream);
        try {
            if (derInputStream.nextTag() != 16) {
                throw new CodingException("DigestInfo must be SEQUENCE!");
            }
            DerInputStream derInputStream2 = derInputStream.readSequence();
            this.sM = new AlgorithmID(derInputStream2);
            if (derInputStream2.nextTag() != 4) {
                throw new CodingException("Digest component must be OCTET STRING!");
            }
            this.b = derInputStream2.readOctetStringByteArray();
        }
        catch (IOException iOException) {
            throw new CodingException("Error decoding DigestInfo: " + iOException.toString());
        }
        if (byteArrayInputStream.read() != -1) {
            throw new CodingException("Invalid DigestInfo encoding: too long!");
        }
    }

    public boolean checkDigestAlgorithm(AlgorithmID algorithmID) {
        boolean bl = false;
        if (algorithmID == null) {
            bl = false;
        } else if (this.sM == algorithmID) {
            bl = true;
        } else {
            bl = this.sM.getAlgorithm().equals((Object)algorithmID.getAlgorithm());
            if (bl) {
                ASN1Object aSN1Object = this.sM.getParameter();
                ASN1Object aSN1Object2 = algorithmID.getParameter();
                if (aSN1Object != null && aSN1Object.isA(ASN.NULL)) {
                    aSN1Object = null;
                }
                if (aSN1Object2 != null && aSN1Object2.isA(ASN.NULL)) {
                    aSN1Object2 = null;
                }
                bl = aSN1Object != null && aSN1Object2 != null ? CryptoUtils.equalsBlock((byte[])DerCoder.encode((ASN1Object)aSN1Object), (byte[])DerCoder.encode((ASN1Object)aSN1Object2)) : aSN1Object == null && aSN1Object2 == null;
            }
        }
        return bl;
    }

    public void decode(ASN1Object aSN1Object) {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("DigestInfo must be a SEQUENCE!");
        }
        if (aSN1Object.countComponents() != 2) {
            throw new CodingException("DigestInfo must have two compontents!");
        }
        try {
            this.sM = new AlgorithmID(aSN1Object.getComponentAt(0));
            this.b = (byte[])aSN1Object.getComponentAt(1).getValue();
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    public byte[] getDigest() {
        return this.b;
    }

    public AlgorithmID getDigestAlgorithm() {
        return this.sM;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.sM.toASN1Object());
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.b));
        return sEQUENCE;
    }

    public byte[] toByteArray() {
        return DerCoder.encode((ASN1Object)this.toASN1Object());
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digest_algorithm: " + this.sM + "\n");
        stringBuffer.append("digest: " + this.b.length + " Bytes [" + Util.toString((byte[])this.b, (int)0, (int)5) + "...]\n");
        return stringBuffer.toString();
    }
}

