/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.cms.CMSException;
import iaik.cms.SDSEncodeListener;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.x509.X509CRL;
import java.security.SignatureException;
import java.security.cert.Certificate;

public class DefaultSDSEncodeListener
extends SDSEncodeListener {
    protected Certificate[] certificates_;
    protected X509CRL[] crls_;
    protected SignerInfo[] signerInfos_;

    protected void afterComputeSignature(SignedDataStream signedDataStream) {
        SignerInfo[] signerInfoArray = signedDataStream.getSignerInfos();
        int n2 = 0;
        while (n2 < signerInfoArray.length) {
            try {
                signedDataStream.verify(n2);
            }
            catch (SignatureException signatureException) {
                throw new CMSException("Signature ERROR from signer: " + signedDataStream.getCertificate(signerInfoArray[n2].getSignerIdentifier()).getSubjectDN() + signatureException.getMessage());
            }
            ++n2;
        }
    }

    protected void beforeComputeSignature(SignedDataStream signedDataStream) {
        signedDataStream.addCertificates(this.certificates_);
        signedDataStream.addCRLs(this.crls_);
        if (this.signerInfos_ != null) {
            try {
                int n2 = 0;
                while (n2 < this.signerInfos_.length) {
                    signedDataStream.addSignerInfo(this.signerInfos_[n2]);
                    ++n2;
                }
            }
            catch (Exception exception) {
                throw new CMSException("Error adding signer info: " + exception.toString());
            }
        }
    }

    public Certificate[] getCertificates() {
        return this.certificates_;
    }

    public X509CRL[] getCrls() {
        return this.crls_;
    }

    public SignerInfo[] getSignerInfos() {
        return this.signerInfos_;
    }

    public void setCertificates(Certificate[] certificateArray) {
        this.certificates_ = certificateArray;
    }

    public void setCrls(X509CRL[] x509CRLArray) {
        this.crls_ = x509CRLArray;
    }

    public void setSignerInfos(SignerInfo[] signerInfoArray) {
        this.signerInfos_ = signerInfoArray;
    }
}

