/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.ContentStream;
import iaik.cms.DebugCMS;
import iaik.cms.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DataStream
implements ContentStream {
    private static boolean a = false;
    protected InputStream inputStream_;
    protected int blockSize_ = 2048;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    protected DataStream() {
    }

    public DataStream(InputStream inputStream) {
        this();
        this.decode(inputStream);
    }

    public DataStream(InputStream inputStream, int n2) {
        this();
        this.inputStream_ = inputStream;
        if (n2 > 0) {
            this.blockSize_ = n2;
        }
    }

    public void decode(InputStream inputStream) {
        if (inputStream == null) {
            throw new IOException("Cannot decode a null object!");
        }
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = null;
        int n2 = ((DerInputStream)inputStream).nextTag();
        if (n2 == 16) {
            DerInputStream derInputStream2 = ((DerInputStream)inputStream).readSequence();
            ObjectID objectID = derInputStream2.readObjectID();
            if (!objectID.equals((Object)ObjectID.cms_data)) {
                throw new CMSParsingException("Content type not Data!");
            }
            derInputStream = derInputStream2.readContextSpecific();
        } else if (n2 == 4) {
            derInputStream = (DerInputStream)inputStream;
        } else {
            throw new IOException("Next tag no OCTET STRING!");
        }
        this.inputStream_ = Utils.c(derInputStream);
    }

    public int getBlockSize() {
        return this.blockSize_;
    }

    public ObjectID getContentType() {
        return ObjectID.cms_data;
    }

    public InputStream getInputStream() {
        return this.inputStream_;
    }

    public void setBlockSize(int n2) {
        this.blockSize_ = n2;
    }

    public ASN1Object toASN1Object() {
        if (this.blockSize_ > 0) {
            return new OCTET_STRING(this.inputStream_, this.blockSize_);
        }
        return new OCTET_STRING(this.inputStream_);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.inputStream_ != null) {
            stringBuffer.append("Content: data supplied from input stream.");
        } else {
            stringBuffer.append("no content!");
        }
        return stringBuffer.toString();
    }

    public void writeTo(OutputStream outputStream) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.getMessage());
        }
    }
}

