/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.Content;
import iaik.cms.DataStream;
import iaik.cms.Utils;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Data
extends DataStream
implements Content {
    private byte[] a;

    protected Data() {
        this.blockSize_ = -1;
    }

    public Data(ASN1Object aSN1Object) {
        this();
        this.decode(aSN1Object);
    }

    public Data(InputStream inputStream) {
        this();
        this.decode(inputStream);
    }

    public Data(byte[] byArray) {
        this();
        this.a = byArray;
    }

    public Data(byte[] byArray, int n2) {
        this();
        this.a = byArray;
        this.blockSize_ = n2;
    }

    public void decode(ASN1Object aSN1Object) {
        ASN1Object aSN1Object2;
        if (aSN1Object == null) {
            throw new CMSParsingException("Cannot parse a null object!");
        }
        if (aSN1Object.isA(ASN.SEQUENCE)) {
            try {
                if (aSN1Object.countComponents() != 2) {
                    throw new CMSParsingException("ContentInfo must contain two components!");
                }
                aSN1Object2 = aSN1Object.getComponentAt(0);
                if (!aSN1Object2.isA(ASN.ObjectID)) {
                    throw new CMSParsingException("First ContentInfo component must be content type OID!");
                }
                if (!aSN1Object2.equals(ObjectID.cms_data)) {
                    throw new CMSParsingException("Content type not Data!");
                }
                aSN1Object2 = aSN1Object.getComponentAt(1);
                if (!aSN1Object2.isA(ASN.CON_SPEC)) {
                    throw new CMSParsingException("Second ContentInfo component must be context specfic");
                }
                aSN1Object2 = (ASN1Object)aSN1Object2.getValue();
            }
            catch (CodingException codingException) {
                throw new CMSParsingException("Error parsing Data object: " + codingException.toString());
            }
        } else {
            aSN1Object2 = aSN1Object;
        }
        this.a(aSN1Object2);
    }

    public void decode(InputStream inputStream) {
        DerInputStream derInputStream = inputStream instanceof DerInputStream ? (DerInputStream)inputStream : new DerInputStream(inputStream);
        if (derInputStream.nextTag() == 16) {
            if ((derInputStream = derInputStream.readSequence()).nextTag() != 6) {
                throw new CMSParsingException("First ContentInfo component must be content type OID!");
            }
            ObjectID objectID = derInputStream.readObjectID();
            if (!objectID.equals((Object)ObjectID.cms_data)) {
                throw new CMSParsingException("Content type not Data!");
            }
            if (!derInputStream.nextIsContextSpecific()) {
                throw new CMSParsingException("Second ContentInfo component must be context specfic");
            }
            derInputStream = derInputStream.readContextSpecific();
        }
        try {
            this.a(DerCoder.decode((InputStream)derInputStream));
            if (Utils.getIaikProviderVersion() >= 3.18) {
                derInputStream.readEOC();
            }
        }
        catch (CodingException codingException) {
            throw new CMSParsingException("Content parsing error: " + codingException.toString());
        }
    }

    private void a(ASN1Object aSN1Object) {
        if (aSN1Object == null) {
            throw new CMSParsingException("Cannot decode a null object!");
        }
        if (!aSN1Object.isA(ASN.OCTET_STRING)) {
            throw new CMSParsingException("Encapsulated content must be an OCTET STRING!");
        }
        try {
            this.a = ((OCTET_STRING)aSN1Object).getWholeValue();
        }
        catch (Exception exception) {
            throw new CMSParsingException("Error decoding octet string: " + exception.toString());
        }
    }

    public byte[] getData() {
        return this.a;
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    public InputStream getInputStream() {
        if (this.a != null) {
            return new ByteArrayInputStream(this.a);
        }
        return this.inputStream_;
    }

    public ASN1Object toASN1Object() {
        if (this.blockSize_ > 0) {
            return new OCTET_STRING(this.a, this.blockSize_);
        }
        return new OCTET_STRING(this.a);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("Content: " + this.a.length + " bytes");
            if (bl) {
                stringBuffer.append(": " + Util.toString((byte[])this.a, (int)0, (int)15));
                if (this.a.length > 15) {
                    stringBuffer.append("...");
                }
            }
        } else {
            stringBuffer.append("No content!");
        }
        return stringBuffer.toString();
    }
}

