/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.ContentFactory;
import iaik.cms.ContentStream;
import iaik.cms.Utils;
import iaik.cms.c;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class ContentInfoStream {
    static final ObjectID sd = new ObjectID("1.2.840.113549.1.9.16.1.9", "CMS compressedData");
    static final ObjectID sG = new ObjectID("1.2.840.113549.1.9.16.1.23", "CMS authEnvelopedData");
    private static ContentFactory uj;
    private static final HashMap uk;
    private ObjectID sv;
    private ContentStream ul;
    private DerInputStream ug;
    private boolean tZ = false;
    static Class c;

    static {
        uk = new HashMap(10);
        try {
            uj = Utils.getIaikProviderVersion() >= 3.17 ? (ContentFactory)Class.forName("iaik.cms.d").newInstance() : (ContentFactory)Class.forName("iaik.cms.c").newInstance();
        }
        catch (Throwable throwable) {
            uj = new c();
        }
        uk.put(ObjectID.cms_data, "iaik.cms.DataStream");
        uk.put(ObjectID.cms_digestedData, "iaik.cms.DigestedDataStream");
        uk.put(ObjectID.cms_signedData, "iaik.cms.SignedDataStream");
        uk.put(ObjectID.cms_envelopedData, "iaik.cms.EnvelopedDataStream");
        uk.put(ObjectID.cms_encryptedData, "iaik.cms.EncryptedDataStream");
        uk.put(ObjectID.cms_authData, "iaik.cms.AuthenticatedDataStream");
        uk.put(sd, "iaik.cms.CompressedDataStream");
        uk.put(sG, "iaik.cms.AuthEnvelopedDataStream");
        uk.put(ObjectID.receipt, "iaik.smime.ess.Receipt");
    }

    private ContentInfoStream() {
    }

    public ContentInfoStream(ContentStream contentStream) {
        this();
        this.sv = contentStream.getContentType();
        this.ul = contentStream;
    }

    public ContentInfoStream(InputStream inputStream) {
        this();
        if (inputStream instanceof DerInputStream) {
            this.decode((DerInputStream)inputStream);
        } else {
            this.decode(new DerInputStream(inputStream));
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static ContentStream create(ObjectID objectID) {
        ContentStream contentStream = null;
        try {
            contentStream = (ContentStream)uj.create(c != null ? c : (c = ContentInfoStream.class$("iaik.cms.ContentStream")), objectID, false);
        }
        catch (Exception exception) {
            String string = (String)uk.get(objectID);
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    if (clazz != null) {
                        if (!(c != null ? c : (c = ContentInfoStream.class$("iaik.cms.ContentStream"))).isAssignableFrom(clazz)) {
                            throw new InstantiationException("Class " + clazz + " is no ContentStream implementation!");
                        }
                    } else {
                        throw new CMSException("No implementation for " + objectID.getName());
                    }
                    ContentInfoStream.register(objectID, clazz);
                    contentStream = (ContentStream)uj.create(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new CMSException(classNotFoundException.toString());
                }
                catch (InstantiationException instantiationException) {
                    throw new CMSException(instantiationException.toString());
                }
            }
            throw new CMSException("No implementation for " + objectID.getName());
        }
        return contentStream;
    }

    public static ContentStream create(ObjectID objectID, InputStream inputStream) {
        try {
            ContentStream contentStream = ContentInfoStream.create(objectID);
            contentStream.decode(inputStream);
            return contentStream;
        }
        catch (CMSException cMSException) {
            throw new CMSParsingException(cMSException.getMessage());
        }
    }

    protected void decode(DerInputStream derInputStream) {
        DerInputStream derInputStream2 = derInputStream.readSequence();
        this.sv = derInputStream2.readObjectID();
        this.ug = derInputStream2.readContextSpecific();
    }

    private void a() {
        if (this.ug != null) {
            try {
                this.ul = ContentInfoStream.create(this.sv);
            }
            catch (CMSException cMSException) {
                throw new CMSParsingException(cMSException.getMessage());
            }
            this.ul.decode((InputStream)this.ug);
            this.tZ = true;
        }
    }

    public ContentStream getContent() {
        if (this.ul != null) {
            return this.ul;
        }
        this.a();
        return this.ul;
    }

    public InputStream getContentInputStream() {
        this.tZ = true;
        return this.ug;
    }

    public ObjectID getContentType() {
        return this.sv;
    }

    public static void register(ObjectID objectID, Class clazz) {
        uj.register(c != null ? c : (c = ContentInfoStream.class$("iaik.cms.ContentStream")), objectID, clazz);
    }

    public void setContent(ContentStream contentStream) {
        this.sv = contentStream.getContentType();
        this.ul = contentStream;
    }

    public ASN1Object toASN1Object() {
        if (this.sv == null) {
            throw new CMSException("Cannot create ASN.1 object. At least the content type must be set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        sEQUENCE.addComponent((ASN1Object)this.sv);
        if (!this.tZ) {
            try {
                this.a();
            }
            catch (IOException iOException) {
                throw new CMSException(iOException.getMessage());
            }
        }
        if (this.ul == null) {
            throw new CMSException("CMS ContentInfo with empty content not allowed!");
        }
        CON_SPEC cON_SPEC = new CON_SPEC(0, this.ul.toASN1Object());
        cON_SPEC.setIndefiniteLength(true);
        sEQUENCE.addComponent((ASN1Object)cON_SPEC);
        return sEQUENCE;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContentType: " + this.sv.getName() + " {\n");
        if (this.ul == null) {
            stringBuffer.append("No content!\n");
        } else {
            stringBuffer.append(String.valueOf(this.ul.toString(bl)) + "\n}");
        }
        return stringBuffer.toString();
    }

    public void writeTo(OutputStream outputStream) {
        DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
    }
}

