/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.CMSRuntimeException;
import iaik.cms.Content;
import iaik.cms.ContentFactory;
import iaik.cms.ContentInfoStream;
import iaik.cms.Utils;
import iaik.cms.c;
import iaik.utils.TracedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class ContentInfo {
    private static ContentFactory ue;
    private static final HashMap c;
    private static boolean d;
    private ObjectID tV;
    private Content uf;
    private byte[] g;
    private DerInputStream ug;
    private boolean tZ = false;
    static Class a;

    static {
        c = new HashMap(10);
        try {
            ue = Utils.getIaikProviderVersion() >= 3.17 ? (ContentFactory)Class.forName("iaik.cms.d").newInstance() : (ContentFactory)Class.forName("iaik.cms.c").newInstance();
        }
        catch (Throwable throwable) {
            ue = new c();
        }
        c.put(ObjectID.cms_data, "iaik.cms.Data");
        c.put(ObjectID.cms_digestedData, "iaik.cms.DigestedData");
        c.put(ObjectID.cms_signedData, "iaik.cms.SignedData");
        c.put(ObjectID.cms_envelopedData, "iaik.cms.EnvelopedData");
        c.put(ObjectID.cms_encryptedData, "iaik.cms.EncryptedData");
        c.put(ObjectID.cms_authData, "iaik.cms.AuthenticatedData");
        c.put(ContentInfoStream.sG, "iaik.cms.AuthEnvelopedData");
        c.put(ContentInfoStream.sd, "iaik.cms.CompressedData");
        c.put(ObjectID.receipt, "iaik.smime.ess.Receipt");
        d = false;
    }

    private ContentInfo() {
    }

    public ContentInfo(ASN1Object aSN1Object) {
        this();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(DerCoder.encode((ASN1Object)aSN1Object));
        try {
            this.decode(new DerInputStream((InputStream)byteArrayInputStream));
        }
        catch (IOException iOException) {
            throw new CMSParsingException("Error parsing ContentInfo: " + iOException.getMessage());
        }
    }

    public ContentInfo(Content content) {
        this();
        this.tV = content.getContentType();
        this.uf = content;
    }

    public ContentInfo(InputStream inputStream) {
        this();
        if (inputStream instanceof DerInputStream) {
            this.decode((DerInputStream)inputStream);
        } else {
            this.decode(new DerInputStream(inputStream));
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Content create(ObjectID objectID) {
        Content content = null;
        try {
            content = (Content)ue.create(a != null ? a : (a = ContentInfo.class$("iaik.cms.Content")), objectID, false);
        }
        catch (Exception exception) {
            String string = (String)c.get(objectID);
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    if (clazz != null) {
                        if (!(a != null ? a : (a = ContentInfo.class$("iaik.cms.Content"))).isAssignableFrom(clazz)) {
                            throw new InstantiationException("Class " + clazz + " is no Content implementation!");
                        }
                    } else {
                        throw new CMSException("No implementation for " + objectID.getName());
                    }
                    ContentInfo.register(objectID, clazz);
                    content = (Content)ue.create(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new CMSException(classNotFoundException.toString());
                }
                catch (InstantiationException instantiationException) {
                    throw new CMSException(instantiationException.toString());
                }
            }
            throw new CMSException("No implementation for " + objectID.getName());
        }
        return content;
    }

    public static Content create(ObjectID objectID, ASN1Object aSN1Object) {
        try {
            Content content = ContentInfo.create(objectID);
            content.decode(aSN1Object);
            return content;
        }
        catch (CMSException cMSException) {
            throw new CMSParsingException(cMSException.getMessage());
        }
    }

    protected void decode(DerInputStream derInputStream) {
        DerInputStream derInputStream2 = derInputStream.readSequence();
        this.tV = derInputStream2.readObjectID();
        this.ug = derInputStream2.readContextSpecific();
        if (d) {
            this.a();
        }
    }

    private void a() {
        if (this.ug != null) {
            try {
                this.uf = ContentInfo.create(this.tV);
            }
            catch (CMSException cMSException) {
                throw new CMSParsingException(cMSException.getMessage());
            }
            if (d) {
                TracedInputStream tracedInputStream = new TracedInputStream((InputStream)this.ug);
                this.uf.decode((InputStream)tracedInputStream);
                this.g = tracedInputStream.getTracedData();
                this.ug.readEOC();
            } else {
                this.uf.decode((InputStream)this.ug);
            }
            this.tZ = true;
        }
    }

    public Content getContent() {
        if (this.uf == null) {
            try {
                this.a();
            }
            catch (Exception exception) {
                throw new CMSRuntimeException("Error parsing content: " + exception.toString());
            }
        }
        return this.uf;
    }

    public InputStream getContentInputStream() {
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.g != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.g);
        } else if (this.ug != null) {
            this.tZ = true;
            byteArrayInputStream = this.ug;
        }
        return byteArrayInputStream;
    }

    public ObjectID getContentType() {
        return this.tV;
    }

    public byte[] getEncoded() {
        return this.toByteArray();
    }

    public static void keepEncodedContent(boolean bl) {
        d = bl;
    }

    public static void register(ObjectID objectID, Class clazz) {
        ue.register(a != null ? a : (a = ContentInfo.class$("iaik.cms.Content")), objectID, clazz);
    }

    public void setContent(Content content) {
        this.tV = content.getContentType();
        this.uf = content;
    }

    public ASN1Object toASN1Object() {
        if (this.tV == null) {
            throw new CMSException("Cannot create ASN.1 object. At least the content type must be set!");
        }
        boolean bl = true;
        bl = this.uf == null ? false : this.uf.getBlockSize() > 0;
        SEQUENCE sEQUENCE = new SEQUENCE(bl);
        sEQUENCE.addComponent((ASN1Object)this.tV);
        if (!this.tZ) {
            try {
                this.a();
            }
            catch (IOException iOException) {
                throw new CMSException(iOException.getMessage());
            }
        }
        if (this.uf == null) {
            throw new CMSException("CMS ContentInfo with empty content not allowed!");
        }
        CON_SPEC cON_SPEC = new CON_SPEC(0, this.uf.toASN1Object());
        cON_SPEC.setIndefiniteLength(bl);
        sEQUENCE.addComponent((ASN1Object)cON_SPEC);
        return sEQUENCE;
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContentType: " + this.tV.getName() + " {\n");
        if (this.uf == null) {
            stringBuffer.append("No content!\n");
        } else {
            stringBuffer.append(String.valueOf(this.uf.toString(bl)) + "\n}");
        }
        return stringBuffer.toString();
    }

    public void writeTo(OutputStream outputStream) {
        DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
    }
}

