/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.ContentInfoStream;
import iaik.cms.ContentStream;
import iaik.cms.DebugCMS;
import iaik.cms.EncapsulatedContentInfoStream;
import iaik.cms.InputStreamCompressEngine;
import iaik.cms.SecurityProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;

public class CompressedDataStream
implements ContentStream {
    public static final ObjectID contentType = ContentInfoStream.sd;
    private static boolean ua = false;
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    protected int version_ = 0;
    protected AlgorithmID compressionAlgorithm_;
    private InputStreamCompressEngine ub;
    protected ObjectID encapContentType_;
    DerInputStream uc;
    protected int blockSize_ = 2048;
    EncapsulatedContentInfoStream ud;
    protected InputStream inputStream_;
    int c = 1;
    SecurityProvider d;
    int e = 0;

    static {
        ua = DebugCMS.getDebugMode() && ua;
    }

    protected CompressedDataStream() {
    }

    public CompressedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID, int n2) {
        this();
        if (objectID == null) {
            throw new NullPointerException("No content type specified!");
        }
        if (algorithmID == null) {
            throw new NullPointerException("No compresseion algorithm specified!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.encapContentType_ = objectID;
        this.c = n2;
        this.inputStream_ = inputStream;
        this.compressionAlgorithm_ = (AlgorithmID)algorithmID.clone();
    }

    public CompressedDataStream(InputStream inputStream) {
        this();
        this.decode(inputStream);
    }

    public CompressedDataStream(InputStream inputStream, AlgorithmID algorithmID, int n2) {
        this(ObjectID.cms_data, inputStream, algorithmID, n2);
    }

    public void decode(InputStream inputStream) {
        DerInputStream derInputStream;
        int n2;
        this.e = 1;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        if ((n2 = (derInputStream = ((DerInputStream)inputStream).readSequence()).nextTag()) == 6) {
            ObjectID objectID = derInputStream.readObjectID();
            if (!objectID.equals((Object)contentType)) {
                throw new CMSParsingException("Content type not CompressedData!");
            }
            this.uc = derInputStream.readContextSpecific().readSequence();
        } else {
            this.uc = derInputStream;
        }
        this.version_ = this.uc.readInteger().intValue();
        this.compressionAlgorithm_ = new AlgorithmID(this.uc);
        this.a();
    }

    public int getBlockSize() {
        return this.blockSize_;
    }

    public AlgorithmID getCompressionAlgorithm() {
        return this.compressionAlgorithm_;
    }

    public ObjectID getContentType() {
        return contentType;
    }

    public ObjectID getEncapsulatedContentType() {
        return this.encapContentType_;
    }

    public InputStream getInputStream() {
        if (this.ub == null) {
            this.b();
        }
        return this.inputStream_;
    }

    public int getMode() {
        return this.c;
    }

    public SecurityProvider getSecurityProvider() {
        return this.d;
    }

    public int getVersion() {
        return this.version_;
    }

    void a() {
        this.ud = new EncapsulatedContentInfoStream((InputStream)this.uc);
        this.encapContentType_ = this.ud.getContentType();
        if (this.ud.hasContent()) {
            this.c = 1;
            this.inputStream_ = this.ud.getContentInputStream();
        } else {
            this.c = 2;
        }
    }

    public void setBlockSize(int n2) {
        this.blockSize_ = n2;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream_ = inputStream;
        this.b();
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.d = securityProvider;
    }

    private void b() {
        if (this.compressionAlgorithm_ == null) {
            throw new NullPointerException("Compression algorithm not set!");
        }
        if (this.inputStream_ == null) {
            throw new NullPointerException("Input data stream not set!");
        }
        SecurityProvider securityProvider = this.d;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        this.ub = securityProvider.getInputStreamCompressEngine(this.compressionAlgorithm_, this.inputStream_, this.e, this.blockSize_);
        this.inputStream_ = this.ub.getInputStream();
    }

    public ASN1Object toASN1Object() {
        return this.toASN1Object(this.blockSize_);
    }

    protected ASN1Object toASN1Object(int n2) {
        if (n2 <= 0) {
            n2 = this.blockSize_;
        }
        if (this.compressionAlgorithm_ == null) {
            throw new NullPointerException("Compression algorithm not set!");
        }
        if (this.inputStream_ != null && this.ub == null) {
            try {
                this.b();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CMSException(noSuchAlgorithmException.toString());
            }
        }
        if (this.c == 1) {
            if (this.inputStream_ == null) {
                throw new NullPointerException("InputStream not set!");
            }
            this.ud = new EncapsulatedContentInfoStream(this.inputStream_, this.encapContentType_);
            this.ud.setBlockSize(n2);
        } else if (this.ud == null) {
            this.ud = new EncapsulatedContentInfoStream(this.encapContentType_);
            this.ud.setBlockSize(n2);
        }
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
        if (this.compressionAlgorithm_.getParameter() == null) {
            this.compressionAlgorithm_.encodeAbsentParametersAsNull(false);
        }
        sEQUENCE.addComponent(this.compressionAlgorithm_.toASN1Object());
        sEQUENCE.addComponent(this.ud.toASN1Object());
        return sEQUENCE;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version_ + "\n");
        stringBuffer.append("compressionAlgorithm: " + this.compressionAlgorithm_.getName());
        stringBuffer.append("encapContentInfo: " + this.ud);
        return stringBuffer.toString();
    }

    public void writeTo(OutputStream outputStream) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    public void writeTo(OutputStream outputStream, int n2) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(n2), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }
}

