/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.DataOutputStream;
import iaik.cms.DebugCMS;
import iaik.cms.OutputStreamCompressEngine;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;

public class CompressedDataOutputStream
extends OutputStream {
    private static boolean a = false;
    private int b = 0;
    private AlgorithmID tT;
    private OutputStreamCompressEngine tU;
    private ObjectID tV;
    private OutputStream tW;
    private OutputStream tX;
    private SecurityProvider tY;
    private boolean tZ;
    private boolean j = true;
    private boolean k;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    private CompressedDataOutputStream() {
    }

    public CompressedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID) {
        this();
        if (objectID == null) {
            throw new NullPointerException("No content type specified!");
        }
        if (algorithmID == null) {
            throw new NullPointerException("No compresseion algorithm specified!");
        }
        this.tV = objectID;
        this.tW = outputStream;
        this.tX = new DataOutputStream(outputStream, false);
        this.tT = (AlgorithmID)algorithmID.clone();
    }

    public CompressedDataOutputStream(OutputStream outputStream, AlgorithmID algorithmID) {
        this(ObjectID.cms_data, outputStream, algorithmID);
    }

    private void a() {
        if (this.k) {
            throw new IOException("Stream already closed!");
        }
    }

    public void close() {
        this.a();
        this.k = true;
        this.a(-1);
        this.tX.close();
        this.tW.write(new byte[2]);
        this.tW.write(new byte[2]);
        this.tW.write(new byte[2]);
        if (this.j) {
            this.tW.close();
        }
    }

    private void a(int n2) {
        if (this.tU == null) {
            try {
                this.b(n2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException("Compressin algorithm not supported: " + noSuchAlgorithmException.toString());
            }
        }
        if (!this.tZ) {
            this.tW.write(new byte[]{48, -128});
            this.tW.write(DerCoder.encode((ASN1Object)new INTEGER(this.b)));
            this.tW.write(DerCoder.encode((ASN1Object)this.tT.toASN1Object()));
            this.tW.write(new byte[]{48, -128});
            this.tW.write(DerCoder.encode((ASN1Object)this.tV));
            this.tW.write(new byte[]{-96, -128});
            this.tZ = true;
        }
    }

    public void flush() {
        this.a();
        this.a(4096);
        this.tX.flush();
    }

    public SecurityProvider getSecurityProvider() {
        return this.tY;
    }

    public int getVersion() {
        return this.b;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.tY = securityProvider;
    }

    private void b(int n2) {
        if (this.tT == null) {
            throw new NullPointerException("Compression algorithm not set!");
        }
        if (this.tW == null) {
            throw new NullPointerException("Output data stream not set!");
        }
        SecurityProvider securityProvider = this.tY;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        this.tU = securityProvider.getOutputStreamCompressEngine(this.tT, this.tX, n2);
        this.tX = this.tU.getOutputStream();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.b + "\n");
        stringBuffer.append("compressionAlgorithm: " + this.tT.getName());
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        Utils.printIndented("ContentType: " + this.tV.getName() + ", content included\n", true, stringBuffer);
        return stringBuffer.toString();
    }

    public void write(int n2) {
        this.a();
        this.write(new byte[]{(byte)(n2 & 0xFF)}, 0, 1);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException("May not write null data.");
        }
        this.a();
        this.a(byArray.length);
        this.tX.write(byArray, n2, n3);
    }
}

