/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.CompressedDataStream;
import iaik.cms.Content;
import iaik.cms.EncapsulatedContentInfo;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CompressedData
extends CompressedDataStream
implements Content {
    private byte[] tS;
    private boolean g;

    protected CompressedData() {
        this.blockSize_ = -1;
        this.g = false;
    }

    public CompressedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID, int n2) {
        this(objectID, byArray, algorithmID, n2, null);
    }

    public CompressedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID, int n2, SecurityProvider securityProvider) {
        this();
        if (objectID == null) {
            throw new NullPointerException("No content type specified!");
        }
        if (algorithmID == null) {
            throw new NullPointerException("No compresseion algorithm specified!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.encapContentType_ = objectID;
        this.c = n2;
        this.compressionAlgorithm_ = (AlgorithmID)algorithmID.clone();
        if (byArray != null) {
            this.tS = (byte[])byArray.clone();
            this.b();
            this.g = true;
        }
    }

    public CompressedData(InputStream inputStream) {
        this();
        this.decode(inputStream);
    }

    public CompressedData(byte[] byArray, AlgorithmID algorithmID, int n2) {
        this(ObjectID.cms_data, byArray, algorithmID, n2, null);
    }

    private void b() {
        if (this.compressionAlgorithm_ == null) {
            throw new NullPointerException("Compression algorithm not set!");
        }
        if (this.tS == null) {
            throw new NullPointerException("Input data not set!");
        }
        SecurityProvider securityProvider = this.d;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        this.tS = securityProvider.compress(this.compressionAlgorithm_, this.tS, this.e);
    }

    public void decode(ASN1Object aSN1Object) {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode((ASN1Object)aSN1Object)));
        }
        catch (IOException iOException) {
            throw new CMSParsingException(iOException.getMessage());
        }
    }

    public byte[] getContent() {
        if (!this.g && this.tS != null) {
            this.b();
            this.g = true;
        }
        return this.tS;
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    public InputStream getInputStream() {
        ByteArrayInputStream byteArrayInputStream = null;
        this.getContent();
        if (this.tS != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.tS);
        }
        return byteArrayInputStream;
    }

    void a() {
        this.ud = new EncapsulatedContentInfo((InputStream)this.uc);
        this.encapContentType_ = this.ud.getContentType();
        if (this.ud.hasContent()) {
            this.c = 1;
            this.tS = ((EncapsulatedContentInfo)this.ud).getContent();
        } else {
            this.c = 2;
        }
    }

    public void setContent(byte[] byArray) {
        if (byArray == null) {
            this.tS = null;
        } else {
            this.tS = (byte[])byArray.clone();
            this.b();
            this.g = true;
        }
    }

    public void setInputStream(InputStream inputStream) {
        if (inputStream != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Utils.copyStream(inputStream, byteArrayOutputStream, null);
            this.tS = byteArrayOutputStream.toByteArray();
            this.b();
            this.g = true;
        }
    }

    protected ASN1Object toASN1Object(int n2) {
        if (n2 <= 0) {
            n2 = this.blockSize_;
        }
        if (this.compressionAlgorithm_ == null) {
            throw new NullPointerException("Compression algorithm not set!");
        }
        if (this.c == 1) {
            if (this.tS == null) {
                throw new NullPointerException("Content data not set!");
            }
            if (!this.g) {
                try {
                    this.b();
                }
                catch (Exception exception) {
                    throw new CMSException("Error compressing content: " + exception.toString());
                }
                this.g = true;
            }
            this.ud = new EncapsulatedContentInfo(this.tS, this.encapContentType_);
            this.ud.setBlockSize(n2);
        } else if (this.ud == null) {
            this.ud = new EncapsulatedContentInfo(this.encapContentType_);
        }
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
        if (this.compressionAlgorithm_.getParameter() == null) {
            this.compressionAlgorithm_.encodeAbsentParametersAsNull(false);
        }
        sEQUENCE.addComponent(this.compressionAlgorithm_.toASN1Object());
        sEQUENCE.addComponent(this.ud.toASN1Object());
        return sEQUENCE;
    }
}

