/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.SET;
import iaik.cms.CertificateChoices;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DebugCMS;
import iaik.cms.OtherCertificate;
import iaik.x509.X509Certificate;
import iaik.x509.attr.AttributeCertificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Vector;

public class CertificateSet {
    private static boolean a = false;
    private Vector tR = new Vector();

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    public CertificateSet() {
    }

    public CertificateSet(InputStream inputStream) {
        this(inputStream, false);
    }

    CertificateSet(InputStream inputStream, boolean bl) {
        this();
        this.b(inputStream, bl);
    }

    public void addCertificate(Certificate certificate) {
        if (!(certificate instanceof X509Certificate || certificate instanceof AttributeCertificate || certificate instanceof OtherCertificate)) {
            throw new IllegalArgumentException("Only iaik.x509.X509Certificates or iaik.x509.attr.AttributeCertificates or iaik.cms.OtherCertificates are allowed!");
        }
        this.tR.addElement(new CertificateChoices(certificate));
    }

    public void addCertificateChoices(CertificateChoices certificateChoices) {
        this.tR.addElement(certificateChoices);
    }

    public void addCertificateChoices(CertificateChoices[] certificateChoicesArray) {
        int n2 = 0;
        while (n2 < certificateChoicesArray.length) {
            CertificateChoices certificateChoices = certificateChoicesArray[n2];
            if (certificateChoices != null) {
                this.addCertificateChoices(certificateChoices);
            }
            ++n2;
        }
    }

    public void addCertificates(Certificate[] certificateArray) {
        int n2 = 0;
        while (n2 < certificateArray.length) {
            this.addCertificate(certificateArray[n2]);
            ++n2;
        }
    }

    public boolean containsAttributeCertificates() {
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            Certificate certificate = ((CertificateChoices)enumeration.nextElement()).getCertificate();
            if (!(certificate instanceof AttributeCertificate)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOtherCertificates() {
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            Certificate certificate = ((CertificateChoices)enumeration.nextElement()).getCertificate();
            if (!(certificate instanceof OtherCertificate)) continue;
            return true;
        }
        return false;
    }

    public boolean containsX509Certificates() {
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            Certificate certificate = ((CertificateChoices)enumeration.nextElement()).getCertificate();
            if (!(certificate instanceof X509Certificate)) continue;
            return true;
        }
        return false;
    }

    private int a() {
        int n2 = 0;
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            Certificate certificate = ((CertificateChoices)enumeration.nextElement()).getCertificate();
            if (!(certificate instanceof AttributeCertificate)) continue;
            ++n2;
        }
        return n2;
    }

    private int b() {
        int n2 = 0;
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            Certificate certificate = ((CertificateChoices)enumeration.nextElement()).getCertificate();
            if (!(certificate instanceof OtherCertificate)) continue;
            ++n2;
        }
        return n2;
    }

    public void decode(InputStream inputStream) {
        this.b(inputStream, false);
    }

    void b(InputStream inputStream, boolean bl) {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = (DerInputStream)inputStream;
        DerInputStream derInputStream2 = derInputStream.readSet();
        while (derInputStream2.nextTag() > -1) {
            CertificateChoices certificateChoices = new CertificateChoices((InputStream)derInputStream2, bl);
            this.tR.addElement(certificateChoices);
        }
    }

    public int getAttributeCertificateType() {
        int n2 = 0;
        Enumeration enumeration = this.tR.elements();
        Certificate certificate = null;
        while (enumeration.hasMoreElements()) {
            certificate = ((CertificateChoices)enumeration.nextElement()).getCertificate();
            if (!(certificate instanceof AttributeCertificate)) continue;
            if (((AttributeCertificate)certificate).getVersion() == 2) {
                n2 = 2;
                break;
            }
            n2 = 1;
        }
        return n2;
    }

    public AttributeCertificate[] getAttributeCertificates() {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            object = ((CertificateChoices)enumeration.nextElement()).getCertificate();
            if (!(object instanceof AttributeCertificate)) continue;
            vector.addElement((Object[])object);
        }
        object = new AttributeCertificate[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public CertificateChoices[] getCertificateChoices() {
        Object[] objectArray = new CertificateChoices[this.tR.size()];
        this.tR.copyInto(objectArray);
        return objectArray;
    }

    public Certificate[] getCertificates() {
        int n2 = this.tR.size();
        Certificate[] certificateArray = new Certificate[n2];
        Enumeration enumeration = this.tR.elements();
        int n3 = 0;
        while (n3 < n2) {
            if (enumeration.hasMoreElements()) {
                certificateArray[n3] = ((CertificateChoices)enumeration.nextElement()).getCertificate();
            }
            ++n3;
        }
        return certificateArray;
    }

    public OtherCertificate[] getOtherCertificates() {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            object = ((CertificateChoices)enumeration.nextElement()).getCertificate();
            if (!(object instanceof OtherCertificate)) continue;
            vector.addElement((Object[])object);
        }
        object = new OtherCertificate[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public X509Certificate getX509Certificate(CertificateIdentifier certificateIdentifier) {
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            Certificate certificate = ((CertificateChoices)enumeration.nextElement()).getCertificate();
            if (!certificate.getType().equalsIgnoreCase("X.509") || !certificateIdentifier.identifiesCert((X509Certificate)certificate)) continue;
            return (X509Certificate)certificate;
        }
        return null;
    }

    public X509Certificate[] getX509Certificates() {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            object = ((CertificateChoices)enumeration.nextElement()).getCertificate();
            if (!(object instanceof X509Certificate)) continue;
            vector.addElement((Object[])object);
        }
        object = new X509Certificate[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public boolean isEmpty() {
        return this.tR.isEmpty();
    }

    public void removeAllCertificates() {
        this.tR.removeAllElements();
    }

    public void setCertificateChoices(CertificateChoices[] certificateChoicesArray) {
        this.tR.clear();
        this.addCertificateChoices(certificateChoicesArray);
    }

    public void setCertificates(Certificate[] certificateArray) {
        this.tR.removeAllElements();
        this.addCertificates(certificateArray);
    }

    public int size() {
        return this.tR.size();
    }

    public ASN1Object toASN1Object() {
        SET sET = new SET();
        Enumeration enumeration = this.tR.elements();
        while (enumeration.hasMoreElements()) {
            CertificateChoices certificateChoices = (CertificateChoices)enumeration.nextElement();
            sET.addComponent(certificateChoices.toASN1Object());
        }
        return sET;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Certificates: " + this.tR.size());
        stringBuffer.append(" -- " + this.a() + " attribute certificate(s), ");
        stringBuffer.append(String.valueOf(this.b()) + " other certificate(s)\n");
        return stringBuffer.toString();
    }

    public void writeTo(OutputStream outputStream) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.toString());
        }
    }
}

