/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.cms.CMSParsingException;
import iaik.cms.DebugCMS;
import iaik.cms.OtherCertificate;
import iaik.cms.Utils;
import iaik.utils.TracedInputStream;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.attr.AttributeCertificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class CertificateChoices {
    private static boolean a = false;
    public static final int TYPE_CERTIFICATE = 4;
    public static final int TYPE_EXTENDED_CERTIFICATE = 0;
    public static final int TYPE_ATTRIBUTE_CERTIFICATE_V1 = 1;
    public static final int TYPE_ATTRIBUTE_CERTIFICATE_V2 = 2;
    public static final int TYPE_OTHER_CERTIFICATE = 3;
    private byte[] b;
    private Certificate tQ;
    private int d = -1;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    CertificateChoices() {
    }

    public CertificateChoices(InputStream inputStream) {
        this(inputStream, false);
    }

    CertificateChoices(InputStream inputStream, boolean bl) {
        this();
        this.b(inputStream, bl);
    }

    public CertificateChoices(Certificate certificate) {
        this();
        if (certificate == null) {
            throw new NullPointerException("certificate must not be null!");
        }
        this.tQ = certificate;
        this.a(certificate);
    }

    public CertificateChoices(byte[] byArray) {
        this();
        try {
            this.a(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new CMSParsingException(iOException.toString());
        }
    }

    public void clearEncoded() {
        this.b = null;
    }

    void a(InputStream inputStream) {
        this.b(inputStream, false);
    }

    void b(InputStream inputStream, boolean bl) {
        DerInputStream derInputStream = inputStream instanceof DerInputStream ? (DerInputStream)inputStream : new DerInputStream(inputStream);
        boolean bl2 = derInputStream.nextIsContextSpecific() ^ true;
        try {
            if (!bl2) {
                TracedInputStream tracedInputStream = null;
                if (bl) {
                    tracedInputStream = new TracedInputStream(inputStream, 1024);
                    derInputStream = new DerInputStream((InputStream)tracedInputStream);
                }
                int n2 = derInputStream.readContextSpecific(16);
                switch (n2) {
                    case 0: {
                        this.d = 0;
                        throw new CMSParsingException("PKCS#6 extended certificates are obsolete and therefore not supported!");
                    }
                    case 1: {
                        this.tQ = new AttributeCertificate((InputStream)derInputStream);
                        this.d = 1;
                        break;
                    }
                    case 2: {
                        this.tQ = new AttributeCertificate((InputStream)derInputStream);
                        this.d = 2;
                        break;
                    }
                    case 3: {
                        this.d = 3;
                        DerInputStream derInputStream2 = derInputStream.readSequence();
                        ObjectID objectID = derInputStream2.readObjectID();
                        try {
                            this.tQ = new OtherCertificate(objectID, (InputStream)derInputStream2);
                            break;
                        }
                        catch (CodingException codingException) {
                            throw new CMSParsingException("Error parsing other cert: " + codingException.getMessage());
                        }
                    }
                    default: {
                        throw new CMSParsingException("Invalid implicit tag " + n2 + " for CertificateChoices!");
                    }
                }
                if (tracedInputStream != null) {
                    this.b = tracedInputStream.getTracedData();
                }
            } else {
                this.d = 4;
                this.tQ = new X509Certificate((InputStream)derInputStream);
                if (bl) {
                    this.b = this.tQ.getEncoded();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw new CMSParsingException(certificateException.toString());
        }
    }

    public Certificate getCertificate() {
        return this.tQ;
    }

    public byte[] getEncoded() {
        byte[] byArray = this.b;
        if (byArray == null) {
            byArray = DerCoder.encode((ASN1Object)this.toASN1Object());
        }
        return byArray;
    }

    public int getType() {
        return this.d;
    }

    private void a(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            this.d = 4;
        } else if (certificate instanceof AttributeCertificate) {
            this.d = ((AttributeCertificate)certificate).getVersion() == 1 ? 1 : 2;
        } else if (certificate instanceof OtherCertificate) {
            this.d = 3;
        } else {
            throw new IllegalArgumentException("Only iaik.x509.X509Certificates or iaik.x509.attr.AttributeCertificates or iaik.cms.OtherCertificates are allowed!");
        }
    }

    public ASN1Object toASN1Object() {
        ASN1Object aSN1Object = null;
        if (this.b != null) {
            aSN1Object = Utils.a(this.b, null);
        }
        if (aSN1Object == null) {
            if (this.tQ instanceof X509Certificate) {
                try {
                    aSN1Object = Utils.a(((X509Certificate)this.tQ).getEncoded(), null);
                }
                catch (Exception exception) {}
                if (aSN1Object == null) {
                    aSN1Object = ((X509Certificate)this.tQ).toASN1Object();
                }
            } else if (this.tQ instanceof AttributeCertificate) {
                int n2;
                if (this.d == 2) {
                    n2 = 2;
                } else if (this.d == 1) {
                    n2 = 1;
                } else {
                    n2 = 2;
                    if (((AttributeCertificate)this.tQ).getVersion() == 1) {
                        n2 = 1;
                    }
                }
                aSN1Object = new CON_SPEC(n2, ((AttributeCertificate)this.tQ).toASN1Object(), true);
            } else if (this.tQ instanceof OtherCertificate) {
                int n3 = 3;
                OtherCertificate otherCertificate = (OtherCertificate)this.tQ;
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent((ASN1Object)otherCertificate.getOtherCertFormat());
                sEQUENCE.addComponent(otherCertificate.toASN1Object());
                aSN1Object = new CON_SPEC(n3, (ASN1Object)sEQUENCE, true);
            } else {
                throw new CodingException("Unknown certificate type: " + this.tQ.getType() + "!");
            }
        }
        return aSN1Object;
    }

    public String toString() {
        return this.tQ != null ? this.tQ.toString() : (this.b != null ? String.valueOf(Util.toString((byte[])this.b, (int)0, (int)5)) + "..." : "");
    }

    public void writeTo(OutputStream outputStream) {
        if (this.b != null) {
            outputStream.write(this.b);
        } else {
            boolean bl = true;
            if (this.tQ instanceof X509Certificate) {
                try {
                    outputStream.write(((X509Certificate)this.tQ).getEncoded());
                    bl = false;
                }
                catch (Exception exception) {}
            }
            if (bl) {
                try {
                    DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
                }
                catch (CodingException codingException) {
                    throw new IOException(codingException.toString());
                }
            }
        }
    }
}

