/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.cms.CMSException;
import iaik.cms.CertificateSet;
import iaik.cms.ContentInfo;
import iaik.cms.DebugCMS;
import iaik.cms.SignedData;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.attr.AttributeCertificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.cert.Certificate;

public class CMSCertList
implements Serializable {
    private static boolean a = false;
    private SignedData tP;

    static {
        a = DebugCMS.getDebugMode() && a;
    }

    public CMSCertList() {
        this.tP = new SignedData(ObjectID.cms_data);
    }

    public CMSCertList(InputStream inputStream) {
        ContentInfo contentInfo = new ContentInfo(inputStream);
        this.tP = (SignedData)contentInfo.getContent();
    }

    public AttributeCertificate[] getAttributeCertificates() {
        return this.tP.getAttributeCertificates();
    }

    public X509CRL[] getCRLList() {
        return this.tP.getCRLs();
    }

    public Certificate[] getCertificateList() {
        return this.tP.getCertificates();
    }

    public CertificateSet getCertificateSet() {
        return this.tP.getCertificateSet();
    }

    public X509Certificate[] getX509Certificates() {
        return this.tP.getX509Certificates();
    }

    public void setCRLList(X509CRL[] x509CRLArray) {
        this.tP.setCRLs(x509CRLArray);
    }

    public void setCertificateList(CertificateSet certificateSet) {
        this.tP.setCertificateSet(certificateSet);
    }

    public void setCertificateList(Certificate[] certificateArray) {
        this.tP.setCertificates(certificateArray);
    }

    public byte[] toByteArray() {
        return new ContentInfo(this.tP).toByteArray();
    }

    public String toString() {
        return this.tP.toString();
    }

    public void writeTo(OutputStream outputStream) {
        try {
            DerCoder.encodeTo((ASN1Object)new ContentInfo(this.tP).toASN1Object(), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }
}

