/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;

public class CMSAlgorithmID
extends AlgorithmID {
    private static String c = "AES128";
    public static CMSAlgorithmID pwri_kek;
    public static CMSAlgorithmID aes128_CBC;
    public static CMSAlgorithmID aes192_CBC;
    public static CMSAlgorithmID aes256_CBC;
    public static CMSAlgorithmID cms_aes128_wrap;
    public static CMSAlgorithmID cms_aes192_wrap;
    public static CMSAlgorithmID cms_aes256_wrap;
    public static CMSAlgorithmID cms_camellia128_wrap;
    public static CMSAlgorithmID cms_camellia192_wrap;
    public static CMSAlgorithmID cms_camellia256_wrap;
    public static CMSAlgorithmID zlib_compress;
    public static CMSAlgorithmID cms_HMACwith3DES_wrap;
    public static CMSAlgorithmID cms_HMACwithAES_wrap;
    public static CMSAlgorithmID rsassaPss;
    public static CMSAlgorithmID dhSinglePass_stdDH_sha1kdf_scheme;
    public static CMSAlgorithmID dhSinglePass_cofactorDH_sha1kdf_scheme;
    public static CMSAlgorithmID dhSinglePass_stdDH_sha256kdf_scheme;
    public static CMSAlgorithmID dhSinglePass_stdDH_sha384kdf_scheme;
    public static CMSAlgorithmID sha224;
    static final AlgorithmID sM;
    static final AlgorithmID tO;
    public static CMSAlgorithmID ecdsa_With_SHA1;
    public static CMSAlgorithmID ecdsa_With_SHA224;
    public static CMSAlgorithmID ecdsa_With_SHA256;
    public static CMSAlgorithmID ecdsa_With_SHA384;
    public static CMSAlgorithmID ecdsa_With_SHA512;
    public static CMSAlgorithmID ecdsa_plain_With_SHA1;
    public static CMSAlgorithmID ecdsa_plain_With_SHA224;
    public static CMSAlgorithmID ecdsa_plain_With_SHA256;
    public static CMSAlgorithmID ecdsa_plain_With_SHA384;
    public static CMSAlgorithmID ecdsa_plain_With_SHA512;
    public static CMSAlgorithmID ecdsa_plain_With_RIPEMD160;
    public static CMSAlgorithmID aes128_CCM;
    public static CMSAlgorithmID aes192_CCM;
    public static CMSAlgorithmID aes256_CCM;
    public static CMSAlgorithmID aes128_GCM;
    public static CMSAlgorithmID aes192_GCM;
    public static CMSAlgorithmID aes256_GCM;
    private byte[] d;

    static {
        try {
            c = AlgorithmID.aes128_CBC.getRawImplementationName();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        pwri_kek = new CMSAlgorithmID("1.2.840.113549.1.9.16.3.9", "PWRI-KEK", "PWRI-KEK");
        aes128_CBC = new CMSAlgorithmID("2.16.840.1.101.3.4.1.2", "AES128-CBC", String.valueOf(c) + "/CBC/PKCS5Padding");
        aes192_CBC = new CMSAlgorithmID("2.16.840.1.101.3.4.1.22", "AES192-CBC", "AES192/CBC/PKCS5Padding");
        aes256_CBC = new CMSAlgorithmID("2.16.840.1.101.3.4.1.42", "AES256-CBC", "AES256/CBC/PKCS5Padding");
        cms_aes128_wrap = new CMSAlgorithmID("2.16.840.1.101.3.4.1.5", "CMS-AES128-Wrap", "AESWrapAES");
        cms_aes192_wrap = new CMSAlgorithmID("2.16.840.1.101.3.4.1.25", "CMS-AES192-Wrap", "AES192WrapAES192");
        cms_aes256_wrap = new CMSAlgorithmID("2.16.840.1.101.3.4.1.45", "CMS-AES256-Wrap", "AES256WrapAES256");
        cms_camellia128_wrap = new CMSAlgorithmID("1.2.392.200011.61.1.1.3.2", "CMS-Camellia128-Wrap", "CamelliaWrapCamellia", false);
        cms_camellia192_wrap = new CMSAlgorithmID("1.2.392.200011.61.1.1.3.3", "CMS-Camellia192-Wrap", "Camellia192WrapCamellia192", false);
        cms_camellia256_wrap = new CMSAlgorithmID("1.2.392.200011.61.1.1.3.4", "CMS-Camellia256-Wrap", "Camellia256WrapCamellia256", false);
        zlib_compress = new CMSAlgorithmID("1.2.840.113549.1.9.16.3.8", "ZLIB-COMPRESS", "ZLIB-COMPRESS");
        cms_HMACwith3DES_wrap = new CMSAlgorithmID("1.2.840.113549.1.9.16.3.11", "CMS-HMACwith3DES-Wrap", "3DESWrapHMAC", true);
        cms_HMACwithAES_wrap = new CMSAlgorithmID("1.2.840.113549.1.9.16.3.12", "CMS-HMACwithAES-Wrap", "AESWrapHMAC", true);
        rsassaPss = new CMSAlgorithmID("1.2.840.113549.1.1.10", "RSASSA-PSS", "RSASSA-PSS");
        dhSinglePass_stdDH_sha1kdf_scheme = new CMSAlgorithmID("1.3.133.16.840.63.0.2", "STD-ECDH", "ECDH");
        dhSinglePass_cofactorDH_sha1kdf_scheme = new CMSAlgorithmID("1.3.133.16.840.63.0.3", "COFACTOR-ECDH", "ECDHwithCofactor");
        dhSinglePass_stdDH_sha256kdf_scheme = new CMSAlgorithmID("1.3.132.1.11.1", "STD-ECDH", "ECDH");
        dhSinglePass_stdDH_sha384kdf_scheme = new CMSAlgorithmID("1.3.132.1.11.2", "STD-ECDH", "ECDH");
        sha224 = new CMSAlgorithmID("2.16.840.1.101.3.4.2.4", "SHA224", "SHA224");
        sM = new AlgorithmID("1.3.36.3.2.3", "RipeMd256", "RIPEMD256");
        tO = new AlgorithmID("1.0.10118.3.0.55", "Whirlpool", "Whirlpool");
        ecdsa_With_SHA1 = new CMSAlgorithmID("1.2.840.10045.4.1", "ecdsaWithSHA1", "SHA1withECDSA", false);
        ecdsa_With_SHA224 = new CMSAlgorithmID("1.2.840.10045.4.3.1", "ecdsaWithSHA224", "SHA224withECDSA", false);
        ecdsa_With_SHA256 = new CMSAlgorithmID("1.2.840.10045.4.3.2", "ecdsaWithSHA256", "SHA256withECDSA", false);
        ecdsa_With_SHA384 = new CMSAlgorithmID("1.2.840.10045.4.3.3", "ecdsaWithSHA384", "SHA384withECDSA", false);
        ecdsa_With_SHA512 = new CMSAlgorithmID("1.2.840.10045.4.3.4", "ecdsaWithSHA512", "SHA512withECDSA", false);
        ecdsa_plain_With_SHA1 = new CMSAlgorithmID("0.4.0.127.0.7.1.1.4.1.1", "ecdsaPlainWithSHA1", "SHA1withECDSAPlain", false);
        ecdsa_plain_With_SHA224 = new CMSAlgorithmID("0.4.0.127.0.7.1.1.4.1.2", "ecdsaPlainWithSHA224", "SHA224withECDSAPlain", false);
        ecdsa_plain_With_SHA256 = new CMSAlgorithmID("0.4.0.127.0.7.1.1.4.1.3", "ecdsaPlainWithSHA256", "SHA256withECDSAPlain", false);
        ecdsa_plain_With_SHA384 = new CMSAlgorithmID("0.4.0.127.0.7.1.1.4.1.4", "ecdsaPlainWithSHA384", "SHA384withECDSAPlain", false);
        ecdsa_plain_With_SHA512 = new CMSAlgorithmID("0.4.0.127.0.7.1.1.4.1.5", "ecdsaPlainWithSHA512", "SHA512withECDSAPlain", false);
        ecdsa_plain_With_RIPEMD160 = new CMSAlgorithmID("0.4.0.127.0.7.1.1.4.1.6", "ecdsaPlainWithRIPEMD160", "RIPEMD160withECDSAPlain", false);
        aes128_CCM = new CMSAlgorithmID("2.16.840.1.101.3.4.1.7", "AES128-CCM", String.valueOf(c) + "/CCM/NoPadding");
        aes192_CCM = new CMSAlgorithmID("2.16.840.1.101.3.4.1.27", "AES192-CCM", "AES192/CCM/NoPadding");
        aes256_CCM = new CMSAlgorithmID("2.16.840.1.101.3.4.1.47", "AES256-CCM", "AES256/CCM/NoPadding");
        aes128_GCM = new CMSAlgorithmID("2.16.840.1.101.3.4.1.6", "AES128-GCM", String.valueOf(c) + "/GCM/NoPadding");
        aes192_GCM = new CMSAlgorithmID("2.16.840.1.101.3.4.1.26", "AES192-GCM", "AES192/GCM/NoPadding");
        aes256_GCM = new CMSAlgorithmID("2.16.840.1.101.3.4.1.46", "AES256-GCM", "AES256/GCM/NoPadding");
    }

    public CMSAlgorithmID() {
    }

    public CMSAlgorithmID(ASN1Object aSN1Object) {
        super(aSN1Object);
    }

    CMSAlgorithmID(DerInputStream derInputStream) {
        super(derInputStream);
    }

    public CMSAlgorithmID(ObjectID objectID) {
        super(objectID);
    }

    public CMSAlgorithmID(ObjectID objectID, ASN1Object aSN1Object) {
        super(objectID, aSN1Object);
    }

    public CMSAlgorithmID(String string, String string2) {
        super(string, string2);
    }

    public CMSAlgorithmID(String string, String string2, String string3) {
        super(string, string2, string3);
        AlgorithmID.algorithms.put(string3, this);
    }

    public CMSAlgorithmID(String string, String string2, String string3, boolean bl) {
        super(string, string2, string3, bl);
    }

    public void clearEncoded() {
        this.d = null;
    }

    public void decode(ASN1Object aSN1Object) {
        super.decode(aSN1Object);
        if (this.getParameter() == null) {
            this.encodeAbsentParametersAsNull(false);
        }
    }

    public byte[] getEncoded() {
        byte[] byArray = this.d == null ? DerCoder.encode((ASN1Object)this.toASN1Object()) : this.d;
        return byArray;
    }

    static final CMSAlgorithmID b(DerInputStream derInputStream) {
        DerInputStream derInputStream2 = derInputStream.readSequence();
        ObjectID objectID = derInputStream2.readObjectID();
        CMSAlgorithmID cMSAlgorithmID = new CMSAlgorithmID(objectID);
        try {
            if (derInputStream2.nextTag() != -1) {
                ASN1Object aSN1Object = DerCoder.decode((InputStream)derInputStream2);
                cMSAlgorithmID.setParameter(aSN1Object);
            } else {
                cMSAlgorithmID.encodeAbsentParametersAsNull(false);
            }
        }
        catch (CodingException codingException) {
            throw new IOException("Error decoding algorithm parameter.");
        }
        derInputStream2.readEOC();
        return cMSAlgorithmID;
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec, String string) {
        super.setAlgorithmParameterSpec(algorithmParameterSpec, string);
        this.clearEncoded();
    }

    public void setAlgorithmParameters(AlgorithmParameters algorithmParameters) {
        super.setAlgorithmParameters(algorithmParameters);
        this.clearEncoded();
    }

    void a(byte[] byArray) {
        this.d = byArray;
    }

    public void setParameter(ASN1Object aSN1Object) {
        super.setParameter(aSN1Object);
        this.clearEncoded();
    }

    public ASN1Object toASN1Object(boolean bl) {
        ASN1Object aSN1Object = null;
        if (this.d != null) {
            aSN1Object = Utils.a(this.d, null);
        }
        if (aSN1Object == null) {
            aSN1Object = super.toASN1Object(bl);
        }
        return aSN1Object;
    }
}

