/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.EncodeListener;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.CMSException;
import iaik.cms.CMSMacException;
import iaik.cms.CMSParsingException;
import iaik.cms.CMSRuntimeException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.CertificateSet;
import iaik.cms.ContentStream;
import iaik.cms.DebugCMS;
import iaik.cms.EncapsulatedContentInfoStream;
import iaik.cms.InputStreamHashEngine;
import iaik.cms.InputStreamMacEngine;
import iaik.cms.InvalidContentHashException;
import iaik.cms.InvalidContentTypeException;
import iaik.cms.KeyAgreeRecipientInfo;
import iaik.cms.KeyIdentifier;
import iaik.cms.OriginatorInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.RevocationInfoChoices;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.CMSMessageDigest;
import iaik.cms.b;
import iaik.utils.CryptoUtils;
import iaik.utils.EOFListener;
import iaik.utils.NotifyEOFInputStream;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.SecretKey;

public class AuthenticatedDataStream
implements EncodeListener,
ContentStream,
EOFListener {
    private static boolean ty = false;
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    int a = 1;
    int b = 0;
    OriginatorInfo tz;
    Vector tA = new Vector();
    AlgorithmID sX;
    AlgorithmParameterSpec tB;
    private InputStreamMacEngine tC;
    int g;
    AlgorithmID tg;
    private InputStreamHashEngine tD;
    private byte[] y;
    ObjectID tE;
    private InputStream tF;
    EncapsulatedContentInfoStream tG;
    b sP = new b();
    byte[] l;
    private byte[] tH;
    b tI = new b();
    SecretKey tJ;
    int o = 2048;
    SecurityProvider tK;
    DerInputStream tL;
    boolean tr;
    boolean sk = false;
    boolean tM = false;
    static Class tN;

    static {
        ty = DebugCMS.getDebugMode() && ty;
    }

    protected AuthenticatedDataStream() {
    }

    public AuthenticatedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID, int n2, AlgorithmParameterSpec algorithmParameterSpec, int n3) {
        this(objectID, inputStream, algorithmID, n2, algorithmParameterSpec, null, n3, null);
    }

    public AuthenticatedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID, int n2, AlgorithmParameterSpec algorithmParameterSpec, int n3, SecurityProvider securityProvider) {
        this(objectID, inputStream, algorithmID, n2, algorithmParameterSpec, null, n3, securityProvider);
    }

    public AuthenticatedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID, int n2, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmID algorithmID2, int n3) {
        this(objectID, inputStream, algorithmID, n2, algorithmParameterSpec, algorithmID2, n3, null);
    }

    public AuthenticatedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID, int n2, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmID algorithmID2, int n3, SecurityProvider securityProvider) {
        this();
        if (objectID == null) {
            throw new NullPointerException("Cannot create AuthenticatedData. Missing encapsulated content type!");
        }
        if (algorithmID == null) {
            throw new NullPointerException("Cannot create AuthenticatedData from null mac algorithm!");
        }
        if (n3 != 1 && n3 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n3 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.tE = objectID;
        this.tF = inputStream;
        this.sX = algorithmID;
        this.g = n2;
        this.tB = algorithmParameterSpec;
        this.tg = algorithmID2;
        this.tK = securityProvider;
        this.a = n3;
        if (this.tF != null) {
            this.a(true);
        }
    }

    public AuthenticatedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID, byte[] byArray, AlgorithmID algorithmID2, int n2) {
        this();
        if (objectID == null) {
            throw new NullPointerException("Cannot create AuthenticatedData. Missing encapsulated content type!");
        }
        if (algorithmID == null) {
            throw new NullPointerException("Cannot create AuthenticatedData from null mac algorithm!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.tE = objectID;
        this.tF = inputStream;
        this.sX = algorithmID;
        this.l = byArray;
        this.tg = algorithmID2;
        this.tr = false;
        this.a = n2;
        this.tM = true;
    }

    public AuthenticatedDataStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public AuthenticatedDataStream(InputStream inputStream, SecurityProvider securityProvider) {
        this();
        this.tK = securityProvider;
        this.decode(inputStream);
    }

    public void addRecipientInfo(RecipientInfo recipientInfo) {
        if (recipientInfo.getSecurityProvider() == null) {
            recipientInfo.setSecurityProvider(this.tK);
        }
        this.tA.addElement(recipientInfo);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void decode(InputStream inputStream) {
        int n2;
        Object[] objectArray;
        DerInputStream derInputStream;
        int n3;
        this.sk = true;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        if ((n3 = (derInputStream = ((DerInputStream)inputStream).readSequence()).nextTag()) == 6) {
            objectArray = derInputStream.readObjectID();
            if (!objectArray.equals((Object)ObjectID.cms_authData)) {
                throw new CMSParsingException("Content type not AutheticatedData!");
            }
            this.tL = derInputStream.readContextSpecific().readSequence();
        } else {
            this.tL = derInputStream;
        }
        this.b = this.tL.readInteger().intValue();
        if (this.tL.nextIsContextSpecific()) {
            int n4 = this.tL.readContextSpecific(16);
            if (n4 != 0) {
                throw new CMSParsingException("Invalid OriginatorInfo tag: " + n4 + "(Expected 0)");
            }
            this.tz = new OriginatorInfo((InputStream)this.tL);
        }
        objectArray = RecipientInfo.parseRecipientInfos((InputStream)this.tL, this.tK);
        this.tA = Util.getVector((Object[])objectArray);
        if (this.tz != null && !this.tz.isEmpty()) {
            n2 = 0;
            while (n2 < objectArray.length) {
                KeyAgreeRecipientInfo keyAgreeRecipientInfo;
                KeyIdentifier keyIdentifier;
                if (((RecipientInfo)objectArray[n2]).getRecipientInfoType() == 1 && (keyIdentifier = (keyAgreeRecipientInfo = (KeyAgreeRecipientInfo)objectArray[n2]).getOriginator()) != null && keyIdentifier.getKeyIdType() != 4) {
                    try {
                        X509Certificate x509Certificate = this.tz.getCertificate((CertificateIdentifier)keyIdentifier);
                        if (x509Certificate != null) {
                            keyAgreeRecipientInfo.a(x509Certificate.getPublicKey(), null);
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        this.sX = new AlgorithmID(this.tL);
        if (this.tL.nextIsContextSpecific()) {
            n2 = this.tL.readContextSpecific(16);
            if (n2 != 1) {
                throw new CMSParsingException("Invalid digestAlgorithm tag: " + n2 + "(Expected 1)");
            }
            this.tg = new AlgorithmID(this.tL);
        }
        this.tG = new EncapsulatedContentInfoStream((InputStream)this.tL);
        this.tE = this.tG.getContentType();
        if (!this.tG.hasContent()) {
            this.a = 2;
            this.notifyEOF();
        } else {
            this.tF = this.tG.getContentInputStream();
            this.tF = new NotifyEOFInputStream(this.tF);
            ((NotifyEOFInputStream)this.tF).addEOFListener((EOFListener)this);
        }
    }

    public void encodeCalled(ASN1Object aSN1Object, int n2) {
        Object object;
        SET sET = null;
        if (this.sP.size() > 0) {
            if (this.tg == null) {
                throw new NullPointerException("Digest algorithm not allowed to be null when auth attributes are present!");
            }
            if (this.sP.getAttribute(ObjectID.messageDigest) == null) {
                if (this.tD == null) {
                    throw new NullPointerException("Cannot calculate MessageDigest attribute! Digest engine not set!");
                }
                object = this.tD.getHash();
                this.sP.addAttribute(new Attribute((AttributeValue)new CMSMessageDigest((byte[])object)));
            }
            sET = this.sP.toAsn1SET(true);
            aSN1Object.addComponent((ASN1Object)new CON_SPEC(2, (ASN1Object)sET, true));
        }
        if (this.l == null) {
            try {
                if (this.tC != null && this.tg == null) {
                    this.l = this.tC.getMac();
                } else {
                    object = this.tK;
                    if (object == null) {
                        object = SecurityProvider.getSecurityProvider();
                    }
                    if (this.tJ == null) {
                        throw new NullPointerException("Cannot create MAC with null key!");
                    }
                    if (sET == null) {
                        throw new NullPointerException("Auth attributes have to be set if digest algorithm is present!");
                    }
                    byte[] byArray = DerCoder.encode((ASN1Object)sET);
                    this.l = ((SecurityProvider)object).calculateMac(this.sX, this.tJ, null, byArray);
                }
            }
            catch (Exception exception) {
                throw new CodingException("Mac calculation error: " + exception.toString());
            }
        }
        aSN1Object.addComponent((ASN1Object)new OCTET_STRING(this.l));
        if (this.tI.size() > 0) {
            aSN1Object.addComponent((ASN1Object)new CON_SPEC(3, (ASN1Object)this.tI.toAsn1SET(), true));
        }
    }

    public Attribute getAuthenticatedAttribute(ObjectID objectID) {
        return this.sP.getAttribute(objectID);
    }

    public Attribute[] getAuthenticatedAttributes() {
        return this.sP.toArray();
    }

    public byte[] getAuthenticatedDigest() {
        byte[] byArray = null;
        Attribute attribute = this.sP.getAttribute(CMSMessageDigest.oid);
        if (attribute != null) {
            try {
                AttributeValue attributeValue = attribute.getAttributeValue();
                if (attributeValue != null) {
                    CMSMessageDigest cMSMessageDigest = attributeValue instanceof CMSMessageDigest ? (CMSMessageDigest)attributeValue : new CMSMessageDigest(attributeValue.toASN1Object());
                    byArray = cMSMessageDigest.getDigest();
                }
            }
            catch (CodingException codingException) {
                throw new CMSException("Error parsing MessageDigest attribute: " + codingException.getMessage());
            }
        }
        if (byArray == null) {
            throw new CMSException("Message digest not included in signed attributes!");
        }
        return byArray;
    }

    public int getBlockSize() {
        return this.o;
    }

    public ObjectID getContentType() {
        return ObjectID.cms_authData;
    }

    public AlgorithmID getDigestAlgorithm() {
        return this.tg;
    }

    public ObjectID getEncapsulatedContentType() {
        return this.tE;
    }

    public InputStream getInputStream() {
        return this.tF;
    }

    public byte[] getMac() {
        return this.l;
    }

    public AlgorithmID getMacAlgorithm() {
        return this.sX;
    }

    public int getMode() {
        return this.a;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.tz;
    }

    public RecipientInfo getRecipientInfo(KeyIdentifier keyIdentifier) {
        Enumeration enumeration = this.tA.elements();
        while (enumeration.hasMoreElements()) {
            RecipientInfo recipientInfo = (RecipientInfo)enumeration.nextElement();
            if (!recipientInfo.isRecipientInfoFor(keyIdentifier)) continue;
            return recipientInfo;
        }
        return null;
    }

    public RecipientInfo getRecipientInfo(X509Certificate x509Certificate) {
        Enumeration enumeration = this.tA.elements();
        while (enumeration.hasMoreElements()) {
            RecipientInfo recipientInfo = (RecipientInfo)enumeration.nextElement();
            if (recipientInfo.isRecipientInfoFor(x509Certificate) == null) continue;
            return recipientInfo;
        }
        return null;
    }

    public RecipientInfo[] getRecipientInfos() {
        return (RecipientInfo[])Util.toArray((Vector)this.tA, (Class)(tN != null ? tN : (tN = AuthenticatedDataStream.class$("iaik.cms.RecipientInfo"))));
    }

    public RecipientInfo[] getRecipientInfos(int n2) {
        Enumeration enumeration = this.tA.elements();
        Vector<RecipientInfo> vector = new Vector<RecipientInfo>();
        while (enumeration.hasMoreElements()) {
            RecipientInfo recipientInfo = (RecipientInfo)enumeration.nextElement();
            if (recipientInfo.getRecipientInfoType() != n2) continue;
            vector.addElement(recipientInfo);
        }
        Object[] objectArray = new RecipientInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SecurityProvider getSecurityProvider() {
        return this.tK;
    }

    public Attribute getUnauthenticatedAttribute(ObjectID objectID) {
        return this.tI.getAttribute(objectID);
    }

    public Attribute[] getUnauthenticatedAttributes() {
        return this.tI.toArray();
    }

    public int getVersion() {
        return this.b;
    }

    private void a(boolean bl) {
        if (this.sX == null) {
            throw new NullPointerException("Cannot init Mac computation with null Mac algorithm!");
        }
        if (this.tF == null) {
            throw new NullPointerException("Cannot init Mac computation for null content data!");
        }
        SecurityProvider securityProvider = this.tK;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        if (bl) {
            this.tJ = securityProvider.generateKey(this.sX, this.g);
            this.tr = true;
        }
        if (this.tg != null) {
            this.tD = securityProvider.getInputStreamHashEngine(this.tg, this.tF);
            this.tF = this.tD.getInputStream();
        } else {
            try {
                this.tC = securityProvider.getInputStreamMacEngine(this.sX, this.tJ, this.tB, this.tF);
                this.tF = this.tC.getInputStream();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new NoSuchAlgorithmException("Invalid Mac key: " + invalidKeyException.getMessage());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new NoSuchAlgorithmException("Invalid Mac parameters: " + invalidAlgorithmParameterException.getMessage());
            }
        }
    }

    public void notifyEOF() {
        int n2;
        if (this.tL.nextIsContextSpecific()) {
            try {
                n2 = this.tL.readContextSpecific(17);
                if (n2 != 2) {
                    throw new IOException("Error parsing unauthenticated attributes. Invalid tag: " + n2 + " (Expected 2).");
                }
                this.sP = new b((InputStream)this.tL);
                if (this.tg == null) {
                    throw new NullPointerException("Parsing error: Digest algorithm not allowed to be null when auth attributes are present!");
                }
            }
            catch (CodingException codingException) {
                throw new IOException("Error parsing authenticated attributes: " + codingException.getMessage());
            }
        }
        this.l = this.tL.readOctetStringByteArray();
        if (this.tL.nextIsContextSpecific()) {
            try {
                n2 = this.tL.readContextSpecific(17);
                if (n2 != 3) {
                    throw new IOException("Error parsing unauthenticated attributes. Invalid tag: " + n2 + " (Expected 3).");
                }
                this.tI = new b((InputStream)this.tL);
            }
            catch (CodingException codingException) {
                throw new IOException("Error parsing unauthenticated attributes: " + codingException.getMessage());
            }
        }
        if (Utils.getIaikProviderVersion() >= 3.16) {
            this.tL.readEOC();
        }
    }

    public void setAuthenticatedAttributes(Attribute[] attributeArray) {
        if (attributeArray != null && attributeArray.length > 0) {
            if (this.tg == null) {
                throw new NullPointerException("Cannot set authenticated attributes. Digest algorithm is null!");
            }
            b b2 = new b(attributeArray);
            try {
                Utils.a(b2, this.l, this.tE);
            }
            catch (CMSException cMSException) {
                throw new CMSRuntimeException(cMSException.getMessage());
            }
            catch (Throwable throwable) {
                throw new CMSRuntimeException("Error checking ContentType attribute: " + throwable.toString());
            }
            this.sP = b2;
        } else {
            this.sP.clearAll();
        }
        if (!this.tM) {
            this.l = null;
            this.y = null;
            this.tH = null;
        }
    }

    public void setBlockSize(int n2) {
        this.o = n2;
    }

    public void setInputStream(InputStream inputStream) {
        block3: {
            this.tF = inputStream;
            if (this.tF == null || this.l != null && !this.sk) break block3;
            this.y = null;
            this.tH = null;
            if (this.l == null) {
                try {
                    this.a(this.sk ^ true);
                }
                catch (Exception exception) {
                    this.tF = inputStream;
                }
            }
        }
    }

    public void setOriginatorInfo(OriginatorInfo originatorInfo) {
        this.b = 0;
        this.tz = originatorInfo;
        if (this.tz != null) {
            RevocationInfoChoices revocationInfoChoices = this.tz.getRevocationInfoChoices();
            if (revocationInfoChoices.containsOtherRevocationInfos()) {
                this.b = 3;
            } else {
                CertificateSet certificateSet = this.tz.getCertificateSet();
                if (certificateSet.containsOtherCertificates()) {
                    this.b = 3;
                } else if (certificateSet.getAttributeCertificateType() == 2) {
                    this.b = 1;
                }
            }
        }
    }

    public void setRecipientInfos(RecipientInfo[] recipientInfoArray) {
        this.tA.removeAllElements();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            this.addRecipientInfo(recipientInfoArray[n2]);
            ++n2;
        }
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.tK = securityProvider;
        if (this.tA != null) {
            Object[] objectArray = Util.toArray((Vector)this.tA);
            int n2 = 0;
            while (n2 < objectArray.length) {
                RecipientInfo recipientInfo = (RecipientInfo)objectArray[n2];
                if (recipientInfo.getSecurityProvider() == null) {
                    recipientInfo.setSecurityProvider(this.tK);
                }
                ++n2;
            }
        }
    }

    public void setUnauthenticatedAttributes(Attribute[] attributeArray) {
        this.tI = new b(attributeArray);
    }

    public SecretKey setupMac(Key key, int n2) {
        RecipientInfo recipientInfo = (RecipientInfo)this.tA.elementAt(n2);
        this.tJ = recipientInfo.decryptKey(key, null, this.sX.getImplementationName());
        this.setupMac(this.tJ);
        return this.tJ;
    }

    public SecretKey setupMac(Key key, KeyIdentifier keyIdentifier) {
        RecipientInfo recipientInfo = this.getRecipientInfo(keyIdentifier);
        if (recipientInfo == null) {
            throw new CMSException("No recipient for the given recipient identifier included!");
        }
        this.tJ = recipientInfo.decryptKey(key, keyIdentifier, this.sX.getImplementationName());
        this.setupMac(this.tJ);
        return this.tJ;
    }

    public SecretKey setupMac(Key key, X509Certificate x509Certificate) {
        RecipientInfo recipientInfo = null;
        CertificateIdentifier certificateIdentifier = null;
        Enumeration enumeration = this.tA.elements();
        while (enumeration.hasMoreElements()) {
            recipientInfo = (RecipientInfo)enumeration.nextElement();
            certificateIdentifier = recipientInfo.isRecipientInfoFor(x509Certificate);
            if (certificateIdentifier != null) break;
        }
        if (certificateIdentifier == null) {
            throw new CMSException("No recipient for the given recipient identifier included!");
        }
        this.tJ = recipientInfo.decryptKey(key, certificateIdentifier, this.sX.getImplementationName());
        this.setupMac(this.tJ);
        return this.tJ;
    }

    public void setupMac(SecretKey secretKey) {
        this.tJ = secretKey;
        if (this.tF != null) {
            this.a(false);
        }
    }

    public ASN1Object toASN1Object() {
        return this.toASN1Object(-1);
    }

    protected ASN1Object toASN1Object(int n2) {
        Object object;
        if (n2 <= 0) {
            n2 = this.o;
        }
        if (this.tE == null) {
            throw new NullPointerException("Encapsulated content type not set.");
        }
        if (this.tA == null || this.tA.size() == 0) {
            throw new NullPointerException("No recipients specified.");
        }
        if (this.sX == null) {
            throw new NullPointerException("No Mac algorithm specified.");
        }
        if (this.tJ != null && this.tr) {
            object = this.tA.elements();
            while (object.hasMoreElements()) {
                ((RecipientInfo)object.nextElement()).encryptKey(this.tJ);
            }
            this.tr = false;
        }
        object = new SEQUENCE(true);
        object.addComponent((ASN1Object)new INTEGER(this.b));
        if (this.tz != null && !this.tz.isEmpty()) {
            object.addComponent((ASN1Object)new CON_SPEC(0, this.tz.toASN1Object(), true));
        }
        object.addComponent((ASN1Object)RecipientInfo.createRecipientInfos(this.tA));
        if (this.sX.getParameter() == null) {
            this.sX.encodeAbsentParametersAsNull(false);
        }
        object.addComponent(this.sX.toASN1Object());
        if (this.tg != null) {
            object.addComponent((ASN1Object)new CON_SPEC(1, this.tg.toASN1Object(), true));
        }
        if (this.a == 1 && this.tF != null) {
            this.tG = new EncapsulatedContentInfoStream(this.tF, this.tE);
            this.tG.setBlockSize(n2);
        } else {
            this.tG = new EncapsulatedContentInfoStream(this.tE);
        }
        object.addComponent(this.tG.toASN1Object());
        object.addEncodeListener((EncodeListener)this, 1, object.countComponents() - 1);
        return object;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.b + "\n");
        if (this.tz != null && !this.tz.isEmpty()) {
            stringBuffer.append("OriginatorInfo: " + this.tz + "\n");
        }
        stringBuffer.append("RecipientInfos: " + this.tA.size() + "\n");
        if (bl) {
            int n2 = 0;
            while (n2 < this.tA.size()) {
                stringBuffer.append("RecipientInfo " + (n2 + 1) + ": {\n");
                Utils.printIndented(((RecipientInfo)this.tA.elementAt(n2)).toString(), true, stringBuffer);
                stringBuffer.append("\n}\n");
                ++n2;
            }
        }
        stringBuffer.append("MacAlgorithm: " + this.sX + "\n");
        if (this.tg != null) {
            stringBuffer.append("DigestAlgorithm: " + this.tg + "\n");
        }
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        if (this.tG != null) {
            Utils.printIndented(this.tG.toString(bl), true, stringBuffer);
        }
        stringBuffer.append("\n}\n");
        if (this.sP.size() > 0) {
            stringBuffer.append("Authenticated Attributes: {\n");
            Utils.printIndented(this.sP.toString(), true, stringBuffer);
            stringBuffer.append("\n}\n");
        }
        stringBuffer.append("Mac: ");
        if (this.l != null) {
            stringBuffer.append(String.valueOf(this.l.length) + " bytes [" + Util.toString((byte[])this.l, (int)0, (int)5) + "...]\n");
        }
        if (this.tI.size() > 0) {
            stringBuffer.append("Unauthenticated attributes: {\n");
            Utils.printIndented(this.tI.toString(), true, stringBuffer);
            stringBuffer.append("\n}");
        }
        return stringBuffer.toString();
    }

    public boolean verifyMac() {
        SecurityProvider securityProvider = this.tK;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        if (this.sX == null) {
            throw new NullPointerException("Cannot verify Mac. Mac algorithm not allowed to be null!");
        }
        if (this.tJ == null) {
            throw new NullPointerException("Cannot verify Mac. Mac key is null!");
        }
        try {
            this.tB = securityProvider.getAlgorithmParameterSpec(this.sX);
        }
        catch (Exception exception) {}
        try {
            if (this.sP.size() > 0) {
                AttributeValue attributeValue = null;
                Attribute attribute = this.sP.getAttribute(CMSContentType.oid);
                if (attribute != null && (attributeValue = attribute.getAttributeValue()) != null) {
                    CMSContentType cMSContentType;
                    CMSContentType cMSContentType2 = cMSContentType = attributeValue instanceof CMSContentType ? (CMSContentType)attributeValue : new CMSContentType(attributeValue.toASN1Object());
                    if (!cMSContentType.get().equals((Object)this.tE)) {
                        throw new InvalidContentTypeException();
                    }
                }
                if (attributeValue == null) {
                    throw new InvalidContentTypeException("Missing ContentType attribute!");
                }
                if (this.tg == null) {
                    throw new NullPointerException("Cannot verify Mac. Digest algorithm not allowed to be null when auth attributes are present!");
                }
                if (this.y == null) {
                    if (this.tD == null) {
                        throw new NullPointerException("Cannot verify Mac. Digest engine not initialized!");
                    }
                    this.y = this.tD.getHash();
                }
                if (!CryptoUtils.equalsBlock((byte[])this.y, (byte[])this.getAuthenticatedDigest())) {
                    throw new InvalidContentHashException();
                }
                return CryptoUtils.equalsBlock((byte[])this.l, (byte[])securityProvider.calculateMac(this.sX, this.tJ, this.tB, DerCoder.encode((ASN1Object)this.sP.toAsn1SET(this.sk ^ true))));
            }
            if (this.tH == null) {
                if (this.tC == null) {
                    throw new NullPointerException("Cannot verify Mac. Mac engine not initialized!");
                }
                this.tH = this.tC.getMac();
            }
            return CryptoUtils.equalsBlock((byte[])this.tH, (byte[])this.l);
        }
        catch (CodingException codingException) {
            throw new CMSMacException("Error encoding authenticated attributes: " + codingException.toString());
        }
        catch (Exception exception) {
            throw new CMSMacException(exception.toString());
        }
    }

    public void writeTo(OutputStream outputStream) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    public void writeTo(OutputStream outputStream, int n2) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(n2), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }
}

