/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SET;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.CMSException;
import iaik.cms.CMSRuntimeException;
import iaik.cms.CertificateSet;
import iaik.cms.DataOutputStream;
import iaik.cms.DebugCMS;
import iaik.cms.OriginatorInfo;
import iaik.cms.OutputStreamHashEngine;
import iaik.cms.OutputStreamMacEngine;
import iaik.cms.RecipientInfo;
import iaik.cms.RevocationInfoChoices;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import iaik.cms.attributes.CMSMessageDigest;
import iaik.cms.b;
import iaik.cms.w;
import iaik.utils.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.SecretKey;

public class AuthenticatedDataOutputStream
extends OutputStream {
    private static boolean c = false;
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    private int d = 1;
    private int e = 0;
    private OriginatorInfo te;
    private Vector tf = new Vector();
    private AlgorithmID tg;
    private AlgorithmParameterSpec th;
    private OutputStreamMacEngine tj;
    private int k;
    private AlgorithmID tk;
    private OutputStreamHashEngine tl;
    private ObjectID tm;
    private OutputStream tn;
    private OutputStream to;
    private boolean tp;
    private boolean tr = true;
    private b ts = new b();
    private byte[] tt;
    private b tu = new b();
    private SecretKey tv;
    private SecurityProvider tw;
    boolean a;
    boolean rH = false;
    private boolean tx;

    static {
        c = DebugCMS.getDebugMode() && c;
    }

    private AuthenticatedDataOutputStream() {
    }

    public AuthenticatedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID, int n2, AlgorithmParameterSpec algorithmParameterSpec, int n3) {
        this(objectID, outputStream, algorithmID, n2, algorithmParameterSpec, null, n3, null);
    }

    public AuthenticatedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID, int n2, AlgorithmParameterSpec algorithmParameterSpec, int n3, SecurityProvider securityProvider) {
        this(objectID, outputStream, algorithmID, n2, algorithmParameterSpec, null, n3, securityProvider);
    }

    public AuthenticatedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID, int n2, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmID algorithmID2, int n3) {
        this(objectID, outputStream, algorithmID, n2, algorithmParameterSpec, algorithmID2, n3, null);
    }

    public AuthenticatedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID, int n2, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmID algorithmID2, int n3, SecurityProvider securityProvider) {
        this();
        if (objectID == null) {
            throw new NullPointerException("Encapsulated content type must not be null!");
        }
        if (algorithmID == null) {
            throw new NullPointerException("Mac algorithm must not be null!");
        }
        if (n3 != 1 && n3 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n3 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.tm = objectID;
        this.tn = outputStream;
        this.tg = algorithmID;
        this.k = n2;
        this.th = algorithmParameterSpec;
        this.tk = algorithmID2;
        this.tw = securityProvider;
        this.d = n3;
        if (this.tn != null) {
            this.a(true);
        }
    }

    public AuthenticatedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID, byte[] byArray, AlgorithmID algorithmID2, int n2) {
        this();
        if (objectID == null) {
            throw new NullPointerException("Encapsulated content type must not be null!");
        }
        if (algorithmID == null) {
            throw new NullPointerException("Mac algorithm must not be null!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.tm = objectID;
        this.tn = outputStream;
        this.to = this.d == 1 ? new DataOutputStream(this.tn, false) : new w();
        this.tg = algorithmID;
        this.tt = byArray;
        this.tk = algorithmID2;
        this.a = false;
        this.d = n2;
        this.rH = true;
    }

    public void addRecipientInfo(RecipientInfo recipientInfo) {
        if (recipientInfo.getSecurityProvider() == null) {
            recipientInfo.setSecurityProvider(this.tw);
        }
        this.tf.addElement(recipientInfo);
    }

    private void a() {
        if (this.tx) {
            throw new IOException("Stream already closed!");
        }
    }

    public void close() {
        this.a();
        this.tx = true;
        this.b();
        this.to.close();
        if (this.d == 1) {
            this.tn.write(new byte[2]);
        }
        this.tn.write(new byte[2]);
        try {
            Object object;
            SET sET = null;
            if (this.ts.size() > 0) {
                if (this.tk == null) {
                    throw new NullPointerException("Digest algorithm not allowed to be null when auth attributes are present!");
                }
                if (this.ts.getAttribute(ObjectID.messageDigest) == null) {
                    if (this.tl == null) {
                        throw new NullPointerException("Cannot calculate MessageDigest attribute! Digest engine not set!");
                    }
                    object = this.tl.getHash();
                    this.ts.addAttribute(new Attribute((AttributeValue)new CMSMessageDigest((byte[])object)));
                }
                sET = this.ts.toAsn1SET(true);
                this.tn.write(DerCoder.encode((ASN1Object)new CON_SPEC(2, (ASN1Object)sET, true)));
            }
            if (this.tt == null) {
                try {
                    if (this.tj != null && this.tk == null) {
                        this.tt = this.tj.getMac();
                    } else {
                        object = this.tw;
                        if (object == null) {
                            object = SecurityProvider.getSecurityProvider();
                        }
                        if (this.tv == null) {
                            throw new NullPointerException("Cannot create MAC with null key!");
                        }
                        if (sET == null) {
                            throw new NullPointerException("Auth attributes have to be set if digest algorithm is present!");
                        }
                        byte[] byArray = DerCoder.encode((ASN1Object)sET);
                        this.tt = ((SecurityProvider)object).calculateMac(this.tg, this.tv, null, byArray);
                    }
                }
                catch (Exception exception) {
                    throw new CodingException("Mac calculation error: " + exception.toString());
                }
            }
            this.tn.write(DerCoder.encode((ASN1Object)new OCTET_STRING(this.tt)));
            if (this.tu != null && this.tu.size() > 0) {
                try {
                    this.tn.write(DerCoder.encode((ASN1Object)new CON_SPEC(3, (ASN1Object)this.tu.toAsn1SET(), true)));
                }
                catch (CodingException codingException) {
                    throw new IOException(codingException.toString());
                }
            }
            this.tn.write(new byte[2]);
            if (this.tr) {
                this.tn.close();
            }
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.toString());
        }
    }

    private void b() {
        if (!this.tp) {
            try {
                this.tn.write(new byte[]{48, -128});
                this.tn.write(DerCoder.encode((ASN1Object)new INTEGER(this.e)));
                if (this.te != null && !this.te.isEmpty()) {
                    this.tn.write(DerCoder.encode((ASN1Object)new CON_SPEC(0, this.te.toASN1Object(), true)));
                }
                if (this.tv != null) {
                    Enumeration enumeration = this.tf.elements();
                    while (enumeration.hasMoreElements()) {
                        ((RecipientInfo)enumeration.nextElement()).encryptKey(this.tv);
                    }
                }
                this.tn.write(DerCoder.encode((ASN1Object)RecipientInfo.createRecipientInfos(this.tf)));
                this.tn.write(DerCoder.encode((ASN1Object)this.tg.toASN1Object()));
                if (this.tk != null) {
                    this.tn.write(DerCoder.encode((ASN1Object)new CON_SPEC(1, this.tk.toASN1Object(), true)));
                }
                this.tn.write(new byte[]{48, -128});
                this.tn.write(DerCoder.encode((ASN1Object)this.tm));
                if (this.d == 1) {
                    this.tn.write(new byte[]{-96, -128});
                }
                this.tp = true;
            }
            catch (CMSException cMSException) {
                throw new IOException(cMSException.toString());
            }
        }
    }

    public void flush() {
        this.a();
        this.b();
        this.to.flush();
    }

    public Attribute getAuthenticatedAttribute(ObjectID objectID) {
        return this.ts.getAttribute(objectID);
    }

    public Attribute[] getAuthenticatedAttributes() {
        return this.ts.toArray();
    }

    public byte[] getAuthenticatedDigest() {
        byte[] byArray = null;
        Attribute attribute = this.ts.getAttribute(CMSMessageDigest.oid);
        if (attribute != null) {
            try {
                AttributeValue attributeValue = attribute.getAttributeValue();
                if (attributeValue != null) {
                    CMSMessageDigest cMSMessageDigest = attributeValue instanceof CMSMessageDigest ? (CMSMessageDigest)attributeValue : new CMSMessageDigest(attributeValue.toASN1Object());
                    byArray = cMSMessageDigest.getDigest();
                }
            }
            catch (CodingException codingException) {
                throw new CMSException("Error parsing MessageDigest attribute: " + codingException.getMessage());
            }
        }
        if (byArray == null) {
            throw new CMSException("Message digest not included in signed attributes!");
        }
        return byArray;
    }

    public byte[] getMac() {
        return this.tt;
    }

    public SecurityProvider getSecurityProvider() {
        return this.tw;
    }

    public Attribute getUnauthenticatedAttribute(ObjectID objectID) {
        return this.tu.getAttribute(objectID);
    }

    public Attribute[] getUnauthenticatedAttributes() {
        return this.tu.toArray();
    }

    public int getVersion() {
        return this.e;
    }

    private void a(boolean bl) {
        if (this.tg == null) {
            throw new NullPointerException("Cannot init Mac computation with null Mac algorithm!");
        }
        if (this.tn == null) {
            throw new NullPointerException("Cannot init Mac computation for null content data!");
        }
        SecurityProvider securityProvider = this.tw;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        if (bl) {
            this.tv = securityProvider.generateKey(this.tg, this.k);
            this.a = true;
        }
        if (this.to == null) {
            OutputStream outputStream = this.to = this.d == 1 ? new DataOutputStream(this.tn, false) : new w();
        }
        if (this.tk != null) {
            this.tl = securityProvider.getOutputStreamHashEngine(this.tk, this.to);
            this.to = this.tl.getOutputStream();
        } else {
            try {
                this.tj = securityProvider.getOutputStreamMacEngine(this.tg, this.tv, this.th, this.to);
                this.to = this.tj.getOutputStream();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new NoSuchAlgorithmException("Invalid Mac key: " + invalidKeyException.getMessage());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new NoSuchAlgorithmException("Invalid Mac parameters: " + invalidAlgorithmParameterException.getMessage());
            }
        }
    }

    public boolean isPassThroughClose() {
        return this.tr;
    }

    public void setAuthenticatedAttributes(Attribute[] attributeArray) {
        if (attributeArray != null && attributeArray.length > 0) {
            if (this.tk == null) {
                throw new NullPointerException("Cannot set authenticated attributes. Digest algorithm is null!");
            }
            b b2 = new b(attributeArray);
            try {
                Utils.a(b2, this.tt, this.tm);
            }
            catch (CMSException cMSException) {
                throw new CMSRuntimeException(cMSException.getMessage());
            }
            catch (Throwable throwable) {
                throw new CMSRuntimeException("Error checking ContentType attribute: " + throwable.toString());
            }
            this.ts = b2;
        } else {
            this.ts.clearAll();
        }
        if (!this.rH) {
            this.tt = null;
        }
    }

    public void setOriginatorInfo(OriginatorInfo originatorInfo) {
        this.e = 0;
        this.te = originatorInfo;
        if (this.te != null) {
            RevocationInfoChoices revocationInfoChoices = this.te.getRevocationInfoChoices();
            if (revocationInfoChoices.containsOtherRevocationInfos()) {
                this.e = 3;
            } else {
                CertificateSet certificateSet = this.te.getCertificateSet();
                if (certificateSet.containsOtherCertificates()) {
                    this.e = 3;
                } else if (certificateSet.getAttributeCertificateType() == 2) {
                    this.e = 1;
                }
            }
        }
    }

    public void setPassThroughClose(boolean bl) {
        this.tr = bl;
    }

    public void setRecipientInfos(RecipientInfo[] recipientInfoArray) {
        this.tf.removeAllElements();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            this.addRecipientInfo(recipientInfoArray[n2]);
            ++n2;
        }
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.tw = securityProvider;
        if (this.tf != null) {
            Object[] objectArray = Util.toArray((Vector)this.tf);
            int n2 = 0;
            while (n2 < objectArray.length) {
                RecipientInfo recipientInfo = (RecipientInfo)objectArray[n2];
                if (recipientInfo.getSecurityProvider() == null) {
                    recipientInfo.setSecurityProvider(this.tw);
                }
                ++n2;
            }
        }
    }

    public void setUnauthenticatedAttributes(Attribute[] attributeArray) {
        this.tu = new b(attributeArray);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.e + "\n");
        if (this.te != null && !this.te.isEmpty()) {
            stringBuffer.append("OriginatorInfo: " + this.te + "\n");
        }
        stringBuffer.append("RecipientInfos: " + this.tf.size() + "\n");
        if (bl) {
            int n2 = 0;
            while (n2 < this.tf.size()) {
                stringBuffer.append("RecipientInfo " + (n2 + 1) + ": {\n");
                Utils.printIndented(((RecipientInfo)this.tf.elementAt(n2)).toString(), true, stringBuffer);
                stringBuffer.append("\n}\n");
                ++n2;
            }
        }
        stringBuffer.append("MacAlgorithm: " + this.tg + "\n");
        if (this.tk != null) {
            stringBuffer.append("DigestAlgorithm: " + this.tk + "\n");
        }
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        Utils.printIndented("ContentType: " + this.tm.getName() + (this.d == 1 ? ", content included\n" : ", no content\n"), true, stringBuffer);
        if (this.ts.size() > 0) {
            stringBuffer.append("Authenticated Attributes: {\n");
            Utils.printIndented(this.ts.toString(), true, stringBuffer);
            stringBuffer.append("\n}\n");
        }
        stringBuffer.append("Mac: ");
        if (this.tt != null) {
            stringBuffer.append(String.valueOf(this.tt.length) + " bytes [" + Util.toString((byte[])this.tt, (int)0, (int)5) + "...]\n");
        }
        if (this.tu.size() > 0) {
            stringBuffer.append("Unauthenticated attributes: {\n");
            Utils.printIndented(this.tu.toString(), true, stringBuffer);
            stringBuffer.append("\n}");
        }
        return stringBuffer.toString();
    }

    public void write(int n2) {
        this.a();
        this.write(new byte[]{(byte)(n2 & 0xFF)}, 0, 1);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.a();
        this.b();
        this.to.write(byArray, n2, n3);
    }
}

