/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.AuthenticatedDataStream;
import iaik.cms.CMSException;
import iaik.cms.CMSMacException;
import iaik.cms.CMSParsingException;
import iaik.cms.CMSRuntimeException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.Content;
import iaik.cms.EncapsulatedContentInfo;
import iaik.cms.InvalidContentHashException;
import iaik.cms.InvalidContentTypeException;
import iaik.cms.KeyAgreeRecipientInfo;
import iaik.cms.KeyIdentifier;
import iaik.cms.OriginatorInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.CMSMessageDigest;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public class AuthenticatedData
extends AuthenticatedDataStream
implements Content {
    private byte[] td;

    protected AuthenticatedData() {
        this.o = -1;
    }

    public AuthenticatedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID, int n2, AlgorithmParameterSpec algorithmParameterSpec, int n3) {
        this(objectID, byArray, algorithmID, n2, algorithmParameterSpec, null, n3, null);
    }

    public AuthenticatedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID, int n2, AlgorithmParameterSpec algorithmParameterSpec, int n3, SecurityProvider securityProvider) {
        this(objectID, byArray, algorithmID, n2, algorithmParameterSpec, null, n3, securityProvider);
    }

    public AuthenticatedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID, int n2, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmID algorithmID2, int n3) {
        this(objectID, byArray, algorithmID, n2, algorithmParameterSpec, algorithmID2, n3, null);
    }

    public AuthenticatedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID, int n2, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmID algorithmID2, int n3, SecurityProvider securityProvider) {
        this();
        if (objectID == null) {
            throw new NullPointerException("Cannot create AuthenticatedData. Missing encapsulated content type!");
        }
        if (n3 != 1 && n3 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n3 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        if (algorithmID == null) {
            throw new NullPointerException("Cannot create AuthenticatedData from null mac algorithm!");
        }
        this.tE = objectID;
        this.td = byArray;
        this.sX = algorithmID;
        this.g = n2;
        this.tB = algorithmParameterSpec;
        this.tg = algorithmID2;
        this.tK = securityProvider;
        this.a = n3;
        SecurityProvider securityProvider2 = this.tK;
        if (securityProvider2 == null) {
            securityProvider2 = SecurityProvider.getSecurityProvider();
        }
        this.tJ = securityProvider2.generateKey(this.sX, this.g);
        this.tr = true;
    }

    public AuthenticatedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID, byte[] byArray2, AlgorithmID algorithmID2, int n2) {
        this();
        if (objectID == null) {
            throw new NullPointerException("Cannot create AuthenticatedData. Missing encapsulated content type!");
        }
        if (algorithmID == null) {
            throw new NullPointerException("Cannot create AuthenticatedData from null mac algorithm!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.tE = objectID;
        this.td = byArray;
        this.sX = algorithmID;
        this.l = byArray2;
        this.tg = algorithmID2;
        this.tr = false;
        this.a = n2;
    }

    public AuthenticatedData(InputStream inputStream) {
        this(inputStream, null);
    }

    public AuthenticatedData(InputStream inputStream, SecurityProvider securityProvider) {
        this();
        this.tK = securityProvider;
        this.decode(inputStream);
    }

    public void decode(ASN1Object aSN1Object) {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode((ASN1Object)aSN1Object)));
        }
        catch (IOException iOException) {
            throw new CMSParsingException(iOException.getMessage());
        }
    }

    public void decode(InputStream inputStream) {
        int n2;
        Object[] objectArray;
        DerInputStream derInputStream;
        int n3;
        this.sk = true;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        if ((n3 = (derInputStream = ((DerInputStream)inputStream).readSequence()).nextTag()) == 6) {
            objectArray = derInputStream.readObjectID();
            if (!objectArray.equals((Object)ObjectID.cms_authData)) {
                throw new CMSParsingException("Content type not AutheticatedData!");
            }
            this.tL = derInputStream.readContextSpecific().readSequence();
        } else {
            this.tL = derInputStream;
        }
        this.b = this.tL.readInteger().intValue();
        if (this.tL.nextIsContextSpecific()) {
            int n4 = this.tL.readContextSpecific(16);
            if (n4 != 0) {
                throw new CMSParsingException("Invalid OriginatorInfo tag: " + n4 + "(Expected 0)");
            }
            this.tz = new OriginatorInfo((InputStream)this.tL);
        }
        objectArray = RecipientInfo.parseRecipientInfos((InputStream)this.tL, this.tK);
        this.tA = Util.getVector((Object[])objectArray);
        if (this.tz != null && !this.tz.isEmpty()) {
            n2 = 0;
            while (n2 < objectArray.length) {
                KeyAgreeRecipientInfo keyAgreeRecipientInfo;
                KeyIdentifier keyIdentifier;
                if (((RecipientInfo)objectArray[n2]).getRecipientInfoType() == 1 && (keyIdentifier = (keyAgreeRecipientInfo = (KeyAgreeRecipientInfo)objectArray[n2]).getOriginator()) != null && keyIdentifier.getKeyIdType() != 4) {
                    try {
                        X509Certificate x509Certificate = this.tz.getCertificate((CertificateIdentifier)keyIdentifier);
                        if (x509Certificate != null) {
                            keyAgreeRecipientInfo.a(x509Certificate.getPublicKey(), null);
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        this.sX = new AlgorithmID(this.tL);
        if (this.tL.nextIsContextSpecific()) {
            n2 = this.tL.readContextSpecific(16);
            if (n2 != 1) {
                throw new CMSParsingException("Invalid digestAlgorithm tag: " + n2 + "(Expected 1)");
            }
            this.tg = new AlgorithmID(this.tL);
        }
        this.tG = new EncapsulatedContentInfo((InputStream)this.tL);
        this.tE = this.tG.getContentType();
        if (!this.tG.hasContent()) {
            this.a = 2;
        } else {
            this.td = ((EncapsulatedContentInfo)this.tG).getContent();
        }
        this.notifyEOF();
    }

    public byte[] getContent() {
        return this.td;
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    public InputStream getInputStream() {
        if (this.td == null) {
            return null;
        }
        return new ByteArrayInputStream(this.td);
    }

    public void setContent(byte[] byArray) {
        this.td = byArray;
    }

    public void setInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Utils.copyStream(inputStream, byteArrayOutputStream, null);
                this.td = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                throw new CMSRuntimeException("Error reading from stream!", exception);
            }
        }
    }

    public void setupMac(SecretKey secretKey) {
        this.tJ = secretKey;
    }

    protected ASN1Object toASN1Object(int n2) {
        byte[] byArray;
        Object object;
        SecurityProvider securityProvider = this.tK;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        if (n2 <= 0) {
            n2 = this.o;
        }
        if (this.tE == null) {
            throw new NullPointerException("Encapsulated content type not set.");
        }
        if (this.tA == null || this.tA.size() == 0) {
            throw new NullPointerException("No recipients specified.");
        }
        if (this.sX == null) {
            throw new NullPointerException("No Mac algorithm specified.");
        }
        if (this.tJ != null && this.tr) {
            object = this.tA.elements();
            while (object.hasMoreElements()) {
                ((RecipientInfo)object.nextElement()).encryptKey(this.tJ);
            }
            this.tr = false;
        }
        object = new SEQUENCE(n2 > 0);
        object.addComponent((ASN1Object)new INTEGER(this.b));
        if (this.tz != null && !this.tz.isEmpty()) {
            object.addComponent((ASN1Object)new CON_SPEC(0, this.tz.toASN1Object(), true));
        }
        object.addComponent((ASN1Object)RecipientInfo.createRecipientInfos(this.tA));
        if (this.sX.getParameter() == null) {
            this.sX.encodeAbsentParametersAsNull(false);
        }
        object.addComponent(this.sX.toASN1Object());
        if (this.tg != null) {
            object.addComponent((ASN1Object)new CON_SPEC(1, this.tg.toASN1Object(), true));
        }
        if (this.a == 1 && this.td != null) {
            this.tG = new EncapsulatedContentInfo(this.td, this.tE);
            this.tG.setBlockSize(n2);
        } else {
            this.tG = new EncapsulatedContentInfo(this.tE);
        }
        object.addComponent(this.tG.toASN1Object());
        SET sET = null;
        if (this.sP.size() > 0) {
            if (this.tg == null) {
                throw new NullPointerException("Digest algorithm not allowed to be null when auth attributes are present!");
            }
            if (this.sP.getAttribute(ObjectID.messageDigest) == null) {
                try {
                    byArray = securityProvider.getHash(this.tg, this.td);
                    this.sP.addAttribute(new Attribute((AttributeValue)new CMSMessageDigest(byArray)));
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new CMSException("Cannot calculate MessageDigest attribute! Algorithm " + this.tg.getAlgorithm().getName() + " not supported!");
                }
                catch (CodingException codingException) {
                    throw new CMSException("Cannot create MessageDigest attribute: " + codingException.getMessage());
                }
            }
            try {
                sET = this.sP.toAsn1SET(true);
            }
            catch (CodingException codingException) {
                throw new CMSException("Cannot create ASN.1 set of authenticated attributes: " + codingException.getMessage());
            }
            object.addComponent((ASN1Object)new CON_SPEC(2, (ASN1Object)sET, true));
        }
        if (this.l == null) {
            try {
                byArray = null;
                byArray = sET != null ? DerCoder.encode(sET) : this.td;
                this.l = securityProvider.calculateMac(this.sX, this.tJ, this.tB, byArray);
            }
            catch (Exception exception) {
                throw new CMSException("Mac calculation error: " + exception.toString());
            }
        }
        object.addComponent((ASN1Object)new OCTET_STRING(this.l));
        if (this.tI.size() > 0) {
            try {
                object.addComponent((ASN1Object)new CON_SPEC(3, (ASN1Object)this.tI.toAsn1SET(), true));
            }
            catch (CodingException codingException) {
                throw new CMSException("Cannot create ASN.1 set of unauthenticated attributes: " + codingException.getMessage());
            }
        }
        return object;
    }

    public boolean verifyMac() {
        SecurityProvider securityProvider = this.tK;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        if (this.sX == null) {
            throw new NullPointerException("Cannot verify Mac. Mac algorithm not allowed to be null!");
        }
        if (this.tJ == null) {
            throw new NullPointerException("Cannot verify Mac. Mac key is null!");
        }
        if (this.td == null) {
            throw new NullPointerException("Cannot verify Mac from null content!");
        }
        try {
            this.tB = securityProvider.getAlgorithmParameterSpec(this.sX);
        }
        catch (Exception exception) {}
        try {
            if (this.sP.size() > 0) {
                Object object;
                AttributeValue attributeValue = null;
                Attribute attribute = this.sP.getAttribute(CMSContentType.oid);
                if (attribute != null && (attributeValue = attribute.getAttributeValue()) != null) {
                    CMSContentType cMSContentType = object = attributeValue instanceof CMSContentType ? (CMSContentType)attributeValue : new CMSContentType(attributeValue.toASN1Object());
                    if (!object.get().equals((Object)this.tE)) {
                        throw new InvalidContentTypeException();
                    }
                }
                if (attributeValue == null) {
                    throw new InvalidContentTypeException("Missing ContentType attribute!");
                }
                if (this.tg == null) {
                    throw new NullPointerException("Cannot verify Mac. Digest algorithm not allowed to be null when auth attributes are present!");
                }
                if (!CryptoUtils.equalsBlock((byte[])securityProvider.getHash(this.tg, this.td), (byte[])this.getAuthenticatedDigest())) {
                    throw new InvalidContentHashException();
                }
                object = DerCoder.encode((ASN1Object)this.sP.toAsn1SET(this.sk ^ true));
                return CryptoUtils.equalsBlock((byte[])this.l, (byte[])securityProvider.calculateMac(this.sX, this.tJ, this.tB, (byte[])object));
            }
            return CryptoUtils.equalsBlock((byte[])this.l, (byte[])securityProvider.calculateMac(this.sX, this.tJ, this.tB, this.td));
        }
        catch (CodingException codingException) {
            throw new CMSMacException("Error encoding authenticated attributes: " + codingException.toString());
        }
        catch (Exception exception) {
            throw new CMSMacException(exception.toString());
        }
    }
}

