/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.EncodeListener;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.cms.AuthEnvelopedData;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.ContentStream;
import iaik.cms.DebugCMS;
import iaik.cms.EncryptedContentInfo;
import iaik.cms.EncryptedContentInfoStream;
import iaik.cms.KeyAgreeRecipientInfo;
import iaik.cms.KeyIdentifier;
import iaik.cms.OriginatorInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import iaik.cms.b;
import iaik.security.cipher.CCMCMSParameterSpec;
import iaik.security.cipher.GCMParameterSpec;
import iaik.utils.EOFListener;
import iaik.utils.NotifyEOFInputStream;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.SecretKey;

public class AuthEnvelopedDataStream
implements EncodeListener,
ContentStream,
EOFListener {
    private static boolean sS = false;
    int a = 0;
    OriginatorInfo sU;
    Vector sV = new Vector();
    EncryptedContentInfoStream sW;
    AlgorithmID sX;
    int f;
    int g = 2048;
    b sY;
    byte[] sZ;
    b sO;
    SecurityProvider ta;
    private DerInputStream tb;
    long tc = -1L;
    static Class ss;

    static {
        sS = DebugCMS.getDebugMode() && sS;
    }

    protected AuthEnvelopedDataStream() {
    }

    public AuthEnvelopedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID) {
        this(objectID, inputStream, algorithmID, -1, null);
    }

    public AuthEnvelopedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID, int n2) {
        this(objectID, inputStream, algorithmID, n2, null);
    }

    public AuthEnvelopedDataStream(ObjectID objectID, InputStream inputStream, AlgorithmID algorithmID, int n2, SecurityProvider securityProvider) {
        this();
        this.ta = securityProvider;
        this.f = n2;
        this.sX = algorithmID;
        this.sW = new EncryptedContentInfoStream(objectID, inputStream);
        this.sW.setSecurityProvider(this.ta);
        this.sW.a(true);
    }

    public AuthEnvelopedDataStream(InputStream inputStream) {
        this(inputStream, (SecurityProvider)null);
    }

    public AuthEnvelopedDataStream(InputStream inputStream, AlgorithmID algorithmID) {
        this(ObjectID.cms_data, inputStream, algorithmID, -1, null);
    }

    public AuthEnvelopedDataStream(InputStream inputStream, AlgorithmID algorithmID, int n2) {
        this(ObjectID.cms_data, inputStream, algorithmID, n2, null);
    }

    public AuthEnvelopedDataStream(InputStream inputStream, SecurityProvider securityProvider) {
        this();
        this.ta = securityProvider;
        this.decode(inputStream);
    }

    public AuthEnvelopedDataStream(RecipientInfo[] recipientInfoArray, EncryptedContentInfoStream encryptedContentInfoStream) {
        this();
        this.setRecipientInfos(recipientInfoArray);
        this.sW = encryptedContentInfoStream;
        this.sW.a(true);
        this.sX = encryptedContentInfoStream.getContentEncryptionAlgorithm();
    }

    public void addRecipientInfo(RecipientInfo recipientInfo) {
        if (recipientInfo.getSecurityProvider() == null) {
            recipientInfo.setSecurityProvider(this.ta);
        }
        this.sV.addElement(recipientInfo);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static AlgorithmParameterSpec a(AlgorithmID algorithmID, byte[] byArray, long l2) {
        if (algorithmID == null) {
            throw new NullPointerException("Content authenticated encryption algorithm must not be null!");
        }
        CCMCMSParameterSpec cCMCMSParameterSpec = null;
        if (algorithmID.getParameter() == null) {
            boolean bl;
            boolean bl2 = bl = algorithmID.equals((Object)AlgorithmID.aes128_CCM) || algorithmID.equals((Object)AlgorithmID.aes192_CCM) || algorithmID.equals((Object)AlgorithmID.aes256_CCM);
            if (byArray != null) {
                if (bl) {
                    cCMCMSParameterSpec = new CCMCMSParameterSpec(l2, byArray, null, null);
                } else if (algorithmID.equals((Object)AlgorithmID.aes128_GCM) || algorithmID.equals((Object)AlgorithmID.aes192_GCM) || algorithmID.equals((Object)AlgorithmID.aes256_GCM)) {
                    cCMCMSParameterSpec = new GCMParameterSpec(byArray, null);
                }
            } else if (bl && l2 > 0L) {
                cCMCMSParameterSpec = new CCMCMSParameterSpec(l2, null, null, null);
            }
        }
        return cCMCMSParameterSpec;
    }

    public void decode(InputStream inputStream) {
        Object[] objectArray;
        DerInputStream derInputStream;
        int n2;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        if ((n2 = (derInputStream = ((DerInputStream)inputStream).readSequence()).nextTag()) == 6) {
            objectArray = derInputStream.readObjectID();
            if (!objectArray.equals((Object)ObjectID.cms_authEnvelopedData)) {
                throw new CMSParsingException("Content type not AuthEnvelopedData!");
            }
            this.tb = derInputStream.readContextSpecific().readSequence();
        } else {
            this.tb = derInputStream;
        }
        this.a = this.tb.readInteger().intValue();
        if (this.tb.nextIsContextSpecific()) {
            int n3 = this.tb.readContextSpecific(16);
            if (n3 != 0) {
                throw new CMSParsingException("Invalid OriginatorInfo tag: " + n3);
            }
            this.sU = new OriginatorInfo((InputStream)this.tb);
        }
        objectArray = RecipientInfo.parseRecipientInfos((InputStream)this.tb, this.ta);
        this.sV = Util.getVector((Object[])objectArray);
        if (this.sU != null && !this.sU.isEmpty()) {
            int n4 = 0;
            while (n4 < objectArray.length) {
                KeyAgreeRecipientInfo keyAgreeRecipientInfo;
                KeyIdentifier keyIdentifier;
                if (((RecipientInfo)objectArray[n4]).getRecipientInfoType() == 1 && (keyIdentifier = (keyAgreeRecipientInfo = (KeyAgreeRecipientInfo)objectArray[n4]).getOriginator()) != null && keyIdentifier.getKeyIdType() != 4) {
                    try {
                        X509Certificate x509Certificate = this.sU.getCertificate((CertificateIdentifier)keyIdentifier);
                        if (x509Certificate != null) {
                            keyAgreeRecipientInfo.a(x509Certificate.getPublicKey(), null);
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n4;
            }
        }
        this.a(this.tb);
    }

    public void encodeCalled(ASN1Object aSN1Object, int n2) {
        SET sET;
        if (this.sY != null && this.sY.size() > 0) {
            sET = this.sY.toAsn1SET(true);
            aSN1Object.addComponent((ASN1Object)new CON_SPEC(1, (ASN1Object)sET, true));
        }
        if (this.sZ == null) {
            this.sZ = this.sW.a();
        }
        aSN1Object.addComponent((ASN1Object)(this.sZ == null ? new OCTET_STRING(new byte[0]) : new OCTET_STRING(this.sZ)));
        if (this.sO != null && this.sO.size() > 0) {
            sET = this.sO.toAsn1SET(true);
            aSN1Object.addComponent((ASN1Object)new CON_SPEC(2, (ASN1Object)sET, true));
        }
    }

    public Attribute getAuthenticatedAttribute(ObjectID objectID) {
        Attribute attribute = null;
        if (this.sY != null) {
            attribute = this.sY.getAttribute(objectID);
        }
        return attribute;
    }

    public Attribute[] getAuthenticatedAttributes() {
        Attribute[] attributeArray = this.sY == null ? new Attribute[]{} : this.sY.toArray();
        return attributeArray;
    }

    public int getBlockSize() {
        return this.g;
    }

    public ObjectID getContentType() {
        return ObjectID.cms_authEnvelopedData;
    }

    public EncryptedContentInfoStream getEncryptedContentInfo() {
        return this.sW;
    }

    public InputStream getInputStream() {
        return this.sW.getInputStream();
    }

    public byte[] getMac() {
        return this.sZ;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.sU;
    }

    public RecipientInfo getRecipientInfo(KeyIdentifier keyIdentifier) {
        Enumeration enumeration = this.sV.elements();
        while (enumeration.hasMoreElements()) {
            RecipientInfo recipientInfo = (RecipientInfo)enumeration.nextElement();
            if (!recipientInfo.isRecipientInfoFor(keyIdentifier)) continue;
            return recipientInfo;
        }
        return null;
    }

    public RecipientInfo getRecipientInfo(X509Certificate x509Certificate) {
        Enumeration enumeration = this.sV.elements();
        while (enumeration.hasMoreElements()) {
            RecipientInfo recipientInfo = (RecipientInfo)enumeration.nextElement();
            if (recipientInfo.isRecipientInfoFor(x509Certificate) == null) continue;
            return recipientInfo;
        }
        return null;
    }

    public RecipientInfo[] getRecipientInfos() {
        return (RecipientInfo[])Util.toArray((Vector)this.sV, (Class)(ss != null ? ss : (ss = AuthEnvelopedDataStream.class$("iaik.cms.RecipientInfo"))));
    }

    public RecipientInfo[] getRecipientInfos(int n2) {
        Enumeration enumeration = this.sV.elements();
        Vector<RecipientInfo> vector = new Vector<RecipientInfo>();
        while (enumeration.hasMoreElements()) {
            RecipientInfo recipientInfo = (RecipientInfo)enumeration.nextElement();
            if (recipientInfo.getRecipientInfoType() != n2) continue;
            vector.addElement(recipientInfo);
        }
        Object[] objectArray = new RecipientInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SecurityProvider getSecurityProvider() {
        return this.ta;
    }

    public Attribute getUnauthenticatedAttribute(ObjectID objectID) {
        Attribute attribute = null;
        if (this.sO != null) {
            attribute = this.sO.getAttribute(objectID);
        }
        return attribute;
    }

    public Attribute[] getUnauthenticatedAttributes() {
        Attribute[] attributeArray = this.sO == null ? new Attribute[]{} : this.sO.toArray();
        return attributeArray;
    }

    public int getVersion() {
        return this.a;
    }

    public void notifyEOF() {
        int n2;
        if (this.tb.nextIsContextSpecific()) {
            try {
                n2 = this.tb.readContextSpecific(17);
                if (n2 != 1) {
                    throw new IOException("Error parsing authenticated attributes. Invalid tag: " + n2);
                }
                this.sY = new b((InputStream)this.tb);
                if (this.sY != null && this.sY.size() > 0) {
                    SET sET = this.sY.toAsn1SET(true);
                    this.sW.a(DerCoder.encode((ASN1Object)sET));
                }
            }
            catch (CodingException codingException) {
                throw new IOException("Error parsing authenticated attributes: " + codingException.getMessage());
            }
        }
        this.sZ = this.tb.readOctetStringByteArray();
        if (this.tb.nextIsContextSpecific()) {
            try {
                n2 = this.tb.readContextSpecific(17);
                if (n2 != 2) {
                    throw new IOException("Error parsing unauthenticated attributes. Invalid tag: " + n2);
                }
                this.sO = new b((InputStream)this.tb);
            }
            catch (CodingException codingException) {
                throw new IOException("Error parsing unauthenticated attributes: " + codingException.getMessage());
            }
        }
        if (Utils.getIaikProviderVersion() >= 3.16) {
            this.tb.readEOC();
        }
    }

    void a(DerInputStream derInputStream) {
        DerInputStream derInputStream2 = derInputStream.readSequence();
        ObjectID objectID = derInputStream2.readObjectID();
        this.sX = new AlgorithmID(derInputStream2);
        if (this.sX.equals((Object)AlgorithmID.aes128_CCM) || this.sX.equals((Object)AlgorithmID.aes192_CCM) || this.sX.equals((Object)AlgorithmID.aes256_CCM) || this.sX.equals((Object)AlgorithmID.aes128_GCM) || this.sX.equals((Object)AlgorithmID.aes192_GCM) || this.sX.equals((Object)AlgorithmID.aes256_GCM)) {
            this.sW = new EncryptedContentInfo(objectID, this.sX);
            this.sW.setSecurityProvider(this.ta);
            this.sW.a(true);
            this.sW.a(derInputStream2);
            this.notifyEOF();
        } else {
            this.sW = new EncryptedContentInfoStream(objectID, this.sX);
            this.sW.setSecurityProvider(this.ta);
            this.sW.a(true);
            this.sW.a(derInputStream2);
            if (this.sW.a != null) {
                this.sW.a = new NotifyEOFInputStream(this.sW.a);
                ((NotifyEOFInputStream)this.sW.a).addEOFListener((EOFListener)this);
            }
        }
    }

    public void setAuthenticatedAttributes(Attribute[] attributeArray) {
        this.sY = attributeArray == null ? null : new b(attributeArray);
    }

    public void setBlockSize(int n2) {
        this.g = n2;
    }

    public void setInputLength(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Data input Length must not be negative");
        }
        this.tc = l2;
    }

    public void setInputStream(InputStream inputStream) {
        if (this.sW == null) {
            throw new NullPointerException("Cannot set content input stream. Internal EncryptedContentInfo not initialized!");
        }
        this.sW.setInputStream(inputStream);
    }

    public void setMac(byte[] byArray) {
        this.sZ = byArray;
    }

    public void setOriginatorInfo(OriginatorInfo originatorInfo) {
        this.sU = originatorInfo;
    }

    public void setRecipientInfos(RecipientInfo[] recipientInfoArray) {
        this.sV.removeAllElements();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            this.addRecipientInfo(recipientInfoArray[n2]);
            ++n2;
        }
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.ta = securityProvider;
        if (this.sV != null) {
            Object[] objectArray = Util.toArray((Vector)this.sV);
            int n2 = 0;
            while (n2 < objectArray.length) {
                RecipientInfo recipientInfo = (RecipientInfo)objectArray[n2];
                if (recipientInfo.getSecurityProvider() == null) {
                    recipientInfo.setSecurityProvider(this.ta);
                }
                ++n2;
            }
        }
        if (this.sW != null && this.sW.getSecurityProvider() == null) {
            this.sW.setSecurityProvider(securityProvider);
        }
    }

    public void setUnauthenticatedAttributes(Attribute[] attributeArray) {
        this.sO = attributeArray == null ? null : new b(attributeArray);
    }

    public void setupCipher(Key key) {
        GCMParameterSpec gCMParameterSpec;
        block19: {
            gCMParameterSpec = null;
            ASN1Object aSN1Object = this.sX.getParameter();
            if (aSN1Object != null) {
                boolean bl;
                boolean bl2 = bl = this.sX.equals((Object)AlgorithmID.aes128_CCM) || this.sX.equals((Object)AlgorithmID.aes192_CCM) || this.sX.equals((Object)AlgorithmID.aes256_CCM);
                if (bl || this.sX.equals((Object)AlgorithmID.aes128_GCM) || this.sX.equals((Object)AlgorithmID.aes192_GCM) || this.sX.equals((Object)AlgorithmID.aes256_GCM)) {
                    String string = this.sX.getName();
                    try {
                        if (!aSN1Object.isA(ASN.SEQUENCE)) {
                            throw new CMSException("Invalid " + string + " parameter encoding! Expected SEQUENCE!");
                        }
                        if (aSN1Object.countComponents() != 2) {
                            throw new CMSException("Invalid number of " + string + " parameter compontents! Expected 2!");
                        }
                        ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
                        if (!aSN1Object2.isA(ASN.OCTET_STRING)) {
                            throw new CMSException("Invalid nonce component of " + string + " parameter! Expected OCTET STRING!");
                        }
                        byte[] byArray = (byte[])aSN1Object2.getValue();
                        aSN1Object2 = aSN1Object.getComponentAt(1);
                        if (!aSN1Object2.isA(ASN.INTEGER)) {
                            throw new CMSException("Invalid ICVlen component of " + string + " parameter! Expected INTEGER!");
                        }
                        int n2 = ((BigInteger)aSN1Object2.getValue()).intValue();
                        byte[] byArray2 = null;
                        if (this.sY != null && this.sY.size() > 0) {
                            SET sET = this.sY.toAsn1SET(true);
                            byArray2 = DerCoder.encode((ASN1Object)sET);
                            this.sW.a(byArray2);
                        }
                        if (bl) {
                            byte[] byArray3;
                            long l2 = this.tc;
                            if (l2 <= 0L && this.sW instanceof EncryptedContentInfo && (byArray3 = ((EncryptedContentInfo)this.sW).getContent()) != null) {
                                l2 = (long)byArray3.length & 0xFFFFFFFFL;
                            }
                            try {
                                gCMParameterSpec = this.sZ == null ? new CCMCMSParameterSpec(l2, byArray2, byArray, n2) : new CCMCMSParameterSpec(l2, byArray2, byArray, this.sZ);
                                break block19;
                            }
                            catch (Exception exception) {
                                throw new CMSException("Cannot create CCM parameters: " + exception.toString());
                            }
                        }
                        try {
                            gCMParameterSpec = this.sZ == null ? new GCMParameterSpec(byArray2, byArray, n2) : new GCMParameterSpec(byArray2, byArray, this.sZ);
                        }
                        catch (Exception exception) {
                            throw new CMSException("Cannot create GCM parameters: " + exception.toString());
                        }
                    }
                    catch (CodingException codingException) {
                        throw new CMSException("Cannot parse " + string + " parameters: " + codingException.toString());
                    }
                }
            }
        }
        if (gCMParameterSpec != null) {
            try {
                this.sW.setupCipher(key, (AlgorithmParameterSpec)gCMParameterSpec);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new CMSException("Error setting up cipher for decryption: " + invalidAlgorithmParameterException.toString());
            }
        } else {
            this.sW.setupCipher(key);
        }
    }

    public SecretKey setupCipher(Key key, int n2) {
        if (n2 < 0 || n2 > this.sV.size()) {
            throw new ArrayIndexOutOfBoundsException("RecipientInfo index out of bounds!");
        }
        RecipientInfo recipientInfo = (RecipientInfo)this.sV.elementAt(n2);
        SecretKey secretKey = recipientInfo.decryptKey(key, null, this.sW.getContentEncryptionAlgorithm().getRawImplementationName());
        this.setupCipher(secretKey);
        return secretKey;
    }

    public SecretKey setupCipher(Key key, KeyIdentifier keyIdentifier) {
        RecipientInfo recipientInfo = this.getRecipientInfo(keyIdentifier);
        if (recipientInfo == null) {
            throw new CMSException("No recipient for the given recipient identifier included!");
        }
        SecretKey secretKey = recipientInfo.decryptKey(key, keyIdentifier, this.sW.getContentEncryptionAlgorithm().getRawImplementationName());
        this.setupCipher(secretKey);
        return secretKey;
    }

    public SecretKey setupCipher(Key key, X509Certificate x509Certificate) {
        RecipientInfo recipientInfo = null;
        CertificateIdentifier certificateIdentifier = null;
        Enumeration enumeration = this.sV.elements();
        while (enumeration.hasMoreElements()) {
            recipientInfo = (RecipientInfo)enumeration.nextElement();
            certificateIdentifier = recipientInfo.isRecipientInfoFor(x509Certificate);
            if (certificateIdentifier != null) break;
        }
        if (certificateIdentifier == null) {
            throw new CMSException("No recipient for the given recipient identifier included!");
        }
        SecretKey secretKey = recipientInfo.decryptKey(key, certificateIdentifier, this.sW.getContentEncryptionAlgorithm().getRawImplementationName());
        this.setupCipher(secretKey);
        return secretKey;
    }

    public ASN1Object toASN1Object() {
        return this.toASN1Object(-1);
    }

    protected ASN1Object toASN1Object(int n2) {
        Object object;
        if (n2 <= 0) {
            n2 = this.g;
        }
        if (this.sV == null || this.sV.size() == 0) {
            throw new CMSException("No recipients specified.");
        }
        this.sW.setBlockSize(n2);
        if (this.sW.cipher_ == null) {
            try {
                Object object2;
                boolean bl;
                object = null;
                byte[] byArray = null;
                boolean bl2 = bl = this.sY != null && this.sY.size() > 0;
                if (bl || this.tc >= 0L) {
                    if (bl) {
                        object2 = this.sY.toAsn1SET(true);
                        byArray = DerCoder.encode((ASN1Object)object2);
                    }
                    object = AuthEnvelopedDataStream.a(this.sX, byArray, this.tc);
                }
                this.sW.a(byArray);
                object2 = this.sW.setupCipher(this.sX, this.f, (AlgorithmParameterSpec)object);
                Enumeration enumeration = this.sV.elements();
                while (enumeration.hasMoreElements()) {
                    ((RecipientInfo)enumeration.nextElement()).encryptKey((SecretKey)object2);
                }
            }
            catch (Exception exception) {
                throw new CMSException("Cannot setup cipher for encryption: " + exception.toString());
            }
        }
        object = new SEQUENCE(this.a(n2));
        try {
            object.addComponent((ASN1Object)new INTEGER(this.a));
            if (this.sU != null && !this.sU.isEmpty()) {
                object.addComponent((ASN1Object)new CON_SPEC(0, this.sU.toASN1Object(), true));
            }
            object.addComponent((ASN1Object)RecipientInfo.createRecipientInfos(this.sV));
            object.addComponent(this.sW.toASN1Object());
            if (this instanceof AuthEnvelopedData) {
                this.encodeCalled((ASN1Object)object, 1);
            } else {
                object.addEncodeListener((EncodeListener)this, 1, object.countComponents() - 1);
            }
        }
        catch (CMSException cMSException) {
            throw cMSException;
        }
        catch (Exception exception) {
            throw new CMSException(exception.toString());
        }
        return object;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.a + "\n");
        if (this.sU != null && !this.sU.isEmpty()) {
            stringBuffer.append("originatorInfo: " + this.sU + "\n");
        }
        if (bl) {
            int n2 = 0;
            while (n2 < this.sV.size()) {
                stringBuffer.append("RecipientInfo " + (n2 + 1) + ": {\n");
                Utils.printIndented(((RecipientInfo)this.sV.elementAt(n2)).toString(), true, stringBuffer);
                stringBuffer.append("\n}\n");
                ++n2;
            }
        } else {
            stringBuffer.append("RecipientInfos: " + this.sV.size() + "\n");
        }
        stringBuffer.append("EncryptedContentInfo: {\n");
        Utils.printIndented(this.sW.toString(), true, stringBuffer);
        stringBuffer.append("\n}");
        if (this.sY != null && this.sY.size() > 0) {
            stringBuffer.append("\nAuthenticated attributes: {\n");
            Utils.printIndented(this.sY.toString(), false, stringBuffer);
            stringBuffer.append("\n}");
        }
        stringBuffer.append("Mac: ");
        if (this.sZ != null) {
            stringBuffer.append(String.valueOf(this.sZ.length) + " bytes [" + Util.toString((byte[])this.sZ, (int)0, (int)5) + "...]\n");
        }
        if (this.sO != null && this.sO.size() > 0) {
            stringBuffer.append("\nUnauthenticated attributes: {\n");
            Utils.printIndented(this.sO.toString(), false, stringBuffer);
            stringBuffer.append("\n}");
        }
        return stringBuffer.toString();
    }

    boolean a(int n2) {
        return true;
    }

    public void writeTo(OutputStream outputStream) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    public void writeTo(OutputStream outputStream, int n2) {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(n2), (OutputStream)outputStream);
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }
}

