/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SET;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.cms.AuthEnvelopedDataStream;
import iaik.cms.CMSException;
import iaik.cms.DebugCMS;
import iaik.cms.OriginatorInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.SecurityProvider;
import iaik.cms.Utils;
import iaik.cms.b;
import iaik.cms.t;
import iaik.utils.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.SecretKey;

public class AuthEnvelopedDataOutputStream
extends OutputStream {
    private static boolean rM = false;
    private int f = 0;
    private OriginatorInfo sJ;
    private Vector sK = new Vector();
    private t sL;
    AlgorithmID sM;
    int b;
    long sN = -1L;
    private b sO;
    byte[] d;
    private b sP;
    private SecurityProvider sQ;
    private OutputStream sR;
    private boolean sS;
    private boolean sg = true;
    private boolean sT;

    static {
        rM = DebugCMS.getDebugMode() && rM;
    }

    private AuthEnvelopedDataOutputStream() {
    }

    public AuthEnvelopedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID) {
        this(objectID, outputStream, algorithmID, -1, null);
    }

    public AuthEnvelopedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID, int n2) {
        this(objectID, outputStream, algorithmID, n2, null);
    }

    public AuthEnvelopedDataOutputStream(ObjectID objectID, OutputStream outputStream, AlgorithmID algorithmID, int n2, SecurityProvider securityProvider) {
        this();
        this.sR = outputStream;
        this.sQ = securityProvider;
        this.sL = new t(objectID, outputStream);
        this.sL.b(false);
        this.sL.a(securityProvider);
        this.sL.a(true);
        this.sM = algorithmID;
        this.b = n2;
    }

    public AuthEnvelopedDataOutputStream(OutputStream outputStream, AlgorithmID algorithmID) {
        this(ObjectID.cms_data, outputStream, algorithmID, -1, null);
    }

    public AuthEnvelopedDataOutputStream(OutputStream outputStream, AlgorithmID algorithmID, int n2) {
        this(ObjectID.cms_data, outputStream, algorithmID, n2, null);
    }

    public void addRecipientInfo(RecipientInfo recipientInfo) {
        if (recipientInfo.getSecurityProvider() == null) {
            recipientInfo.setSecurityProvider(this.sQ);
        }
        this.sK.addElement(recipientInfo);
    }

    private void a() {
        if (this.sT) {
            throw new IOException("Stream already closed!");
        }
    }

    public void close() {
        SET sET;
        this.a();
        this.sT = true;
        this.b();
        this.sL.close();
        if (this.sO != null && this.sO.size() > 0) {
            try {
                sET = this.sO.toAsn1SET(true);
                this.sR.write(DerCoder.encode((ASN1Object)new CON_SPEC(1, (ASN1Object)sET, true)));
            }
            catch (CodingException codingException) {
                throw new IOException("Error encoding authenticated attributes: " + codingException.toString());
            }
        }
        if (this.d == null) {
            this.d = this.sL.a();
        }
        sET = this.d == null ? new OCTET_STRING(new byte[0]) : new OCTET_STRING(this.d);
        this.sR.write(DerCoder.encode((ASN1Object)sET));
        if (this.sP != null && this.sP.size() > 0) {
            try {
                SET sET2 = this.sP.toAsn1SET(true);
                this.sR.write(DerCoder.encode((ASN1Object)new CON_SPEC(2, (ASN1Object)sET2, true)));
            }
            catch (CodingException codingException) {
                throw new IOException("Error encoding unauthenticated attributes: " + codingException.toString());
            }
        }
        this.sR.write(new byte[2]);
        if (this.sg) {
            this.sR.close();
        }
    }

    private void b() {
        if (!this.sS) {
            try {
                this.sR.write(new byte[]{48, -128});
                this.sR.write(DerCoder.encode((ASN1Object)new INTEGER(this.f)));
                if (this.sJ != null && !this.sJ.isEmpty()) {
                    this.sR.write(DerCoder.encode((ASN1Object)new CON_SPEC(0, this.sJ.toASN1Object(), true)));
                }
                try {
                    boolean bl;
                    AlgorithmParameterSpec algorithmParameterSpec = null;
                    byte[] byArray = null;
                    SET sET = null;
                    boolean bl2 = bl = this.sO != null && this.sO.size() > 0;
                    if (bl || this.sN >= 0L) {
                        if (bl) {
                            sET = this.sO.toAsn1SET(true);
                            byArray = DerCoder.encode((ASN1Object)sET);
                            this.sL.a(byArray);
                        }
                        algorithmParameterSpec = AuthEnvelopedDataStream.a(this.sM, byArray, this.sN);
                    }
                    SecretKey secretKey = this.sL.a(this.sM, this.b, algorithmParameterSpec);
                    Enumeration enumeration = this.sK.elements();
                    while (enumeration.hasMoreElements()) {
                        RecipientInfo recipientInfo = (RecipientInfo)enumeration.nextElement();
                        if (recipientInfo.getEncryptedKey(null) != null) continue;
                        recipientInfo.encryptKey(secretKey);
                    }
                }
                catch (CMSException cMSException) {
                    throw cMSException;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new CMSException("Cannot setup cipher for encryption: " + noSuchAlgorithmException.toString());
                }
                catch (Exception exception) {
                    throw new CMSException(exception.toString());
                }
                this.sR.write(DerCoder.encode((ASN1Object)RecipientInfo.createRecipientInfos(this.sK)));
                this.sS = true;
            }
            catch (CMSException cMSException) {
                throw new IOException(cMSException.toString());
            }
        }
    }

    public void flush() {
        this.a();
        this.b();
        this.sL.flush();
    }

    public SecurityProvider getSecurityProvider() {
        return this.sQ;
    }

    public int getVersion() {
        return this.f;
    }

    public boolean isPassThroughClose() {
        return this.sg;
    }

    public void setAuthenticatedAttributes(Attribute[] attributeArray) {
        this.sO = attributeArray == null ? null : new b(attributeArray);
    }

    public void setInputLength(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Data input Length must not be negative");
        }
        this.sN = l2;
    }

    public void setOriginatorInfo(OriginatorInfo originatorInfo) {
        this.sJ = originatorInfo;
    }

    public void setPassThroughClose(boolean bl) {
        this.sg = bl;
    }

    public void setRecipientInfos(RecipientInfo[] recipientInfoArray) {
        this.sK.removeAllElements();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            this.addRecipientInfo(recipientInfoArray[n2]);
            ++n2;
        }
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.sQ = securityProvider;
        if (this.sK != null) {
            Object[] objectArray = Util.toArray((Vector)this.sK);
            int n2 = 0;
            while (n2 < objectArray.length) {
                RecipientInfo recipientInfo = (RecipientInfo)objectArray[n2];
                if (recipientInfo.getSecurityProvider() == null) {
                    recipientInfo.setSecurityProvider(this.sQ);
                }
                ++n2;
            }
        }
        if (this.sL != null && this.sL.b() == null) {
            this.sL.a(securityProvider);
        }
    }

    public void setUnauthenticatedAttributes(Attribute[] attributeArray) {
        this.sP = attributeArray == null ? null : new b(attributeArray);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.f + "\n");
        if (this.sJ != null && !this.sJ.isEmpty()) {
            stringBuffer.append("originatorInfo: " + this.sJ + "\n");
        }
        if (bl) {
            int n2 = 0;
            while (n2 < this.sK.size()) {
                stringBuffer.append("RecipientInfo " + (n2 + 1) + ": {\n");
                Utils.printIndented(((RecipientInfo)this.sK.elementAt(n2)).toString(), true, stringBuffer);
                stringBuffer.append("\n}\n");
                ++n2;
            }
        } else {
            stringBuffer.append("RecipientInfos: " + this.sK.size() + "\n");
        }
        stringBuffer.append("EncryptedContentInfo: {\n");
        Utils.printIndented(this.sL.toString(), true, stringBuffer);
        stringBuffer.append("\n}");
        stringBuffer.append("\n}");
        if (this.sO != null && this.sO.size() > 0) {
            stringBuffer.append("\nAuthenticated attributes: {\n");
            Utils.printIndented(this.sO.toString(), false, stringBuffer);
            stringBuffer.append("\n}");
        }
        stringBuffer.append("Mac: ");
        if (this.d != null) {
            stringBuffer.append(String.valueOf(this.d.length) + " bytes [" + Util.toString((byte[])this.d, (int)0, (int)5) + "...]\n");
        }
        if (this.sP != null && this.sP.size() > 0) {
            stringBuffer.append("\nUnauthenticated attributes: {\n");
            Utils.printIndented(this.sP.toString(), false, stringBuffer);
            stringBuffer.append("\n}");
        }
        return stringBuffer.toString();
    }

    public void write(int n2) {
        this.a();
        this.write(new byte[]{(byte)(n2 & 0xFF)}, 0, 1);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.a();
        this.b();
        this.sL.write(byArray, n2, n3);
    }
}

