/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.AuthEnvelopedDataStream;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.Content;
import iaik.cms.EncryptedContentInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.SecurityProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AuthEnvelopedData
extends AuthEnvelopedDataStream
implements Content {
    protected AuthEnvelopedData() {
        this.g = -1;
    }

    public AuthEnvelopedData(ASN1Object aSN1Object) {
        this(aSN1Object, null);
    }

    public AuthEnvelopedData(ASN1Object aSN1Object, SecurityProvider securityProvider) {
        this();
        this.ta = securityProvider;
        this.decode(aSN1Object);
    }

    public AuthEnvelopedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID) {
        this(objectID, byArray, algorithmID, -1);
    }

    public AuthEnvelopedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID, int n2) {
        this(objectID, byArray, algorithmID, n2, null);
    }

    public AuthEnvelopedData(ObjectID objectID, byte[] byArray, AlgorithmID algorithmID, int n2, SecurityProvider securityProvider) {
        this();
        this.ta = securityProvider;
        this.f = n2;
        this.sX = algorithmID;
        this.sW = new EncryptedContentInfo(objectID, byArray);
        this.sW.setSecurityProvider(this.ta);
        this.sW.a(true);
        this.tc = byArray.length;
    }

    public AuthEnvelopedData(InputStream inputStream) {
        this(inputStream, (SecurityProvider)null);
    }

    public AuthEnvelopedData(InputStream inputStream, SecurityProvider securityProvider) {
        this();
        this.ta = securityProvider;
        this.decode(inputStream);
    }

    public AuthEnvelopedData(byte[] byArray, AlgorithmID algorithmID) {
        this(ObjectID.cms_data, byArray, algorithmID, -1);
    }

    public AuthEnvelopedData(byte[] byArray, AlgorithmID algorithmID, int n2) {
        this(ObjectID.cms_data, byArray, algorithmID, n2);
    }

    public AuthEnvelopedData(RecipientInfo[] recipientInfoArray, EncryptedContentInfo encryptedContentInfo) {
        this();
        this.setRecipientInfos(recipientInfoArray);
        this.sW = encryptedContentInfo;
        this.sW.a(true);
        this.sX = encryptedContentInfo.getContentEncryptionAlgorithm();
    }

    public void decode(ASN1Object aSN1Object) {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode((ASN1Object)aSN1Object)));
        }
        catch (IOException iOException) {
            throw new CMSParsingException(iOException.getMessage());
        }
    }

    public byte[] getContent() {
        return ((EncryptedContentInfo)this.sW).getContent();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    void a(DerInputStream derInputStream) {
        this.sW = new EncryptedContentInfo();
        this.sW.setSecurityProvider(this.ta);
        this.sW.a(true);
        this.sW.decode((InputStream)derInputStream);
        this.notifyEOF();
        this.sX = this.sW.getContentEncryptionAlgorithm();
    }

    public void setInputStream(InputStream inputStream) {
        if (this.sW == null) {
            throw new NullPointerException("Cannot set content input stream. Internal EncryptedContentInfo not initialized!");
        }
        this.sW.setInputStream(inputStream);
    }

    boolean a(int n2) {
        return n2 > 0;
    }
}

