/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public final class ServerAcl {
    protected static final byte[] ALL_SET_4BYTES = new byte[]{-1, -1, -1, -1};
    protected static final byte[] ALL_SET_16BYTES = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private PrintWriter aXq = null;
    private List aXr;
    private static a aXs;
    private static a aXt;
    private File aXu;
    private long aXv = 0L;

    public static String dottedNotation(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(byArray[i2] & 0xFF);
        }
        return stringBuffer.toString();
    }

    public static String colonNotation(byte[] byArray) {
        if (byArray.length / 2 * 2 != byArray.length) {
            throw new RuntimeException("At this time .colonNotation only handles even byte quantities");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; i2 += 2) {
            if (i2 > 0) {
                stringBuffer.append(':');
            }
            stringBuffer.append(Integer.toHexString((byArray[i2] & 0xFF) * 256 + (byArray[i2 + 1] & 0xFF)));
        }
        return stringBuffer.toString();
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.aXq = printWriter;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.aXr.size(); ++i2) {
            if (i2 > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append("Entry " + (i2 + 1) + ": " + this.aXr.get(i2));
        }
        return stringBuffer.toString();
    }

    public boolean permitAccess(String string) {
        try {
            return this.permitAccess(InetAddress.getByName(string).getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            this.println("'" + string + "' denied because failed to resolve to an addr");
            return false;
        }
    }

    public boolean permitAccess(byte[] byArray) {
        this.ensureAclsUptodate();
        for (int i2 = 0; i2 < this.aXr.size(); ++i2) {
            if (!((a)this.aXr.get(i2)).matches(byArray)) continue;
            a a2 = (a)this.aXr.get(i2);
            this.println("Addr '" + ServerAcl.dottedNotation(byArray) + "' matched rule #" + (i2 + 1) + ":  " + a2);
            return a2.allow;
        }
        throw new RuntimeException("No rule matches address '" + ServerAcl.dottedNotation(byArray) + "'");
    }

    private void println(String string) {
        if (this.aXq == null) {
            return;
        }
        this.aXq.println(string);
        this.aXq.flush();
    }

    public ServerAcl(File file) {
        this.aXu = file;
        this.aXr = this.load();
    }

    protected synchronized void ensureAclsUptodate() {
        if (this.aXv > this.aXu.lastModified()) {
            return;
        }
        try {
            this.aXr = this.load();
            this.println("ACLs reloaded from file");
            return;
        }
        catch (Exception exception) {
            this.println("Failed to reload ACL file.  Retaining old ACLs.  " + exception);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    protected List load() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length > 1) {
            throw new RuntimeException("Try: java -cp path/to/hsqldb.jar " + ServerAcl.class.getName() + " --help");
        }
        if (stringArray.length > 0 && stringArray[0].equals("--help")) {
            System.err.println("SYNTAX: java -cp path/to/hsqldb.jar " + ServerAcl.class.getName() + " [filepath.txt]");
            System.err.println("ACL file path defaults to 'acl.txt' in the current directory.");
            System.exit(0);
        }
        ServerAcl serverAcl = new ServerAcl(new File(stringArray.length == 0 ? "acl.txt" : stringArray[0]));
        serverAcl.setPrintWriter(new PrintWriter(System.out));
        System.out.println(serverAcl.toString());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter hostnames or IP addresses to be tested (one per line).");
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() < 1) continue;
            System.out.println(Boolean.toString(serverAcl.permitAccess(string)));
        }
    }

    static {
        try {
            aXs = new a(InetAddress.getByName("0.0.0.0").getAddress(), 0, false);
            aXt = new a(InetAddress.getByName("::").getAddress(), 0, false);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("Unexpected problem in static initializer", unknownHostException);
        }
        catch (b b2) {
            throw new RuntimeException("Unexpected problem in static initializer", b2);
        }
    }

    private static final class c
    extends Exception {
        private c() {
        }
    }

    private static final class a {
        private byte[] value;
        private byte[] mask;
        private int aXw;
        public boolean allow;

        public a(byte[] byArray, int n2, boolean bl2) {
            byte[] byArray2 = null;
            switch (byArray.length) {
                case 4: {
                    byArray2 = ALL_SET_4BYTES;
                    break;
                }
                case 16: {
                    byArray2 = ALL_SET_16BYTES;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Only 4 and 16 bytes supported, not " + byArray.length);
                }
            }
            if (n2 > byArray.length * 8) {
                throw new IllegalArgumentException("Specified " + n2 + " significant bits, but value only has " + byArray.length * 8 + " bits");
            }
            this.aXw = n2;
            this.value = byArray;
            this.mask = org.hsqldb.c.b.leftShift(byArray2, byArray.length * 8 - n2);
            if (this.mask.length != byArray.length) {
                throw new RuntimeException("Basic program assertion failed.  Generated mask length " + this.mask.length + " (bytes) does not match given value length " + byArray.length + " (bytes).");
            }
            this.allow = bl2;
            this.validateMask();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("Addrs ");
            stringBuffer.append(this.value.length == 16 ? "[" + ServerAcl.colonNotation(this.value) + ']' : ServerAcl.dottedNotation(this.value));
            stringBuffer.append("/" + this.aXw + ' ' + (this.allow ? "ALLOW" : "DENY"));
            return stringBuffer.toString();
        }

        public boolean matches(byte[] byArray) {
            if (this.value.length != byArray.length) {
                return false;
            }
            return !org.hsqldb.c.b.hasAnyBitSet(org.hsqldb.c.b.xor(this.value, org.hsqldb.c.b.and(byArray, this.mask)));
        }

        public void validateMask() {
            if (org.hsqldb.c.b.hasAnyBitSet(org.hsqldb.c.b.and(this.value, org.hsqldb.c.b.not(this.mask)))) {
                throw new b("The base address '" + ServerAcl.dottedNotation(this.value) + "' is too specific for block-size-spec /" + this.aXw);
            }
        }
    }

    public static final class b
    extends Exception {
        public b(String string) {
            super(string);
        }
    }
}

