/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.hsqldb.aa;
import org.hsqldb.h;
import org.hsqldb.i;
import org.hsqldb.lib.af;
import org.hsqldb.lib.ai;
import org.hsqldb.lib.at;
import org.hsqldb.lib.bf;
import org.hsqldb.lib.bj;
import org.hsqldb.lib.d;
import org.hsqldb.lib.p;
import org.hsqldb.lib.t;
import org.hsqldb.server.ServerAcl;
import org.hsqldb.server.WebServer;
import org.hsqldb.server.g;
import org.hsqldb.server.k;
import org.hsqldb.z;

public class Server
implements at {
    protected static final int serverBundleHandle = org.hsqldb.f.a.getBundleHandle("org_hsqldb_server_Server_messages", null);
    org.hsqldb.server.i aXe;
    t aXf;
    protected String[] dbAlias;
    protected String[] dbType;
    protected String[] dbPath;
    protected org.hsqldb.e.p[] dbProps;
    protected int[] dbID;
    protected long[] dbActionSequence;
    t aXg = new t();
    protected int maxConnections;
    volatile long aXh;
    protected String serverId;
    protected int serverProtocol;
    protected ThreadGroup serverConnectionThreadGroup;
    protected org.hsqldb.server.a socketFactory;
    protected volatile ServerSocket socket;
    private Thread aXi;
    private Throwable aXj;
    private volatile int aXk;
    private volatile boolean aXl;
    protected volatile boolean isRemoteOpen;
    protected boolean isDaemon;
    private PrintWriter logWriter;
    private PrintWriter aXm;
    private ServerAcl aXn = null;
    private volatile boolean aXo;

    public Thread getServerThread() {
        return this.aXi;
    }

    public Server() {
        this(1);
    }

    protected Server(int n2) {
        this.init(n2);
    }

    public void checkRunning(boolean bl2) {
        boolean bl3;
        this.printWithThread("checkRunning(" + bl2 + ") entered");
        int n2 = this.getState();
        boolean bl4 = bl3 = bl2 && n2 != 1 || !bl2 && n2 != 16;
        if (bl3) {
            String string = "server is " + (bl2 ? "not " : "") + "running";
            throw org.hsqldb.a.a.error(458, string);
        }
        this.printWithThread("checkRunning(" + bl2 + ") exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void signalCloseAllServerConnections() {
        Object[] objectArray;
        this.printWithThread("signalCloseAllServerConnections() entered");
        t t2 = this.aXf;
        synchronized (t2) {
            objectArray = new org.hsqldb.server.h[this.aXf.size()];
            this.aXf.toArray(objectArray);
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            this.printWithThread("Closing " + object);
            ((org.hsqldb.server.h)object).nO();
        }
        this.printWithThread("signalCloseAllServerConnections() exited");
    }

    protected void finalize() {
        if (this.aXi != null) {
            this.nN();
        }
    }

    public String getAddress() {
        return this.socket == null ? this.aXe.getProperty("server.address") : this.socket.getInetAddress().getHostAddress();
    }

    public String getDatabaseName(int n2, boolean bl2) {
        if (bl2) {
            return this.aXe.getProperty("server.dbname." + n2);
        }
        if (this.getState() == 1) {
            return this.dbAlias == null || n2 < 0 || n2 >= this.dbAlias.length ? null : this.dbAlias[n2];
        }
        return null;
    }

    public String getDatabasePath(int n2, boolean bl2) {
        if (bl2) {
            return this.aXe.getProperty("server.database." + n2);
        }
        if (this.getState() == 1) {
            return this.dbPath == null || n2 < 0 || n2 >= this.dbPath.length ? null : this.dbPath[n2];
        }
        return null;
    }

    public String getDatabaseType(int n2) {
        return this.dbType == null || n2 < 0 || n2 >= this.dbType.length ? null : this.dbType[n2];
    }

    public String getDefaultWebPage() {
        return "[IGNORED]";
    }

    public String getHelpString() {
        return org.hsqldb.f.a.getString(serverBundleHandle, "server.help");
    }

    public PrintWriter getErrWriter() {
        return this.aXm;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public int getPort() {
        return this.aXe.getIntegerProperty("server.port", g.getDefaultPort(this.serverProtocol, this.isTls()));
    }

    public String getProductName() {
        return "HSQLDB server";
    }

    public String getProductVersion() {
        return "2.3.3";
    }

    public String getProtocol() {
        return this.isTls() ? "HSQLS" : "HSQL";
    }

    public Throwable getServerError() {
        return this.aXj;
    }

    public String getServerId() {
        return this.serverId;
    }

    public int getState() {
        return this.aXk;
    }

    public String getStateDescriptor() {
        String string;
        Throwable throwable = this.getServerError();
        switch (this.aXk) {
            case 16: {
                string = "SHUTDOWN";
                break;
            }
            case 4: {
                string = "OPENING";
                break;
            }
            case 8: {
                string = "CLOSING";
                break;
            }
            case 1: {
                string = "ONLINE";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    public String getWebRoot() {
        return "[IGNORED]";
    }

    public void handleConnection(Socket socket) {
        String string;
        Runnable runnable;
        this.printWithThread("handleConnection(" + socket + ") entered");
        if (!this.allowConnection(socket)) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.printWithThread("allowConnection(): connection refused");
            this.printWithThread("handleConnection() exited");
            return;
        }
        if (this.socketFactory != null) {
            this.socketFactory.configureSocket(socket);
        }
        if (this.serverProtocol == 1) {
            runnable = new org.hsqldb.server.h(socket, this);
            string = runnable.nP();
        } else {
            runnable = new k(socket, (WebServer)this);
            string = ((k)runnable).nP();
        }
        Thread thread = new Thread(this.serverConnectionThreadGroup, runnable, string);
        thread.start();
        this.printWithThread("handleConnection() exited");
    }

    public boolean isNoSystemExit() {
        return this.aXe.isPropertyTrue("server.no_system_exit");
    }

    public boolean isRestartOnShutdown() {
        return this.aXe.isPropertyTrue("server.restart_on_shutdown");
    }

    public boolean isSilent() {
        return this.aXl;
    }

    public boolean isTls() {
        return this.aXe.isPropertyTrue("server.tls");
    }

    public boolean isTrace() {
        return this.aXe.isPropertyTrue("server.trace");
    }

    public boolean putPropertiesFromFile(String string) {
        return this.putPropertiesFromFile(string, ".properties");
    }

    public boolean putPropertiesFromFile(String string, String string2) {
        if (this.getState() != 16) {
            throw org.hsqldb.a.a.error(458, "server properties");
        }
        string = p.getFileUtil().canonicalOrAbsolutePath(string);
        org.hsqldb.server.i i2 = g.getPropertiesFromFile(1, string, string2);
        if (i2 == null || i2.isEmpty()) {
            return false;
        }
        this.printWithThread("putPropertiesFromFile(): [" + string + ".properties]");
        try {
            this.setProperties(i2);
        }
        catch (Exception exception) {
            throw org.hsqldb.a.a.error(exception, 458, 26, new String[]{"Failed to set properties"});
        }
        return true;
    }

    public void putPropertiesFromString(String string) {
        if (this.getState() != 16) {
            throw org.hsqldb.a.a.error(458);
        }
        if (bj.isEmpty(string)) {
            return;
        }
        this.printWithThread("putPropertiesFromString(): [" + string + "]");
        org.hsqldb.e.p p2 = org.hsqldb.e.p.delimitedArgPairsToProps(string, "=", ";", "server");
        try {
            this.setProperties(p2);
        }
        catch (Exception exception) {
            throw org.hsqldb.a.a.error(exception, 458, 26, new String[]{"Failed to set properties"});
        }
    }

    public void setAddress(String string) {
        this.checkRunning(false);
        if (bj.isEmpty(string)) {
            string = "0.0.0.0";
        }
        this.printWithThread("setAddress(" + string + ")");
        this.aXe.setProperty("server.address", string);
    }

    public void setDatabaseName(int n2, String string) {
        this.checkRunning(false);
        this.printWithThread("setDatabaseName(" + n2 + "," + string + ")");
        this.aXe.setProperty("server.dbname." + n2, string);
    }

    public void setDatabasePath(int n2, String string) {
        this.checkRunning(false);
        this.printWithThread("setDatabasePath(" + n2 + "," + string + ")");
        this.aXe.setProperty("server.database." + n2, string);
    }

    public void setDefaultWebPage(String string) {
        this.checkRunning(false);
        this.printWithThread("setDefaultWebPage(" + string + ")");
        if (this.serverProtocol != 0) {
            return;
        }
        this.aXe.setProperty("server.default_page", string);
    }

    public void setPort(int n2) {
        this.checkRunning(false);
        this.printWithThread("setPort(" + n2 + ")");
        this.aXe.setProperty("server.port", n2);
    }

    public void setErrWriter(PrintWriter printWriter) {
        this.aXm = printWriter;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public void setNoSystemExit(boolean bl2) {
        this.printWithThread("setNoSystemExit(" + bl2 + ")");
        this.aXe.setProperty("server.no_system_exit", bl2);
    }

    public void setRestartOnShutdown(boolean bl2) {
        this.printWithThread("setRestartOnShutdown(" + bl2 + ")");
        this.aXe.setProperty("server.restart_on_shutdown", bl2);
    }

    public void setSilent(boolean bl2) {
        this.printWithThread("setSilent(" + bl2 + ")");
        this.aXe.setProperty("server.silent", bl2);
        this.aXl = bl2;
    }

    public void setTls(boolean bl2) {
        this.checkRunning(false);
        this.printWithThread("setTls(" + bl2 + ")");
        this.aXe.setProperty("server.tls", bl2);
    }

    public void setTrace(boolean bl2) {
        this.printWithThread("setTrace(" + bl2 + ")");
        this.aXe.setProperty("server.trace", bl2);
        org.hsqldb.lib.a.a.setLogToSystem(bl2);
    }

    public void setDaemon(boolean bl2) {
        this.checkRunning(false);
        this.printWithThread("setDaemon(" + bl2 + ")");
        this.aXe.setProperty("server.daemon", bl2);
    }

    public void setWebRoot(String string) {
        this.checkRunning(false);
        string = new File(string).getAbsolutePath();
        this.printWithThread("setWebRoot(" + string + ")");
        if (this.serverProtocol != 0) {
            return;
        }
        this.aXe.setProperty("server.root", string);
    }

    public void setProperties(org.hsqldb.e.p p2) {
        Object object;
        this.checkRunning(false);
        if (p2 != null) {
            p2.validate();
            object = p2.getErrorKeys();
            if (((String[])object).length > 0) {
                throw org.hsqldb.a.a.error(407, object[0]);
            }
            this.aXe.addProperties(p2);
        }
        this.maxConnections = this.aXe.getIntegerProperty("server.maxconnections", 16);
        org.hsqldb.lib.a.a.setLogToSystem(this.isTrace());
        this.aXl = this.aXe.isPropertyTrue("server.silent");
        this.isRemoteOpen = this.aXe.isPropertyTrue("server.remote_open");
        this.isDaemon = this.aXe.isPropertyTrue("server.daemon");
        object = this.aXe.getProperty("server.acl");
        if (object != null) {
            this.aXn = new ServerAcl(new File((String)object));
            if (this.logWriter != null && !this.aXl) {
                this.aXn.setPrintWriter(this.logWriter);
            }
        }
    }

    public int start() {
        this.printWithThread("start() entered");
        int n2 = this.getState();
        if (this.aXi != null) {
            this.printWithThread("start(): serverThread != null; no action taken");
            return n2;
        }
        this.setState(4);
        this.aXi = new a("HSQLDB Server ");
        if (this.isDaemon) {
            this.aXi.setDaemon(true);
        }
        this.aXi.start();
        while (this.getState() == 4) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.printWithThread("start() exiting");
        return n2;
    }

    public int stop() {
        this.printWithThread("stop() entered");
        int n2 = this.getState();
        if (this.aXi == null) {
            this.printWithThread("stop() serverThread is null; no action taken");
            return n2;
        }
        this.nN();
        this.printWithThread("stop() exiting");
        return n2;
    }

    protected boolean allowConnection(Socket socket) {
        if (this.aXo) {
            return false;
        }
        return this.aXn == null ? true : this.aXn.permitAccess(socket.getInetAddress().getAddress());
    }

    protected void init(int n2) {
        this.aXk = 16;
        this.aXf = new t();
        this.serverId = this.toString();
        this.serverId = this.serverId.substring(this.serverId.lastIndexOf(46) + 1);
        this.serverProtocol = n2;
        this.aXe = g.newDefaultProperties(n2);
        this.logWriter = new PrintWriter(System.out);
        this.aXm = new PrintWriter(System.err);
        org.hsqldb.lib.a.a.setLogToSystem(this.isTrace());
    }

    protected synchronized void setState(int n2) {
        this.aXk = n2;
    }

    @Override
    public final void notify(int n2) {
        this.printWithThread("notifiy( database shutdown," + n2 + ") entered");
        this.cN(n2);
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.dbID.length; ++i2) {
            if (this.dbAlias[i2] == null) continue;
            bl2 = false;
        }
        if (!this.isRemoteOpen && bl2) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void cN(int n2) {
        Object[] objectArray;
        boolean bl2 = false;
        this.printWithThread("releaseDatabase(" + n2 + ") entered");
        for (int i2 = 0; i2 < this.dbID.length; ++i2) {
            if (this.dbID[i2] != n2 || this.dbAlias[i2] == null) continue;
            this.dbID[i2] = 0;
            this.dbActionSequence[i2] = 0L;
            this.dbAlias[i2] = null;
            this.dbPath[i2] = null;
            this.dbType[i2] = null;
            this.dbProps[i2] = null;
        }
        t t2 = this.aXf;
        synchronized (t2) {
            objectArray = new org.hsqldb.server.h[this.aXf.size()];
            this.aXf.toArray(objectArray);
        }
        for (int i3 = 0; i3 < objectArray.length; ++i3) {
            Object object = objectArray[i3];
            if (((org.hsqldb.server.h)object).aXy != n2) continue;
            ((org.hsqldb.server.h)object).nO();
        }
        this.printWithThread("releaseDatabase(" + n2 + ") exiting");
    }

    protected void print(String string) {
        PrintWriter printWriter = this.logWriter;
        if (printWriter != null) {
            printWriter.println("[" + this.serverId + "]: " + string);
            printWriter.flush();
        }
    }

    final void bS(String string) {
        if (serverBundleHandle < 0) {
            return;
        }
        String string2 = org.hsqldb.f.a.getString(serverBundleHandle, string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            this.print(stringTokenizer.nextToken());
        }
    }

    protected void printStackTrace(Throwable throwable) {
        if (this.aXm != null) {
            throwable.printStackTrace(this.aXm);
            this.aXm.flush();
        }
    }

    final void bT(String string) {
        this.print(z.getSystemTimeString() + " " + string);
    }

    protected void printWithThread(String string) {
        if (!this.isSilent()) {
            this.print("[" + Thread.currentThread() + "]: " + string);
        }
    }

    protected void printError(String string) {
        PrintWriter printWriter = this.aXm;
        if (printWriter != null) {
            printWriter.print("[" + this.serverId + "]: ");
            printWriter.print("[" + Thread.currentThread() + "]: ");
            printWriter.println(string);
            printWriter.flush();
        }
    }

    final void a(int n2, org.hsqldb.g.a a2) {
        if (this.isSilent()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2);
        stringBuffer.append(':');
        block0 : switch (a2.getType()) {
            case 37: {
                stringBuffer.append("SQLCLI:SQLPREPARE ");
                stringBuffer.append(a2.getMainString());
                break;
            }
            case 34: {
                stringBuffer.append(a2.getMainString());
                break;
            }
            case 21: 
            case 35: {
                stringBuffer.append("SQLCLI:SQLEXECUTE:");
                stringBuffer.append(a2.getStatementID());
                break;
            }
            case 9: {
                stringBuffer.append("SQLCLI:SQLEXECUTE:");
                stringBuffer.append("BATCHMODE:");
                stringBuffer.append(a2.getStatementID());
                break;
            }
            case 41: {
                stringBuffer.append("SQLCLI:RESULTUPDATE:");
                stringBuffer.append(a2.getStatementID());
                break;
            }
            case 36: {
                stringBuffer.append("SQLCLI:SQLFREESTMT:");
                stringBuffer.append(a2.getStatementID());
                break;
            }
            case 7: {
                stringBuffer.append("HSQLCLI:GETSESSIONATTR");
                break;
            }
            case 6: {
                stringBuffer.append("HSQLCLI:SETSESSIONATTR:");
                break;
            }
            case 33: {
                stringBuffer.append("SQLCLI:SQLENDTRAN:");
                switch (a2.getActionType()) {
                    case 0: {
                        stringBuffer.append("COMMIT");
                        break block0;
                    }
                    case 1: {
                        stringBuffer.append("ROLLBACK");
                        break block0;
                    }
                    case 4: {
                        stringBuffer.append("SAVEPOINT_NAME_RELEASE ");
                        stringBuffer.append(a2.getMainString());
                        break block0;
                    }
                    case 2: {
                        stringBuffer.append("SAVEPOINT_NAME_ROLLBACK ");
                        stringBuffer.append(a2.getMainString());
                        break block0;
                    }
                }
                stringBuffer.append(a2.getActionType());
                break;
            }
            case 39: {
                stringBuffer.append("SQLCLI:SQLSTARTTRAN");
                break;
            }
            case 32: {
                stringBuffer.append("SQLCLI:SQLDISCONNECT");
                break;
            }
            case 38: {
                stringBuffer.append("SQLCLI:SQLSETCONNECTATTR:");
                switch (a2.getConnectionAttrType()) {
                    case 10027: {
                        stringBuffer.append("SQL_ATTR_SAVEPOINT_NAME ");
                        stringBuffer.append(a2.getMainString());
                        break block0;
                    }
                }
                stringBuffer.append(a2.getConnectionAttrType());
                break;
            }
            case 40: {
                stringBuffer.append("HQLCLI:CLOSE_RESULT:RESULT_ID ");
                stringBuffer.append(a2.getResultId());
                break;
            }
            case 13: {
                stringBuffer.append("HQLCLI:REQUESTDATA:RESULT_ID ");
                stringBuffer.append(a2.getResultId());
                stringBuffer.append(" ROWOFFSET ");
                stringBuffer.append(a2.getUpdateCount());
                stringBuffer.append(" ROWCOUNT ");
                stringBuffer.append(a2.getFetchSize());
                break;
            }
            default: {
                stringBuffer.append("SQLCLI:MODE:");
                stringBuffer.append(a2.getType());
            }
        }
        this.print(stringBuffer.toString());
    }

    final synchronized int bU(String string) {
        int n2;
        int n3 = string.indexOf(59);
        String string2 = string;
        String string3 = null;
        if (n3 != -1) {
            string2 = string.substring(0, n3);
            string3 = string.substring(n3 + 1);
        }
        if ((n2 = d.find(this.dbAlias, string2)) == -1) {
            if (string3 == null) {
                aa aa2 = org.hsqldb.a.a.error(458, "database alias does not exist");
                this.printError("database alias=" + string2 + " does not exist");
                this.setServerError(aa2);
                throw aa2;
            }
            return this.w(string2, string3);
        }
        return n2;
    }

    final int w(String string, String string2) {
        if (!this.isRemoteOpen) {
            aa aa2 = org.hsqldb.a.a.error(458, "remote open not allowed");
            this.printError("Remote database open not allowed");
            this.setServerError(aa2);
            throw aa2;
        }
        int n2 = this.nH();
        if (n2 < -1 && (n2 = this.closeOldestDatabase()) < -1) {
            aa aa3 = org.hsqldb.a.a.error(458, "limit of open databases reached");
            this.printError("limit of open databases reached");
            this.setServerError(aa3);
            throw aa3;
        }
        org.hsqldb.e.p p2 = i.parseURL(string2, false, false);
        if (p2 == null) {
            aa aa4 = org.hsqldb.a.a.error(458, "invalid database path");
            this.printError("invalid database path");
            this.setServerError(aa4);
            throw aa4;
        }
        String string3 = p2.getProperty("database");
        String string4 = p2.getProperty("connection_type");
        try {
            int n3;
            this.dbID[n2] = n3 = h.getDatabase(string4, string3, this, p2);
            this.dbActionSequence[n2] = this.aXh;
            this.dbAlias[n2] = string;
            this.dbPath[n2] = string3;
            this.dbType[n2] = string4;
            this.dbProps[n2] = p2;
            return n2;
        }
        catch (aa aa5) {
            this.printError("Database [index=" + n2 + ", db=" + this.dbType[n2] + this.dbPath[n2] + ", alias=" + this.dbAlias[n2] + "] did not open: " + aa5.toString());
            this.setServerError(aa5);
            throw aa5;
        }
    }

    final int nH() {
        for (int i2 = 0; i2 < this.dbAlias.length; ++i2) {
            if (this.dbAlias[i2] != null) continue;
            return i2;
        }
        return -1;
    }

    final boolean nI() {
        this.printWithThread("openDatabases() entered");
        boolean bl2 = false;
        this.nJ();
        for (int i2 = 0; i2 < this.dbAlias.length; ++i2) {
            int n2;
            if (this.dbAlias[i2] == null) continue;
            this.printWithThread("Opening database: [" + this.dbType[i2] + this.dbPath[i2] + "]");
            bf bf2 = new bf();
            try {
                this.dbID[i2] = n2 = h.getDatabase(this.dbType[i2], this.dbPath[i2], this, this.dbProps[i2]);
                bl2 = true;
            }
            catch (aa aa2) {
                this.printError("Database [index=" + i2 + ", db=" + this.dbType[i2] + this.dbPath[i2] + ", alias=" + this.dbAlias[i2] + "] did not open: " + aa2.toString());
                this.setServerError(aa2);
                this.dbAlias[i2] = null;
                this.dbPath[i2] = null;
                this.dbType[i2] = null;
                this.dbProps[i2] = null;
                continue;
            }
            bf2.stop();
            String string = "Database [index=" + i2 + ", id=" + n2 + ", db=" + this.dbType[i2] + this.dbPath[i2] + ", alias=" + this.dbAlias[i2] + "] opened sucessfully";
            this.print(bf2.elapsedTimeToMessage(string));
        }
        this.printWithThread("openDatabases() exiting");
        if (this.isRemoteOpen) {
            bl2 = true;
        }
        if (!bl2 && this.getServerError() == null) {
            this.setServerError(org.hsqldb.a.a.error(407));
        }
        return bl2;
    }

    private void nJ() {
        int n2;
        af af2 = this.nK();
        int n3 = af2.size();
        if (this.aXe.isPropertyTrue("server.remote_open") && n3 < (n2 = this.aXe.getIntegerProperty("server.maxdatabases", 10))) {
            n3 = n2;
        }
        this.dbAlias = new String[n3];
        this.dbPath = new String[this.dbAlias.length];
        this.dbType = new String[this.dbAlias.length];
        this.dbID = new int[this.dbAlias.length];
        this.dbActionSequence = new long[this.dbAlias.length];
        this.dbProps = new org.hsqldb.e.p[this.dbAlias.length];
        ai ai2 = af2.keySet().iterator();
        int n4 = 0;
        while (ai2.hasNext()) {
            int n5 = ai2.nextInt();
            String string = this.getDatabasePath(n5, true);
            if (string == null) {
                this.printWithThread("missing database path: " + af2.get(n5));
                continue;
            }
            org.hsqldb.e.p p2 = i.parseURL(string, false, false);
            if (p2 == null) {
                this.printWithThread("malformed database path: " + string);
                continue;
            }
            this.dbAlias[n4] = (String)af2.get(n5);
            this.dbPath[n4] = p2.getProperty("database");
            this.dbType[n4] = p2.getProperty("connection_type");
            this.dbProps[n4] = p2;
            ++n4;
        }
    }

    private af nK() {
        int n2 = "server.dbname.".length();
        af af2 = new af();
        Enumeration enumeration = this.aXe.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            int n3;
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("server.dbname.")) continue;
            try {
                n3 = Integer.parseInt(string.substring(n2));
            }
            catch (NumberFormatException numberFormatException) {
                this.printWithThread("maformed database enumerator: " + string);
                continue;
            }
            String string2 = this.aXe.getProperty(string).toLowerCase();
            if (!this.aXg.add(string2)) {
                this.printWithThread("duplicate alias: " + string2);
            }
            if ((object = af2.put(n3, string2)) == null) continue;
            this.printWithThread("duplicate database enumerator: " + string);
        }
        return af2;
    }

    private void nL() {
        this.printWithThread("openServerSocket() entered");
        if (this.isTls()) {
            this.printWithThread("Requesting TLS/SSL-encrypted JDBC");
        }
        bf bf2 = new bf();
        this.socketFactory = org.hsqldb.server.a.getInstance(this.isTls());
        String string = this.getAddress();
        int n2 = this.getPort();
        if (bj.isEmpty(string) || "0.0.0.0".equalsIgnoreCase(string.trim())) {
            this.socket = this.socketFactory.createServerSocket(n2);
        } else {
            try {
                this.socket = this.socketFactory.createServerSocket(n2, string);
            }
            catch (UnknownHostException unknownHostException) {
                Object[] objectArray;
                int n3;
                String[] stringArray = g.listLocalInetAddressNames();
                if (stringArray.length > 0) {
                    n3 = 61;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(stringArray[i2]);
                    }
                    objectArray = new Object[]{string, stringBuffer.toString()};
                } else {
                    n3 = 62;
                    objectArray = new Object[]{string};
                }
                throw new UnknownHostException(org.hsqldb.a.a.getMessage(n3, 0, objectArray));
            }
        }
        this.socket.setSoTimeout(1000);
        this.printWithThread("Got server socket: " + this.socket);
        this.print(bf2.elapsedTimeToMessage("Server socket opened successfully"));
        if (this.socketFactory.isSecure()) {
            this.print("Using TLS/SSL-encrypted JDBC");
        }
        this.printWithThread("openServerSocket() exiting");
    }

    private void nM() {
        String string = this.getProductName() + " " + this.getProductVersion() + " is online on port " + this.getPort();
        this.bT(string);
        this.bS("online.help");
    }

    protected void printProperties() {
        if (this.isSilent()) {
            return;
        }
        Enumeration enumeration = this.aXe.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.aXe.getProperty(string);
            this.printWithThread(string + "=" + string2);
        }
    }

    private synchronized void nN() {
        this.printWithThread("releaseServerSocket() entered");
        if (this.socket != null) {
            this.printWithThread("Releasing server socket: [" + this.socket + "]");
            this.setState(8);
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                this.printError("Exception closing server socket");
                this.printError("releaseServerSocket(): " + iOException);
            }
            this.socket = null;
        }
        this.printWithThread("releaseServerSocket() exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        this.printWithThread("run() entered");
        this.print("Initiating startup sequence...");
        this.printProperties();
        bf bf2 = new bf();
        this.setServerError(null);
        try {
            this.nL();
        }
        catch (Exception exception) {
            this.setServerError(exception);
            this.printError("run()/openServerSocket(): ");
            this.printStackTrace(exception);
            this.shutdown(true);
            return;
        }
        String string = "HSQLDB Connections @" + Integer.toString(this.hashCode(), 16);
        ThreadGroup threadGroup = new ThreadGroup(string);
        threadGroup.setDaemon(false);
        this.serverConnectionThreadGroup = threadGroup;
        if (!this.nI()) {
            this.setServerError(null);
            this.printError("Shutting down because there are no open databases");
            this.shutdown(true);
            return;
        }
        this.setState(1);
        this.print(bf2.elapsedTimeToMessage("Startup sequence completed"));
        this.nM();
        this.aXo = false;
        try {
            while (this.socket != null) {
                try {
                    this.handleConnection(this.socket.accept());
                }
                catch (InterruptedIOException interruptedIOException) {}
            }
        }
        catch (IOException iOException) {
            if (this.getState() == 1) {
                this.setServerError(iOException);
                this.printError(this + ".run()/handleConnection(): ");
                this.printStackTrace(iOException);
            }
        }
        catch (Throwable throwable) {
            this.printWithThread(throwable.toString());
        }
        finally {
            this.shutdown(false);
        }
    }

    protected void setServerError(Throwable throwable) {
        this.aXj = throwable;
    }

    public void shutdownCatalogs(int n2) {
        h.shutdownDatabases(this, n2);
    }

    public void shutdownWithCatalogs(int n2) {
        this.aXo = true;
        h.shutdownDatabases(this, n2);
        this.shutdown(false);
        this.aXo = false;
    }

    public void shutdown() {
        this.shutdown(false);
    }

    protected synchronized void shutdown(boolean bl2) {
        int n2;
        if (this.aXk == 16) {
            return;
        }
        this.printWithThread("shutdown() entered");
        bf bf2 = new bf();
        this.print("Initiating shutdown sequence...");
        this.nN();
        h.deRegisterServer(this);
        if (this.dbPath != null) {
            for (n2 = 0; n2 < this.dbPath.length; ++n2) {
                this.cN(this.dbID[n2]);
            }
        }
        if (this.serverConnectionThreadGroup != null) {
            if (!this.serverConnectionThreadGroup.isDestroyed()) {
                n2 = this.serverConnectionThreadGroup.activeCount();
                for (int i2 = 0; this.serverConnectionThreadGroup.activeCount() > 0 && i2 < n2; ++i2) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    this.serverConnectionThreadGroup.destroy();
                    this.printWithThread(this.serverConnectionThreadGroup.getName() + " destroyed");
                }
                catch (Throwable throwable) {
                    this.printWithThread(this.serverConnectionThreadGroup.getName() + " not destroyed");
                    this.printWithThread(throwable.toString());
                }
            }
            this.serverConnectionThreadGroup = null;
        }
        this.aXi = null;
        this.setState(16);
        this.print(bf2.elapsedTimeToMessage("Shutdown sequence completed"));
        if (this.isNoSystemExit()) {
            this.bT("SHUTDOWN : System.exit() was not called");
            this.printWithThread("shutdown() exited");
        } else {
            this.bT("SHUTDOWN : System.exit() is called next");
            this.printWithThread("shutdown() exiting...");
            try {
                System.exit(0);
            }
            catch (Throwable throwable) {
                this.printWithThread(throwable.toString());
            }
        }
    }

    protected int closeOldestDatabase() {
        return -1;
    }

    protected static void printHelp(String string) {
        System.out.println(org.hsqldb.f.a.getString(serverBundleHandle, string));
    }

    public static void main(String[] stringArray) {
        org.hsqldb.e.p p2 = null;
        p2 = org.hsqldb.e.p.argArrayToProps(stringArray, "server");
        String[] stringArray2 = p2.getErrorKeys();
        if (stringArray2.length != 0) {
            System.out.println("no value for argument:" + stringArray2[0]);
            Server.printHelp("server.help");
            return;
        }
        String string = p2.getProperty("server.props");
        String string2 = "";
        if (string == null) {
            string = "server";
            string2 = ".properties";
        } else {
            p2.removeProperty("server.props");
        }
        string = p.getFileUtil().canonicalOrAbsolutePath(string);
        org.hsqldb.server.i i2 = g.getPropertiesFromFile(1, string, string2);
        org.hsqldb.server.i i3 = i2 == null ? new org.hsqldb.server.i(1) : i2;
        i3.addProperties(p2);
        g.translateDefaultDatabaseProperty(i3);
        g.translateDefaultNoSystemExitProperty(i3);
        g.translateAddressProperty(i3);
        Server server = new Server();
        try {
            server.setProperties(i3);
        }
        catch (Exception exception) {
            server.printError("Failed to set properties");
            server.printStackTrace(exception);
            return;
        }
        server.print("Startup sequence initiated from main() method");
        if (i2 != null) {
            server.print("Loaded properties from [" + string + string2 + "]");
        } else {
            server.print("Could not load properties from file");
            server.print("Using cli/default properties only");
        }
        server.start();
    }

    private class a
    extends Thread {
        a(String string) {
            super(string);
            this.setName(string + '@' + Integer.toString(Server.this.hashCode(), 16));
        }

        @Override
        public void run() {
            Server.this.run();
            Server.this.printWithThread("ServerThread.run() exited");
        }
    }
}

