/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import java.util.Comparator;
import org.hsqldb.lib.c;
import org.hsqldb.lib.d;
import org.hsqldb.lib.e;
import org.hsqldb.lib.z;

public class v
extends e
implements z {
    Object[] elementData;
    Object[] aNW;
    private boolean aNX;

    public v(Object[] objectArray, int n2) {
        this.elementData = objectArray;
        this.elementCount = n2;
    }

    public v() {
        this.elementData = new Object[8];
    }

    public v(int n2, boolean bl2) {
        if (n2 < 8) {
            n2 = 8;
        }
        this.elementData = new Object[n2];
        this.aNX = bl2;
    }

    public v(int n2) {
        if (n2 < 0) {
            throw new NegativeArraySizeException("Invalid initial capacity given");
        }
        if (n2 < 8) {
            n2 = 8;
        }
        this.elementData = new Object[n2];
    }

    @Override
    public void add(int n2, Object object) {
        if (n2 > this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + ">" + this.elementCount);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " < 0");
        }
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        for (int i2 = this.elementCount; i2 > n2; --i2) {
            this.elementData[i2] = this.elementData[i2 - 1];
        }
        this.elementData[n2] = object;
        ++this.elementCount;
    }

    @Override
    public boolean add(Object object) {
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementData[this.elementCount] = object;
        ++this.elementCount;
        return true;
    }

    @Override
    public Object get(int n2) {
        if (n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " >= " + this.elementCount);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " < 0");
        }
        return this.elementData[n2];
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                if (this.elementData[i2] != null) continue;
                return i2;
            }
            return -1;
        }
        for (int i3 = 0; i3 < this.elementCount; ++i3) {
            if (!object.equals(this.elementData[i3])) continue;
            return i3;
        }
        return -1;
    }

    @Override
    public Object remove(int n2) {
        if (n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " >= " + this.elementCount);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " < 0");
        }
        Object object = this.elementData[n2];
        for (int i2 = n2; i2 < this.elementCount - 1; ++i2) {
            this.elementData[i2] = this.elementData[i2 + 1];
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
        if (this.elementCount == 0) {
            this.clear();
        }
        return object;
    }

    @Override
    public Object set(int n2, Object object) {
        if (n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " >= " + this.elementCount);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " < 0");
        }
        Object object2 = this.elementData[n2];
        this.elementData[n2] = object;
        return object2;
    }

    @Override
    public final int size() {
        return this.elementCount;
    }

    private void increaseCapacity() {
        int n2 = this.elementData.length == 0 ? 1 : this.elementData.length;
        n2 = (int)((float)n2 * 2.0f);
        this.resize(n2);
    }

    private void resize(int n2) {
        if (n2 == this.elementData.length) {
            return;
        }
        Object[] objectArray = (Object[])Array.newInstance(this.elementData.getClass().getComponentType(), n2);
        int n3 = this.elementData.length > objectArray.length ? objectArray.length : this.elementData.length;
        System.arraycopy(this.elementData, 0, objectArray, 0, n3);
        if (this.aNX && this.aNW == null) {
            d.clearArray(76, this.elementData, 0, this.elementData.length);
            this.aNW = this.elementData;
        }
        this.elementData = objectArray;
    }

    public void trim() {
        this.resize(this.elementCount);
    }

    @Override
    public void clear() {
        if (this.aNX && this.aNW != null) {
            this.elementData = this.aNW;
            this.aNW = null;
            this.elementCount = 0;
            return;
        }
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = null;
        }
        this.elementCount = 0;
    }

    public void setSize(int n2) {
        if (n2 == 0) {
            this.clear();
            return;
        }
        if (n2 <= this.elementCount) {
            for (int i2 = n2; i2 < this.elementCount; ++i2) {
                this.elementData[i2] = null;
            }
            this.elementCount = n2;
            return;
        }
        while (n2 > this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementCount = n2;
    }

    public Object[] toArray() {
        Object[] objectArray = (Object[])Array.newInstance(this.elementData.getClass().getComponentType(), this.elementCount);
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public Object[] toArray(int n2, int n3) {
        Object[] objectArray = (Object[])Array.newInstance(this.elementData.getClass().getComponentType(), n3 - n2);
        System.arraycopy(this.elementData, n2, objectArray, 0, n3 - n2);
        return objectArray;
    }

    public Object toArray(Object object) {
        if (Array.getLength(object) < this.elementCount) {
            object = Array.newInstance(object.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, object, 0, this.elementCount);
        return object;
    }

    public void sort(Comparator comparator) {
        if (this.elementCount < 2) {
            return;
        }
        c.sort(this.elementData, 0, this.elementCount, comparator);
    }

    public Object[] getArray() {
        return this.elementData;
    }
}

