/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import org.hsqldb.lib.bj;
import org.hsqldb.lib.tar.b;
import org.hsqldb.lib.tar.d;
import org.hsqldb.lib.tar.e;
import org.hsqldb.lib.tar.h;
import org.hsqldb.lib.tar.i;

public class j {
    public static final int LIST_MODE = 0;
    public static final int EXTRACT_MODE = 1;
    public static final int OVERWRITE_MODE = 2;
    protected e archive;
    protected Pattern[] patterns = null;
    protected int mode;
    protected File extractBaseDir;

    public j(File file, int n2, String[] stringArray, Integer n3, File file2) {
        this.mode = n2;
        File file3 = file.getAbsoluteFile();
        this.extractBaseDir = file2 == null ? null : file2.getAbsoluteFile();
        int n4 = 0;
        if (file3.getName().endsWith(".tgz") || file3.getName().endsWith(".gz")) {
            n4 = 1;
        }
        if (stringArray != null) {
            this.patterns = new Pattern[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.patterns[i2] = Pattern.compile(stringArray[i2]);
            }
        }
        this.archive = n3 == null ? new e(file3, n4) : new e(file3, n4, n3);
    }

    public void read() {
        boolean bl2 = false;
        Long l2 = null;
        String string = null;
        try {
            while (this.archive.readNextHeaderBlock()) {
                a a2 = new a(this.archive.readBuffer);
                char c2 = a2.getEntryType();
                if (c2 == 'x') {
                    l2 = this.getPifData(a2).getSize();
                    string = a2.toString();
                    continue;
                }
                if (l2 != null) {
                    a2.setDataSize(l2);
                    l2 = null;
                }
                if (this.patterns != null) {
                    boolean bl3 = false;
                    for (int i2 = 0; i2 < this.patterns.length; ++i2) {
                        if (!this.patterns[i2].matcher(a2.getPath()).matches()) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3) {
                        string = null;
                        this.skipFileData(a2);
                        continue;
                    }
                }
                if (c2 != '\u0000' && c2 != '0' && c2 != 'x') {
                    bl2 = true;
                }
                switch (this.mode) {
                    case 0: {
                        if (string != null) {
                            System.out.println(string);
                        }
                        System.out.println(a2.toString());
                        this.skipFileData(a2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (string != null) {
                            System.out.println(string);
                        }
                        System.out.println(a2.toString());
                        if (c2 == '\u0000' || c2 == '0' || c2 == 'x') {
                            this.extractFile(a2);
                            break;
                        }
                        this.skipFileData(a2);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(d.unsupported_mode.getString(this.mode));
                    }
                }
                string = null;
            }
            if (bl2) {
                System.out.println(d.unsupported_entry_present.getString());
            }
        }
        catch (IOException iOException) {
            this.archive.close();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected b getPifData(a a2) {
        long l2 = a2.getDataSize();
        if (l2 < 1L) {
            throw new i(d.pif_unknown_datasize.getString());
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new i(d.pif_data_toobig.getString(Long.toString(l2), Integer.MAX_VALUE));
        }
        int n2 = (int)(l2 % 512L);
        PipedInputStream pipedInputStream = null;
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        try {
            int n3;
            pipedInputStream = new PipedInputStream(pipedOutputStream);
            for (int i2 = (int)(l2 / 512L); i2 > 0; i2 -= n3) {
                n3 = i2 > this.archive.getReadBufferBlocks() ? this.archive.getReadBufferBlocks() : i2;
                this.archive.readBlocks(n3);
                pipedOutputStream.write(this.archive.readBuffer, 0, n3 * 512);
            }
            if (n2 != 0) {
                this.archive.readBlock();
                pipedOutputStream.write(this.archive.readBuffer, 0, n2);
            }
            pipedOutputStream.flush();
        }
        catch (IOException iOException) {
            if (pipedInputStream != null) {
                pipedInputStream.close();
            }
            throw iOException;
        }
        finally {
            try {
                pipedOutputStream.close();
            }
            finally {
                pipedOutputStream = null;
            }
        }
        return new b(pipedInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractFile(a a2) {
        if (a2.getDataSize() < 1L) {
            throw new i(d.data_size_unknown.getString());
        }
        int n2 = (int)(a2.getDataSize() / 512L);
        int n3 = (int)(a2.getDataSize() % 512L);
        File file = a2.generateFile();
        if (!file.isAbsolute()) {
            file = this.extractBaseDir == null ? file.getAbsoluteFile() : new File(this.extractBaseDir, file.getPath());
        }
        File file2 = file.getParentFile();
        if (file.exists()) {
            if (this.mode != 2) {
                throw new IOException(d.extraction_exists.getString(file.getAbsolutePath()));
            }
            if (!file.isFile()) {
                throw new IOException(d.extraction_exists_notfile.getString(file.getAbsolutePath()));
            }
        }
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new IOException(d.extraction_parent_not_dir.getString(file2.getAbsolutePath()));
            }
            if (!file2.canWrite()) {
                throw new IOException(d.extraction_parent_not_writable.getString(file2.getAbsolutePath()));
            }
        } else if (!file2.mkdirs()) {
            throw new IOException(d.extraction_parent_mkfail.getString(file2.getAbsolutePath()));
        }
        int n4 = a2.getFileMode();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            file.setExecutable(false, false);
            file.setReadable(false, false);
            file.setWritable(false, false);
            file.setExecutable((n4 & 0x40) != 0, true);
            file.setReadable((n4 & 0x100) != 0, true);
            file.setWritable((n4 & 0x80) != 0, true);
            while (n2 > 0) {
                int n5 = n2 > this.archive.getReadBufferBlocks() ? this.archive.getReadBufferBlocks() : n2;
                this.archive.readBlocks(n5);
                n2 -= n5;
                fileOutputStream.write(this.archive.readBuffer, 0, n5 * 512);
            }
            if (n3 != 0) {
                this.archive.readBlock();
                fileOutputStream.write(this.archive.readBuffer, 0, n3);
            }
            fileOutputStream.flush();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            finally {
                fileOutputStream = null;
            }
        }
        file.setLastModified(a2.getModTime() * 1000L);
        if (file.length() != a2.getDataSize()) {
            throw new IOException(d.write_count_mismatch.getString(Long.toString(a2.getDataSize()), file.getAbsolutePath(), Long.toString(file.length())));
        }
    }

    protected void skipFileData(a a2) {
        int n2;
        if (a2.getDataSize() == 0L) {
            return;
        }
        if (a2.getDataSize() < 0L) {
            throw new i(d.data_size_unknown.getString());
        }
        int n3 = a2.getDataSize() % 512L == 0L ? 0 : 1;
        for (int i2 = (int)(a2.getDataSize() / 512L) + n3; i2 > 0; i2 -= n2) {
            n2 = i2 > this.archive.getReadBufferBlocks() ? this.archive.getReadBufferBlocks() : i2;
            this.archive.readBlocks(n2);
        }
    }

    protected static class org.hsqldb.lib.tar.j$a {
        protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        protected byte[] rawHeader;
        protected String path;
        protected int fileMode;
        protected long dataSize = -1L;
        protected long modTime;
        protected char entryType;
        protected String ownerName;
        protected boolean ustar;

        public org.hsqldb.lib.tar.j$a(byte[] byArray) {
            this.rawHeader = byArray;
            Long l2 = this.readInteger(h.checksum);
            try {
                if (l2 == null) {
                    throw new a(h.checksum);
                }
                long l3 = this.headerChecksum();
                if (l2 != l3) {
                    throw new i(d.checksum_mismatch.getString(l2.toString(), Long.toString(l3)));
                }
                this.path = this.readString(h.name);
                if (this.path == null) {
                    throw new a(h.name);
                }
                Long l4 = this.readInteger(h.mode);
                if (l4 == null) {
                    throw new a(h.mode);
                }
                this.fileMode = (int)l4.longValue();
                l4 = this.readInteger(h.size);
                if (l4 != null) {
                    this.dataSize = l4;
                }
                if ((l4 = this.readInteger(h.mtime)) == null) {
                    throw new a(h.mtime);
                }
                this.modTime = l4;
            }
            catch (a a2) {
                throw new i(a2.getMessage());
            }
            this.entryType = this.readChar(h.typeflag);
            this.ownerName = this.readString(h.uname);
            String string = this.readString(h.prefix);
            if (string != null) {
                this.path = string + '/' + this.path;
            }
            this.ustar = this.isUstar();
        }

        public File generateFile() {
            if (this.entryType != '\u0000' && this.entryType != '0') {
                throw new IllegalStateException(d.create_only_normal.getString());
            }
            return new File(this.path);
        }

        public char getEntryType() {
            return this.entryType;
        }

        public String getPath() {
            return this.path;
        }

        public void setDataSize(long l2) {
            this.dataSize = l2;
        }

        public long getDataSize() {
            return this.dataSize;
        }

        public long getModTime() {
            return this.modTime;
        }

        public int getFileMode() {
            return this.fileMode;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.sdf.format(this.modTime * 1000L) + ' ');
            stringBuffer.append(this.entryType == '\u0000' ? (char)' ' : (char)this.entryType);
            stringBuffer.append(this.ustar ? (char)'*' : ' ');
            stringBuffer.append(" " + bj.toPaddedString(Integer.toOctalString(this.fileMode), 4, ' ', false) + ' ' + bj.toPaddedString(Long.toString(this.dataSize), 11, ' ', false) + "  ");
            stringBuffer.append(bj.toPaddedString(this.ownerName == null ? "-" : this.ownerName, 8, ' ', true));
            stringBuffer.append("  " + this.path);
            return stringBuffer.toString();
        }

        public boolean isUstar() {
            String string = this.readString(h.magic);
            return string != null && string.startsWith("ustar");
        }

        public static int indexOf(byte[] byArray, byte by2, int n2, int n3) {
            for (int i2 = n2; i2 < n3; ++i2) {
                if (byArray[i2] != by2) continue;
                return i2 - n2;
            }
            return -1;
        }

        protected char readChar(h h2) {
            String string = this.readString(h2);
            return string == null ? (char)'\u0000' : string.charAt(0);
        }

        protected String readString(h h2) {
            int n2 = h2.getStart();
            int n3 = h2.getStop();
            int n4 = org.hsqldb.lib.tar.j$a.indexOf(this.rawHeader, (byte)0, n2, n3);
            switch (n4) {
                case 0: {
                    return null;
                }
                case -1: {
                    n4 = n3 - n2;
                    break;
                }
            }
            try {
                return new String(this.rawHeader, n2, n4);
            }
            catch (Throwable throwable) {
                throw new i(d.bad_header_value.getString(h2.toString()));
            }
        }

        protected Long readInteger(h h2) {
            String string = this.readString(h2);
            if (string == null) {
                return null;
            }
            try {
                return Long.valueOf(string, 8);
            }
            catch (NumberFormatException numberFormatException) {
                throw new i(d.bad_numeric_header_value.getString(h2.toString(), numberFormatException.toString()));
            }
        }

        protected long headerChecksum() {
            long l2 = 0L;
            for (int i2 = 0; i2 < 512; ++i2) {
                boolean bl2 = i2 >= h.checksum.getStart() && i2 < h.checksum.getStop();
                l2 += bl2 ? 32L : (long)(0xFF & this.rawHeader[i2]);
            }
            return l2;
        }

        protected static class a
        extends Exception {
            private h aPt;

            public a(h h2) {
                this.aPt = h2;
            }

            @Override
            public String getMessage() {
                return d.header_field_missing.getString(this.aPt.toString());
            }
        }
    }
}

