/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hsqldb.lib.ac;
import org.hsqldb.lib.ad;
import org.hsqldb.lib.bj;
import org.hsqldb.lib.tar.c;
import org.hsqldb.lib.tar.d;
import org.hsqldb.lib.tar.f;
import org.hsqldb.lib.tar.h;
import org.hsqldb.lib.tar.i;

public class g {
    protected f archive;
    protected List<a> entryQueue = new ArrayList<a>();
    protected long paxThreshold = 0x200000000L;

    public void setPaxThreshold(long l2) {
        this.paxThreshold = l2;
    }

    public long getPaxThreshold() {
        return this.paxThreshold;
    }

    public g(File file, boolean bl2, Integer n2) {
        File file2 = file.getAbsoluteFile();
        int n3 = 0;
        if (file2.getName().endsWith(".tgz") || file2.getName().endsWith(".tar.gz")) {
            n3 = 1;
        } else if (!file2.getName().endsWith(".tar")) {
            throw new IllegalArgumentException(d.unsupported_ext.getString(this.getClass().getName(), file2.getPath()));
        }
        if (file2.exists()) {
            if (!bl2) {
                throw new IOException(d.dest_exists.getString(file2.getPath()));
            }
        } else {
            File file3 = file2.getParentFile();
            if (file3.exists()) {
                if (!file3.isDirectory()) {
                    throw new IOException(d.parent_not_dir.getString(file3.getPath()));
                }
                if (!file3.canWrite()) {
                    throw new IOException(d.cant_write_parent.getString(file3.getPath()));
                }
            } else if (!file3.mkdirs()) {
                throw new IOException(d.parent_create_fail.getString(file3.getPath()));
            }
        }
        f f2 = this.archive = n2 == null ? new f(file2, n3) : new f(file2, n3, n2);
        if (n2 != null && f.debug) {
            System.out.println(d.bpr_write.getString(n2));
        }
    }

    public void queueEntry(File file) {
        this.queueEntry(null, file);
    }

    public void queueEntry(String string, File file) {
        this.entryQueue.add(new a(string, file, this.archive, this.paxThreshold));
    }

    public void queueEntry(String string, ac ac2) {
        this.entryQueue.add(new a(string, ac2, this.archive, this.paxThreshold));
    }

    public void queueEntry(String string, InputStream inputStream, int n2) {
        this.entryQueue.add(new a(string, inputStream, n2, '0', this.archive));
    }

    public void write() {
        if (f.debug) {
            System.out.println(d.write_queue_report.getString(this.entryQueue.size()));
        }
        try {
            for (int i2 = 0; i2 < this.entryQueue.size(); ++i2) {
                System.err.print(Integer.toString(i2 + 1) + " / " + this.entryQueue.size() + ' ');
                a a2 = this.entryQueue.get(i2);
                System.err.print(a2.getPath() + "... ");
                a2.write();
                this.archive.assertAtBlockBoundary();
                System.err.println();
            }
            this.archive.finish();
        }
        catch (IOException iOException) {
            System.err.println();
            try {
                for (a a3 : this.entryQueue) {
                    a3.close();
                }
                this.archive.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    protected static class a {
        static final byte[] aPo = (byte[])f.aPn.clone();
        static Character aPp = null;
        static final byte[] aPq = new byte[]{117, 115, 116, 97, 114};
        protected byte[] rawHeader = (byte[])aPo.clone();
        protected String fileMode = "600";
        protected ac inputStream;
        protected String path;
        protected long modTime;
        protected f tarStream;
        protected long dataSize;
        protected boolean paxSized = false;
        protected final long paxThreshold;
        public static final String DEFAULT_FILE_MODES = "600";

        protected static void writeField(h h2, String string, byte[] byArray) {
            byte[] byArray2;
            int n2 = h2.getStart();
            int n3 = h2.getStop();
            try {
                byArray2 = string.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
            if (byArray2.length > n3 - n2) {
                throw new i(d.tar_field_toobig.getString(h2.toString(), string));
            }
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                byArray[n2 + i2] = byArray2[i2];
            }
        }

        protected static void clearField(h h2, byte[] byArray) {
            int n2 = h2.getStart();
            int n3 = h2.getStop();
            for (int i2 = n2; i2 < n3; ++i2) {
                byArray[i2] = 0;
            }
        }

        protected static void writeField(h h2, long l2, byte[] byArray) {
            a.writeField(h2, a.prePaddedOctalString(l2, h2.getStop() - h2.getStart()), byArray);
        }

        public static String prePaddedOctalString(long l2, int n2) {
            return bj.toPaddedString(Long.toOctalString(l2), n2, '0', false);
        }

        public String getPath() {
            return this.path;
        }

        public long getDataSize() {
            return this.dataSize;
        }

        protected a(String string, char c2, f f2, long l2) {
            this.paxThreshold = l2;
            if (string == null) {
                throw new IllegalArgumentException(d.missing_supp_path.getString());
            }
            this.path = aPp == null ? string : string.replace(aPp.charValue(), '/');
            this.tarStream = f2;
            this.writeField(h.typeflag, c2);
            if (c2 == '\u0000' || c2 == ' ') {
                a.writeField(h.uname, System.getProperty("user.name"), aPo);
                a.writeField(h.gname, "root", aPo);
            }
        }

        public a makeXentry() {
            c c2 = new c(new File(this.path));
            c2.addRecord("size", this.dataSize);
            return new a(c2.getName(), new ByteArrayInputStream(c2.toByteArray()), c2.size(), 'x', this.tarStream);
        }

        public a(String string, File file, f f2, long l2) {
            this(string == null ? file.getPath() : string, '0', f2, l2);
            if (!file.isFile()) {
                throw new IllegalArgumentException(d.nonfile_entry.getString());
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException(d.read_denied.getString(file.getAbsolutePath()));
            }
            this.modTime = file.lastModified() / 1000L;
            this.fileMode = a.getLameMode(file);
            this.dataSize = file.length();
            this.inputStream = new ad(new FileInputStream(file));
        }

        public a(String string, ac ac2, f f2, long l2) {
            this(string, '0', f2, l2);
            this.modTime = System.currentTimeMillis() / 1000L;
            this.fileMode = DEFAULT_FILE_MODES;
            this.inputStream = ac2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public a(String string, InputStream inputStream, int n2, char c2, f f2) {
            this(string, c2, f2, 0x200000000L);
            if (n2 < 1) {
                throw new IllegalArgumentException(d.read_lt_1.getString());
            }
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            try {
                int n3;
                this.inputStream = new ad(new PipedInputStream(pipedOutputStream));
                while ((n3 = inputStream.read(f2.writeBuffer, 0, f2.writeBuffer.length)) > 0) {
                    pipedOutputStream.write(f2.writeBuffer, 0, n3);
                }
                pipedOutputStream.flush();
                this.dataSize = this.inputStream.available();
                if (f.debug) {
                    System.out.println(d.stream_buffer_report.getString(Long.toString(this.dataSize)));
                }
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
            finally {
                try {
                    pipedOutputStream.close();
                }
                finally {
                    pipedOutputStream = null;
                }
            }
            this.modTime = new Date().getTime() / 1000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.inputStream == null) {
                return;
            }
            try {
                this.inputStream.close();
            }
            finally {
                this.inputStream = null;
            }
        }

        protected long headerChecksum() {
            long l2 = 0L;
            for (int i2 = 0; i2 < this.rawHeader.length; ++i2) {
                boolean bl2 = i2 >= h.checksum.getStart() && i2 < h.checksum.getStop();
                l2 += bl2 ? 32L : (long)(0xFF & this.rawHeader[i2]);
            }
            return l2;
        }

        protected void clearField(h h2) {
            a.clearField(h2, this.rawHeader);
        }

        protected void writeField(h h2, String string) {
            a.writeField(h2, string, this.rawHeader);
        }

        protected void writeField(h h2, long l2) {
            a.writeField(h2, l2, this.rawHeader);
        }

        protected void writeField(h h2, char c2) {
            a.writeField(h2, Character.toString(c2), this.rawHeader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() {
            try {
                int n2;
                long l2 = this.inputStream.getSizeLimit();
                if (l2 == 0L) {
                    return;
                }
                if (l2 > 0L) {
                    this.dataSize = l2;
                }
                if (this.dataSize >= this.paxThreshold) {
                    this.paxSized = true;
                    this.makeXentry().write();
                    System.err.print("x... ");
                }
                this.writeField(h.name, this.path);
                this.writeField(h.mode, this.fileMode);
                if (!this.paxSized) {
                    this.writeField(h.size, this.dataSize);
                }
                this.writeField(h.mtime, this.modTime);
                this.writeField(h.checksum, a.prePaddedOctalString(this.headerChecksum(), 6) + "\u0000 ");
                this.tarStream.writeBlock(this.rawHeader);
                long l3 = this.tarStream.getBytesWritten();
                while ((n2 = this.inputStream.read(this.tarStream.writeBuffer)) > 0) {
                    this.tarStream.write(n2);
                }
                if (l3 + this.dataSize != this.tarStream.getBytesWritten()) {
                    throw new IOException(d.data_changed.getString(Long.toString(this.dataSize), Long.toString(this.tarStream.getBytesWritten() - l3)));
                }
                this.tarStream.padCurrentBlock();
            }
            finally {
                this.close();
            }
        }

        protected static String getLameMode(File file) {
            int n2 = 0;
            if (file.canExecute()) {
                n2 = 1;
            }
            if (file.canWrite()) {
                n2 += 2;
            }
            if (file.canRead()) {
                n2 += 4;
            }
            return "0" + n2 + "00";
        }

        static {
            char c2 = System.getProperty("file.separator").charAt(0);
            if (c2 != '/') {
                aPp = Character.valueOf(c2);
            }
            try {
                a.writeField(h.uid, 0L, aPo);
                a.writeField(h.gid, 0L, aPo);
            }
            catch (i i2) {
                throw new RuntimeException(i2);
            }
            int n2 = h.magic.getStart();
            for (int i3 = 0; i3 < aPq.length; ++i3) {
                a.aPo[n2 + i3] = aPq[i3];
            }
            a.aPo[263] = 48;
            a.aPo[264] = 48;
        }
    }
}

