/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.hsqldb.lib.tar.d;

public class f {
    public static final boolean debug = Boolean.getBoolean("DEBUG");
    protected int blocksPerRecord;
    protected long bytesWritten = 0L;
    private OutputStream aPk;
    private File aPl;
    private File aPm;
    public byte[] writeBuffer;
    static final byte[] aPn = new byte[512];

    public f(File file) {
        this(file, 0);
    }

    public f(File file, int n2) {
        this(file, n2, 20);
    }

    public f(File file, int n2, int n3) {
        this.blocksPerRecord = n3;
        this.aPl = file;
        this.aPm = new File(file.getParentFile(), file.getName() + "-partial");
        if (this.aPm.exists()) {
            throw new IOException(d.move_work_file.getString(this.aPm.getAbsolutePath()));
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException(d.cant_overwrite.getString(file.getAbsolutePath()));
        }
        File file2 = file.getAbsoluteFile().getParentFile();
        if (file2.exists() && file2.isDirectory()) {
            if (!file2.canWrite()) {
                throw new IOException(d.cant_write_dir.getString(file2.getAbsolutePath()));
            }
        } else {
            throw new IOException(d.no_parent_dir.getString(file2.getAbsolutePath()));
        }
        this.writeBuffer = new byte[n3 * 512];
        switch (n2) {
            case 0: {
                this.aPk = new FileOutputStream(this.aPm);
                break;
            }
            case 1: {
                this.aPk = new GZIPOutputStream((OutputStream)new FileOutputStream(this.aPm), this.writeBuffer.length);
                break;
            }
            default: {
                throw new IllegalArgumentException(d.compression_unknown.getString(n2));
            }
        }
        this.aPm.setExecutable(false, true);
        this.aPm.setExecutable(false, false);
        this.aPm.setReadable(false, false);
        this.aPm.setReadable(true, true);
        this.aPm.setWritable(false, false);
        this.aPm.setWritable(true, true);
    }

    public void write(byte[] byArray, int n2) {
        this.aPk.write(byArray, 0, n2);
        this.bytesWritten += (long)n2;
    }

    public void write(int n2) {
        this.write(this.writeBuffer, n2);
    }

    public void writeBlock(byte[] byArray) {
        if (byArray.length != 512) {
            throw new IllegalArgumentException(d.bad_block_write_len.getString(byArray.length));
        }
        this.write(byArray, byArray.length);
    }

    public void writePadBlocks(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.write(aPn, aPn.length);
        }
    }

    public void writePadBlock() {
        this.writePadBlocks(1);
    }

    public int bytesLeftInBlock() {
        int n2 = (int)(this.bytesWritten % 512L);
        if (n2 == 0) {
            return 0;
        }
        return 512 - n2;
    }

    public void assertAtBlockBoundary() {
        if (this.bytesLeftInBlock() != 0) {
            throw new IllegalArgumentException(d.illegal_block_boundary.getString(Long.toString(this.bytesWritten)));
        }
    }

    public void padCurrentBlock() {
        int n2 = this.bytesLeftInBlock();
        if (n2 == 0) {
            return;
        }
        this.write(aPn, n2);
        this.assertAtBlockBoundary();
    }

    public void flush() {
        this.aPk.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.aPk == null) {
            return;
        }
        try {
            this.aPk.close();
            if (!this.aPm.delete()) {
                throw new IOException(d.workfile_delete_fail.getString(this.aPm.getAbsolutePath()));
            }
        }
        finally {
            this.aPk = null;
        }
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void finish() {
        try {
            long l2 = this.bytesWritten / 512L + 2L;
            if (l2 % (long)this.blocksPerRecord != 0L) {
                l2 = (l2 / (long)this.blocksPerRecord + 1L) * (long)this.blocksPerRecord;
            }
            int n2 = (int)(l2 - this.bytesWritten / 512L);
            if (debug) {
                System.out.println(d.pad_block_write.getString(n2));
            }
            this.writePadBlocks(n2);
        }
        catch (IOException iOException) {
            try {
                this.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        this.aPk.close();
        this.aPm.renameTo(this.aPl);
    }
}

