/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.hsqldb.lib.tar.d;
import org.hsqldb.lib.tar.i;

public class e {
    protected long bytesRead = 0L;
    private InputStream aPj;
    protected byte[] readBuffer;
    protected int readBufferBlocks;
    protected int compressionType;

    public e(File file) {
        this(file, 0);
    }

    public e(File file, int n2) {
        this(file, n2, 20);
    }

    public int getReadBufferBlocks() {
        return this.readBufferBlocks;
    }

    public e(File file, int n2, int n3) {
        if (!file.isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException(d.read_denied.getString(file.getAbsolutePath()));
        }
        this.readBufferBlocks = n3;
        this.compressionType = n2;
        this.readBuffer = new byte[n3 * 512];
        switch (n2) {
            case 0: {
                this.aPj = new FileInputStream(file);
                break;
            }
            case 1: {
                this.aPj = new GZIPInputStream((InputStream)new FileInputStream(file), this.readBuffer.length);
                break;
            }
            default: {
                throw new IllegalArgumentException(d.compression_unknown.getString(n2));
            }
        }
    }

    public void readBlocks(int n2) {
        if (this.compressionType != 0) {
            this.readCompressedBlocks(n2);
            return;
        }
        int n3 = this.aPj.read(this.readBuffer, 0, n2 * 512);
        this.bytesRead += (long)n3;
        if (n3 != n2 * 512) {
            throw new i(d.insufficient_read.getString(n2 * 512, n3));
        }
    }

    protected void readCompressedBlocks(int n2) {
        int n3;
        int n4 = 512 * n2;
        for (int i2 = 0; i2 < n4; i2 += n3) {
            n3 = this.aPj.read(this.readBuffer, i2, n4 - i2);
            if (n3 < 0) {
                throw new EOFException(d.decompression_ranout.getString(i2, n4));
            }
            this.bytesRead += (long)n3;
        }
    }

    public void readBlock() {
        this.readBlocks(1);
    }

    public boolean readNextHeaderBlock() {
        try {
            while (this.aPj.available() > 0) {
                this.readBlock();
                if (this.readBuffer[0] == 0) continue;
                return true;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.aPj == null) {
            return;
        }
        try {
            this.aPj.close();
        }
        finally {
            this.aPj = null;
        }
    }
}

