/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.k;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.bg;
import org.hsqldb.bj;
import org.hsqldb.c.d;
import org.hsqldb.k.ad;
import org.hsqldb.k.b;
import org.hsqldb.k.j;
import org.hsqldb.k.l;
import org.hsqldb.k.u;
import org.hsqldb.lib.a.a;

public final class y
extends ad {
    public static final int defaultNumericPrecision = 128;
    public static final int defaultNumericScale = 32;
    public static final int maxNumericPrecision = Integer.MAX_VALUE;
    public static final int TINYINT_WIDTH = 8;
    public static final int SMALLINT_WIDTH = 16;
    public static final int INTEGER_WIDTH = 32;
    public static final int BIGINT_WIDTH = 64;
    public static final int DOUBLE_WIDTH = 128;
    public static final int DECIMAL_WIDTH = 256;
    public static final ad SQL_NUMERIC_DEFAULT_INT = new y(2, 128L, 0);
    public static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    public static final BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    public static final BigDecimal MAX_INT = BigDecimal.valueOf(Integer.MAX_VALUE);
    public static final BigDecimal MIN_INT = BigDecimal.valueOf(Integer.MIN_VALUE);
    public static final BigInteger MIN_LONG_BI = MIN_LONG.toBigInteger();
    public static final BigInteger MAX_LONG_BI = MAX_LONG.toBigInteger();
    final int aWZ;

    public y(int n2, long l2, int n3) {
        super(2, n2, l2, n3);
        switch (n2) {
            case -6: {
                this.aWZ = 8;
                break;
            }
            case 5: {
                this.aWZ = 16;
                break;
            }
            case 4: {
                this.aWZ = 32;
                break;
            }
            case 25: {
                this.aWZ = 64;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.aWZ = 128;
                break;
            }
            case 2: 
            case 3: {
                this.aWZ = 256;
                break;
            }
            default: {
                throw org.hsqldb.a.a.runtimeError(201, "NumberType");
            }
        }
    }

    public int getPrecision() {
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                return this.aWZ;
            }
            case 6: 
            case 7: 
            case 8: {
                return 64;
            }
            case 2: 
            case 3: {
                return (int)this.precision;
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    public int getDecimalPrecision() {
        switch (this.typeCode) {
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 25: {
                return 19;
            }
            case 6: 
            case 7: 
            case 8: {
                return this.displaySize() - 1;
            }
            case 2: 
            case 3: {
                return (int)this.precision;
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                if (this.scale == 0) {
                    if (this.precision == 0L) {
                        return 646456995;
                    }
                    return (int)this.precision + 1;
                }
                if (this.precision == (long)this.scale) {
                    return (int)this.precision + 3;
                }
                return (int)this.precision + 2;
            }
            case 6: 
            case 7: 
            case 8: {
                return 23;
            }
            case 25: {
                return 20;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 6;
            }
            case -6: {
                return 4;
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode == 25 ? -5 : this.typeCode;
    }

    @Override
    public Class getJDBCClass() {
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case 25: {
                return Long.class;
            }
            case 6: 
            case 7: 
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case 25: {
                return "java.lang.Long";
            }
            case 6: 
            case 7: 
            case 8: {
                return "java.lang.Double";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    @Override
    public int getJDBCPrecision() {
        return this.getPrecision();
    }

    @Override
    public String getNameString() {
        switch (this.typeCode) {
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case 25: {
                return "BIGINT";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    @Override
    public String getFullNameString() {
        switch (this.typeCode) {
            case 8: {
                return "DOUBLE PRECISION";
            }
        }
        return this.getNameString();
    }

    @Override
    public String getDefinition() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                StringBuffer stringBuffer = new StringBuffer(16);
                stringBuffer.append(this.getNameString());
                stringBuffer.append('(');
                stringBuffer.append(this.precision);
                if (this.scale != 0) {
                    stringBuffer.append(',');
                    stringBuffer.append(this.scale);
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
        }
        return this.getNameString();
    }

    @Override
    public long getMaxPrecision() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return Integer.MAX_VALUE;
            }
        }
        return this.getNumericPrecisionInRadix();
    }

    @Override
    public int getMaxScale() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return Short.MAX_VALUE;
            }
        }
        return 0;
    }

    @Override
    public boolean acceptsPrecision() {
        switch (this.typeCode) {
            case 2: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean acceptsScale() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPrecisionRadix() {
        if (this.typeCode == 3 || this.typeCode == 2) {
            return 10;
        }
        return 2;
    }

    @Override
    public boolean isNumberType() {
        return true;
    }

    @Override
    public boolean isIntegralType() {
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
            case 2: 
            case 3: {
                return this.scale == 0;
            }
        }
        return true;
    }

    @Override
    public boolean isExactNumberType() {
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isDecimalType() {
        switch (this.typeCode) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public int getNominalWidth() {
        return this.aWZ;
    }

    @Override
    public int precedenceDegree(ad ad2) {
        if (ad2.isNumberType()) {
            int n2 = ((y)ad2).aWZ;
            return n2 - this.aWZ;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public ad getAggregateType(ad ad2) {
        if (ad2 == null) {
            return this;
        }
        if (ad2 == SQL_ALL_TYPES) {
            return this;
        }
        if (this == ad2) {
            return this;
        }
        if (ad2.isCharacterType()) {
            return ad2.getAggregateType(this);
        }
        switch (ad2.typeCode) {
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                break;
            }
            default: {
                throw org.hsqldb.a.a.error(5562);
            }
        }
        if (this.aWZ == 128) {
            return this;
        }
        if (((y)ad2).aWZ == 128) {
            return ad2;
        }
        if (this.aWZ <= 64 && ((y)ad2).aWZ <= 64) {
            return this.aWZ > ((y)ad2).aWZ ? this : ad2;
        }
        int n2 = this.scale > ad2.scale ? this.scale : ad2.scale;
        long l2 = this.precision - (long)this.scale > ad2.precision - (long)ad2.scale ? this.precision - (long)this.scale : ad2.precision - (long)ad2.scale;
        return y.getNumberType(3, l2 + (long)n2, n2);
    }

    @Override
    public ad getCombinedType(bg bg2, ad ad2, int n2) {
        long l2;
        int n3;
        if (ad2.typeCode == 0) {
            ad2 = this;
        }
        switch (n2) {
            case 32: 
            case 35: {
                break;
            }
            case 34: {
                if (!ad2.isIntervalType()) break;
                return ad2.getCombinedType(bg2, this, 34);
            }
            default: {
                return this.getAggregateType(ad2);
            }
        }
        if (!ad2.isNumberType()) {
            throw org.hsqldb.a.a.error(5562);
        }
        if (this.aWZ == 128 || ((y)ad2).aWZ == 128) {
            return ad.SQL_DOUBLE;
        }
        if (n2 != 35 || bg2.database.sqlAvgScale == 0) {
            n3 = n2 == 35 ? this.aWZ : this.aWZ + ((y)ad2).aWZ;
            if (n3 <= 32) {
                return ad.SQL_INTEGER;
            }
            if (n3 <= 64) {
                return ad.SQL_BIGINT;
            }
        }
        switch (n2) {
            case 32: {
                n3 = this.scale > ad2.scale ? this.scale : ad2.scale;
                l2 = this.getDecimalPrecision() - this.scale > ((y)ad2).getDecimalPrecision() - ad2.scale ? (long)(this.getDecimalPrecision() - this.scale) : (long)(((y)ad2).getDecimalPrecision() - ad2.scale);
                ++l2;
                break;
            }
            case 35: {
                l2 = this.getDecimalPrecision() - this.scale + ad2.scale;
                int n4 = n3 = this.scale > ad2.scale ? this.scale : ad2.scale;
                if (bg2.database.sqlAvgScale <= n3) break;
                n3 = bg2.database.sqlAvgScale;
                break;
            }
            case 34: {
                l2 = this.getDecimalPrecision() - this.scale + ((y)ad2).getDecimalPrecision() - ad2.scale;
                n3 = this.scale + ad2.scale;
                break;
            }
            default: {
                throw org.hsqldb.a.a.runtimeError(201, "NumberType");
            }
        }
        return y.getNumberType(3, (long)n3 + l2, n3);
    }

    @Override
    public int compare(bg bg2, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                if (object2 instanceof Integer) {
                    int n2;
                    int n3 = ((Number)object).intValue();
                    return n3 > (n2 = ((Number)object2).intValue()) ? 1 : (n2 > n3 ? -1 : 0);
                }
                if (object2 instanceof Double) {
                    double d2;
                    double d3 = ((Number)object).doubleValue();
                    return d3 > (d2 = ((Number)object2).doubleValue()) ? 1 : (d2 > d3 ? -1 : 0);
                }
                if (object2 instanceof BigDecimal) {
                    BigDecimal bigDecimal = y.p(object);
                    return bigDecimal.compareTo((BigDecimal)object2);
                }
            }
            case 25: {
                if (object2 instanceof Long) {
                    long l2;
                    long l3 = ((Number)object).longValue();
                    return l3 > (l2 = ((Number)object2).longValue()) ? 1 : (l2 > l3 ? -1 : 0);
                }
                if (object2 instanceof Double) {
                    BigDecimal bigDecimal = BigDecimal.valueOf(((Number)object).longValue());
                    BigDecimal bigDecimal2 = new BigDecimal((Double)object2);
                    return bigDecimal.compareTo(bigDecimal2);
                }
                if (object2 instanceof BigDecimal) {
                    BigDecimal bigDecimal = y.p(object);
                    return bigDecimal.compareTo((BigDecimal)object2);
                }
            }
            case 6: 
            case 7: 
            case 8: {
                double d4 = ((Number)object).doubleValue();
                double d5 = ((Number)object2).doubleValue();
                if (Double.isNaN(d4)) {
                    return Double.isNaN(d5) ? 0 : -1;
                }
                if (Double.isNaN(d5)) {
                    return 1;
                }
                return Double.compare(d4, d5);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = y.p(object2);
                return ((BigDecimal)object).compareTo(bigDecimal);
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    @Override
    public Object convertToTypeLimits(bj bj2, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                return object;
            }
            case 6: 
            case 7: 
            case 8: {
                return object;
            }
            case 2: 
            case 3: {
                int n2;
                BigDecimal bigDecimal = (BigDecimal)object;
                if (this.scale != bigDecimal.scale()) {
                    bigDecimal = bigDecimal.setScale(this.scale, 5);
                }
                if ((long)(n2 = a.precision(bigDecimal)) > this.precision) {
                    throw org.hsqldb.a.a.error(3403);
                }
                return bigDecimal;
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    @Override
    public Object convertToType(bj bj2, Object object, ad ad2) {
        if (object == null) {
            return object;
        }
        if (ad2.typeCode == this.typeCode) {
            switch (this.typeCode) {
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (this.scale != bigDecimal.scale()) {
                        bigDecimal = bigDecimal.setScale(this.scale, 5);
                    }
                    if ((long)a.precision(bigDecimal) > this.precision) {
                        throw org.hsqldb.a.a.error(3403);
                    }
                    return bigDecimal;
                }
            }
            return object;
        }
        if (ad2.isIntervalType()) {
            int n2 = ((u)ad2).startIntervalType;
            switch (n2) {
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    double d2 = ((u)ad2).convertToDoubleStartUnits(object);
                    return this.convertToType(bj2, d2, ad.SQL_DOUBLE);
                }
            }
        }
        switch (ad2.typeCode) {
            case 40: {
                object = ((l)object).getSubString(bj2, 0L, (int)((l)object).length(bj2));
            }
            case 1: 
            case 12: {
                object = bj2.getScanner().convertToNumber((String)object, this);
                object = this.convertToDefaultType(bj2, object);
                return this.convertToTypeLimits(bj2, object);
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                break;
            }
            case 14: 
            case 15: {
                if (ad2.precision == 1L) {
                    if (((b)object).getBytes()[0] == 0) {
                        object = d.INTEGER_0;
                        break;
                    }
                    object = d.INTEGER_1;
                    break;
                }
            }
            default: {
                throw org.hsqldb.a.a.error(5561);
            }
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return y.a(bj2, object, this.typeCode);
            }
            case 25: {
                return y.b(bj2, object);
            }
            case 6: 
            case 7: 
            case 8: {
                return y.o(object);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = null;
                if (this.scale == 0 && object instanceof Double) {
                    double d3 = ((Number)object).doubleValue();
                    if (bj2 instanceof bg && !((bg)bj2).database.sqlConvertTruncate) {
                        d3 = Math.rint(d3);
                    }
                    if (Double.isInfinite(d3) || Double.isNaN(d3)) {
                        throw org.hsqldb.a.a.error(3403);
                    }
                    bigDecimal = BigDecimal.valueOf(d3);
                }
                if (bigDecimal == null) {
                    bigDecimal = y.p(object);
                }
                return this.convertToTypeLimits(bj2, bigDecimal);
            }
        }
        throw org.hsqldb.a.a.error(5561);
    }

    @Override
    public Object convertToTypeJDBC(bj bj2, Object object, ad ad2) {
        if (object == null) {
            return object;
        }
        if (ad2.isLobType()) {
            throw org.hsqldb.a.a.error(5561);
        }
        switch (ad2.typeCode) {
            case 16: {
                object = (Boolean)object != false ? d.INTEGER_1 : d.INTEGER_0;
                ad2 = ad.SQL_INTEGER;
            }
        }
        return this.convertToType(bj2, object, ad2);
    }

    @Override
    public Object convertToDefaultType(bj bj2, Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof Number) {
            if (object instanceof BigInteger) {
                object = new BigDecimal((BigInteger)object);
            } else if (object instanceof Float) {
                object = new Double(((Float)object).doubleValue());
            } else if (object instanceof Byte) {
                object = d.getInt(((Byte)object).intValue());
            } else if (object instanceof Short) {
                object = d.getInt(((Short)object).intValue());
            }
            if (object instanceof Integer) {
                y y2 = ad.SQL_INTEGER;
            } else if (object instanceof Long) {
                y y3 = ad.SQL_BIGINT;
            } else if (object instanceof Double) {
                y y4 = ad.SQL_DOUBLE;
            } else if (object instanceof BigDecimal) {
                y y5 = ad.SQL_DECIMAL_DEFAULT;
            } else {
                throw org.hsqldb.a.a.error(5561);
            }
            switch (this.typeCode) {
                case -6: 
                case 4: 
                case 5: {
                    return y.a(bj2, object, 4);
                }
                case 25: {
                    return y.b(bj2, object);
                }
                case 6: 
                case 7: 
                case 8: {
                    return y.o(object);
                }
                case 2: 
                case 3: {
                    object = y.p(object);
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (this.scale != bigDecimal.scale()) {
                        bigDecimal = bigDecimal.setScale(this.scale, 5);
                    }
                    return bigDecimal;
                }
            }
            throw org.hsqldb.a.a.error(5561);
        }
        if (!(object instanceof String)) {
            throw org.hsqldb.a.a.error(5561);
        }
        j j2 = ad.SQL_VARCHAR;
        return this.convertToType(bj2, object, j2);
    }

    @Override
    public Object convertJavaToSQL(bj bj2, Object object) {
        return this.convertToDefaultType(bj2, object);
    }

    static Integer a(bj bj2, Object object, int n2) {
        int n3;
        if (object instanceof Integer) {
            if (n2 == 4) {
                return (Integer)object;
            }
            n3 = (Integer)object;
        } else if (object instanceof Long) {
            long l2 = (Long)object;
            if (Integer.MAX_VALUE < l2 || l2 < Integer.MIN_VALUE) {
                throw org.hsqldb.a.a.error(3403);
            }
            n3 = (int)l2;
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.compareTo(MAX_INT) > 0 || bigDecimal.compareTo(MIN_INT) < 0) {
                throw org.hsqldb.a.a.error(3403);
            }
            n3 = bigDecimal.intValue();
        } else if (object instanceof Double || object instanceof Float) {
            double d2 = ((Number)object).doubleValue();
            if (bj2 instanceof bg && !((bg)bj2).database.sqlConvertTruncate) {
                d2 = Math.rint(d2);
            }
            if (Double.isInfinite(d2) || Double.isNaN(d2) || d2 >= 2.147483648E9 || d2 <= -2.147483649E9) {
                throw org.hsqldb.a.a.error(3403);
            }
            n3 = (int)d2;
        } else {
            throw org.hsqldb.a.a.error(5561);
        }
        if (n2 == -6 ? 127 < n3 || n3 < -128 : n2 == 5 && (Short.MAX_VALUE < n3 || n3 < Short.MIN_VALUE)) {
            throw org.hsqldb.a.a.error(3403);
        }
        return n3;
    }

    static Long b(bj bj2, Object object) {
        if (object instanceof Integer) {
            return d.getLong(((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.compareTo(MAX_LONG) > 0 || bigDecimal.compareTo(MIN_LONG) < 0) {
                throw org.hsqldb.a.a.error(3403);
            }
            return d.getLong(bigDecimal.longValue());
        }
        if (object instanceof Double || object instanceof Float) {
            double d2 = ((Number)object).doubleValue();
            if (bj2 instanceof bg && !((bg)bj2).database.sqlConvertTruncate) {
                d2 = Math.rint(d2);
            }
            if (Double.isInfinite(d2) || Double.isNaN(d2) || d2 >= 9.223372036854776E18 || d2 <= -9.223372036854776E18) {
                throw org.hsqldb.a.a.error(3403);
            }
            return d.getLong((long)d2);
        }
        throw org.hsqldb.a.a.error(5561);
    }

    private static Double o(Object object) {
        if (object instanceof Double) {
            return (Double)object;
        }
        double d2 = y.toDouble(object);
        return d.getDouble(Double.doubleToLongBits(d2));
    }

    public static double toDouble(Object object) {
        double d2;
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof BigDecimal) {
            int n2;
            BigDecimal bigDecimal = (BigDecimal)object;
            d2 = bigDecimal.doubleValue();
            BigDecimal bigDecimal2 = new BigDecimal(d2 + (double)(n2 = bigDecimal.signum()));
            if (bigDecimal2.compareTo(bigDecimal) != n2) {
                throw org.hsqldb.a.a.error(3403);
            }
        } else if (object instanceof Number) {
            d2 = ((Number)object).doubleValue();
        } else {
            throw org.hsqldb.a.a.error(3471);
        }
        return d2;
    }

    private static BigDecimal p(Object object) {
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Integer || object instanceof Long) {
            return BigDecimal.valueOf(((Number)object).longValue());
        }
        if (object instanceof Double) {
            double d2 = ((Number)object).doubleValue();
            if (Double.isInfinite(d2) || Double.isNaN(d2)) {
                throw org.hsqldb.a.a.error(3403);
            }
            return BigDecimal.valueOf(d2);
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                return object.toString();
            }
            case 7: 
            case 8: {
                double d2 = (Double)object;
                if (d2 == Double.NEGATIVE_INFINITY) {
                    return "-1E0/0";
                }
                if (d2 == Double.POSITIVE_INFINITY) {
                    return "1E0/0";
                }
                if (Double.isNaN(d2)) {
                    return "0E0/0E0";
                }
                String string = Double.toString(d2);
                if (string.indexOf(69) < 0) {
                    string = string.concat("E0");
                }
                return string;
            }
            case 2: 
            case 3: {
                return a.toString((BigDecimal)object);
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        return this.convertToString(object);
    }

    @Override
    public boolean canConvertFrom(ad ad2) {
        if (ad2.typeCode == 0) {
            return true;
        }
        if (ad2.isNumberType()) {
            return true;
        }
        if (ad2.isIntervalType()) {
            return true;
        }
        if (ad2.isCharacterType()) {
            return true;
        }
        return ad2.isBitType() && ad2.precision == 1L;
    }

    @Override
    public int canMoveFrom(ad ad2) {
        if (ad2 == this) {
            return 0;
        }
        switch (this.typeCode) {
            case -6: {
                if (ad2.typeCode != 5 && ad2.typeCode != 4) break;
                return 1;
            }
            case 5: {
                if (ad2.typeCode == -6) {
                    return 0;
                }
                if (ad2.typeCode != 4) break;
                return 1;
            }
            case 4: {
                if (ad2.typeCode != 5 && ad2.typeCode != -6) break;
                return 0;
            }
            case 25: {
                break;
            }
            case 2: 
            case 3: {
                if (ad2.typeCode != 3 && ad2.typeCode != 2 || this.scale != ad2.scale) break;
                if (this.precision >= ad2.precision) {
                    return 0;
                }
                return 1;
            }
            case 6: 
            case 7: 
            case 8: {
                if (ad2.typeCode != 7 && ad2.typeCode != 6 && ad2.typeCode != 8) break;
                return 0;
            }
        }
        return -1;
    }

    @Override
    public int compareToTypeRange(Object object) {
        if (!(object instanceof Number)) {
            return 0;
        }
        if (object instanceof Integer || object instanceof Long) {
            int n2;
            int n3;
            long l2 = ((Number)object).longValue();
            switch (this.typeCode) {
                case -6: {
                    n3 = -128;
                    n2 = 127;
                    break;
                }
                case 5: {
                    n3 = Short.MIN_VALUE;
                    n2 = Short.MAX_VALUE;
                    break;
                }
                case 4: {
                    n3 = Integer.MIN_VALUE;
                    n2 = Integer.MAX_VALUE;
                    break;
                }
                case 25: {
                    return 0;
                }
                case 2: 
                case 3: {
                    if (this.precision - (long)this.scale > 18L) {
                        return 0;
                    }
                    if (this.precision - (long)this.scale > 9L && object instanceof Integer) {
                        return 0;
                    }
                    BigDecimal bigDecimal = y.p(object);
                    int n4 = bigDecimal.scale();
                    int n5 = a.precision(bigDecimal);
                    if (n4 < 0) {
                        n5 -= n4;
                        n4 = 0;
                    }
                    return this.precision - (long)this.scale >= (long)(n5 - n4) ? 0 : bigDecimal.signum();
                }
                default: {
                    return 0;
                }
            }
            if ((long)n2 < l2) {
                return 1;
            }
            if (l2 < (long)n3) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public Object add(bg bg2, Object object, Object object2, ad ad2) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return d.getDouble(Double.doubleToLongBits(d2 + d3));
            }
            case 2: 
            case 3: {
                object = this.convertToDefaultType(null, object);
                object2 = this.convertToDefaultType(null, object2);
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                bigDecimal = bigDecimal.add(bigDecimal2);
                return this.convertToTypeLimits(null, bigDecimal);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return d.getInt(n2 + n3);
            }
            case 25: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return d.getLong(l2 + l3);
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    @Override
    public Object subtract(bg bg2, Object object, Object object2, ad ad2) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return d.getDouble(Double.doubleToLongBits(d2 - d3));
            }
            case 2: 
            case 3: {
                object = this.convertToDefaultType(null, object);
                object2 = this.convertToDefaultType(null, object2);
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                bigDecimal = bigDecimal.subtract(bigDecimal2);
                return this.convertToTypeLimits(null, bigDecimal);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return d.getInt(n2 - n3);
            }
            case 25: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return d.getLong(l2 - l3);
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    @Override
    public Object multiply(Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return d.getDouble(Double.doubleToLongBits(d2 * d3));
            }
            case 2: 
            case 3: {
                if (!(object instanceof BigDecimal)) {
                    object = this.convertToDefaultType(null, object);
                }
                if (!(object2 instanceof BigDecimal)) {
                    object2 = this.convertToDefaultType(null, object2);
                }
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
                return this.convertToTypeLimits(null, bigDecimal3);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return d.getInt(n2 * n3);
            }
            case 25: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return d.getLong(l2 * l3);
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    @Override
    public Object divide(bg bg2, Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                if (d3 == 0.0 && (bg2 == null || bg2.database.sqlDoubleNaN)) {
                    throw org.hsqldb.a.a.error(3432);
                }
                return d.getDouble(Double.doubleToLongBits(d2 / d3));
            }
            case 2: 
            case 3: {
                if (!(object instanceof BigDecimal)) {
                    object = this.convertToDefaultType(null, object);
                }
                if (!(object2 instanceof BigDecimal)) {
                    object2 = this.convertToDefaultType(null, object2);
                }
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                if (bigDecimal2.signum() == 0) {
                    throw org.hsqldb.a.a.error(3432);
                }
                BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, this.scale, 1);
                return this.convertToTypeLimits(null, bigDecimal3);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                if (n3 == 0) {
                    throw org.hsqldb.a.a.error(3432);
                }
                return d.getInt(n2 / n3);
            }
            case 25: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                if (l3 == 0L) {
                    throw org.hsqldb.a.a.error(3432);
                }
                return d.getLong(l2 / l3);
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    public Object modulo(bg bg2, Object object, Object object2, ad ad2) {
        if (!ad2.isNumberType()) {
            throw org.hsqldb.a.a.error(5561);
        }
        object = this.truncate(object, this.scale);
        object2 = ((y)ad2).truncate(object2, ad2.scale);
        Object object3 = this.divide(null, object, object2);
        switch (this.typeCode) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                object3 = this.truncate(object3, 0);
            }
        }
        object3 = this.multiply(object3, object2);
        object3 = this.subtract(bg2, object, object3, this);
        return ad2.convertToType(null, object3, this);
    }

    @Override
    public Object absolute(Object object) {
        return this.isNegative(object) ? this.negate(object) : object;
    }

    @Override
    public Object negate(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = -((Number)object).doubleValue();
                return d.getDouble(Double.doubleToLongBits(d2));
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).negate();
            }
            case -6: {
                int n2 = ((Number)object).intValue();
                if (n2 == -128) {
                    throw org.hsqldb.a.a.error(3403);
                }
                return d.getInt(-n2);
            }
            case 5: {
                int n3 = ((Number)object).intValue();
                if (n3 == Short.MIN_VALUE) {
                    throw org.hsqldb.a.a.error(3403);
                }
                return d.getInt(-n3);
            }
            case 4: {
                int n4 = ((Number)object).intValue();
                if (n4 == Integer.MIN_VALUE) {
                    throw org.hsqldb.a.a.error(3403);
                }
                return d.getInt(-n4);
            }
            case 25: {
                long l2 = ((Number)object).longValue();
                if (l2 == Long.MIN_VALUE) {
                    throw org.hsqldb.a.a.error(3403);
                }
                return d.getLong(-l2);
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    public int getNumericPrecisionInRadix() {
        switch (this.typeCode) {
            case -6: {
                return 8;
            }
            case 5: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 25: {
                return 64;
            }
            case 6: 
            case 7: 
            case 8: {
                return 64;
            }
            case 2: 
            case 3: {
                return (int)this.precision;
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    public ad getIntegralType() {
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return SQL_NUMERIC_DEFAULT_INT;
            }
            case 2: 
            case 3: {
                return this.scale == 0 ? this : new y(this.typeCode, this.precision, 0);
            }
        }
        return this;
    }

    public static boolean isZero(Object object) {
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).signum() == 0;
        }
        if (object instanceof Double) {
            return (Double)object == 0.0 || ((Double)object).isNaN();
        }
        return ((Number)object).longValue() == 0L;
    }

    public boolean isNegative(Object object) {
        if (object == null) {
            return false;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                return d2 < 0.0;
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).signum() < 0;
            }
            case -6: 
            case 4: 
            case 5: {
                return ((Number)object).intValue() < 0;
            }
            case 25: {
                return ((Number)object).longValue() < 0L;
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    public int compareToZero(Object object) {
        if (object == null) {
            return 0;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                return d2 == 0.0 ? 0 : (d2 < 0.0 ? -1 : 1);
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).signum();
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                return n2 == 0 ? 0 : (n2 < 0 ? -1 : 1);
            }
            case 25: {
                long l2 = ((Number)object).longValue();
                return l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }

    public static long scaledDecimal(Object object, int n2) {
        if (object == null) {
            return 0L;
        }
        if (n2 == 0) {
            return 0L;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        if (bigDecimal.scale() == 0) {
            return 0L;
        }
        bigDecimal = bigDecimal.setScale(0, 3);
        bigDecimal = ((BigDecimal)object).subtract(bigDecimal);
        return bigDecimal.movePointRight(n2).longValue();
    }

    public static boolean isInLongLimits(BigDecimal bigDecimal) {
        return MIN_LONG.compareTo(bigDecimal) <= 0 && MAX_LONG.compareTo(bigDecimal) >= 0;
    }

    public static boolean isInLongLimits(BigInteger bigInteger) {
        return MIN_LONG_BI.compareTo(bigInteger) <= 0 && MAX_LONG_BI.compareTo(bigInteger) >= 0;
    }

    public Object ceiling(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = Math.ceil((Double)object);
                if (Double.isInfinite(d2)) {
                    throw org.hsqldb.a.a.error(3403);
                }
                return d.getDouble(Double.doubleToLongBits(d2));
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = ((BigDecimal)object).setScale(0, 2);
                return bigDecimal;
            }
        }
        return object;
    }

    public Object floor(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 6: 
            case 7: 
            case 8: {
                double d2 = Math.floor((Double)object);
                if (Double.isInfinite(d2)) {
                    throw org.hsqldb.a.a.error(3403);
                }
                return d.getDouble(Double.doubleToLongBits(d2));
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = ((BigDecimal)object).setScale(0, 3);
                return bigDecimal;
            }
        }
        return object;
    }

    public Object truncate(Object object, int n2) {
        if (object == null) {
            return null;
        }
        BigDecimal bigDecimal = y.p(object);
        bigDecimal = bigDecimal.setScale(n2, 1);
        if (this.typeCode == 3 || this.typeCode == 2) {
            bigDecimal = bigDecimal.setScale(this.scale, 1);
        }
        object = this.convertToDefaultType(null, bigDecimal);
        return this.convertToTypeLimits(null, object);
    }

    public Object round(Object object, int n2) {
        if (object == null) {
            return null;
        }
        BigDecimal bigDecimal = y.p(object);
        switch (this.typeCode) {
            case 8: {
                bigDecimal = bigDecimal.setScale(n2, 6);
                break;
            }
            default: {
                bigDecimal = bigDecimal.setScale(n2, 4);
                bigDecimal = bigDecimal.setScale(this.scale, 1);
            }
        }
        object = this.convertToDefaultType(null, bigDecimal);
        return this.convertToTypeLimits(null, object);
    }

    public static y getNumberType(int n2, long l2, int n3) {
        switch (n2) {
            case 4: {
                return SQL_INTEGER;
            }
            case 5: {
                return SQL_SMALLINT;
            }
            case 25: {
                return SQL_BIGINT;
            }
            case -6: {
                return TINYINT;
            }
            case 7: 
            case 8: {
                return SQL_DOUBLE;
            }
            case 2: 
            case 3: {
                return new y(n2, l2, n3);
            }
        }
        throw org.hsqldb.a.a.runtimeError(201, "NumberType");
    }
}

