/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.k;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.hsqldb.a.a;
import org.hsqldb.aa;
import org.hsqldb.bg;
import org.hsqldb.bj;
import org.hsqldb.k.ab;
import org.hsqldb.k.ac;
import org.hsqldb.k.ad;
import org.hsqldb.k.q;
import org.hsqldb.k.s;
import org.hsqldb.k.t;
import org.hsqldb.k.u;
import org.hsqldb.k.y;
import org.hsqldb.lib.bh;
import org.hsqldb.z;

public final class r
extends q {
    public final boolean withTimeZone;
    private String nameString;
    public static final long epochSeconds = z.getDateSeconds("1-01-01");
    public static final ac epochTimestamp = new ac(epochSeconds);

    public r(int n2, int n3, int n4) {
        super(n2, n3, 0L, n4);
        this.withTimeZone = n3 == 94 || n3 == 95;
        this.nameString = this.nQ();
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 91: {
                return 10;
            }
            case 92: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 94: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
            case 93: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 95: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode;
    }

    @Override
    public Class getJDBCClass() {
        switch (this.typeCode) {
            case 91: {
                return Date.class;
            }
            case 92: 
            case 94: {
                return Time.class;
            }
            case 93: 
            case 95: {
                return Timestamp.class;
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case 91: {
                return "java.sql.Date";
            }
            case 92: 
            case 94: {
                return "java.sql.Time";
            }
            case 93: 
            case 95: {
                return "java.sql.Timestamp";
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCPrecision() {
        return this.displaySize();
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 9;
    }

    @Override
    public String getNameString() {
        return this.nameString;
    }

    @Override
    public boolean canCompareDirect(ad ad2) {
        return this.typeCode == ad2.typeCode;
    }

    private String nQ() {
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 94: {
                return "TIME WITH TIME ZONE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 95: {
                return "TIMESTAMP WITH TIME ZONE";
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getDefinition() {
        String string;
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: 
            case 94: {
                if (this.scale == 0) {
                    return this.getNameString();
                }
                string = "TIME";
                break;
            }
            case 93: 
            case 95: {
                if (this.scale == 6) {
                    return this.getNameString();
                }
                string = "TIMESTAMP";
                break;
            }
            default: {
                throw a.runtimeError(201, "DateTimeType");
            }
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(string);
        stringBuffer.append('(');
        stringBuffer.append(this.scale);
        stringBuffer.append(')');
        if (this.withTimeZone) {
            stringBuffer.append(" WITH TIME ZONE");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isDateTimeType() {
        return true;
    }

    @Override
    public boolean isDateOrTimestampType() {
        switch (this.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                return true;
            }
            case 92: 
            case 94: {
                return false;
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isDateTimeTypeWithZone() {
        return this.withTimeZone;
    }

    @Override
    public boolean acceptsFractionalPrecision() {
        return this.typeCode != 91;
    }

    @Override
    public ad getAggregateType(ad ad2) {
        int n2;
        if (ad2 == null) {
            return this;
        }
        if (ad2 == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == ad2.typeCode) {
            return this.scale >= ad2.scale ? this : ad2;
        }
        if (ad2.typeCode == 0) {
            return this;
        }
        if (ad2.isCharacterType()) {
            return ad2.getAggregateType(this);
        }
        if (!ad2.isDateTimeType()) {
            throw a.error(5562);
        }
        r r2 = (r)ad2;
        if (r2.startIntervalType > this.endIntervalType || this.startIntervalType > r2.endIntervalType) {
            throw a.error(5562);
        }
        int n3 = this.typeCode;
        int n4 = this.scale > r2.scale ? this.scale : r2.scale;
        boolean bl2 = this.withTimeZone || r2.withTimeZone;
        int n5 = n2 = r2.startIntervalType > this.startIntervalType ? this.startIntervalType : r2.startIntervalType;
        n3 = n2 == 104 ? (bl2 ? 94 : 92) : (bl2 ? 95 : 93);
        return r.getDateTimeType(n3, n4);
    }

    @Override
    public ad getCombinedType(bg bg2, ad ad2, int n2) {
        switch (n2) {
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                int n3;
                if (this.typeCode == ad2.typeCode) {
                    return this;
                }
                if (ad2.typeCode == 0) {
                    return this;
                }
                if (!ad2.isDateTimeType()) {
                    throw a.error(5562);
                }
                r r2 = (r)ad2;
                if (r2.startIntervalType > this.endIntervalType || this.startIntervalType > r2.endIntervalType) {
                    throw a.error(5562);
                }
                int n4 = this.typeCode;
                int n5 = this.scale > r2.scale ? this.scale : r2.scale;
                boolean bl2 = this.withTimeZone || r2.withTimeZone;
                int n6 = n3 = r2.startIntervalType > this.startIntervalType ? this.startIntervalType : r2.startIntervalType;
                n4 = n3 == 104 ? (bl2 ? 94 : 92) : (bl2 ? 95 : 93);
                return r.getDateTimeType(n4, n5);
            }
            case 32: 
            case 33: {
                if (ad2.isIntervalType()) {
                    if (this.typeCode != 91 && ad2.scale > this.scale) {
                        return r.getDateTimeType(this.typeCode, ad2.scale);
                    }
                    return this;
                }
                if (ad2.isDateTimeType()) {
                    if (n2 != 33 || ad2.typeComparisonGroup != this.typeComparisonGroup) break;
                    if (this.typeCode == 91) {
                        return ad.SQL_INTERVAL_DAY_MAX_PRECISION;
                    }
                    return ad.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                }
                if (!ad2.isNumberType()) break;
                return this;
            }
        }
        throw a.error(5562);
    }

    @Override
    public int compare(bg bg2, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long l2 = ((ab)object).getSeconds() - ((ab)object2).getSeconds();
                if (l2 == 0L) {
                    l2 = ((ab)object).getNanos() - ((ab)object2).getNanos();
                }
                return l2 == 0L ? 0 : (l2 > 0L ? 1 : -1);
            }
            case 91: 
            case 93: 
            case 95: {
                long l3 = ((ac)object).getSeconds() - ((ac)object2).getSeconds();
                if (l3 == 0L) {
                    l3 = ((ac)object).getNanos() - ((ac)object2).getNanos();
                }
                return l3 == 0L ? 0 : (l3 > 0L ? 1 : -1);
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToTypeLimits(bj bj2, Object object) {
        if (object == null) {
            return null;
        }
        if (this.scale == 9) {
            return object;
        }
        switch (this.typeCode) {
            case 91: {
                return object;
            }
            case 92: 
            case 94: {
                ab ab2 = (ab)object;
                int n2 = ab2.getNanos();
                int n3 = this.cR(n2);
                if (n3 == n2) {
                    return ab2;
                }
                return new ab(ab2.getSeconds(), n3, ab2.getZone());
            }
            case 93: 
            case 95: {
                ac ac2 = (ac)object;
                int n4 = ac2.getNanos();
                int n5 = this.cR(n4);
                if (n5 == n4) {
                    return ac2;
                }
                return new ac(ac2.getSeconds(), n5, ac2.getZone());
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    int cR(int n2) {
        int n3 = nanoScaleFactors[this.scale];
        return n2 / n3 * n3;
    }

    @Override
    public Object convertToType(bj bj2, Object object, ad ad2) {
        if (object == null) {
            return object;
        }
        switch (ad2.typeCode) {
            case 40: {
                object = object.toString();
            }
            case 1: 
            case 12: {
                switch (this.typeCode) {
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        try {
                            return bj2.getScanner().convertToDatetimeInterval(bj2, (String)object, this);
                        }
                        catch (aa aa2) {
                            return r.convertToDatetimeSpecial(bj2, (String)object, this);
                        }
                    }
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                break;
            }
            default: {
                throw a.error(5561);
            }
        }
        switch (this.typeCode) {
            case 91: {
                switch (ad2.typeCode) {
                    case 91: {
                        return object;
                    }
                    case 95: {
                        long l2 = ((ac)object).getSeconds() + (long)((ac)object).getZone();
                        long l3 = z.getNormalisedDate(l2 * 1000L);
                        return new ac(l3 / 1000L);
                    }
                    case 93: {
                        long l4 = z.getNormalisedDate(((ac)object).getSeconds() * 1000L);
                        return new ac(l4 / 1000L);
                    }
                }
                throw a.error(5561);
            }
            case 94: {
                switch (ad2.typeCode) {
                    case 94: {
                        return this.convertToTypeLimits(bj2, object);
                    }
                    case 92: {
                        ab ab2 = (ab)object;
                        return new ab(ab2.getSeconds() - bj2.getZoneSeconds(), this.cR(ab2.getNanos()), bj2.getZoneSeconds());
                    }
                    case 95: {
                        ac ac2 = (ac)object;
                        long l5 = z.convertToNormalisedTime(ac2.getSeconds() * 1000L) / 1000L;
                        return new ab((int)l5, this.cR(ac2.getNanos()), ac2.getZone());
                    }
                    case 93: {
                        ac ac3 = (ac)object;
                        long l6 = ac3.getSeconds() - (long)bj2.getZoneSeconds();
                        l6 = z.convertToNormalisedTime(l6 * 1000L) / 1000L;
                        return new ab((int)l6, this.cR(ac3.getNanos()), bj2.getZoneSeconds());
                    }
                }
                throw a.error(5561);
            }
            case 92: {
                switch (ad2.typeCode) {
                    case 94: {
                        ab ab3 = (ab)object;
                        return new ab(ab3.getSeconds() + ab3.getZone(), this.cR(ab3.getNanos()), 0);
                    }
                    case 92: {
                        return this.convertToTypeLimits(bj2, object);
                    }
                    case 95: {
                        ac ac4 = (ac)object;
                        long l7 = ac4.getSeconds() + (long)ac4.getZone();
                        l7 = z.convertToNormalisedTime(l7 * 1000L) / 1000L;
                        return new ab((int)l7, this.cR(ac4.getNanos()), 0);
                    }
                    case 93: {
                        ac ac5 = (ac)object;
                        long l8 = z.convertToNormalisedTime(ac5.getSeconds() * 1000L) / 1000L;
                        return new ab((int)l8, this.cR(ac5.getNanos()));
                    }
                }
                throw a.error(5561);
            }
            case 95: {
                switch (ad2.typeCode) {
                    case 94: {
                        ab ab4 = (ab)object;
                        long l9 = bj2.getCurrentDate().getSeconds() + (long)ab4.getSeconds();
                        return new ac(l9, this.cR(ab4.getNanos()), ab4.getZone());
                    }
                    case 92: {
                        ab ab5 = (ab)object;
                        long l10 = bj2.getCurrentDate().getSeconds() + (long)ab5.getSeconds() - (long)bj2.getZoneSeconds();
                        return new ac(l10, this.cR(ab5.getNanos()), bj2.getZoneSeconds());
                    }
                    case 95: {
                        return this.convertToTypeLimits(bj2, object);
                    }
                    case 93: {
                        ac ac6 = (ac)object;
                        long l11 = ac6.getSeconds() - (long)bj2.getZoneSeconds();
                        return new ac(l11, this.cR(ac6.getNanos()), bj2.getZoneSeconds());
                    }
                    case 91: {
                        ac ac7 = (ac)object;
                        return new ac(ac7.getSeconds(), 0, bj2.getZoneSeconds());
                    }
                }
                throw a.error(5561);
            }
            case 93: {
                switch (ad2.typeCode) {
                    case 94: {
                        ab ab6 = (ab)object;
                        long l12 = bj2.getCurrentDate().getSeconds() + (long)ab6.getSeconds() - (long)bj2.getZoneSeconds();
                        return new ac(l12, this.cR(ab6.getNanos()), bj2.getZoneSeconds());
                    }
                    case 92: {
                        ab ab7 = (ab)object;
                        long l13 = bj2.getCurrentDate().getSeconds() + (long)ab7.getSeconds();
                        return new ac(l13, this.cR(ab7.getNanos()));
                    }
                    case 95: {
                        ac ac8 = (ac)object;
                        long l14 = ac8.getSeconds() + (long)ac8.getZone();
                        return new ac(l14, this.cR(ac8.getNanos()));
                    }
                    case 93: {
                        return this.convertToTypeLimits(bj2, object);
                    }
                    case 91: {
                        return object;
                    }
                }
                throw a.error(5561);
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToDefaultType(bj bj2, Object object) {
        r r2 = object instanceof ab ? ad.SQL_TIME : ad.SQL_TIMESTAMP;
        return this.convertToType(bj2, object, r2);
    }

    @Override
    public Object convertJavaToSQL(bj bj2, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long l2;
                if (object instanceof Date || !(object instanceof java.util.Date)) break;
                int n2 = 0;
                int n3 = 0;
                if (this.typeCode == 92) {
                    l2 = z.convertMillisFromCalendar(bj2.getCalendar(), ((java.util.Date)object).getTime());
                } else {
                    l2 = ((java.util.Date)object).getTime();
                    n3 = bj2.getZoneSeconds();
                }
                l2 = z.getNormalisedTime(l2);
                if (object instanceof Timestamp) {
                    n2 = ((Timestamp)object).getNanos();
                    n2 = r.normaliseFraction(n2, this.scale);
                }
                return new ab((int)l2 / 1000, n2, n3);
            }
            case 91: {
                if (object instanceof Time || !(object instanceof java.util.Date)) break;
                long l3 = z.convertMillisFromCalendar(bj2.getCalendar(), ((java.util.Date)object).getTime());
                l3 = z.getNormalisedDate(l3);
                return new ac(l3 / 1000L);
            }
            case 93: 
            case 95: {
                long l4;
                if (object instanceof Time || !(object instanceof java.util.Date)) break;
                int n4 = 0;
                int n5 = 0;
                if (this.typeCode == 93) {
                    l4 = z.convertMillisFromCalendar(bj2.getCalendar(), ((java.util.Date)object).getTime());
                } else {
                    l4 = ((java.util.Date)object).getTime();
                    n5 = z.getZoneMillis(bj2.getCalendar(), l4) / 1000;
                }
                if (object instanceof Timestamp) {
                    n4 = ((Timestamp)object).getNanos();
                    n4 = r.normaliseFraction(n4, this.scale);
                }
                return new ac(l4 / 1000L, n4, n5);
            }
        }
        throw a.error(5561);
    }

    public Object convertSQLToJavaGMT(bj bj2, Object object) {
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long l2 = ((ab)object).getSeconds() * 1000;
                return new Time(l2 += (long)(((ab)object).getNanos() / 1000000));
            }
            case 91: {
                long l3 = ((ac)object).getSeconds() * 1000L;
                return new Date(l3);
            }
            case 93: 
            case 95: {
                long l4 = ((ac)object).getSeconds() * 1000L;
                Timestamp timestamp = new Timestamp(l4);
                timestamp.setNanos(((ac)object).getNanos());
                return timestamp;
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertSQLToJava(bj bj2, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: {
                Calendar calendar = bj2.getCalendar();
                long l2 = z.convertMillisToCalendar(calendar, ((ab)object).getSeconds() * 1000);
                l2 = z.getNormalisedTime(calendar, l2);
                Time time = new Time(l2);
                return time;
            }
            case 94: {
                int n2 = ((ab)object).getSeconds();
                return new Time(n2 * 1000);
            }
            case 91: {
                Calendar calendar = bj2.getCalendar();
                long l3 = z.convertMillisToCalendar(calendar, ((ac)object).getSeconds() * 1000L);
                Date date = new Date(l3);
                return date;
            }
            case 93: {
                Calendar calendar = bj2.getCalendar();
                long l4 = z.convertMillisToCalendar(calendar, ((ac)object).getSeconds() * 1000L);
                Timestamp timestamp = new Timestamp(l4);
                timestamp.setNanos(((ac)object).getNanos());
                return timestamp;
            }
            case 95: {
                long l5 = ((ac)object).getSeconds();
                Timestamp timestamp = new Timestamp(l5 * 1000L);
                timestamp.setNanos(((ac)object).getNanos());
                return timestamp;
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    public static int normaliseTime(int n2) {
        while (n2 < 0) {
            n2 += 86400;
        }
        if (n2 > 86400) {
            n2 %= 86400;
        }
        return n2;
    }

    @Override
    public String convertToString(Object object) {
        boolean bl2 = false;
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 91: {
                return z.getDateString(((ac)object).getSeconds());
            }
            case 92: 
            case 94: {
                ab ab2 = (ab)object;
                int n2 = r.normaliseTime(ab2.getSeconds() + ab2.getZone());
                String string = this.a(n2, ab2.getNanos(), false);
                if (!this.withTimeZone) {
                    return string;
                }
                StringBuffer stringBuffer = new StringBuffer(string);
                string = ad.SQL_INTERVAL_HOUR_TO_MINUTE.a(((ab)object).getZone(), 0, true);
                stringBuffer.append(string);
                return stringBuffer.toString();
            }
            case 93: 
            case 95: {
                ac ac2 = (ac)object;
                StringBuffer stringBuffer = new StringBuffer();
                z.getTimestampString(stringBuffer, ac2.getSeconds() + (long)ac2.getZone(), ac2.getNanos(), this.scale);
                if (!this.withTimeZone) {
                    return stringBuffer.toString();
                }
                String string = ad.SQL_INTERVAL_HOUR_TO_MINUTE.a(((ac)object).getZone(), 0, true);
                stringBuffer.append(string);
                return stringBuffer.toString();
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        switch (this.typeCode) {
            case 91: {
                stringBuffer.append("DATE");
                break;
            }
            case 92: 
            case 94: {
                stringBuffer.append("TIME");
                break;
            }
            case 93: 
            case 95: {
                stringBuffer.append("TIMESTAMP");
            }
        }
        stringBuffer.append(bh.toQuotedString(this.convertToString(object), '\'', false));
        return stringBuffer.toString();
    }

    @Override
    public boolean canConvertFrom(ad ad2) {
        if (ad2.typeCode == 0) {
            return true;
        }
        if (ad2.isCharacterType()) {
            return true;
        }
        if (!ad2.isDateTimeType()) {
            return false;
        }
        if (ad2.typeCode == 91) {
            return this.typeCode != 92;
        }
        if (ad2.typeCode == 92) {
            return this.typeCode != 91;
        }
        return true;
    }

    @Override
    public int canMoveFrom(ad ad2) {
        if (ad2 == this) {
            return 0;
        }
        if (this.typeCode == ad2.typeCode) {
            return this.scale >= ad2.scale ? 0 : -1;
        }
        return -1;
    }

    @Override
    public Object add(bg bg2, Object object, Object object2, ad ad2) {
        if (object == null || object2 == null) {
            return null;
        }
        if (ad2.isNumberType()) {
            if (this.typeCode == 91) {
                object2 = ((y)ad2).floor(object2);
            }
            object2 = ad.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(t.oneDay, object2);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (object2 instanceof s) {
                    throw a.runtimeError(201, "DateTimeType");
                }
                if (!(object2 instanceof t)) break;
                return r.addSeconds((ab)object, ((t)object2).aYu, ((t)object2).aYv);
            }
            case 91: 
            case 93: 
            case 95: {
                if (object2 instanceof s) {
                    return r.addMonths(bg2, (ac)object, ((s)object2).units);
                }
                if (!(object2 instanceof t)) break;
                return r.addSeconds((ac)object, ((t)object2).aYu, ((t)object2).aYv);
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object subtract(bg bg2, Object object, Object object2, ad ad2) {
        if (object == null || object2 == null) {
            return null;
        }
        if (ad2.isNumberType()) {
            if (this.typeCode == 91) {
                object2 = ((y)ad2).floor(object2);
            }
            object2 = ad.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(t.oneDay, object2);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (object2 instanceof s) {
                    throw a.runtimeError(201, "DateTimeType");
                }
                if (!(object2 instanceof t)) break;
                return r.addSeconds((ab)object, -((t)object2).aYu, -((t)object2).aYv);
            }
            case 91: 
            case 93: 
            case 95: {
                if (object2 instanceof s) {
                    return r.addMonths(bg2, (ac)object, -((s)object2).units);
                }
                if (!(object2 instanceof t)) break;
                return r.addSeconds((ac)object, -((t)object2).aYu, -((t)object2).aYv);
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    public Object truncate(Object object, int n2) {
        if (object == null) {
            return null;
        }
        long l2 = this.k(object);
        l2 = z.getTruncatedPart(l2, n2);
        l2 -= this.l(object);
        switch (this.typeCode) {
            case 94: {
                l2 = z.getNormalisedTime(l2);
            }
            case 92: {
                return new ab((int)(l2 / 1000L), 0, ((ab)object).getZone());
            }
            case 91: 
            case 93: 
            case 95: {
                return new ac(l2 / 1000L, 0, ((ac)object).getZone());
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    public Object round(Object object, int n2) {
        if (object == null) {
            return null;
        }
        long l2 = this.k(object);
        l2 = z.getRoundedPart(l2, n2);
        l2 -= this.l(object);
        switch (this.typeCode) {
            case 92: 
            case 94: {
                l2 = z.getNormalisedTime(l2);
                return new ab((int)(l2 / 1000L), 0, ((ab)object).getZone());
            }
            case 91: 
            case 93: 
            case 95: {
                return new ac(l2 / 1000L, 0, ((ac)object).getZone());
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ad) {
            return super.equals(object) && ((r)object).withTimeZone == this.withTimeZone;
        }
        return false;
    }

    @Override
    public int getPart(bg bg2, Object object, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 1;
        switch (n2) {
            case 101: {
                n3 = 1;
                break;
            }
            case 102: {
                n4 = 1;
                n3 = 2;
                break;
            }
            case 103: 
            case 260: {
                n3 = 5;
                break;
            }
            case 104: {
                n3 = 11;
                break;
            }
            case 105: {
                n3 = 12;
                break;
            }
            case 106: {
                n3 = 13;
                break;
            }
            case 259: {
                n3 = 7;
                break;
            }
            case 262: {
                n3 = 3;
                break;
            }
            case 266: {
                if (this.typeCode != 92 && this.typeCode != 94) {
                    try {
                        r r2 = this.withTimeZone ? ad.SQL_TIME_WITH_TIME_ZONE : ad.SQL_TIME;
                        object = r2.castToType(bg2, object, this);
                    }
                    catch (aa aa2) {
                        // empty catch block
                    }
                }
                return ((ab)object).getSeconds();
            }
            case 257: {
                if (this.typeCode == 95) {
                    return ((ac)object).getZone() / 3600;
                }
                return ((ab)object).getZone() / 3600;
            }
            case 258: {
                if (this.typeCode == 95) {
                    return ((ac)object).getZone() / 60 % 60;
                }
                return ((ab)object).getZone() / 60 % 60;
            }
            case 263: {
                n4 = 1;
                n5 = 3;
                n3 = 2;
                break;
            }
            case 261: {
                n3 = 6;
                break;
            }
            default: {
                throw a.runtimeError(201, "DateTimeType - " + n2);
            }
        }
        long l2 = this.k(object);
        return z.getDateTimePart(l2, n3) / n5 + n4;
    }

    public Object addMonthsSpecial(bg bg2, Object object, int n2) {
        ac ac2 = (ac)object;
        Calendar calendar = bg2.getCalendarGMT();
        long l2 = (ac2.getSeconds() + (long)ac2.getZone()) * 1000L;
        z.setTimeInMillis(calendar, l2);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        boolean bl2 = l2 == calendar.getTimeInMillis();
        z.setTimeInMillis(calendar, l2);
        calendar.add(2, n2);
        if (bl2) {
            calendar.set(5, 1);
            calendar.add(2, 1);
            calendar.add(5, -1);
        }
        l2 = calendar.getTimeInMillis();
        return new ac(l2 / 1000L, 0, 0);
    }

    public Object getLastDayOfMonth(bg bg2, Object object) {
        ac ac2 = (ac)object;
        Calendar calendar = bg2.getCalendarGMT();
        long l2 = (ac2.getSeconds() + (long)ac2.getZone()) * 1000L;
        z.setTimeInMillis(calendar, l2);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        l2 = calendar.getTimeInMillis();
        return new ac(l2 / 1000L, 0, 0);
    }

    long k(Object object) {
        long l2 = this.typeCode == 92 || this.typeCode == 94 ? (long)((((ab)object).getSeconds() + ((ab)object).getZone()) * 1000) : (((ac)object).getSeconds() + (long)((ac)object).getZone()) * 1000L;
        return l2;
    }

    long l(Object object) {
        long l2 = this.typeCode == 92 || this.typeCode == 94 ? (long)(((ab)object).getZone() * 1000) : (long)(((ac)object).getZone() * 1000);
        return l2;
    }

    @Override
    public BigDecimal getSecondPart(Object object) {
        long l2 = this.getPart(null, object, 106);
        int n2 = 0;
        if (this.typeCode == 93) {
            n2 = ((ac)object).getNanos();
        } else if (this.typeCode == 92) {
            n2 = ((ab)object).getNanos();
        }
        return this.k(l2, n2);
    }

    public String getPartString(bg bg2, Object object, int n2) {
        String string = "";
        switch (n2) {
            case 264: {
                string = "EEEE";
                break;
            }
            case 265: {
                string = "MMMM";
            }
        }
        SimpleDateFormat simpleDateFormat = bg2.getSimpleDateFormatGMT();
        try {
            simpleDateFormat.applyPattern(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        java.util.Date date = (java.util.Date)this.convertSQLToJavaGMT(bg2, object);
        return simpleDateFormat.format(date);
    }

    public Object getValue(long l2, int n2, int n3) {
        switch (this.typeCode) {
            case 91: {
                l2 = z.getNormalisedDate((l2 + (long)n3) * 1000L) / 1000L;
                return new ac(l2);
            }
            case 94: {
                l2 = z.getNormalisedDate(l2 * 1000L) / 1000L;
                return new ab((int)l2, n2, n3);
            }
            case 92: {
                l2 = z.getNormalisedTime((l2 + (long)n3) * 1000L) / 1000L;
                return new ab((int)l2, n2);
            }
            case 95: {
                return new ac(l2, n2, n3);
            }
            case 93: {
                return new ac(l2 + (long)n3, n2);
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    public r getDateTimeTypeWithoutZone() {
        if (this.withTimeZone) {
            r r2;
            switch (this.typeCode) {
                case 94: {
                    r2 = new r(92, 92, this.scale);
                    break;
                }
                case 95: {
                    r2 = new r(93, 93, this.scale);
                    break;
                }
                default: {
                    throw a.runtimeError(201, "DateTimeType");
                }
            }
            r2.nameString = this.nameString;
            return r2;
        }
        return this;
    }

    public static r getDateTimeType(int n2, int n3) {
        if (n3 > 9) {
            throw a.error(5592);
        }
        switch (n2) {
            case 91: {
                return SQL_DATE;
            }
            case 92: {
                if (n3 == 0) {
                    return SQL_TIME;
                }
                return new r(92, n2, n3);
            }
            case 94: {
                if (n3 == 0) {
                    return SQL_TIME_WITH_TIME_ZONE;
                }
                return new r(92, n2, n3);
            }
            case 93: {
                if (n3 == 6) {
                    return SQL_TIMESTAMP;
                }
                return new r(93, n2, n3);
            }
            case 95: {
                if (n3 == 6) {
                    return SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                return new r(93, n2, n3);
            }
        }
        throw a.runtimeError(201, "DateTimeType");
    }

    public Object changeZone(Object object, ad ad2, int n2, int n3) {
        if (object == null) {
            return null;
        }
        if (n2 > 50400 || -n2 > 50400) {
            throw a.error(3409);
        }
        switch (this.typeCode) {
            case 94: {
                ab ab2 = (ab)object;
                if (ad2.isDateTimeTypeWithZone()) {
                    if (ab2.aYz == n2) break;
                    return new ab(ab2.getSeconds(), ab2.getNanos(), n2);
                }
                int n4 = ab2.getSeconds() - n3;
                n4 = (int)(z.getNormalisedTime(n4 * 1000) / 1000L);
                return new ab(n4, ab2.getNanos(), n2);
            }
            case 95: {
                ac ac2 = (ac)object;
                long l2 = ac2.getSeconds();
                if (!ad2.isDateTimeTypeWithZone()) {
                    l2 -= (long)n3;
                }
                if (ac2.getSeconds() == l2 && ac2.aYz == n2) break;
                return new ac(l2, ac2.getNanos(), n2);
            }
        }
        return object;
    }

    public boolean canAdd(u u2) {
        return u2.startPartIndex >= this.startPartIndex && u2.endPartIndex <= this.endPartIndex;
    }

    public int getSqlDateTimeSub() {
        switch (this.typeCode) {
            case 91: {
                return 1;
            }
            case 92: {
                return 2;
            }
            case 93: {
                return 3;
            }
        }
        return 0;
    }

    public static Boolean overlaps(bg bg2, Object[] objectArray, ad[] adArray, Object[] objectArray2, ad[] adArray2) {
        Object[] objectArray3;
        if (objectArray == null || objectArray2 == null) {
            return null;
        }
        if (objectArray[0] == null || objectArray2[0] == null) {
            return null;
        }
        if (objectArray[1] == null) {
            objectArray[1] = objectArray[0];
        }
        if (objectArray2[1] == null) {
            objectArray2[1] = objectArray2[0];
        }
        ad ad2 = adArray[0].getCombinedType(bg2, adArray2[0], 40);
        objectArray[0] = ad2.castToType(bg2, objectArray[0], adArray[0]);
        objectArray2[0] = ad2.castToType(bg2, objectArray2[0], adArray2[0]);
        objectArray[1] = adArray[1].isIntervalType() ? ad2.add(bg2, objectArray[0], objectArray[1], adArray[1]) : ad2.castToType(bg2, objectArray[1], adArray[1]);
        objectArray2[1] = adArray2[1].isIntervalType() ? ad2.add(bg2, objectArray2[0], objectArray2[1], adArray2[1]) : ad2.castToType(bg2, objectArray2[1], adArray2[1]);
        if (ad2.compare(bg2, objectArray[0], objectArray[1]) > 0) {
            objectArray3 = objectArray[0];
            objectArray[0] = objectArray[1];
            objectArray[1] = objectArray3;
        }
        if (ad2.compare(bg2, objectArray2[0], objectArray2[1]) > 0) {
            objectArray3 = objectArray2[0];
            objectArray2[0] = objectArray2[1];
            objectArray2[1] = objectArray3;
        }
        if (ad2.compare(bg2, objectArray[0], objectArray2[0]) > 0) {
            objectArray3 = objectArray;
            objectArray = objectArray2;
            objectArray2 = objectArray3;
        }
        if (ad2.compare(bg2, objectArray[1], objectArray2[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static BigDecimal subtractMonthsSpecial(bg bg2, ac ac2, ac ac3) {
        long l2 = (ac2.getSeconds() + (long)ac2.getZone()) * 1000L;
        long l3 = (ac3.getSeconds() + (long)ac3.getZone()) * 1000L;
        boolean bl2 = false;
        if (l2 < l3) {
            bl2 = true;
            long l4 = l2;
            l2 = l3;
            l3 = l4;
        }
        l2 = z.getNormalisedDate(bg2.getCalendarGMT(), l2);
        l3 = z.getNormalisedDate(bg2.getCalendarGMT(), l3);
        Calendar calendar = bg2.getCalendarGMT();
        calendar.setTimeInMillis(l2);
        int n2 = calendar.get(2) + calendar.get(1) * 12;
        int n3 = calendar.get(5);
        calendar.set(5, 1);
        long l5 = calendar.getTimeInMillis();
        calendar.add(2, 1);
        l5 = calendar.getTimeInMillis();
        calendar.add(5, -1);
        l5 = calendar.getTimeInMillis();
        int n4 = calendar.get(5);
        calendar.setTimeInMillis(l3);
        int n5 = calendar.get(2) + calendar.get(1) * 12;
        int n6 = calendar.get(5);
        calendar.set(5, 1);
        l5 = calendar.getTimeInMillis();
        calendar.add(2, 1);
        l5 = calendar.getTimeInMillis();
        calendar.add(5, -1);
        l5 = calendar.getTimeInMillis();
        int n7 = calendar.get(5);
        if (n3 == n6 || n3 == n4 && n6 == n7) {
            double d2 = n2 - n5;
            if (bl2) {
                d2 = -d2;
            }
            return BigDecimal.valueOf(d2);
        }
        if (n6 > n3) {
            double d3 = n2 - n5 - 1;
            double d4 = n7 - n6 + n3;
            d3 += d4 / 31.0;
            if (bl2) {
                d3 = -d3;
            }
            return BigDecimal.valueOf(d3);
        }
        double d5 = n2 - n5;
        double d6 = n3 - n6;
        d5 += d6 / 31.0;
        if (bl2) {
            d5 = -d5;
        }
        return BigDecimal.valueOf(d5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int subtractMonths(ac ac2, ac ac3, boolean bl2) {
        Calendar calendar = z.tempCalGMT;
        synchronized (calendar) {
            boolean bl3 = false;
            if (ac3.getSeconds() > ac2.getSeconds()) {
                bl3 = true;
                ac ac4 = ac2;
                ac2 = ac3;
                ac3 = ac4;
            }
            z.setTimeInMillis(z.tempCalGMT, ac2.getSeconds() * 1000L);
            int n2 = z.tempCalGMT.get(2);
            int n3 = z.tempCalGMT.get(1);
            z.setTimeInMillis(z.tempCalGMT, ac3.getSeconds() * 1000L);
            n2 -= z.tempCalGMT.get(2);
            n3 -= z.tempCalGMT.get(1);
            if (bl2) {
                n2 = n3 * 12;
            } else {
                if (n2 < 0) {
                    n2 += 12;
                    --n3;
                }
                n2 += n3 * 12;
            }
            if (bl3) {
                n2 = -n2;
            }
            return n2;
        }
    }

    public static ab addSeconds(ab ab2, long l2, int n2) {
        l2 += (long)((n2 += ab2.getNanos()) / 1000000000);
        if ((n2 %= 1000000000) < 0) {
            n2 += 1000000000;
            --l2;
        }
        l2 += (long)ab2.getSeconds();
        ab ab3 = new ab((int)(l2 %= 86400L), n2, ab2.getZone());
        return ab3;
    }

    public static ac addMonths(bg bg2, ac ac2, int n2) {
        int n3 = ac2.getNanos();
        Calendar calendar = bg2.getCalendarGMT();
        z.setTimeInMillis(calendar, ac2.getSeconds() * 1000L);
        calendar.add(2, n2);
        ac ac3 = new ac(calendar.getTimeInMillis() / 1000L, n3, ac2.getZone());
        return ac3;
    }

    public static ac addSeconds(ac ac2, long l2, int n2) {
        l2 += (long)((n2 += ac2.getNanos()) / 1000000000);
        if ((n2 %= 1000000000) < 0) {
            n2 += 1000000000;
            --l2;
        }
        long l3 = ac2.getSeconds() + l2;
        ac ac3 = new ac(l3, n2, ac2.getZone());
        return ac3;
    }

    public static ac convertToDatetimeSpecial(bj bj2, String string, r r2) {
        switch (r2.typeCode) {
            case 93: {
                String string2;
                if (!(bj2 instanceof bg) || !((bg)bj2).database.sqlSyntaxOra) break;
                if (string.length() == 9) {
                    string2 = "DD-MON-YY";
                } else if (string.length() == 11) {
                    string2 = "DD-MON-YYYY";
                } else if (string.length() == 20) {
                    string2 = "DD-MON-YYYY HH24:MI:SS";
                } else {
                    if (string.length() <= 20) break;
                    string2 = "DD-MON-YYYY HH24:MI:SS.FF";
                }
                SimpleDateFormat simpleDateFormat = bj2.getSimpleDateFormatGMT();
                return z.toDate(string, string2, simpleDateFormat);
            }
        }
        throw a.error(3407);
    }
}

