/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.Xid;
import org.hsqldb.a.a;
import org.hsqldb.jdbc.JDBCCommonDataSource;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCDriver;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.jdbc.pool.JDBCXAConnection;
import org.hsqldb.jdbc.pool.JDBCXAResource;
import org.hsqldb.lib.ai;
import org.hsqldb.lib.r;
import org.hsqldb.lib.t;

public class JDBCXADataSource
extends JDBCCommonDataSource
implements Serializable,
Referenceable,
CommonDataSource,
XADataSource {
    private r resources = new r();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    @Override
    public XAConnection getXAConnection() {
        JDBCConnection jDBCConnection = (JDBCConnection)JDBCDriver.getConnection(this.url, this.connectionProps);
        JDBCXAConnection jDBCXAConnection = new JDBCXAConnection(this, jDBCConnection);
        return jDBCXAConnection;
    }

    @Override
    public XAConnection getXAConnection(String string, String string2) {
        if (string == null || string2 == null) {
            throw JDBCUtil.nullArgument();
        }
        if (string.equals(this.user) && string2.equals(this.password)) {
            return this.getXAConnection();
        }
        throw JDBCUtil.sqlException(a.error(4000));
    }

    @Override
    public Reference getReference() {
        String string = "org.hsqldb.jdbc.JDBCDataSourceFactory";
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("database", this.getDatabase()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.password));
        reference.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(Xid xid, JDBCXAResource jDBCXAResource) {
        this.lock.writeLock().lock();
        try {
            this.resources.put(xid, jDBCXAResource);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCXAResource removeResource(Xid xid) {
        this.lock.writeLock().lock();
        try {
            JDBCXAResource jDBCXAResource = (JDBCXAResource)this.resources.remove(xid);
            return jDBCXAResource;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Xid[] getPreparedXids() {
        this.lock.writeLock().lock();
        try {
            ai ai2 = this.resources.keySet().iterator();
            t t2 = new t();
            while (ai2.hasNext()) {
                Xid xid = (Xid)ai2.next();
                if (((JDBCXAResource)this.resources.get((Object)xid)).state != JDBCXAResource.XA_STATE_PREPARED) continue;
                t2.add(xid);
            }
            Object[] objectArray = new Xid[t2.size()];
            t2.toArray(objectArray);
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JDBCXAResource getResource(Xid xid) {
        this.lock.readLock().lock();
        try {
            JDBCXAResource jDBCXAResource = (JDBCXAResource)this.resources.get(xid);
            return jDBCXAResource;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

