/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.pool.JDBCXAConnection;
import org.hsqldb.jdbc.pool.JDBCXAResource;

public class JDBCXAConnectionWrapper
extends JDBCConnection {
    private JDBCXAResource xaResource;

    @Override
    public void setAutoCommit(boolean bl2) {
        this.validateNotWithinTransaction();
        super.setAutoCommit(bl2);
    }

    @Override
    public void commit() {
        this.validateNotWithinTransaction();
        super.commit();
    }

    @Override
    public void rollback() {
        this.validateNotWithinTransaction();
        super.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) {
        this.validateNotWithinTransaction();
        super.rollback(savepoint);
    }

    @Override
    public Savepoint setSavepoint() {
        this.validateNotWithinTransaction();
        return super.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String string) {
        this.validateNotWithinTransaction();
        return super.setSavepoint(string);
    }

    @Override
    public void setTransactionIsolation(int n2) {
        this.validateNotWithinTransaction();
        super.setTransactionIsolation(n2);
    }

    public JDBCXAConnectionWrapper(JDBCXAResource jDBCXAResource, JDBCXAConnection jDBCXAConnection, JDBCConnection jDBCConnection) {
        super(jDBCConnection, jDBCXAConnection);
        jDBCXAResource.setConnection(this);
        this.xaResource = jDBCXAResource;
    }

    private void validateNotWithinTransaction() {
        if (this.xaResource.withinGlobalTransaction()) {
            throw new SQLException("Method prohibited within a global transaction");
        }
    }
}

