/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLWarning;
import org.hsqldb.aa;
import org.hsqldb.g.a;

public class JDBCUtil {
    static final void throwError(aa aa2) {
        throw JDBCUtil.sqlException(aa2.getMessage(), aa2.getSQLState(), aa2.getErrorCode(), aa2);
    }

    static final void throwError(a a2) {
        throw JDBCUtil.sqlException(a2.getMainString(), a2.getSubString(), a2.getErrorCode(), a2.getException());
    }

    public static final SQLException sqlException(aa aa2) {
        return JDBCUtil.sqlException(aa2.getMessage(), aa2.getSQLState(), aa2.getErrorCode(), aa2);
    }

    public static final SQLException sqlException(aa aa2, Throwable throwable) {
        return JDBCUtil.sqlException(aa2.getMessage(), aa2.getSQLState(), aa2.getErrorCode(), throwable);
    }

    public static final SQLException sqlException(int n2) {
        return JDBCUtil.sqlException(org.hsqldb.a.a.error(n2));
    }

    public static final SQLException sqlExceptionSQL(int n2) {
        return JDBCUtil.sqlException(org.hsqldb.a.a.error(n2));
    }

    public static final SQLException sqlException(int n2, String string) {
        return JDBCUtil.sqlException(org.hsqldb.a.a.error(n2, string));
    }

    public static final SQLException sqlException(int n2, String string, Throwable throwable) {
        return JDBCUtil.sqlException(org.hsqldb.a.a.error(n2, string), throwable);
    }

    public static final SQLException sqlException(int n2, int n3) {
        return JDBCUtil.sqlException(org.hsqldb.a.a.error(n2, n3));
    }

    static final SQLException sqlException(int n2, int n3, Object[] objectArray) {
        return JDBCUtil.sqlException(org.hsqldb.a.a.error(null, n2, n3, objectArray));
    }

    static final SQLException notSupported() {
        aa aa2 = org.hsqldb.a.a.error(1500);
        return new SQLFeatureNotSupportedException(aa2.getMessage(), aa2.getSQLState(), -1500);
    }

    static SQLException notUpdatableColumn() {
        return JDBCUtil.sqlException(2500);
    }

    public static SQLException nullArgument() {
        return JDBCUtil.sqlException(423);
    }

    static SQLException nullArgument(String string) {
        return JDBCUtil.sqlException(423, string + ": null");
    }

    public static SQLException invalidArgument() {
        return JDBCUtil.sqlException(423);
    }

    public static SQLException invalidArgument(String string) {
        return JDBCUtil.sqlException(423, string);
    }

    public static SQLException outOfRangeArgument() {
        return JDBCUtil.sqlException(423);
    }

    public static SQLException outOfRangeArgument(String string) {
        return JDBCUtil.sqlException(423, string);
    }

    public static SQLException connectionClosedException() {
        return JDBCUtil.sqlException(1303);
    }

    public static SQLWarning sqlWarning(a a2) {
        return new SQLWarning(a2.getMainString(), a2.getSubString(), a2.getErrorCode());
    }

    public static SQLException sqlException(Throwable throwable) {
        return new SQLNonTransientConnectionException(throwable);
    }

    public static SQLException sqlException(a a2) {
        return JDBCUtil.sqlException(a2.getMainString(), a2.getSubString(), a2.getErrorCode(), a2.getException());
    }

    public static final SQLException sqlException(String string, String string2, int n2, Throwable throwable) {
        if (string2.startsWith("08")) {
            if (!string2.endsWith("3")) {
                return new SQLTransientConnectionException(string, string2, n2, throwable);
            }
            return new SQLNonTransientConnectionException(string, string2, n2, throwable);
        }
        if (string2.startsWith("22")) {
            return new SQLDataException(string, string2, n2, throwable);
        }
        if (string2.startsWith("23")) {
            return new SQLIntegrityConstraintViolationException(string, string2, n2, throwable);
        }
        if (string2.startsWith("28")) {
            return new SQLInvalidAuthorizationSpecException(string, string2, n2, throwable);
        }
        if (string2.startsWith("42") || string2.startsWith("37") || string2.startsWith("2A")) {
            return new SQLSyntaxErrorException(string, string2, n2, throwable);
        }
        if (string2.startsWith("40")) {
            return new SQLTransactionRollbackException(string, string2, n2, throwable);
        }
        if (string2.startsWith("0A")) {
            return new SQLFeatureNotSupportedException(string, string2, n2, throwable);
        }
        return new SQLException(string, string2, n2, throwable);
    }
}

